// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::delete_organization_conformance_pack::_delete_organization_conformance_pack_output::DeleteOrganizationConformancePackOutputBuilder;

pub use crate::operation::delete_organization_conformance_pack::_delete_organization_conformance_pack_input::DeleteOrganizationConformancePackInputBuilder;

impl crate::operation::delete_organization_conformance_pack::builders::DeleteOrganizationConformancePackInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::delete_organization_conformance_pack::DeleteOrganizationConformancePackOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_organization_conformance_pack::DeleteOrganizationConformancePackError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.delete_organization_conformance_pack();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `DeleteOrganizationConformancePack`.
///
/// <p>Deletes the specified organization conformance pack and all of the Config rules and remediation actions from all member accounts in that organization.</p>
/// <p>Only a management account or a delegated administrator account can delete an organization conformance pack. When calling this API with a delegated administrator, you must ensure Organizations <code>ListDelegatedAdministrator</code> permissions are added.</p>
/// <p>Config sets the state of a conformance pack to DELETE_IN_PROGRESS until the deletion is complete. You cannot update a conformance pack while it is in this state.</p>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct DeleteOrganizationConformancePackFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::delete_organization_conformance_pack::builders::DeleteOrganizationConformancePackInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::delete_organization_conformance_pack::DeleteOrganizationConformancePackOutput,
        crate::operation::delete_organization_conformance_pack::DeleteOrganizationConformancePackError,
    > for DeleteOrganizationConformancePackFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::delete_organization_conformance_pack::DeleteOrganizationConformancePackOutput,
            crate::operation::delete_organization_conformance_pack::DeleteOrganizationConformancePackError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl DeleteOrganizationConformancePackFluentBuilder {
    /// Creates a new `DeleteOrganizationConformancePackFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the DeleteOrganizationConformancePack as a reference.
    pub fn as_input(&self) -> &crate::operation::delete_organization_conformance_pack::builders::DeleteOrganizationConformancePackInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::delete_organization_conformance_pack::DeleteOrganizationConformancePackOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_organization_conformance_pack::DeleteOrganizationConformancePackError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::delete_organization_conformance_pack::DeleteOrganizationConformancePack::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::delete_organization_conformance_pack::DeleteOrganizationConformancePack::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::delete_organization_conformance_pack::DeleteOrganizationConformancePackOutput,
        crate::operation::delete_organization_conformance_pack::DeleteOrganizationConformancePackError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The name of organization conformance pack that you want to delete.</p>
    pub fn organization_conformance_pack_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.organization_conformance_pack_name(input.into());
        self
    }
    /// <p>The name of organization conformance pack that you want to delete.</p>
    pub fn set_organization_conformance_pack_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_organization_conformance_pack_name(input);
        self
    }
    /// <p>The name of organization conformance pack that you want to delete.</p>
    pub fn get_organization_conformance_pack_name(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_organization_conformance_pack_name()
    }
}
