// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::describe_configuration_recorder_status::_describe_configuration_recorder_status_output::DescribeConfigurationRecorderStatusOutputBuilder;

pub use crate::operation::describe_configuration_recorder_status::_describe_configuration_recorder_status_input::DescribeConfigurationRecorderStatusInputBuilder;

impl crate::operation::describe_configuration_recorder_status::builders::DescribeConfigurationRecorderStatusInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::describe_configuration_recorder_status::DescribeConfigurationRecorderStatusOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_configuration_recorder_status::DescribeConfigurationRecorderStatusError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.describe_configuration_recorder_status();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `DescribeConfigurationRecorderStatus`.
///
/// <p>Returns the current status of the configuration recorder you specify as well as the status of the last recording event for the configuration recorders.</p>
/// <p>For a detailed status of recording events over time, add your Config events to Amazon CloudWatch metrics and use CloudWatch metrics.</p>
/// <p>If a configuration recorder is not specified, this operation returns the status for the customer managed configuration recorder configured for the account, if applicable.</p><note>
/// <p>When making a request to this operation, you can only specify one configuration recorder.</p>
/// </note>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct DescribeConfigurationRecorderStatusFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::describe_configuration_recorder_status::builders::DescribeConfigurationRecorderStatusInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::describe_configuration_recorder_status::DescribeConfigurationRecorderStatusOutput,
        crate::operation::describe_configuration_recorder_status::DescribeConfigurationRecorderStatusError,
    > for DescribeConfigurationRecorderStatusFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::describe_configuration_recorder_status::DescribeConfigurationRecorderStatusOutput,
            crate::operation::describe_configuration_recorder_status::DescribeConfigurationRecorderStatusError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl DescribeConfigurationRecorderStatusFluentBuilder {
    /// Creates a new `DescribeConfigurationRecorderStatusFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the DescribeConfigurationRecorderStatus as a reference.
    pub fn as_input(&self) -> &crate::operation::describe_configuration_recorder_status::builders::DescribeConfigurationRecorderStatusInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::describe_configuration_recorder_status::DescribeConfigurationRecorderStatusOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_configuration_recorder_status::DescribeConfigurationRecorderStatusError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins =
            crate::operation::describe_configuration_recorder_status::DescribeConfigurationRecorderStatus::operation_runtime_plugins(
                self.handle.runtime_plugins.clone(),
                &self.handle.conf,
                self.config_override,
            );
        crate::operation::describe_configuration_recorder_status::DescribeConfigurationRecorderStatus::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::describe_configuration_recorder_status::DescribeConfigurationRecorderStatusOutput,
        crate::operation::describe_configuration_recorder_status::DescribeConfigurationRecorderStatusError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    ///
    /// Appends an item to `ConfigurationRecorderNames`.
    ///
    /// To override the contents of this collection use [`set_configuration_recorder_names`](Self::set_configuration_recorder_names).
    ///
    /// <p>The name of the configuration recorder. If the name is not specified, the opertation returns the status for the customer managed configuration recorder configured for the account, if applicable.</p><note>
    /// <p>When making a request to this operation, you can only specify one configuration recorder.</p>
    /// </note>
    pub fn configuration_recorder_names(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.configuration_recorder_names(input.into());
        self
    }
    /// <p>The name of the configuration recorder. If the name is not specified, the opertation returns the status for the customer managed configuration recorder configured for the account, if applicable.</p><note>
    /// <p>When making a request to this operation, you can only specify one configuration recorder.</p>
    /// </note>
    pub fn set_configuration_recorder_names(mut self, input: ::std::option::Option<::std::vec::Vec<::std::string::String>>) -> Self {
        self.inner = self.inner.set_configuration_recorder_names(input);
        self
    }
    /// <p>The name of the configuration recorder. If the name is not specified, the opertation returns the status for the customer managed configuration recorder configured for the account, if applicable.</p><note>
    /// <p>When making a request to this operation, you can only specify one configuration recorder.</p>
    /// </note>
    pub fn get_configuration_recorder_names(&self) -> &::std::option::Option<::std::vec::Vec<::std::string::String>> {
        self.inner.get_configuration_recorder_names()
    }
    /// <p>For service-linked configuration recorders, you can use the service principal of the linked Amazon Web Services service to specify the configuration recorder.</p>
    pub fn service_principal(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.service_principal(input.into());
        self
    }
    /// <p>For service-linked configuration recorders, you can use the service principal of the linked Amazon Web Services service to specify the configuration recorder.</p>
    pub fn set_service_principal(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_service_principal(input);
        self
    }
    /// <p>For service-linked configuration recorders, you can use the service principal of the linked Amazon Web Services service to specify the configuration recorder.</p>
    pub fn get_service_principal(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_service_principal()
    }
    /// <p>The Amazon Resource Name (ARN) of the configuration recorder that you want to specify.</p>
    pub fn arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.arn(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the configuration recorder that you want to specify.</p>
    pub fn set_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_arn(input);
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the configuration recorder that you want to specify.</p>
    pub fn get_arn(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_arn()
    }
}
