// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::describe_organization_conformance_packs::_describe_organization_conformance_packs_output::DescribeOrganizationConformancePacksOutputBuilder;

pub use crate::operation::describe_organization_conformance_packs::_describe_organization_conformance_packs_input::DescribeOrganizationConformancePacksInputBuilder;

impl crate::operation::describe_organization_conformance_packs::builders::DescribeOrganizationConformancePacksInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::describe_organization_conformance_packs::DescribeOrganizationConformancePacksOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_organization_conformance_packs::DescribeOrganizationConformancePacksError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.describe_organization_conformance_packs();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `DescribeOrganizationConformancePacks`.
///
/// <p>Returns a list of organization conformance packs.</p><note>
/// <p>When you specify the limit and the next token, you receive a paginated response.</p>
/// <p>Limit and next token are not applicable if you specify organization conformance packs names. They are only applicable, when you request all the organization conformance packs.</p>
/// <p><i>For accounts within an organization</i></p>
/// <p>If you deploy an organizational rule or conformance pack in an organization administrator account, and then establish a delegated administrator and deploy an organizational rule or conformance pack in the delegated administrator account, you won't be able to see the organizational rule or conformance pack in the organization administrator account from the delegated administrator account or see the organizational rule or conformance pack in the delegated administrator account from organization administrator account. The <code>DescribeOrganizationConfigRules</code> and <code>DescribeOrganizationConformancePacks</code> APIs can only see and interact with the organization-related resource that were deployed from within the account calling those APIs.</p>
/// </note>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct DescribeOrganizationConformancePacksFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::describe_organization_conformance_packs::builders::DescribeOrganizationConformancePacksInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::describe_organization_conformance_packs::DescribeOrganizationConformancePacksOutput,
        crate::operation::describe_organization_conformance_packs::DescribeOrganizationConformancePacksError,
    > for DescribeOrganizationConformancePacksFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::describe_organization_conformance_packs::DescribeOrganizationConformancePacksOutput,
            crate::operation::describe_organization_conformance_packs::DescribeOrganizationConformancePacksError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl DescribeOrganizationConformancePacksFluentBuilder {
    /// Creates a new `DescribeOrganizationConformancePacksFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the DescribeOrganizationConformancePacks as a reference.
    pub fn as_input(&self) -> &crate::operation::describe_organization_conformance_packs::builders::DescribeOrganizationConformancePacksInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::describe_organization_conformance_packs::DescribeOrganizationConformancePacksOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_organization_conformance_packs::DescribeOrganizationConformancePacksError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins =
            crate::operation::describe_organization_conformance_packs::DescribeOrganizationConformancePacks::operation_runtime_plugins(
                self.handle.runtime_plugins.clone(),
                &self.handle.conf,
                self.config_override,
            );
        crate::operation::describe_organization_conformance_packs::DescribeOrganizationConformancePacks::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::describe_organization_conformance_packs::DescribeOrganizationConformancePacksOutput,
        crate::operation::describe_organization_conformance_packs::DescribeOrganizationConformancePacksError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// Create a paginator for this request
    ///
    /// Paginators are used by calling [`send().await`](crate::operation::describe_organization_conformance_packs::paginator::DescribeOrganizationConformancePacksPaginator::send) which returns a [`PaginationStream`](aws_smithy_async::future::pagination_stream::PaginationStream).
    pub fn into_paginator(
        self,
    ) -> crate::operation::describe_organization_conformance_packs::paginator::DescribeOrganizationConformancePacksPaginator {
        crate::operation::describe_organization_conformance_packs::paginator::DescribeOrganizationConformancePacksPaginator::new(
            self.handle,
            self.inner,
        )
    }
    ///
    /// Appends an item to `OrganizationConformancePackNames`.
    ///
    /// To override the contents of this collection use [`set_organization_conformance_pack_names`](Self::set_organization_conformance_pack_names).
    ///
    /// <p>The name that you assign to an organization conformance pack.</p>
    pub fn organization_conformance_pack_names(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.organization_conformance_pack_names(input.into());
        self
    }
    /// <p>The name that you assign to an organization conformance pack.</p>
    pub fn set_organization_conformance_pack_names(mut self, input: ::std::option::Option<::std::vec::Vec<::std::string::String>>) -> Self {
        self.inner = self.inner.set_organization_conformance_pack_names(input);
        self
    }
    /// <p>The name that you assign to an organization conformance pack.</p>
    pub fn get_organization_conformance_pack_names(&self) -> &::std::option::Option<::std::vec::Vec<::std::string::String>> {
        self.inner.get_organization_conformance_pack_names()
    }
    /// <p>The maximum number of organization config packs returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>
    pub fn limit(mut self, input: i32) -> Self {
        self.inner = self.inner.limit(input);
        self
    }
    /// <p>The maximum number of organization config packs returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>
    pub fn set_limit(mut self, input: ::std::option::Option<i32>) -> Self {
        self.inner = self.inner.set_limit(input);
        self
    }
    /// <p>The maximum number of organization config packs returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>
    pub fn get_limit(&self) -> &::std::option::Option<i32> {
        self.inner.get_limit()
    }
    /// <p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.next_token(input.into());
        self
    }
    /// <p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn set_next_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_next_token(input);
        self
    }
    /// <p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn get_next_token(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_next_token()
    }
}
