// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::get_aggregate_discovered_resource_counts::_get_aggregate_discovered_resource_counts_output::GetAggregateDiscoveredResourceCountsOutputBuilder;

pub use crate::operation::get_aggregate_discovered_resource_counts::_get_aggregate_discovered_resource_counts_input::GetAggregateDiscoveredResourceCountsInputBuilder;

impl crate::operation::get_aggregate_discovered_resource_counts::builders::GetAggregateDiscoveredResourceCountsInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::get_aggregate_discovered_resource_counts::GetAggregateDiscoveredResourceCountsOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_aggregate_discovered_resource_counts::GetAggregateDiscoveredResourceCountsError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.get_aggregate_discovered_resource_counts();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `GetAggregateDiscoveredResourceCounts`.
///
/// <p>Returns the resource counts across accounts and regions that are present in your Config aggregator. You can request the resource counts by providing filters and GroupByKey.</p>
/// <p>For example, if the input contains accountID 12345678910 and region us-east-1 in filters, the API returns the count of resources in account ID 12345678910 and region us-east-1. If the input contains ACCOUNT_ID as a GroupByKey, the API returns resource counts for all source accounts that are present in your aggregator.</p>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct GetAggregateDiscoveredResourceCountsFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::get_aggregate_discovered_resource_counts::builders::GetAggregateDiscoveredResourceCountsInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::get_aggregate_discovered_resource_counts::GetAggregateDiscoveredResourceCountsOutput,
        crate::operation::get_aggregate_discovered_resource_counts::GetAggregateDiscoveredResourceCountsError,
    > for GetAggregateDiscoveredResourceCountsFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::get_aggregate_discovered_resource_counts::GetAggregateDiscoveredResourceCountsOutput,
            crate::operation::get_aggregate_discovered_resource_counts::GetAggregateDiscoveredResourceCountsError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl GetAggregateDiscoveredResourceCountsFluentBuilder {
    /// Creates a new `GetAggregateDiscoveredResourceCountsFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the GetAggregateDiscoveredResourceCounts as a reference.
    pub fn as_input(
        &self,
    ) -> &crate::operation::get_aggregate_discovered_resource_counts::builders::GetAggregateDiscoveredResourceCountsInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::get_aggregate_discovered_resource_counts::GetAggregateDiscoveredResourceCountsOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_aggregate_discovered_resource_counts::GetAggregateDiscoveredResourceCountsError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins =
            crate::operation::get_aggregate_discovered_resource_counts::GetAggregateDiscoveredResourceCounts::operation_runtime_plugins(
                self.handle.runtime_plugins.clone(),
                &self.handle.conf,
                self.config_override,
            );
        crate::operation::get_aggregate_discovered_resource_counts::GetAggregateDiscoveredResourceCounts::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::get_aggregate_discovered_resource_counts::GetAggregateDiscoveredResourceCountsOutput,
        crate::operation::get_aggregate_discovered_resource_counts::GetAggregateDiscoveredResourceCountsError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// Create a paginator for this request
    ///
    /// Paginators are used by calling [`send().await`](crate::operation::get_aggregate_discovered_resource_counts::paginator::GetAggregateDiscoveredResourceCountsPaginator::send) which returns a [`PaginationStream`](aws_smithy_async::future::pagination_stream::PaginationStream).
    pub fn into_paginator(
        self,
    ) -> crate::operation::get_aggregate_discovered_resource_counts::paginator::GetAggregateDiscoveredResourceCountsPaginator {
        crate::operation::get_aggregate_discovered_resource_counts::paginator::GetAggregateDiscoveredResourceCountsPaginator::new(
            self.handle,
            self.inner,
        )
    }
    /// <p>The name of the configuration aggregator.</p>
    pub fn configuration_aggregator_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.configuration_aggregator_name(input.into());
        self
    }
    /// <p>The name of the configuration aggregator.</p>
    pub fn set_configuration_aggregator_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_configuration_aggregator_name(input);
        self
    }
    /// <p>The name of the configuration aggregator.</p>
    pub fn get_configuration_aggregator_name(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_configuration_aggregator_name()
    }
    /// <p>Filters the results based on the <code>ResourceCountFilters</code> object.</p>
    pub fn filters(mut self, input: crate::types::ResourceCountFilters) -> Self {
        self.inner = self.inner.filters(input);
        self
    }
    /// <p>Filters the results based on the <code>ResourceCountFilters</code> object.</p>
    pub fn set_filters(mut self, input: ::std::option::Option<crate::types::ResourceCountFilters>) -> Self {
        self.inner = self.inner.set_filters(input);
        self
    }
    /// <p>Filters the results based on the <code>ResourceCountFilters</code> object.</p>
    pub fn get_filters(&self) -> &::std::option::Option<crate::types::ResourceCountFilters> {
        self.inner.get_filters()
    }
    /// <p>The key to group the resource counts.</p>
    pub fn group_by_key(mut self, input: crate::types::ResourceCountGroupKey) -> Self {
        self.inner = self.inner.group_by_key(input);
        self
    }
    /// <p>The key to group the resource counts.</p>
    pub fn set_group_by_key(mut self, input: ::std::option::Option<crate::types::ResourceCountGroupKey>) -> Self {
        self.inner = self.inner.set_group_by_key(input);
        self
    }
    /// <p>The key to group the resource counts.</p>
    pub fn get_group_by_key(&self) -> &::std::option::Option<crate::types::ResourceCountGroupKey> {
        self.inner.get_group_by_key()
    }
    /// <p>The maximum number of <code>GroupedResourceCount</code> objects returned on each page. The default is 1000. You cannot specify a number greater than 1000. If you specify 0, Config uses the default.</p>
    pub fn limit(mut self, input: i32) -> Self {
        self.inner = self.inner.limit(input);
        self
    }
    /// <p>The maximum number of <code>GroupedResourceCount</code> objects returned on each page. The default is 1000. You cannot specify a number greater than 1000. If you specify 0, Config uses the default.</p>
    pub fn set_limit(mut self, input: ::std::option::Option<i32>) -> Self {
        self.inner = self.inner.set_limit(input);
        self
    }
    /// <p>The maximum number of <code>GroupedResourceCount</code> objects returned on each page. The default is 1000. You cannot specify a number greater than 1000. If you specify 0, Config uses the default.</p>
    pub fn get_limit(&self) -> &::std::option::Option<i32> {
        self.inner.get_limit()
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.next_token(input.into());
        self
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn set_next_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_next_token(input);
        self
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn get_next_token(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_next_token()
    }
}
