// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::get_aggregate_resource_config::_get_aggregate_resource_config_output::GetAggregateResourceConfigOutputBuilder;

pub use crate::operation::get_aggregate_resource_config::_get_aggregate_resource_config_input::GetAggregateResourceConfigInputBuilder;

impl crate::operation::get_aggregate_resource_config::builders::GetAggregateResourceConfigInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::get_aggregate_resource_config::GetAggregateResourceConfigOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_aggregate_resource_config::GetAggregateResourceConfigError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.get_aggregate_resource_config();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `GetAggregateResourceConfig`.
///
/// <p>Returns configuration item that is aggregated for your specific resource in a specific source account and region.</p><note>
/// <p>The API does not return results for deleted resources.</p>
/// </note>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct GetAggregateResourceConfigFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::get_aggregate_resource_config::builders::GetAggregateResourceConfigInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::get_aggregate_resource_config::GetAggregateResourceConfigOutput,
        crate::operation::get_aggregate_resource_config::GetAggregateResourceConfigError,
    > for GetAggregateResourceConfigFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::get_aggregate_resource_config::GetAggregateResourceConfigOutput,
            crate::operation::get_aggregate_resource_config::GetAggregateResourceConfigError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl GetAggregateResourceConfigFluentBuilder {
    /// Creates a new `GetAggregateResourceConfigFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the GetAggregateResourceConfig as a reference.
    pub fn as_input(&self) -> &crate::operation::get_aggregate_resource_config::builders::GetAggregateResourceConfigInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::get_aggregate_resource_config::GetAggregateResourceConfigOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_aggregate_resource_config::GetAggregateResourceConfigError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::get_aggregate_resource_config::GetAggregateResourceConfig::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::get_aggregate_resource_config::GetAggregateResourceConfig::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::get_aggregate_resource_config::GetAggregateResourceConfigOutput,
        crate::operation::get_aggregate_resource_config::GetAggregateResourceConfigError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The name of the configuration aggregator.</p>
    pub fn configuration_aggregator_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.configuration_aggregator_name(input.into());
        self
    }
    /// <p>The name of the configuration aggregator.</p>
    pub fn set_configuration_aggregator_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_configuration_aggregator_name(input);
        self
    }
    /// <p>The name of the configuration aggregator.</p>
    pub fn get_configuration_aggregator_name(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_configuration_aggregator_name()
    }
    /// <p>An object that identifies aggregate resource.</p>
    pub fn resource_identifier(mut self, input: crate::types::AggregateResourceIdentifier) -> Self {
        self.inner = self.inner.resource_identifier(input);
        self
    }
    /// <p>An object that identifies aggregate resource.</p>
    pub fn set_resource_identifier(mut self, input: ::std::option::Option<crate::types::AggregateResourceIdentifier>) -> Self {
        self.inner = self.inner.set_resource_identifier(input);
        self
    }
    /// <p>An object that identifies aggregate resource.</p>
    pub fn get_resource_identifier(&self) -> &::std::option::Option<crate::types::AggregateResourceIdentifier> {
        self.inner.get_resource_identifier()
    }
}
