// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct GetDiscoveredResourceCountsOutput {
    /// <p>The total number of resources that Config is recording in the region for your account. If you specify resource types in the request, Config returns only the total number of resources for those resource types.</p>
    /// <p class="title"><b>Example</b></p>
    /// <ol>
    /// <li>
    /// <p>Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances, 20 IAM users, and 15 S3 buckets, for a total of 60 resources.</p></li>
    /// <li>
    /// <p>You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify the resource type, <code>"AWS::EC2::Instances"</code>, in the request.</p></li>
    /// <li>
    /// <p>Config returns 25 for <code>totalDiscoveredResources</code>.</p></li>
    /// </ol>
    pub total_discovered_resources: i64,
    /// <p>The list of <code>ResourceCount</code> objects. Each object is listed in descending order by the number of resources.</p>
    pub resource_counts: ::std::option::Option<::std::vec::Vec<crate::types::ResourceCount>>,
    /// <p>The string that you use in a subsequent request to get the next page of results in a paginated response.</p>
    pub next_token: ::std::option::Option<::std::string::String>,
    _request_id: Option<String>,
}
impl GetDiscoveredResourceCountsOutput {
    /// <p>The total number of resources that Config is recording in the region for your account. If you specify resource types in the request, Config returns only the total number of resources for those resource types.</p>
    /// <p class="title"><b>Example</b></p>
    /// <ol>
    /// <li>
    /// <p>Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances, 20 IAM users, and 15 S3 buckets, for a total of 60 resources.</p></li>
    /// <li>
    /// <p>You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify the resource type, <code>"AWS::EC2::Instances"</code>, in the request.</p></li>
    /// <li>
    /// <p>Config returns 25 for <code>totalDiscoveredResources</code>.</p></li>
    /// </ol>
    pub fn total_discovered_resources(&self) -> i64 {
        self.total_discovered_resources
    }
    /// <p>The list of <code>ResourceCount</code> objects. Each object is listed in descending order by the number of resources.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.resource_counts.is_none()`.
    pub fn resource_counts(&self) -> &[crate::types::ResourceCount] {
        self.resource_counts.as_deref().unwrap_or_default()
    }
    /// <p>The string that you use in a subsequent request to get the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> ::std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl ::aws_types::request_id::RequestId for GetDiscoveredResourceCountsOutput {
    fn request_id(&self) -> Option<&str> {
        self._request_id.as_deref()
    }
}
impl GetDiscoveredResourceCountsOutput {
    /// Creates a new builder-style object to manufacture [`GetDiscoveredResourceCountsOutput`](crate::operation::get_discovered_resource_counts::GetDiscoveredResourceCountsOutput).
    pub fn builder() -> crate::operation::get_discovered_resource_counts::builders::GetDiscoveredResourceCountsOutputBuilder {
        crate::operation::get_discovered_resource_counts::builders::GetDiscoveredResourceCountsOutputBuilder::default()
    }
}

/// A builder for [`GetDiscoveredResourceCountsOutput`](crate::operation::get_discovered_resource_counts::GetDiscoveredResourceCountsOutput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct GetDiscoveredResourceCountsOutputBuilder {
    pub(crate) total_discovered_resources: ::std::option::Option<i64>,
    pub(crate) resource_counts: ::std::option::Option<::std::vec::Vec<crate::types::ResourceCount>>,
    pub(crate) next_token: ::std::option::Option<::std::string::String>,
    _request_id: Option<String>,
}
impl GetDiscoveredResourceCountsOutputBuilder {
    /// <p>The total number of resources that Config is recording in the region for your account. If you specify resource types in the request, Config returns only the total number of resources for those resource types.</p>
    /// <p class="title"><b>Example</b></p>
    /// <ol>
    /// <li>
    /// <p>Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances, 20 IAM users, and 15 S3 buckets, for a total of 60 resources.</p></li>
    /// <li>
    /// <p>You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify the resource type, <code>"AWS::EC2::Instances"</code>, in the request.</p></li>
    /// <li>
    /// <p>Config returns 25 for <code>totalDiscoveredResources</code>.</p></li>
    /// </ol>
    pub fn total_discovered_resources(mut self, input: i64) -> Self {
        self.total_discovered_resources = ::std::option::Option::Some(input);
        self
    }
    /// <p>The total number of resources that Config is recording in the region for your account. If you specify resource types in the request, Config returns only the total number of resources for those resource types.</p>
    /// <p class="title"><b>Example</b></p>
    /// <ol>
    /// <li>
    /// <p>Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances, 20 IAM users, and 15 S3 buckets, for a total of 60 resources.</p></li>
    /// <li>
    /// <p>You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify the resource type, <code>"AWS::EC2::Instances"</code>, in the request.</p></li>
    /// <li>
    /// <p>Config returns 25 for <code>totalDiscoveredResources</code>.</p></li>
    /// </ol>
    pub fn set_total_discovered_resources(mut self, input: ::std::option::Option<i64>) -> Self {
        self.total_discovered_resources = input;
        self
    }
    /// <p>The total number of resources that Config is recording in the region for your account. If you specify resource types in the request, Config returns only the total number of resources for those resource types.</p>
    /// <p class="title"><b>Example</b></p>
    /// <ol>
    /// <li>
    /// <p>Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances, 20 IAM users, and 15 S3 buckets, for a total of 60 resources.</p></li>
    /// <li>
    /// <p>You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify the resource type, <code>"AWS::EC2::Instances"</code>, in the request.</p></li>
    /// <li>
    /// <p>Config returns 25 for <code>totalDiscoveredResources</code>.</p></li>
    /// </ol>
    pub fn get_total_discovered_resources(&self) -> &::std::option::Option<i64> {
        &self.total_discovered_resources
    }
    /// Appends an item to `resource_counts`.
    ///
    /// To override the contents of this collection use [`set_resource_counts`](Self::set_resource_counts).
    ///
    /// <p>The list of <code>ResourceCount</code> objects. Each object is listed in descending order by the number of resources.</p>
    pub fn resource_counts(mut self, input: crate::types::ResourceCount) -> Self {
        let mut v = self.resource_counts.unwrap_or_default();
        v.push(input);
        self.resource_counts = ::std::option::Option::Some(v);
        self
    }
    /// <p>The list of <code>ResourceCount</code> objects. Each object is listed in descending order by the number of resources.</p>
    pub fn set_resource_counts(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::ResourceCount>>) -> Self {
        self.resource_counts = input;
        self
    }
    /// <p>The list of <code>ResourceCount</code> objects. Each object is listed in descending order by the number of resources.</p>
    pub fn get_resource_counts(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::ResourceCount>> {
        &self.resource_counts
    }
    /// <p>The string that you use in a subsequent request to get the next page of results in a paginated response.</p>
    pub fn next_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.next_token = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The string that you use in a subsequent request to get the next page of results in a paginated response.</p>
    pub fn set_next_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.next_token = input;
        self
    }
    /// <p>The string that you use in a subsequent request to get the next page of results in a paginated response.</p>
    pub fn get_next_token(&self) -> &::std::option::Option<::std::string::String> {
        &self.next_token
    }
    pub(crate) fn _request_id(mut self, request_id: impl Into<String>) -> Self {
        self._request_id = Some(request_id.into());
        self
    }

    pub(crate) fn _set_request_id(&mut self, request_id: Option<String>) -> &mut Self {
        self._request_id = request_id;
        self
    }
    /// Consumes the builder and constructs a [`GetDiscoveredResourceCountsOutput`](crate::operation::get_discovered_resource_counts::GetDiscoveredResourceCountsOutput).
    pub fn build(self) -> crate::operation::get_discovered_resource_counts::GetDiscoveredResourceCountsOutput {
        crate::operation::get_discovered_resource_counts::GetDiscoveredResourceCountsOutput {
            total_discovered_resources: self.total_discovered_resources.unwrap_or_default(),
            resource_counts: self.resource_counts,
            next_token: self.next_token,
            _request_id: self._request_id,
        }
    }
}
