// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The output for the <code>GetResourceConfigHistory</code> action.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct GetResourceConfigHistoryOutput {
    /// <p>A list that contains the configuration history of one or more resources.</p>
    pub configuration_items: ::std::option::Option<::std::vec::Vec<crate::types::ConfigurationItem>>,
    /// <p>The string that you use in a subsequent request to get the next page of results in a paginated response.</p>
    pub next_token: ::std::option::Option<::std::string::String>,
    _request_id: Option<String>,
}
impl GetResourceConfigHistoryOutput {
    /// <p>A list that contains the configuration history of one or more resources.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.configuration_items.is_none()`.
    pub fn configuration_items(&self) -> &[crate::types::ConfigurationItem] {
        self.configuration_items.as_deref().unwrap_or_default()
    }
    /// <p>The string that you use in a subsequent request to get the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> ::std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl ::aws_types::request_id::RequestId for GetResourceConfigHistoryOutput {
    fn request_id(&self) -> Option<&str> {
        self._request_id.as_deref()
    }
}
impl GetResourceConfigHistoryOutput {
    /// Creates a new builder-style object to manufacture [`GetResourceConfigHistoryOutput`](crate::operation::get_resource_config_history::GetResourceConfigHistoryOutput).
    pub fn builder() -> crate::operation::get_resource_config_history::builders::GetResourceConfigHistoryOutputBuilder {
        crate::operation::get_resource_config_history::builders::GetResourceConfigHistoryOutputBuilder::default()
    }
}

/// A builder for [`GetResourceConfigHistoryOutput`](crate::operation::get_resource_config_history::GetResourceConfigHistoryOutput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct GetResourceConfigHistoryOutputBuilder {
    pub(crate) configuration_items: ::std::option::Option<::std::vec::Vec<crate::types::ConfigurationItem>>,
    pub(crate) next_token: ::std::option::Option<::std::string::String>,
    _request_id: Option<String>,
}
impl GetResourceConfigHistoryOutputBuilder {
    /// Appends an item to `configuration_items`.
    ///
    /// To override the contents of this collection use [`set_configuration_items`](Self::set_configuration_items).
    ///
    /// <p>A list that contains the configuration history of one or more resources.</p>
    pub fn configuration_items(mut self, input: crate::types::ConfigurationItem) -> Self {
        let mut v = self.configuration_items.unwrap_or_default();
        v.push(input);
        self.configuration_items = ::std::option::Option::Some(v);
        self
    }
    /// <p>A list that contains the configuration history of one or more resources.</p>
    pub fn set_configuration_items(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::ConfigurationItem>>) -> Self {
        self.configuration_items = input;
        self
    }
    /// <p>A list that contains the configuration history of one or more resources.</p>
    pub fn get_configuration_items(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::ConfigurationItem>> {
        &self.configuration_items
    }
    /// <p>The string that you use in a subsequent request to get the next page of results in a paginated response.</p>
    pub fn next_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.next_token = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The string that you use in a subsequent request to get the next page of results in a paginated response.</p>
    pub fn set_next_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.next_token = input;
        self
    }
    /// <p>The string that you use in a subsequent request to get the next page of results in a paginated response.</p>
    pub fn get_next_token(&self) -> &::std::option::Option<::std::string::String> {
        &self.next_token
    }
    pub(crate) fn _request_id(mut self, request_id: impl Into<String>) -> Self {
        self._request_id = Some(request_id.into());
        self
    }

    pub(crate) fn _set_request_id(&mut self, request_id: Option<String>) -> &mut Self {
        self._request_id = request_id;
        self
    }
    /// Consumes the builder and constructs a [`GetResourceConfigHistoryOutput`](crate::operation::get_resource_config_history::GetResourceConfigHistoryOutput).
    pub fn build(self) -> crate::operation::get_resource_config_history::GetResourceConfigHistoryOutput {
        crate::operation::get_resource_config_history::GetResourceConfigHistoryOutput {
            configuration_items: self.configuration_items,
            next_token: self.next_token,
            _request_id: self._request_id,
        }
    }
}
