// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct GetResourceEvaluationSummaryOutput {
    /// <p>The unique <code>ResourceEvaluationId</code> of Amazon Web Services resource execution for which you want to retrieve the evaluation summary.</p>
    pub resource_evaluation_id: ::std::option::Option<::std::string::String>,
    /// <p>Lists results of the mode that you requested to retrieve the resource evaluation summary. The valid values are Detective or Proactive.</p>
    pub evaluation_mode: ::std::option::Option<crate::types::EvaluationMode>,
    /// <p>Returns an <code>EvaluationStatus</code> object.</p>
    pub evaluation_status: ::std::option::Option<crate::types::EvaluationStatus>,
    /// <p>The start timestamp when Config rule starts evaluating compliance for the provided resource details.</p>
    pub evaluation_start_timestamp: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>The compliance status of the resource evaluation summary.</p>
    pub compliance: ::std::option::Option<crate::types::ComplianceType>,
    /// <p>Returns an <code>EvaluationContext</code> object.</p>
    pub evaluation_context: ::std::option::Option<crate::types::EvaluationContext>,
    /// <p>Returns a <code>ResourceDetails</code> object.</p>
    pub resource_details: ::std::option::Option<crate::types::ResourceDetails>,
    _request_id: Option<String>,
}
impl GetResourceEvaluationSummaryOutput {
    /// <p>The unique <code>ResourceEvaluationId</code> of Amazon Web Services resource execution for which you want to retrieve the evaluation summary.</p>
    pub fn resource_evaluation_id(&self) -> ::std::option::Option<&str> {
        self.resource_evaluation_id.as_deref()
    }
    /// <p>Lists results of the mode that you requested to retrieve the resource evaluation summary. The valid values are Detective or Proactive.</p>
    pub fn evaluation_mode(&self) -> ::std::option::Option<&crate::types::EvaluationMode> {
        self.evaluation_mode.as_ref()
    }
    /// <p>Returns an <code>EvaluationStatus</code> object.</p>
    pub fn evaluation_status(&self) -> ::std::option::Option<&crate::types::EvaluationStatus> {
        self.evaluation_status.as_ref()
    }
    /// <p>The start timestamp when Config rule starts evaluating compliance for the provided resource details.</p>
    pub fn evaluation_start_timestamp(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.evaluation_start_timestamp.as_ref()
    }
    /// <p>The compliance status of the resource evaluation summary.</p>
    pub fn compliance(&self) -> ::std::option::Option<&crate::types::ComplianceType> {
        self.compliance.as_ref()
    }
    /// <p>Returns an <code>EvaluationContext</code> object.</p>
    pub fn evaluation_context(&self) -> ::std::option::Option<&crate::types::EvaluationContext> {
        self.evaluation_context.as_ref()
    }
    /// <p>Returns a <code>ResourceDetails</code> object.</p>
    pub fn resource_details(&self) -> ::std::option::Option<&crate::types::ResourceDetails> {
        self.resource_details.as_ref()
    }
}
impl ::aws_types::request_id::RequestId for GetResourceEvaluationSummaryOutput {
    fn request_id(&self) -> Option<&str> {
        self._request_id.as_deref()
    }
}
impl GetResourceEvaluationSummaryOutput {
    /// Creates a new builder-style object to manufacture [`GetResourceEvaluationSummaryOutput`](crate::operation::get_resource_evaluation_summary::GetResourceEvaluationSummaryOutput).
    pub fn builder() -> crate::operation::get_resource_evaluation_summary::builders::GetResourceEvaluationSummaryOutputBuilder {
        crate::operation::get_resource_evaluation_summary::builders::GetResourceEvaluationSummaryOutputBuilder::default()
    }
}

/// A builder for [`GetResourceEvaluationSummaryOutput`](crate::operation::get_resource_evaluation_summary::GetResourceEvaluationSummaryOutput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct GetResourceEvaluationSummaryOutputBuilder {
    pub(crate) resource_evaluation_id: ::std::option::Option<::std::string::String>,
    pub(crate) evaluation_mode: ::std::option::Option<crate::types::EvaluationMode>,
    pub(crate) evaluation_status: ::std::option::Option<crate::types::EvaluationStatus>,
    pub(crate) evaluation_start_timestamp: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) compliance: ::std::option::Option<crate::types::ComplianceType>,
    pub(crate) evaluation_context: ::std::option::Option<crate::types::EvaluationContext>,
    pub(crate) resource_details: ::std::option::Option<crate::types::ResourceDetails>,
    _request_id: Option<String>,
}
impl GetResourceEvaluationSummaryOutputBuilder {
    /// <p>The unique <code>ResourceEvaluationId</code> of Amazon Web Services resource execution for which you want to retrieve the evaluation summary.</p>
    pub fn resource_evaluation_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.resource_evaluation_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The unique <code>ResourceEvaluationId</code> of Amazon Web Services resource execution for which you want to retrieve the evaluation summary.</p>
    pub fn set_resource_evaluation_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.resource_evaluation_id = input;
        self
    }
    /// <p>The unique <code>ResourceEvaluationId</code> of Amazon Web Services resource execution for which you want to retrieve the evaluation summary.</p>
    pub fn get_resource_evaluation_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.resource_evaluation_id
    }
    /// <p>Lists results of the mode that you requested to retrieve the resource evaluation summary. The valid values are Detective or Proactive.</p>
    pub fn evaluation_mode(mut self, input: crate::types::EvaluationMode) -> Self {
        self.evaluation_mode = ::std::option::Option::Some(input);
        self
    }
    /// <p>Lists results of the mode that you requested to retrieve the resource evaluation summary. The valid values are Detective or Proactive.</p>
    pub fn set_evaluation_mode(mut self, input: ::std::option::Option<crate::types::EvaluationMode>) -> Self {
        self.evaluation_mode = input;
        self
    }
    /// <p>Lists results of the mode that you requested to retrieve the resource evaluation summary. The valid values are Detective or Proactive.</p>
    pub fn get_evaluation_mode(&self) -> &::std::option::Option<crate::types::EvaluationMode> {
        &self.evaluation_mode
    }
    /// <p>Returns an <code>EvaluationStatus</code> object.</p>
    pub fn evaluation_status(mut self, input: crate::types::EvaluationStatus) -> Self {
        self.evaluation_status = ::std::option::Option::Some(input);
        self
    }
    /// <p>Returns an <code>EvaluationStatus</code> object.</p>
    pub fn set_evaluation_status(mut self, input: ::std::option::Option<crate::types::EvaluationStatus>) -> Self {
        self.evaluation_status = input;
        self
    }
    /// <p>Returns an <code>EvaluationStatus</code> object.</p>
    pub fn get_evaluation_status(&self) -> &::std::option::Option<crate::types::EvaluationStatus> {
        &self.evaluation_status
    }
    /// <p>The start timestamp when Config rule starts evaluating compliance for the provided resource details.</p>
    pub fn evaluation_start_timestamp(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.evaluation_start_timestamp = ::std::option::Option::Some(input);
        self
    }
    /// <p>The start timestamp when Config rule starts evaluating compliance for the provided resource details.</p>
    pub fn set_evaluation_start_timestamp(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.evaluation_start_timestamp = input;
        self
    }
    /// <p>The start timestamp when Config rule starts evaluating compliance for the provided resource details.</p>
    pub fn get_evaluation_start_timestamp(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.evaluation_start_timestamp
    }
    /// <p>The compliance status of the resource evaluation summary.</p>
    pub fn compliance(mut self, input: crate::types::ComplianceType) -> Self {
        self.compliance = ::std::option::Option::Some(input);
        self
    }
    /// <p>The compliance status of the resource evaluation summary.</p>
    pub fn set_compliance(mut self, input: ::std::option::Option<crate::types::ComplianceType>) -> Self {
        self.compliance = input;
        self
    }
    /// <p>The compliance status of the resource evaluation summary.</p>
    pub fn get_compliance(&self) -> &::std::option::Option<crate::types::ComplianceType> {
        &self.compliance
    }
    /// <p>Returns an <code>EvaluationContext</code> object.</p>
    pub fn evaluation_context(mut self, input: crate::types::EvaluationContext) -> Self {
        self.evaluation_context = ::std::option::Option::Some(input);
        self
    }
    /// <p>Returns an <code>EvaluationContext</code> object.</p>
    pub fn set_evaluation_context(mut self, input: ::std::option::Option<crate::types::EvaluationContext>) -> Self {
        self.evaluation_context = input;
        self
    }
    /// <p>Returns an <code>EvaluationContext</code> object.</p>
    pub fn get_evaluation_context(&self) -> &::std::option::Option<crate::types::EvaluationContext> {
        &self.evaluation_context
    }
    /// <p>Returns a <code>ResourceDetails</code> object.</p>
    pub fn resource_details(mut self, input: crate::types::ResourceDetails) -> Self {
        self.resource_details = ::std::option::Option::Some(input);
        self
    }
    /// <p>Returns a <code>ResourceDetails</code> object.</p>
    pub fn set_resource_details(mut self, input: ::std::option::Option<crate::types::ResourceDetails>) -> Self {
        self.resource_details = input;
        self
    }
    /// <p>Returns a <code>ResourceDetails</code> object.</p>
    pub fn get_resource_details(&self) -> &::std::option::Option<crate::types::ResourceDetails> {
        &self.resource_details
    }
    pub(crate) fn _request_id(mut self, request_id: impl Into<String>) -> Self {
        self._request_id = Some(request_id.into());
        self
    }

    pub(crate) fn _set_request_id(&mut self, request_id: Option<String>) -> &mut Self {
        self._request_id = request_id;
        self
    }
    /// Consumes the builder and constructs a [`GetResourceEvaluationSummaryOutput`](crate::operation::get_resource_evaluation_summary::GetResourceEvaluationSummaryOutput).
    pub fn build(self) -> crate::operation::get_resource_evaluation_summary::GetResourceEvaluationSummaryOutput {
        crate::operation::get_resource_evaluation_summary::GetResourceEvaluationSummaryOutput {
            resource_evaluation_id: self.resource_evaluation_id,
            evaluation_mode: self.evaluation_mode,
            evaluation_status: self.evaluation_status,
            evaluation_start_timestamp: self.evaluation_start_timestamp,
            compliance: self.compliance,
            evaluation_context: self.evaluation_context,
            resource_details: self.resource_details,
            _request_id: self._request_id,
        }
    }
}
