// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ListAggregateDiscoveredResourcesInput {
    /// <p>The name of the configuration aggregator.</p>
    pub configuration_aggregator_name: ::std::option::Option<::std::string::String>,
    /// <p>The type of resources that you want Config to list in the response.</p>
    pub resource_type: ::std::option::Option<crate::types::ResourceType>,
    /// <p>Filters the results based on the <code>ResourceFilters</code> object.</p>
    pub filters: ::std::option::Option<crate::types::ResourceFilters>,
    /// <p>The maximum number of resource identifiers returned on each page. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
    pub limit: ::std::option::Option<i32>,
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub next_token: ::std::option::Option<::std::string::String>,
}
impl ListAggregateDiscoveredResourcesInput {
    /// <p>The name of the configuration aggregator.</p>
    pub fn configuration_aggregator_name(&self) -> ::std::option::Option<&str> {
        self.configuration_aggregator_name.as_deref()
    }
    /// <p>The type of resources that you want Config to list in the response.</p>
    pub fn resource_type(&self) -> ::std::option::Option<&crate::types::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>Filters the results based on the <code>ResourceFilters</code> object.</p>
    pub fn filters(&self) -> ::std::option::Option<&crate::types::ResourceFilters> {
        self.filters.as_ref()
    }
    /// <p>The maximum number of resource identifiers returned on each page. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
    pub fn limit(&self) -> ::std::option::Option<i32> {
        self.limit
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> ::std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl ListAggregateDiscoveredResourcesInput {
    /// Creates a new builder-style object to manufacture [`ListAggregateDiscoveredResourcesInput`](crate::operation::list_aggregate_discovered_resources::ListAggregateDiscoveredResourcesInput).
    pub fn builder() -> crate::operation::list_aggregate_discovered_resources::builders::ListAggregateDiscoveredResourcesInputBuilder {
        crate::operation::list_aggregate_discovered_resources::builders::ListAggregateDiscoveredResourcesInputBuilder::default()
    }
}

/// A builder for [`ListAggregateDiscoveredResourcesInput`](crate::operation::list_aggregate_discovered_resources::ListAggregateDiscoveredResourcesInput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ListAggregateDiscoveredResourcesInputBuilder {
    pub(crate) configuration_aggregator_name: ::std::option::Option<::std::string::String>,
    pub(crate) resource_type: ::std::option::Option<crate::types::ResourceType>,
    pub(crate) filters: ::std::option::Option<crate::types::ResourceFilters>,
    pub(crate) limit: ::std::option::Option<i32>,
    pub(crate) next_token: ::std::option::Option<::std::string::String>,
}
impl ListAggregateDiscoveredResourcesInputBuilder {
    /// <p>The name of the configuration aggregator.</p>
    /// This field is required.
    pub fn configuration_aggregator_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.configuration_aggregator_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the configuration aggregator.</p>
    pub fn set_configuration_aggregator_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.configuration_aggregator_name = input;
        self
    }
    /// <p>The name of the configuration aggregator.</p>
    pub fn get_configuration_aggregator_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.configuration_aggregator_name
    }
    /// <p>The type of resources that you want Config to list in the response.</p>
    /// This field is required.
    pub fn resource_type(mut self, input: crate::types::ResourceType) -> Self {
        self.resource_type = ::std::option::Option::Some(input);
        self
    }
    /// <p>The type of resources that you want Config to list in the response.</p>
    pub fn set_resource_type(mut self, input: ::std::option::Option<crate::types::ResourceType>) -> Self {
        self.resource_type = input;
        self
    }
    /// <p>The type of resources that you want Config to list in the response.</p>
    pub fn get_resource_type(&self) -> &::std::option::Option<crate::types::ResourceType> {
        &self.resource_type
    }
    /// <p>Filters the results based on the <code>ResourceFilters</code> object.</p>
    pub fn filters(mut self, input: crate::types::ResourceFilters) -> Self {
        self.filters = ::std::option::Option::Some(input);
        self
    }
    /// <p>Filters the results based on the <code>ResourceFilters</code> object.</p>
    pub fn set_filters(mut self, input: ::std::option::Option<crate::types::ResourceFilters>) -> Self {
        self.filters = input;
        self
    }
    /// <p>Filters the results based on the <code>ResourceFilters</code> object.</p>
    pub fn get_filters(&self) -> &::std::option::Option<crate::types::ResourceFilters> {
        &self.filters
    }
    /// <p>The maximum number of resource identifiers returned on each page. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
    pub fn limit(mut self, input: i32) -> Self {
        self.limit = ::std::option::Option::Some(input);
        self
    }
    /// <p>The maximum number of resource identifiers returned on each page. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
    pub fn set_limit(mut self, input: ::std::option::Option<i32>) -> Self {
        self.limit = input;
        self
    }
    /// <p>The maximum number of resource identifiers returned on each page. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
    pub fn get_limit(&self) -> &::std::option::Option<i32> {
        &self.limit
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.next_token = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn set_next_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.next_token = input;
        self
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn get_next_token(&self) -> &::std::option::Option<::std::string::String> {
        &self.next_token
    }
    /// Consumes the builder and constructs a [`ListAggregateDiscoveredResourcesInput`](crate::operation::list_aggregate_discovered_resources::ListAggregateDiscoveredResourcesInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<
        crate::operation::list_aggregate_discovered_resources::ListAggregateDiscoveredResourcesInput,
        ::aws_smithy_types::error::operation::BuildError,
    > {
        ::std::result::Result::Ok(
            crate::operation::list_aggregate_discovered_resources::ListAggregateDiscoveredResourcesInput {
                configuration_aggregator_name: self.configuration_aggregator_name,
                resource_type: self.resource_type,
                filters: self.filters,
                limit: self.limit,
                next_token: self.next_token,
            },
        )
    }
}
