// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::list_conformance_pack_compliance_scores::_list_conformance_pack_compliance_scores_output::ListConformancePackComplianceScoresOutputBuilder;

pub use crate::operation::list_conformance_pack_compliance_scores::_list_conformance_pack_compliance_scores_input::ListConformancePackComplianceScoresInputBuilder;

impl crate::operation::list_conformance_pack_compliance_scores::builders::ListConformancePackComplianceScoresInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::list_conformance_pack_compliance_scores::ListConformancePackComplianceScoresOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::list_conformance_pack_compliance_scores::ListConformancePackComplianceScoresError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.list_conformance_pack_compliance_scores();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `ListConformancePackComplianceScores`.
///
/// <p>Returns a list of conformance pack compliance scores. A compliance score is the percentage of the number of compliant rule-resource combinations in a conformance pack compared to the number of total possible rule-resource combinations in the conformance pack. This metric provides you with a high-level view of the compliance state of your conformance packs. You can use it to identify, investigate, and understand the level of compliance in your conformance packs.</p><note>
/// <p>Conformance packs with no evaluation results will have a compliance score of <code>INSUFFICIENT_DATA</code>.</p>
/// </note>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct ListConformancePackComplianceScoresFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::list_conformance_pack_compliance_scores::builders::ListConformancePackComplianceScoresInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::list_conformance_pack_compliance_scores::ListConformancePackComplianceScoresOutput,
        crate::operation::list_conformance_pack_compliance_scores::ListConformancePackComplianceScoresError,
    > for ListConformancePackComplianceScoresFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::list_conformance_pack_compliance_scores::ListConformancePackComplianceScoresOutput,
            crate::operation::list_conformance_pack_compliance_scores::ListConformancePackComplianceScoresError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl ListConformancePackComplianceScoresFluentBuilder {
    /// Creates a new `ListConformancePackComplianceScoresFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the ListConformancePackComplianceScores as a reference.
    pub fn as_input(&self) -> &crate::operation::list_conformance_pack_compliance_scores::builders::ListConformancePackComplianceScoresInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::list_conformance_pack_compliance_scores::ListConformancePackComplianceScoresOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::list_conformance_pack_compliance_scores::ListConformancePackComplianceScoresError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins =
            crate::operation::list_conformance_pack_compliance_scores::ListConformancePackComplianceScores::operation_runtime_plugins(
                self.handle.runtime_plugins.clone(),
                &self.handle.conf,
                self.config_override,
            );
        crate::operation::list_conformance_pack_compliance_scores::ListConformancePackComplianceScores::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::list_conformance_pack_compliance_scores::ListConformancePackComplianceScoresOutput,
        crate::operation::list_conformance_pack_compliance_scores::ListConformancePackComplianceScoresError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// Create a paginator for this request
    ///
    /// Paginators are used by calling [`send().await`](crate::operation::list_conformance_pack_compliance_scores::paginator::ListConformancePackComplianceScoresPaginator::send) which returns a [`PaginationStream`](aws_smithy_async::future::pagination_stream::PaginationStream).
    pub fn into_paginator(
        self,
    ) -> crate::operation::list_conformance_pack_compliance_scores::paginator::ListConformancePackComplianceScoresPaginator {
        crate::operation::list_conformance_pack_compliance_scores::paginator::ListConformancePackComplianceScoresPaginator::new(
            self.handle,
            self.inner,
        )
    }
    /// <p>Filters the results based on the <code>ConformancePackComplianceScoresFilters</code>.</p>
    pub fn filters(mut self, input: crate::types::ConformancePackComplianceScoresFilters) -> Self {
        self.inner = self.inner.filters(input);
        self
    }
    /// <p>Filters the results based on the <code>ConformancePackComplianceScoresFilters</code>.</p>
    pub fn set_filters(mut self, input: ::std::option::Option<crate::types::ConformancePackComplianceScoresFilters>) -> Self {
        self.inner = self.inner.set_filters(input);
        self
    }
    /// <p>Filters the results based on the <code>ConformancePackComplianceScoresFilters</code>.</p>
    pub fn get_filters(&self) -> &::std::option::Option<crate::types::ConformancePackComplianceScoresFilters> {
        self.inner.get_filters()
    }
    /// <p>Determines the order in which conformance pack compliance scores are sorted. Either in ascending or descending order.</p>
    /// <p>By default, conformance pack compliance scores are sorted in alphabetical order by name of the conformance pack. Conformance pack compliance scores are sorted in reverse alphabetical order if you enter <code>DESCENDING</code>.</p>
    /// <p>You can sort conformance pack compliance scores by the numerical value of the compliance score by entering <code>SCORE</code> in the <code>SortBy</code> action. When compliance scores are sorted by <code>SCORE</code>, conformance packs with a compliance score of <code>INSUFFICIENT_DATA</code> will be last when sorting by ascending order and first when sorting by descending order.</p>
    pub fn sort_order(mut self, input: crate::types::SortOrder) -> Self {
        self.inner = self.inner.sort_order(input);
        self
    }
    /// <p>Determines the order in which conformance pack compliance scores are sorted. Either in ascending or descending order.</p>
    /// <p>By default, conformance pack compliance scores are sorted in alphabetical order by name of the conformance pack. Conformance pack compliance scores are sorted in reverse alphabetical order if you enter <code>DESCENDING</code>.</p>
    /// <p>You can sort conformance pack compliance scores by the numerical value of the compliance score by entering <code>SCORE</code> in the <code>SortBy</code> action. When compliance scores are sorted by <code>SCORE</code>, conformance packs with a compliance score of <code>INSUFFICIENT_DATA</code> will be last when sorting by ascending order and first when sorting by descending order.</p>
    pub fn set_sort_order(mut self, input: ::std::option::Option<crate::types::SortOrder>) -> Self {
        self.inner = self.inner.set_sort_order(input);
        self
    }
    /// <p>Determines the order in which conformance pack compliance scores are sorted. Either in ascending or descending order.</p>
    /// <p>By default, conformance pack compliance scores are sorted in alphabetical order by name of the conformance pack. Conformance pack compliance scores are sorted in reverse alphabetical order if you enter <code>DESCENDING</code>.</p>
    /// <p>You can sort conformance pack compliance scores by the numerical value of the compliance score by entering <code>SCORE</code> in the <code>SortBy</code> action. When compliance scores are sorted by <code>SCORE</code>, conformance packs with a compliance score of <code>INSUFFICIENT_DATA</code> will be last when sorting by ascending order and first when sorting by descending order.</p>
    pub fn get_sort_order(&self) -> &::std::option::Option<crate::types::SortOrder> {
        self.inner.get_sort_order()
    }
    /// <p>Sorts your conformance pack compliance scores in either ascending or descending order, depending on <code>SortOrder</code>.</p>
    /// <p>By default, conformance pack compliance scores are sorted in alphabetical order by name of the conformance pack. Enter <code>SCORE</code>, to sort conformance pack compliance scores by the numerical value of the compliance score.</p>
    pub fn sort_by(mut self, input: crate::types::SortBy) -> Self {
        self.inner = self.inner.sort_by(input);
        self
    }
    /// <p>Sorts your conformance pack compliance scores in either ascending or descending order, depending on <code>SortOrder</code>.</p>
    /// <p>By default, conformance pack compliance scores are sorted in alphabetical order by name of the conformance pack. Enter <code>SCORE</code>, to sort conformance pack compliance scores by the numerical value of the compliance score.</p>
    pub fn set_sort_by(mut self, input: ::std::option::Option<crate::types::SortBy>) -> Self {
        self.inner = self.inner.set_sort_by(input);
        self
    }
    /// <p>Sorts your conformance pack compliance scores in either ascending or descending order, depending on <code>SortOrder</code>.</p>
    /// <p>By default, conformance pack compliance scores are sorted in alphabetical order by name of the conformance pack. Enter <code>SCORE</code>, to sort conformance pack compliance scores by the numerical value of the compliance score.</p>
    pub fn get_sort_by(&self) -> &::std::option::Option<crate::types::SortBy> {
        self.inner.get_sort_by()
    }
    /// <p>The maximum number of conformance pack compliance scores returned on each page.</p>
    pub fn limit(mut self, input: i32) -> Self {
        self.inner = self.inner.limit(input);
        self
    }
    /// <p>The maximum number of conformance pack compliance scores returned on each page.</p>
    pub fn set_limit(mut self, input: ::std::option::Option<i32>) -> Self {
        self.inner = self.inner.set_limit(input);
        self
    }
    /// <p>The maximum number of conformance pack compliance scores returned on each page.</p>
    pub fn get_limit(&self) -> &::std::option::Option<i32> {
        self.inner.get_limit()
    }
    /// <p>The <code>nextToken</code> string in a prior request that you can use to get the paginated response for the next set of conformance pack compliance scores.</p>
    pub fn next_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.next_token(input.into());
        self
    }
    /// <p>The <code>nextToken</code> string in a prior request that you can use to get the paginated response for the next set of conformance pack compliance scores.</p>
    pub fn set_next_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_next_token(input);
        self
    }
    /// <p>The <code>nextToken</code> string in a prior request that you can use to get the paginated response for the next set of conformance pack compliance scores.</p>
    pub fn get_next_token(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_next_token()
    }
}
