// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. The following resources are supported:</p>
    /// <ul>
    /// <li>
    /// <p><code>ConfigurationRecorder</code></p></li>
    /// <li>
    /// <p><code>ConfigRule</code></p></li>
    /// <li>
    /// <p><code>OrganizationConfigRule</code></p></li>
    /// <li>
    /// <p><code>ConformancePack</code></p></li>
    /// <li>
    /// <p><code>OrganizationConformancePack</code></p></li>
    /// <li>
    /// <p><code>ConfigurationAggregator</code></p></li>
    /// <li>
    /// <p><code>AggregationAuthorization</code></p></li>
    /// <li>
    /// <p><code>StoredQuery</code></p></li>
    /// </ul>
    pub resource_arn: ::std::option::Option<::std::string::String>,
    /// <p>The maximum number of tags returned on each page. The limit maximum is 50. You cannot specify a number greater than 50. If you specify 0, Config uses the default.</p>
    pub limit: ::std::option::Option<i32>,
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub next_token: ::std::option::Option<::std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. The following resources are supported:</p>
    /// <ul>
    /// <li>
    /// <p><code>ConfigurationRecorder</code></p></li>
    /// <li>
    /// <p><code>ConfigRule</code></p></li>
    /// <li>
    /// <p><code>OrganizationConfigRule</code></p></li>
    /// <li>
    /// <p><code>ConformancePack</code></p></li>
    /// <li>
    /// <p><code>OrganizationConformancePack</code></p></li>
    /// <li>
    /// <p><code>ConfigurationAggregator</code></p></li>
    /// <li>
    /// <p><code>AggregationAuthorization</code></p></li>
    /// <li>
    /// <p><code>StoredQuery</code></p></li>
    /// </ul>
    pub fn resource_arn(&self) -> ::std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The maximum number of tags returned on each page. The limit maximum is 50. You cannot specify a number greater than 50. If you specify 0, Config uses the default.</p>
    pub fn limit(&self) -> ::std::option::Option<i32> {
        self.limit
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> ::std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl ListTagsForResourceInput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::operation::list_tags_for_resource::ListTagsForResourceInput).
    pub fn builder() -> crate::operation::list_tags_for_resource::builders::ListTagsForResourceInputBuilder {
        crate::operation::list_tags_for_resource::builders::ListTagsForResourceInputBuilder::default()
    }
}

/// A builder for [`ListTagsForResourceInput`](crate::operation::list_tags_for_resource::ListTagsForResourceInput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ListTagsForResourceInputBuilder {
    pub(crate) resource_arn: ::std::option::Option<::std::string::String>,
    pub(crate) limit: ::std::option::Option<i32>,
    pub(crate) next_token: ::std::option::Option<::std::string::String>,
}
impl ListTagsForResourceInputBuilder {
    /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. The following resources are supported:</p>
    /// <ul>
    /// <li>
    /// <p><code>ConfigurationRecorder</code></p></li>
    /// <li>
    /// <p><code>ConfigRule</code></p></li>
    /// <li>
    /// <p><code>OrganizationConfigRule</code></p></li>
    /// <li>
    /// <p><code>ConformancePack</code></p></li>
    /// <li>
    /// <p><code>OrganizationConformancePack</code></p></li>
    /// <li>
    /// <p><code>ConfigurationAggregator</code></p></li>
    /// <li>
    /// <p><code>AggregationAuthorization</code></p></li>
    /// <li>
    /// <p><code>StoredQuery</code></p></li>
    /// </ul>
    /// This field is required.
    pub fn resource_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.resource_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. The following resources are supported:</p>
    /// <ul>
    /// <li>
    /// <p><code>ConfigurationRecorder</code></p></li>
    /// <li>
    /// <p><code>ConfigRule</code></p></li>
    /// <li>
    /// <p><code>OrganizationConfigRule</code></p></li>
    /// <li>
    /// <p><code>ConformancePack</code></p></li>
    /// <li>
    /// <p><code>OrganizationConformancePack</code></p></li>
    /// <li>
    /// <p><code>ConfigurationAggregator</code></p></li>
    /// <li>
    /// <p><code>AggregationAuthorization</code></p></li>
    /// <li>
    /// <p><code>StoredQuery</code></p></li>
    /// </ul>
    pub fn set_resource_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.resource_arn = input;
        self
    }
    /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. The following resources are supported:</p>
    /// <ul>
    /// <li>
    /// <p><code>ConfigurationRecorder</code></p></li>
    /// <li>
    /// <p><code>ConfigRule</code></p></li>
    /// <li>
    /// <p><code>OrganizationConfigRule</code></p></li>
    /// <li>
    /// <p><code>ConformancePack</code></p></li>
    /// <li>
    /// <p><code>OrganizationConformancePack</code></p></li>
    /// <li>
    /// <p><code>ConfigurationAggregator</code></p></li>
    /// <li>
    /// <p><code>AggregationAuthorization</code></p></li>
    /// <li>
    /// <p><code>StoredQuery</code></p></li>
    /// </ul>
    pub fn get_resource_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.resource_arn
    }
    /// <p>The maximum number of tags returned on each page. The limit maximum is 50. You cannot specify a number greater than 50. If you specify 0, Config uses the default.</p>
    pub fn limit(mut self, input: i32) -> Self {
        self.limit = ::std::option::Option::Some(input);
        self
    }
    /// <p>The maximum number of tags returned on each page. The limit maximum is 50. You cannot specify a number greater than 50. If you specify 0, Config uses the default.</p>
    pub fn set_limit(mut self, input: ::std::option::Option<i32>) -> Self {
        self.limit = input;
        self
    }
    /// <p>The maximum number of tags returned on each page. The limit maximum is 50. You cannot specify a number greater than 50. If you specify 0, Config uses the default.</p>
    pub fn get_limit(&self) -> &::std::option::Option<i32> {
        &self.limit
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.next_token = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn set_next_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.next_token = input;
        self
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn get_next_token(&self) -> &::std::option::Option<::std::string::String> {
        &self.next_token
    }
    /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::operation::list_tags_for_resource::ListTagsForResourceInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<crate::operation::list_tags_for_resource::ListTagsForResourceInput, ::aws_smithy_types::error::operation::BuildError>
    {
        ::std::result::Result::Ok(crate::operation::list_tags_for_resource::ListTagsForResourceInput {
            resource_arn: self.resource_arn,
            limit: self.limit,
            next_token: self.next_token,
        })
    }
}
