// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::put_external_evaluation::_put_external_evaluation_output::PutExternalEvaluationOutputBuilder;

pub use crate::operation::put_external_evaluation::_put_external_evaluation_input::PutExternalEvaluationInputBuilder;

impl crate::operation::put_external_evaluation::builders::PutExternalEvaluationInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::put_external_evaluation::PutExternalEvaluationOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_external_evaluation::PutExternalEvaluationError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.put_external_evaluation();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `PutExternalEvaluation`.
///
/// <p>Add or updates the evaluations for process checks. This API checks if the rule is a process check when the name of the Config rule is provided.</p>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct PutExternalEvaluationFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::put_external_evaluation::builders::PutExternalEvaluationInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::put_external_evaluation::PutExternalEvaluationOutput,
        crate::operation::put_external_evaluation::PutExternalEvaluationError,
    > for PutExternalEvaluationFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::put_external_evaluation::PutExternalEvaluationOutput,
            crate::operation::put_external_evaluation::PutExternalEvaluationError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl PutExternalEvaluationFluentBuilder {
    /// Creates a new `PutExternalEvaluationFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the PutExternalEvaluation as a reference.
    pub fn as_input(&self) -> &crate::operation::put_external_evaluation::builders::PutExternalEvaluationInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::put_external_evaluation::PutExternalEvaluationOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_external_evaluation::PutExternalEvaluationError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::put_external_evaluation::PutExternalEvaluation::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::put_external_evaluation::PutExternalEvaluation::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::put_external_evaluation::PutExternalEvaluationOutput,
        crate::operation::put_external_evaluation::PutExternalEvaluationError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The name of the Config rule.</p>
    pub fn config_rule_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.config_rule_name(input.into());
        self
    }
    /// <p>The name of the Config rule.</p>
    pub fn set_config_rule_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_config_rule_name(input);
        self
    }
    /// <p>The name of the Config rule.</p>
    pub fn get_config_rule_name(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_config_rule_name()
    }
    /// <p>An <code>ExternalEvaluation</code> object that provides details about compliance.</p>
    pub fn external_evaluation(mut self, input: crate::types::ExternalEvaluation) -> Self {
        self.inner = self.inner.external_evaluation(input);
        self
    }
    /// <p>An <code>ExternalEvaluation</code> object that provides details about compliance.</p>
    pub fn set_external_evaluation(mut self, input: ::std::option::Option<crate::types::ExternalEvaluation>) -> Self {
        self.inner = self.inner.set_external_evaluation(input);
        self
    }
    /// <p>An <code>ExternalEvaluation</code> object that provides details about compliance.</p>
    pub fn get_external_evaluation(&self) -> &::std::option::Option<crate::types::ExternalEvaluation> {
        self.inner.get_external_evaluation()
    }
}
