// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::put_resource_config::_put_resource_config_output::PutResourceConfigOutputBuilder;

pub use crate::operation::put_resource_config::_put_resource_config_input::PutResourceConfigInputBuilder;

impl crate::operation::put_resource_config::builders::PutResourceConfigInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::put_resource_config::PutResourceConfigOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_resource_config::PutResourceConfigError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.put_resource_config();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `PutResourceConfig`.
///
/// <p>Records the configuration state for the resource provided in the request. The configuration state of a resource is represented in Config as Configuration Items. Once this API records the configuration item, you can retrieve the list of configuration items for the custom resource type using existing Config APIs.</p><note>
/// <p>The custom resource type must be registered with CloudFormation. This API accepts the configuration item registered with CloudFormation.</p>
/// <p>When you call this API, Config only stores configuration state of the resource provided in the request. This API does not change or remediate the configuration of the resource.</p>
/// <p>Write-only schema properites are not recorded as part of the published configuration item.</p>
/// </note>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct PutResourceConfigFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::put_resource_config::builders::PutResourceConfigInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::put_resource_config::PutResourceConfigOutput,
        crate::operation::put_resource_config::PutResourceConfigError,
    > for PutResourceConfigFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::put_resource_config::PutResourceConfigOutput,
            crate::operation::put_resource_config::PutResourceConfigError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl PutResourceConfigFluentBuilder {
    /// Creates a new `PutResourceConfigFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the PutResourceConfig as a reference.
    pub fn as_input(&self) -> &crate::operation::put_resource_config::builders::PutResourceConfigInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::put_resource_config::PutResourceConfigOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_resource_config::PutResourceConfigError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::put_resource_config::PutResourceConfig::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::put_resource_config::PutResourceConfig::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::put_resource_config::PutResourceConfigOutput,
        crate::operation::put_resource_config::PutResourceConfigError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The type of the resource. The custom resource type must be registered with CloudFormation.</p><note>
    /// <p>You cannot use the organization names “amzn”, “amazon”, “alexa”, “custom” with custom resource types. It is the first part of the ResourceType up to the first ::.</p>
    /// </note>
    pub fn resource_type(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.resource_type(input.into());
        self
    }
    /// <p>The type of the resource. The custom resource type must be registered with CloudFormation.</p><note>
    /// <p>You cannot use the organization names “amzn”, “amazon”, “alexa”, “custom” with custom resource types. It is the first part of the ResourceType up to the first ::.</p>
    /// </note>
    pub fn set_resource_type(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_resource_type(input);
        self
    }
    /// <p>The type of the resource. The custom resource type must be registered with CloudFormation.</p><note>
    /// <p>You cannot use the organization names “amzn”, “amazon”, “alexa”, “custom” with custom resource types. It is the first part of the ResourceType up to the first ::.</p>
    /// </note>
    pub fn get_resource_type(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_resource_type()
    }
    /// <p>Version of the schema registered for the ResourceType in CloudFormation.</p>
    pub fn schema_version_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.schema_version_id(input.into());
        self
    }
    /// <p>Version of the schema registered for the ResourceType in CloudFormation.</p>
    pub fn set_schema_version_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_schema_version_id(input);
        self
    }
    /// <p>Version of the schema registered for the ResourceType in CloudFormation.</p>
    pub fn get_schema_version_id(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_schema_version_id()
    }
    /// <p>Unique identifier of the resource.</p>
    pub fn resource_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.resource_id(input.into());
        self
    }
    /// <p>Unique identifier of the resource.</p>
    pub fn set_resource_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_resource_id(input);
        self
    }
    /// <p>Unique identifier of the resource.</p>
    pub fn get_resource_id(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_resource_id()
    }
    /// <p>Name of the resource.</p>
    pub fn resource_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.resource_name(input.into());
        self
    }
    /// <p>Name of the resource.</p>
    pub fn set_resource_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_resource_name(input);
        self
    }
    /// <p>Name of the resource.</p>
    pub fn get_resource_name(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_resource_name()
    }
    /// <p>The configuration object of the resource in valid JSON format. It must match the schema registered with CloudFormation.</p><note>
    /// <p>The configuration JSON must not exceed 64 KB.</p>
    /// </note>
    pub fn configuration(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.configuration(input.into());
        self
    }
    /// <p>The configuration object of the resource in valid JSON format. It must match the schema registered with CloudFormation.</p><note>
    /// <p>The configuration JSON must not exceed 64 KB.</p>
    /// </note>
    pub fn set_configuration(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_configuration(input);
        self
    }
    /// <p>The configuration object of the resource in valid JSON format. It must match the schema registered with CloudFormation.</p><note>
    /// <p>The configuration JSON must not exceed 64 KB.</p>
    /// </note>
    pub fn get_configuration(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_configuration()
    }
    ///
    /// Adds a key-value pair to `Tags`.
    ///
    /// To override the contents of this collection use [`set_tags`](Self::set_tags).
    ///
    /// <p>Tags associated with the resource.</p><note>
    /// <p>This field is not to be confused with the Amazon Web Services-wide tag feature for Amazon Web Services resources. Tags for <code>PutResourceConfig</code> are tags that you supply for the configuration items of your custom resources.</p>
    /// </note>
    pub fn tags(mut self, k: impl ::std::convert::Into<::std::string::String>, v: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.tags(k.into(), v.into());
        self
    }
    /// <p>Tags associated with the resource.</p><note>
    /// <p>This field is not to be confused with the Amazon Web Services-wide tag feature for Amazon Web Services resources. Tags for <code>PutResourceConfig</code> are tags that you supply for the configuration items of your custom resources.</p>
    /// </note>
    pub fn set_tags(mut self, input: ::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>>) -> Self {
        self.inner = self.inner.set_tags(input);
        self
    }
    /// <p>Tags associated with the resource.</p><note>
    /// <p>This field is not to be confused with the Amazon Web Services-wide tag feature for Amazon Web Services resources. Tags for <code>PutResourceConfig</code> are tags that you supply for the configuration items of your custom resources.</p>
    /// </note>
    pub fn get_tags(&self) -> &::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>> {
        self.inner.get_tags()
    }
}
