// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. The following resources are supported:</p>
    /// <ul>
    /// <li>
    /// <p><code>ConfigurationRecorder</code></p></li>
    /// <li>
    /// <p><code>ConfigRule</code></p></li>
    /// <li>
    /// <p><code>OrganizationConfigRule</code></p></li>
    /// <li>
    /// <p><code>ConformancePack</code></p></li>
    /// <li>
    /// <p><code>OrganizationConformancePack</code></p></li>
    /// <li>
    /// <p><code>ConfigurationAggregator</code></p></li>
    /// <li>
    /// <p><code>AggregationAuthorization</code></p></li>
    /// <li>
    /// <p><code>StoredQuery</code></p></li>
    /// </ul>
    pub resource_arn: ::std::option::Option<::std::string::String>,
    /// <p>An array of tag object.</p>
    pub tags: ::std::option::Option<::std::vec::Vec<crate::types::Tag>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. The following resources are supported:</p>
    /// <ul>
    /// <li>
    /// <p><code>ConfigurationRecorder</code></p></li>
    /// <li>
    /// <p><code>ConfigRule</code></p></li>
    /// <li>
    /// <p><code>OrganizationConfigRule</code></p></li>
    /// <li>
    /// <p><code>ConformancePack</code></p></li>
    /// <li>
    /// <p><code>OrganizationConformancePack</code></p></li>
    /// <li>
    /// <p><code>ConfigurationAggregator</code></p></li>
    /// <li>
    /// <p><code>AggregationAuthorization</code></p></li>
    /// <li>
    /// <p><code>StoredQuery</code></p></li>
    /// </ul>
    pub fn resource_arn(&self) -> ::std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>An array of tag object.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.tags.is_none()`.
    pub fn tags(&self) -> &[crate::types::Tag] {
        self.tags.as_deref().unwrap_or_default()
    }
}
impl TagResourceInput {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::operation::tag_resource::TagResourceInput).
    pub fn builder() -> crate::operation::tag_resource::builders::TagResourceInputBuilder {
        crate::operation::tag_resource::builders::TagResourceInputBuilder::default()
    }
}

/// A builder for [`TagResourceInput`](crate::operation::tag_resource::TagResourceInput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct TagResourceInputBuilder {
    pub(crate) resource_arn: ::std::option::Option<::std::string::String>,
    pub(crate) tags: ::std::option::Option<::std::vec::Vec<crate::types::Tag>>,
}
impl TagResourceInputBuilder {
    /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. The following resources are supported:</p>
    /// <ul>
    /// <li>
    /// <p><code>ConfigurationRecorder</code></p></li>
    /// <li>
    /// <p><code>ConfigRule</code></p></li>
    /// <li>
    /// <p><code>OrganizationConfigRule</code></p></li>
    /// <li>
    /// <p><code>ConformancePack</code></p></li>
    /// <li>
    /// <p><code>OrganizationConformancePack</code></p></li>
    /// <li>
    /// <p><code>ConfigurationAggregator</code></p></li>
    /// <li>
    /// <p><code>AggregationAuthorization</code></p></li>
    /// <li>
    /// <p><code>StoredQuery</code></p></li>
    /// </ul>
    /// This field is required.
    pub fn resource_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.resource_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. The following resources are supported:</p>
    /// <ul>
    /// <li>
    /// <p><code>ConfigurationRecorder</code></p></li>
    /// <li>
    /// <p><code>ConfigRule</code></p></li>
    /// <li>
    /// <p><code>OrganizationConfigRule</code></p></li>
    /// <li>
    /// <p><code>ConformancePack</code></p></li>
    /// <li>
    /// <p><code>OrganizationConformancePack</code></p></li>
    /// <li>
    /// <p><code>ConfigurationAggregator</code></p></li>
    /// <li>
    /// <p><code>AggregationAuthorization</code></p></li>
    /// <li>
    /// <p><code>StoredQuery</code></p></li>
    /// </ul>
    pub fn set_resource_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.resource_arn = input;
        self
    }
    /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. The following resources are supported:</p>
    /// <ul>
    /// <li>
    /// <p><code>ConfigurationRecorder</code></p></li>
    /// <li>
    /// <p><code>ConfigRule</code></p></li>
    /// <li>
    /// <p><code>OrganizationConfigRule</code></p></li>
    /// <li>
    /// <p><code>ConformancePack</code></p></li>
    /// <li>
    /// <p><code>OrganizationConformancePack</code></p></li>
    /// <li>
    /// <p><code>ConfigurationAggregator</code></p></li>
    /// <li>
    /// <p><code>AggregationAuthorization</code></p></li>
    /// <li>
    /// <p><code>StoredQuery</code></p></li>
    /// </ul>
    pub fn get_resource_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.resource_arn
    }
    /// Appends an item to `tags`.
    ///
    /// To override the contents of this collection use [`set_tags`](Self::set_tags).
    ///
    /// <p>An array of tag object.</p>
    pub fn tags(mut self, input: crate::types::Tag) -> Self {
        let mut v = self.tags.unwrap_or_default();
        v.push(input);
        self.tags = ::std::option::Option::Some(v);
        self
    }
    /// <p>An array of tag object.</p>
    pub fn set_tags(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::Tag>>) -> Self {
        self.tags = input;
        self
    }
    /// <p>An array of tag object.</p>
    pub fn get_tags(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::Tag>> {
        &self.tags
    }
    /// Consumes the builder and constructs a [`TagResourceInput`](crate::operation::tag_resource::TagResourceInput).
    pub fn build(self) -> ::std::result::Result<crate::operation::tag_resource::TagResourceInput, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::operation::tag_resource::TagResourceInput {
            resource_arn: self.resource_arn,
            tags: self.tags,
        })
    }
}
