// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Filters the conformance packs based on an account ID, region, compliance type, and the name of the conformance pack.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct AggregateConformancePackComplianceFilters {
    /// <p>The name of the conformance pack.</p>
    pub conformance_pack_name: ::std::option::Option<::std::string::String>,
    /// <p>The compliance status of the conformance pack.</p>
    pub compliance_type: ::std::option::Option<crate::types::ConformancePackComplianceType>,
    /// <p>The 12-digit Amazon Web Services account ID of the source account.</p>
    pub account_id: ::std::option::Option<::std::string::String>,
    /// <p>The source Amazon Web Services Region from where the data is aggregated.</p>
    pub aws_region: ::std::option::Option<::std::string::String>,
}
impl AggregateConformancePackComplianceFilters {
    /// <p>The name of the conformance pack.</p>
    pub fn conformance_pack_name(&self) -> ::std::option::Option<&str> {
        self.conformance_pack_name.as_deref()
    }
    /// <p>The compliance status of the conformance pack.</p>
    pub fn compliance_type(&self) -> ::std::option::Option<&crate::types::ConformancePackComplianceType> {
        self.compliance_type.as_ref()
    }
    /// <p>The 12-digit Amazon Web Services account ID of the source account.</p>
    pub fn account_id(&self) -> ::std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The source Amazon Web Services Region from where the data is aggregated.</p>
    pub fn aws_region(&self) -> ::std::option::Option<&str> {
        self.aws_region.as_deref()
    }
}
impl AggregateConformancePackComplianceFilters {
    /// Creates a new builder-style object to manufacture [`AggregateConformancePackComplianceFilters`](crate::types::AggregateConformancePackComplianceFilters).
    pub fn builder() -> crate::types::builders::AggregateConformancePackComplianceFiltersBuilder {
        crate::types::builders::AggregateConformancePackComplianceFiltersBuilder::default()
    }
}

/// A builder for [`AggregateConformancePackComplianceFilters`](crate::types::AggregateConformancePackComplianceFilters).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct AggregateConformancePackComplianceFiltersBuilder {
    pub(crate) conformance_pack_name: ::std::option::Option<::std::string::String>,
    pub(crate) compliance_type: ::std::option::Option<crate::types::ConformancePackComplianceType>,
    pub(crate) account_id: ::std::option::Option<::std::string::String>,
    pub(crate) aws_region: ::std::option::Option<::std::string::String>,
}
impl AggregateConformancePackComplianceFiltersBuilder {
    /// <p>The name of the conformance pack.</p>
    pub fn conformance_pack_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.conformance_pack_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the conformance pack.</p>
    pub fn set_conformance_pack_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.conformance_pack_name = input;
        self
    }
    /// <p>The name of the conformance pack.</p>
    pub fn get_conformance_pack_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.conformance_pack_name
    }
    /// <p>The compliance status of the conformance pack.</p>
    pub fn compliance_type(mut self, input: crate::types::ConformancePackComplianceType) -> Self {
        self.compliance_type = ::std::option::Option::Some(input);
        self
    }
    /// <p>The compliance status of the conformance pack.</p>
    pub fn set_compliance_type(mut self, input: ::std::option::Option<crate::types::ConformancePackComplianceType>) -> Self {
        self.compliance_type = input;
        self
    }
    /// <p>The compliance status of the conformance pack.</p>
    pub fn get_compliance_type(&self) -> &::std::option::Option<crate::types::ConformancePackComplianceType> {
        &self.compliance_type
    }
    /// <p>The 12-digit Amazon Web Services account ID of the source account.</p>
    pub fn account_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.account_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The 12-digit Amazon Web Services account ID of the source account.</p>
    pub fn set_account_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.account_id = input;
        self
    }
    /// <p>The 12-digit Amazon Web Services account ID of the source account.</p>
    pub fn get_account_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.account_id
    }
    /// <p>The source Amazon Web Services Region from where the data is aggregated.</p>
    pub fn aws_region(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.aws_region = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The source Amazon Web Services Region from where the data is aggregated.</p>
    pub fn set_aws_region(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.aws_region = input;
        self
    }
    /// <p>The source Amazon Web Services Region from where the data is aggregated.</p>
    pub fn get_aws_region(&self) -> &::std::option::Option<::std::string::String> {
        &self.aws_region
    }
    /// Consumes the builder and constructs a [`AggregateConformancePackComplianceFilters`](crate::types::AggregateConformancePackComplianceFilters).
    pub fn build(self) -> crate::types::AggregateConformancePackComplianceFilters {
        crate::types::AggregateConformancePackComplianceFilters {
            conformance_pack_name: self.conformance_pack_name,
            compliance_type: self.compliance_type,
            account_id: self.account_id,
            aws_region: self.aws_region,
        }
    }
}
