// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The details that identify a resource that is collected by Config aggregator, including the resource type, ID, (if available) the custom resource name, the source account, and source region.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct AggregateResourceIdentifier {
    /// <p>The 12-digit account ID of the source account.</p>
    pub source_account_id: ::std::string::String,
    /// <p>The source region where data is aggregated.</p>
    pub source_region: ::std::string::String,
    /// <p>The ID of the Amazon Web Services resource.</p>
    pub resource_id: ::std::string::String,
    /// <p>The type of the Amazon Web Services resource.</p>
    pub resource_type: crate::types::ResourceType,
    /// <p>The name of the Amazon Web Services resource.</p>
    pub resource_name: ::std::option::Option<::std::string::String>,
}
impl AggregateResourceIdentifier {
    /// <p>The 12-digit account ID of the source account.</p>
    pub fn source_account_id(&self) -> &str {
        use std::ops::Deref;
        self.source_account_id.deref()
    }
    /// <p>The source region where data is aggregated.</p>
    pub fn source_region(&self) -> &str {
        use std::ops::Deref;
        self.source_region.deref()
    }
    /// <p>The ID of the Amazon Web Services resource.</p>
    pub fn resource_id(&self) -> &str {
        use std::ops::Deref;
        self.resource_id.deref()
    }
    /// <p>The type of the Amazon Web Services resource.</p>
    pub fn resource_type(&self) -> &crate::types::ResourceType {
        &self.resource_type
    }
    /// <p>The name of the Amazon Web Services resource.</p>
    pub fn resource_name(&self) -> ::std::option::Option<&str> {
        self.resource_name.as_deref()
    }
}
impl AggregateResourceIdentifier {
    /// Creates a new builder-style object to manufacture [`AggregateResourceIdentifier`](crate::types::AggregateResourceIdentifier).
    pub fn builder() -> crate::types::builders::AggregateResourceIdentifierBuilder {
        crate::types::builders::AggregateResourceIdentifierBuilder::default()
    }
}

/// A builder for [`AggregateResourceIdentifier`](crate::types::AggregateResourceIdentifier).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct AggregateResourceIdentifierBuilder {
    pub(crate) source_account_id: ::std::option::Option<::std::string::String>,
    pub(crate) source_region: ::std::option::Option<::std::string::String>,
    pub(crate) resource_id: ::std::option::Option<::std::string::String>,
    pub(crate) resource_type: ::std::option::Option<crate::types::ResourceType>,
    pub(crate) resource_name: ::std::option::Option<::std::string::String>,
}
impl AggregateResourceIdentifierBuilder {
    /// <p>The 12-digit account ID of the source account.</p>
    /// This field is required.
    pub fn source_account_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.source_account_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The 12-digit account ID of the source account.</p>
    pub fn set_source_account_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.source_account_id = input;
        self
    }
    /// <p>The 12-digit account ID of the source account.</p>
    pub fn get_source_account_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.source_account_id
    }
    /// <p>The source region where data is aggregated.</p>
    /// This field is required.
    pub fn source_region(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.source_region = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The source region where data is aggregated.</p>
    pub fn set_source_region(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.source_region = input;
        self
    }
    /// <p>The source region where data is aggregated.</p>
    pub fn get_source_region(&self) -> &::std::option::Option<::std::string::String> {
        &self.source_region
    }
    /// <p>The ID of the Amazon Web Services resource.</p>
    /// This field is required.
    pub fn resource_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.resource_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The ID of the Amazon Web Services resource.</p>
    pub fn set_resource_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.resource_id = input;
        self
    }
    /// <p>The ID of the Amazon Web Services resource.</p>
    pub fn get_resource_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.resource_id
    }
    /// <p>The type of the Amazon Web Services resource.</p>
    /// This field is required.
    pub fn resource_type(mut self, input: crate::types::ResourceType) -> Self {
        self.resource_type = ::std::option::Option::Some(input);
        self
    }
    /// <p>The type of the Amazon Web Services resource.</p>
    pub fn set_resource_type(mut self, input: ::std::option::Option<crate::types::ResourceType>) -> Self {
        self.resource_type = input;
        self
    }
    /// <p>The type of the Amazon Web Services resource.</p>
    pub fn get_resource_type(&self) -> &::std::option::Option<crate::types::ResourceType> {
        &self.resource_type
    }
    /// <p>The name of the Amazon Web Services resource.</p>
    pub fn resource_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.resource_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the Amazon Web Services resource.</p>
    pub fn set_resource_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.resource_name = input;
        self
    }
    /// <p>The name of the Amazon Web Services resource.</p>
    pub fn get_resource_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.resource_name
    }
    /// Consumes the builder and constructs a [`AggregateResourceIdentifier`](crate::types::AggregateResourceIdentifier).
    /// This method will fail if any of the following fields are not set:
    /// - [`source_account_id`](crate::types::builders::AggregateResourceIdentifierBuilder::source_account_id)
    /// - [`source_region`](crate::types::builders::AggregateResourceIdentifierBuilder::source_region)
    /// - [`resource_id`](crate::types::builders::AggregateResourceIdentifierBuilder::resource_id)
    /// - [`resource_type`](crate::types::builders::AggregateResourceIdentifierBuilder::resource_type)
    pub fn build(self) -> ::std::result::Result<crate::types::AggregateResourceIdentifier, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::AggregateResourceIdentifier {
            source_account_id: self.source_account_id.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "source_account_id",
                    "source_account_id was not specified but it is required when building AggregateResourceIdentifier",
                )
            })?,
            source_region: self.source_region.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "source_region",
                    "source_region was not specified but it is required when building AggregateResourceIdentifier",
                )
            })?,
            resource_id: self.resource_id.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "resource_id",
                    "resource_id was not specified but it is required when building AggregateResourceIdentifier",
                )
            })?,
            resource_type: self.resource_type.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "resource_type",
                    "resource_type was not specified but it is required when building AggregateResourceIdentifier",
                )
            })?,
            resource_name: self.resource_name,
        })
    }
}
