// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The number of Amazon Web Services resources or Config rules responsible for the current compliance of the item, up to a maximum number.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ComplianceContributorCount {
    /// <p>The number of Amazon Web Services resources or Config rules responsible for the current compliance of the item.</p>
    pub capped_count: i32,
    /// <p>Indicates whether the maximum count is reached.</p>
    pub cap_exceeded: bool,
}
impl ComplianceContributorCount {
    /// <p>The number of Amazon Web Services resources or Config rules responsible for the current compliance of the item.</p>
    pub fn capped_count(&self) -> i32 {
        self.capped_count
    }
    /// <p>Indicates whether the maximum count is reached.</p>
    pub fn cap_exceeded(&self) -> bool {
        self.cap_exceeded
    }
}
impl ComplianceContributorCount {
    /// Creates a new builder-style object to manufacture [`ComplianceContributorCount`](crate::types::ComplianceContributorCount).
    pub fn builder() -> crate::types::builders::ComplianceContributorCountBuilder {
        crate::types::builders::ComplianceContributorCountBuilder::default()
    }
}

/// A builder for [`ComplianceContributorCount`](crate::types::ComplianceContributorCount).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ComplianceContributorCountBuilder {
    pub(crate) capped_count: ::std::option::Option<i32>,
    pub(crate) cap_exceeded: ::std::option::Option<bool>,
}
impl ComplianceContributorCountBuilder {
    /// <p>The number of Amazon Web Services resources or Config rules responsible for the current compliance of the item.</p>
    pub fn capped_count(mut self, input: i32) -> Self {
        self.capped_count = ::std::option::Option::Some(input);
        self
    }
    /// <p>The number of Amazon Web Services resources or Config rules responsible for the current compliance of the item.</p>
    pub fn set_capped_count(mut self, input: ::std::option::Option<i32>) -> Self {
        self.capped_count = input;
        self
    }
    /// <p>The number of Amazon Web Services resources or Config rules responsible for the current compliance of the item.</p>
    pub fn get_capped_count(&self) -> &::std::option::Option<i32> {
        &self.capped_count
    }
    /// <p>Indicates whether the maximum count is reached.</p>
    pub fn cap_exceeded(mut self, input: bool) -> Self {
        self.cap_exceeded = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates whether the maximum count is reached.</p>
    pub fn set_cap_exceeded(mut self, input: ::std::option::Option<bool>) -> Self {
        self.cap_exceeded = input;
        self
    }
    /// <p>Indicates whether the maximum count is reached.</p>
    pub fn get_cap_exceeded(&self) -> &::std::option::Option<bool> {
        &self.cap_exceeded
    }
    /// Consumes the builder and constructs a [`ComplianceContributorCount`](crate::types::ComplianceContributorCount).
    pub fn build(self) -> crate::types::ComplianceContributorCount {
        crate::types::ComplianceContributorCount {
            capped_count: self.capped_count.unwrap_or_default(),
            cap_exceeded: self.cap_exceeded.unwrap_or_default(),
        }
    }
}
