// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The number of Config rules or Amazon Web Services resources that are compliant and noncompliant.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ComplianceSummary {
    /// <p>The number of Config rules or Amazon Web Services resources that are compliant, up to a maximum of 25 for rules and 100 for resources.</p>
    pub compliant_resource_count: ::std::option::Option<crate::types::ComplianceContributorCount>,
    /// <p>The number of Config rules or Amazon Web Services resources that are noncompliant, up to a maximum of 25 for rules and 100 for resources.</p>
    pub non_compliant_resource_count: ::std::option::Option<crate::types::ComplianceContributorCount>,
    /// <p>The time that Config created the compliance summary.</p>
    pub compliance_summary_timestamp: ::std::option::Option<::aws_smithy_types::DateTime>,
}
impl ComplianceSummary {
    /// <p>The number of Config rules or Amazon Web Services resources that are compliant, up to a maximum of 25 for rules and 100 for resources.</p>
    pub fn compliant_resource_count(&self) -> ::std::option::Option<&crate::types::ComplianceContributorCount> {
        self.compliant_resource_count.as_ref()
    }
    /// <p>The number of Config rules or Amazon Web Services resources that are noncompliant, up to a maximum of 25 for rules and 100 for resources.</p>
    pub fn non_compliant_resource_count(&self) -> ::std::option::Option<&crate::types::ComplianceContributorCount> {
        self.non_compliant_resource_count.as_ref()
    }
    /// <p>The time that Config created the compliance summary.</p>
    pub fn compliance_summary_timestamp(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.compliance_summary_timestamp.as_ref()
    }
}
impl ComplianceSummary {
    /// Creates a new builder-style object to manufacture [`ComplianceSummary`](crate::types::ComplianceSummary).
    pub fn builder() -> crate::types::builders::ComplianceSummaryBuilder {
        crate::types::builders::ComplianceSummaryBuilder::default()
    }
}

/// A builder for [`ComplianceSummary`](crate::types::ComplianceSummary).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ComplianceSummaryBuilder {
    pub(crate) compliant_resource_count: ::std::option::Option<crate::types::ComplianceContributorCount>,
    pub(crate) non_compliant_resource_count: ::std::option::Option<crate::types::ComplianceContributorCount>,
    pub(crate) compliance_summary_timestamp: ::std::option::Option<::aws_smithy_types::DateTime>,
}
impl ComplianceSummaryBuilder {
    /// <p>The number of Config rules or Amazon Web Services resources that are compliant, up to a maximum of 25 for rules and 100 for resources.</p>
    pub fn compliant_resource_count(mut self, input: crate::types::ComplianceContributorCount) -> Self {
        self.compliant_resource_count = ::std::option::Option::Some(input);
        self
    }
    /// <p>The number of Config rules or Amazon Web Services resources that are compliant, up to a maximum of 25 for rules and 100 for resources.</p>
    pub fn set_compliant_resource_count(mut self, input: ::std::option::Option<crate::types::ComplianceContributorCount>) -> Self {
        self.compliant_resource_count = input;
        self
    }
    /// <p>The number of Config rules or Amazon Web Services resources that are compliant, up to a maximum of 25 for rules and 100 for resources.</p>
    pub fn get_compliant_resource_count(&self) -> &::std::option::Option<crate::types::ComplianceContributorCount> {
        &self.compliant_resource_count
    }
    /// <p>The number of Config rules or Amazon Web Services resources that are noncompliant, up to a maximum of 25 for rules and 100 for resources.</p>
    pub fn non_compliant_resource_count(mut self, input: crate::types::ComplianceContributorCount) -> Self {
        self.non_compliant_resource_count = ::std::option::Option::Some(input);
        self
    }
    /// <p>The number of Config rules or Amazon Web Services resources that are noncompliant, up to a maximum of 25 for rules and 100 for resources.</p>
    pub fn set_non_compliant_resource_count(mut self, input: ::std::option::Option<crate::types::ComplianceContributorCount>) -> Self {
        self.non_compliant_resource_count = input;
        self
    }
    /// <p>The number of Config rules or Amazon Web Services resources that are noncompliant, up to a maximum of 25 for rules and 100 for resources.</p>
    pub fn get_non_compliant_resource_count(&self) -> &::std::option::Option<crate::types::ComplianceContributorCount> {
        &self.non_compliant_resource_count
    }
    /// <p>The time that Config created the compliance summary.</p>
    pub fn compliance_summary_timestamp(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.compliance_summary_timestamp = ::std::option::Option::Some(input);
        self
    }
    /// <p>The time that Config created the compliance summary.</p>
    pub fn set_compliance_summary_timestamp(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.compliance_summary_timestamp = input;
        self
    }
    /// <p>The time that Config created the compliance summary.</p>
    pub fn get_compliance_summary_timestamp(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.compliance_summary_timestamp
    }
    /// Consumes the builder and constructs a [`ComplianceSummary`](crate::types::ComplianceSummary).
    pub fn build(self) -> crate::types::ComplianceSummary {
        crate::types::ComplianceSummary {
            compliant_resource_count: self.compliant_resource_count,
            non_compliant_resource_count: self.non_compliant_resource_count,
            compliance_summary_timestamp: self.compliance_summary_timestamp,
        }
    }
}
