// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Config rules evaluate the configuration settings of your Amazon Web Services resources. A rule can run when Config detects a configuration change to an Amazon Web Services resource or at a periodic frequency that you choose (for example, every 24 hours). There are two types of rules: <i>Config Managed Rules</i> and <i>Config Custom Rules</i>.</p>
/// <p>Config Managed Rules are predefined, customizable rules created by Config. For a list of managed rules, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html">List of Config Managed Rules</a>.</p>
/// <p>Config Custom Rules are rules that you create from scratch. There are two ways to create Config custom rules: with Lambda functions (<a href="https://docs.aws.amazon.com/config/latest/developerguide/gettingstarted-concepts.html#gettingstarted-concepts-function"> Lambda Developer Guide</a>) and with Guard (<a href="https://github.com/aws-cloudformation/cloudformation-guard">Guard GitHub Repository</a>), a policy-as-code language. Config custom rules created with Lambda are called <i>Config Custom Lambda Rules</i> and Config custom rules created with Guard are called <i>Config Custom Policy Rules</i>.</p>
/// <p>For more information about developing and using Config rules, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config.html">Evaluating Resource with Config Rules</a> in the <i>Config Developer Guide</i>.</p><note>
/// <p>You can use the Amazon Web Services CLI and Amazon Web Services SDKs if you want to create a rule that triggers evaluations for your resources when Config delivers the configuration snapshot. For more information, see <code>ConfigSnapshotDeliveryProperties</code>.</p>
/// </note>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ConfigRule {
    /// <p>The name that you assign to the Config rule. The name is required if you are adding a new rule.</p>
    pub config_rule_name: ::std::option::Option<::std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Config rule.</p>
    pub config_rule_arn: ::std::option::Option<::std::string::String>,
    /// <p>The ID of the Config rule.</p>
    pub config_rule_id: ::std::option::Option<::std::string::String>,
    /// <p>The description that you provide for the Config rule.</p>
    pub description: ::std::option::Option<::std::string::String>,
    /// <p>Defines which resources can trigger an evaluation for the rule. The scope can include one or more resource types, a combination of one resource type and one resource ID, or a combination of a tag key and value. Specify a scope to constrain the resources that can trigger an evaluation for the rule. If you do not specify a scope, evaluations are triggered when any resource in the recording group changes.</p><note>
    /// <p>The scope can be empty.</p>
    /// </note>
    pub scope: ::std::option::Option<crate::types::Scope>,
    /// <p>Provides the rule owner (<code>Amazon Web Services</code> for managed rules, <code>CUSTOM_POLICY</code> for Custom Policy rules, and <code>CUSTOM_LAMBDA</code> for Custom Lambda rules), the rule identifier, and the notifications that cause the function to evaluate your Amazon Web Services resources.</p>
    pub source: ::std::option::Option<crate::types::Source>,
    /// <p>A string, in JSON format, that is passed to the Config rule Lambda function.</p>
    pub input_parameters: ::std::option::Option<::std::string::String>,
    /// <p>The maximum frequency with which Config runs evaluations for a rule. You can specify a value for <code>MaximumExecutionFrequency</code> when:</p>
    /// <ul>
    /// <li>
    /// <p>This is for an Config managed rule that is triggered at a periodic frequency.</p></li>
    /// <li>
    /// <p>Your custom rule is triggered when Config delivers the configuration snapshot. For more information, see <code>ConfigSnapshotDeliveryProperties</code>.</p></li>
    /// </ul><note>
    /// <p>By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.</p>
    /// </note>
    pub maximum_execution_frequency: ::std::option::Option<crate::types::MaximumExecutionFrequency>,
    /// <p>Indicates whether the Config rule is active or is currently being deleted by Config. It can also indicate the evaluation status for the Config rule.</p>
    /// <p>Config sets the state of the rule to <code>EVALUATING</code> temporarily after you use the <code>StartConfigRulesEvaluation</code> request to evaluate your resources against the Config rule.</p>
    /// <p>Config sets the state of the rule to <code>DELETING_RESULTS</code> temporarily after you use the <code>DeleteEvaluationResults</code> request to delete the current evaluation results for the Config rule.</p>
    /// <p>Config temporarily sets the state of a rule to <code>DELETING</code> after you use the <code>DeleteConfigRule</code> request to delete the rule. After Config deletes the rule, the rule and all of its evaluations are erased and are no longer available.</p>
    pub config_rule_state: ::std::option::Option<crate::types::ConfigRuleState>,
    /// <p>Service principal name of the service that created the rule.</p><note>
    /// <p>The field is populated only if the service-linked rule is created by a service. The field is empty if you create your own rule.</p>
    /// </note>
    pub created_by: ::std::option::Option<::std::string::String>,
    /// <p>The modes the Config rule can be evaluated in. The valid values are distinct objects. By default, the value is Detective evaluation mode only.</p>
    pub evaluation_modes: ::std::option::Option<::std::vec::Vec<crate::types::EvaluationModeConfiguration>>,
}
impl ConfigRule {
    /// <p>The name that you assign to the Config rule. The name is required if you are adding a new rule.</p>
    pub fn config_rule_name(&self) -> ::std::option::Option<&str> {
        self.config_rule_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Config rule.</p>
    pub fn config_rule_arn(&self) -> ::std::option::Option<&str> {
        self.config_rule_arn.as_deref()
    }
    /// <p>The ID of the Config rule.</p>
    pub fn config_rule_id(&self) -> ::std::option::Option<&str> {
        self.config_rule_id.as_deref()
    }
    /// <p>The description that you provide for the Config rule.</p>
    pub fn description(&self) -> ::std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Defines which resources can trigger an evaluation for the rule. The scope can include one or more resource types, a combination of one resource type and one resource ID, or a combination of a tag key and value. Specify a scope to constrain the resources that can trigger an evaluation for the rule. If you do not specify a scope, evaluations are triggered when any resource in the recording group changes.</p><note>
    /// <p>The scope can be empty.</p>
    /// </note>
    pub fn scope(&self) -> ::std::option::Option<&crate::types::Scope> {
        self.scope.as_ref()
    }
    /// <p>Provides the rule owner (<code>Amazon Web Services</code> for managed rules, <code>CUSTOM_POLICY</code> for Custom Policy rules, and <code>CUSTOM_LAMBDA</code> for Custom Lambda rules), the rule identifier, and the notifications that cause the function to evaluate your Amazon Web Services resources.</p>
    pub fn source(&self) -> ::std::option::Option<&crate::types::Source> {
        self.source.as_ref()
    }
    /// <p>A string, in JSON format, that is passed to the Config rule Lambda function.</p>
    pub fn input_parameters(&self) -> ::std::option::Option<&str> {
        self.input_parameters.as_deref()
    }
    /// <p>The maximum frequency with which Config runs evaluations for a rule. You can specify a value for <code>MaximumExecutionFrequency</code> when:</p>
    /// <ul>
    /// <li>
    /// <p>This is for an Config managed rule that is triggered at a periodic frequency.</p></li>
    /// <li>
    /// <p>Your custom rule is triggered when Config delivers the configuration snapshot. For more information, see <code>ConfigSnapshotDeliveryProperties</code>.</p></li>
    /// </ul><note>
    /// <p>By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.</p>
    /// </note>
    pub fn maximum_execution_frequency(&self) -> ::std::option::Option<&crate::types::MaximumExecutionFrequency> {
        self.maximum_execution_frequency.as_ref()
    }
    /// <p>Indicates whether the Config rule is active or is currently being deleted by Config. It can also indicate the evaluation status for the Config rule.</p>
    /// <p>Config sets the state of the rule to <code>EVALUATING</code> temporarily after you use the <code>StartConfigRulesEvaluation</code> request to evaluate your resources against the Config rule.</p>
    /// <p>Config sets the state of the rule to <code>DELETING_RESULTS</code> temporarily after you use the <code>DeleteEvaluationResults</code> request to delete the current evaluation results for the Config rule.</p>
    /// <p>Config temporarily sets the state of a rule to <code>DELETING</code> after you use the <code>DeleteConfigRule</code> request to delete the rule. After Config deletes the rule, the rule and all of its evaluations are erased and are no longer available.</p>
    pub fn config_rule_state(&self) -> ::std::option::Option<&crate::types::ConfigRuleState> {
        self.config_rule_state.as_ref()
    }
    /// <p>Service principal name of the service that created the rule.</p><note>
    /// <p>The field is populated only if the service-linked rule is created by a service. The field is empty if you create your own rule.</p>
    /// </note>
    pub fn created_by(&self) -> ::std::option::Option<&str> {
        self.created_by.as_deref()
    }
    /// <p>The modes the Config rule can be evaluated in. The valid values are distinct objects. By default, the value is Detective evaluation mode only.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.evaluation_modes.is_none()`.
    pub fn evaluation_modes(&self) -> &[crate::types::EvaluationModeConfiguration] {
        self.evaluation_modes.as_deref().unwrap_or_default()
    }
}
impl ConfigRule {
    /// Creates a new builder-style object to manufacture [`ConfigRule`](crate::types::ConfigRule).
    pub fn builder() -> crate::types::builders::ConfigRuleBuilder {
        crate::types::builders::ConfigRuleBuilder::default()
    }
}

/// A builder for [`ConfigRule`](crate::types::ConfigRule).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ConfigRuleBuilder {
    pub(crate) config_rule_name: ::std::option::Option<::std::string::String>,
    pub(crate) config_rule_arn: ::std::option::Option<::std::string::String>,
    pub(crate) config_rule_id: ::std::option::Option<::std::string::String>,
    pub(crate) description: ::std::option::Option<::std::string::String>,
    pub(crate) scope: ::std::option::Option<crate::types::Scope>,
    pub(crate) source: ::std::option::Option<crate::types::Source>,
    pub(crate) input_parameters: ::std::option::Option<::std::string::String>,
    pub(crate) maximum_execution_frequency: ::std::option::Option<crate::types::MaximumExecutionFrequency>,
    pub(crate) config_rule_state: ::std::option::Option<crate::types::ConfigRuleState>,
    pub(crate) created_by: ::std::option::Option<::std::string::String>,
    pub(crate) evaluation_modes: ::std::option::Option<::std::vec::Vec<crate::types::EvaluationModeConfiguration>>,
}
impl ConfigRuleBuilder {
    /// <p>The name that you assign to the Config rule. The name is required if you are adding a new rule.</p>
    pub fn config_rule_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.config_rule_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name that you assign to the Config rule. The name is required if you are adding a new rule.</p>
    pub fn set_config_rule_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.config_rule_name = input;
        self
    }
    /// <p>The name that you assign to the Config rule. The name is required if you are adding a new rule.</p>
    pub fn get_config_rule_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.config_rule_name
    }
    /// <p>The Amazon Resource Name (ARN) of the Config rule.</p>
    pub fn config_rule_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.config_rule_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the Config rule.</p>
    pub fn set_config_rule_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.config_rule_arn = input;
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the Config rule.</p>
    pub fn get_config_rule_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.config_rule_arn
    }
    /// <p>The ID of the Config rule.</p>
    pub fn config_rule_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.config_rule_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The ID of the Config rule.</p>
    pub fn set_config_rule_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.config_rule_id = input;
        self
    }
    /// <p>The ID of the Config rule.</p>
    pub fn get_config_rule_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.config_rule_id
    }
    /// <p>The description that you provide for the Config rule.</p>
    pub fn description(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.description = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The description that you provide for the Config rule.</p>
    pub fn set_description(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.description = input;
        self
    }
    /// <p>The description that you provide for the Config rule.</p>
    pub fn get_description(&self) -> &::std::option::Option<::std::string::String> {
        &self.description
    }
    /// <p>Defines which resources can trigger an evaluation for the rule. The scope can include one or more resource types, a combination of one resource type and one resource ID, or a combination of a tag key and value. Specify a scope to constrain the resources that can trigger an evaluation for the rule. If you do not specify a scope, evaluations are triggered when any resource in the recording group changes.</p><note>
    /// <p>The scope can be empty.</p>
    /// </note>
    pub fn scope(mut self, input: crate::types::Scope) -> Self {
        self.scope = ::std::option::Option::Some(input);
        self
    }
    /// <p>Defines which resources can trigger an evaluation for the rule. The scope can include one or more resource types, a combination of one resource type and one resource ID, or a combination of a tag key and value. Specify a scope to constrain the resources that can trigger an evaluation for the rule. If you do not specify a scope, evaluations are triggered when any resource in the recording group changes.</p><note>
    /// <p>The scope can be empty.</p>
    /// </note>
    pub fn set_scope(mut self, input: ::std::option::Option<crate::types::Scope>) -> Self {
        self.scope = input;
        self
    }
    /// <p>Defines which resources can trigger an evaluation for the rule. The scope can include one or more resource types, a combination of one resource type and one resource ID, or a combination of a tag key and value. Specify a scope to constrain the resources that can trigger an evaluation for the rule. If you do not specify a scope, evaluations are triggered when any resource in the recording group changes.</p><note>
    /// <p>The scope can be empty.</p>
    /// </note>
    pub fn get_scope(&self) -> &::std::option::Option<crate::types::Scope> {
        &self.scope
    }
    /// <p>Provides the rule owner (<code>Amazon Web Services</code> for managed rules, <code>CUSTOM_POLICY</code> for Custom Policy rules, and <code>CUSTOM_LAMBDA</code> for Custom Lambda rules), the rule identifier, and the notifications that cause the function to evaluate your Amazon Web Services resources.</p>
    /// This field is required.
    pub fn source(mut self, input: crate::types::Source) -> Self {
        self.source = ::std::option::Option::Some(input);
        self
    }
    /// <p>Provides the rule owner (<code>Amazon Web Services</code> for managed rules, <code>CUSTOM_POLICY</code> for Custom Policy rules, and <code>CUSTOM_LAMBDA</code> for Custom Lambda rules), the rule identifier, and the notifications that cause the function to evaluate your Amazon Web Services resources.</p>
    pub fn set_source(mut self, input: ::std::option::Option<crate::types::Source>) -> Self {
        self.source = input;
        self
    }
    /// <p>Provides the rule owner (<code>Amazon Web Services</code> for managed rules, <code>CUSTOM_POLICY</code> for Custom Policy rules, and <code>CUSTOM_LAMBDA</code> for Custom Lambda rules), the rule identifier, and the notifications that cause the function to evaluate your Amazon Web Services resources.</p>
    pub fn get_source(&self) -> &::std::option::Option<crate::types::Source> {
        &self.source
    }
    /// <p>A string, in JSON format, that is passed to the Config rule Lambda function.</p>
    pub fn input_parameters(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.input_parameters = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>A string, in JSON format, that is passed to the Config rule Lambda function.</p>
    pub fn set_input_parameters(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.input_parameters = input;
        self
    }
    /// <p>A string, in JSON format, that is passed to the Config rule Lambda function.</p>
    pub fn get_input_parameters(&self) -> &::std::option::Option<::std::string::String> {
        &self.input_parameters
    }
    /// <p>The maximum frequency with which Config runs evaluations for a rule. You can specify a value for <code>MaximumExecutionFrequency</code> when:</p>
    /// <ul>
    /// <li>
    /// <p>This is for an Config managed rule that is triggered at a periodic frequency.</p></li>
    /// <li>
    /// <p>Your custom rule is triggered when Config delivers the configuration snapshot. For more information, see <code>ConfigSnapshotDeliveryProperties</code>.</p></li>
    /// </ul><note>
    /// <p>By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.</p>
    /// </note>
    pub fn maximum_execution_frequency(mut self, input: crate::types::MaximumExecutionFrequency) -> Self {
        self.maximum_execution_frequency = ::std::option::Option::Some(input);
        self
    }
    /// <p>The maximum frequency with which Config runs evaluations for a rule. You can specify a value for <code>MaximumExecutionFrequency</code> when:</p>
    /// <ul>
    /// <li>
    /// <p>This is for an Config managed rule that is triggered at a periodic frequency.</p></li>
    /// <li>
    /// <p>Your custom rule is triggered when Config delivers the configuration snapshot. For more information, see <code>ConfigSnapshotDeliveryProperties</code>.</p></li>
    /// </ul><note>
    /// <p>By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.</p>
    /// </note>
    pub fn set_maximum_execution_frequency(mut self, input: ::std::option::Option<crate::types::MaximumExecutionFrequency>) -> Self {
        self.maximum_execution_frequency = input;
        self
    }
    /// <p>The maximum frequency with which Config runs evaluations for a rule. You can specify a value for <code>MaximumExecutionFrequency</code> when:</p>
    /// <ul>
    /// <li>
    /// <p>This is for an Config managed rule that is triggered at a periodic frequency.</p></li>
    /// <li>
    /// <p>Your custom rule is triggered when Config delivers the configuration snapshot. For more information, see <code>ConfigSnapshotDeliveryProperties</code>.</p></li>
    /// </ul><note>
    /// <p>By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.</p>
    /// </note>
    pub fn get_maximum_execution_frequency(&self) -> &::std::option::Option<crate::types::MaximumExecutionFrequency> {
        &self.maximum_execution_frequency
    }
    /// <p>Indicates whether the Config rule is active or is currently being deleted by Config. It can also indicate the evaluation status for the Config rule.</p>
    /// <p>Config sets the state of the rule to <code>EVALUATING</code> temporarily after you use the <code>StartConfigRulesEvaluation</code> request to evaluate your resources against the Config rule.</p>
    /// <p>Config sets the state of the rule to <code>DELETING_RESULTS</code> temporarily after you use the <code>DeleteEvaluationResults</code> request to delete the current evaluation results for the Config rule.</p>
    /// <p>Config temporarily sets the state of a rule to <code>DELETING</code> after you use the <code>DeleteConfigRule</code> request to delete the rule. After Config deletes the rule, the rule and all of its evaluations are erased and are no longer available.</p>
    pub fn config_rule_state(mut self, input: crate::types::ConfigRuleState) -> Self {
        self.config_rule_state = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates whether the Config rule is active or is currently being deleted by Config. It can also indicate the evaluation status for the Config rule.</p>
    /// <p>Config sets the state of the rule to <code>EVALUATING</code> temporarily after you use the <code>StartConfigRulesEvaluation</code> request to evaluate your resources against the Config rule.</p>
    /// <p>Config sets the state of the rule to <code>DELETING_RESULTS</code> temporarily after you use the <code>DeleteEvaluationResults</code> request to delete the current evaluation results for the Config rule.</p>
    /// <p>Config temporarily sets the state of a rule to <code>DELETING</code> after you use the <code>DeleteConfigRule</code> request to delete the rule. After Config deletes the rule, the rule and all of its evaluations are erased and are no longer available.</p>
    pub fn set_config_rule_state(mut self, input: ::std::option::Option<crate::types::ConfigRuleState>) -> Self {
        self.config_rule_state = input;
        self
    }
    /// <p>Indicates whether the Config rule is active or is currently being deleted by Config. It can also indicate the evaluation status for the Config rule.</p>
    /// <p>Config sets the state of the rule to <code>EVALUATING</code> temporarily after you use the <code>StartConfigRulesEvaluation</code> request to evaluate your resources against the Config rule.</p>
    /// <p>Config sets the state of the rule to <code>DELETING_RESULTS</code> temporarily after you use the <code>DeleteEvaluationResults</code> request to delete the current evaluation results for the Config rule.</p>
    /// <p>Config temporarily sets the state of a rule to <code>DELETING</code> after you use the <code>DeleteConfigRule</code> request to delete the rule. After Config deletes the rule, the rule and all of its evaluations are erased and are no longer available.</p>
    pub fn get_config_rule_state(&self) -> &::std::option::Option<crate::types::ConfigRuleState> {
        &self.config_rule_state
    }
    /// <p>Service principal name of the service that created the rule.</p><note>
    /// <p>The field is populated only if the service-linked rule is created by a service. The field is empty if you create your own rule.</p>
    /// </note>
    pub fn created_by(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.created_by = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Service principal name of the service that created the rule.</p><note>
    /// <p>The field is populated only if the service-linked rule is created by a service. The field is empty if you create your own rule.</p>
    /// </note>
    pub fn set_created_by(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.created_by = input;
        self
    }
    /// <p>Service principal name of the service that created the rule.</p><note>
    /// <p>The field is populated only if the service-linked rule is created by a service. The field is empty if you create your own rule.</p>
    /// </note>
    pub fn get_created_by(&self) -> &::std::option::Option<::std::string::String> {
        &self.created_by
    }
    /// Appends an item to `evaluation_modes`.
    ///
    /// To override the contents of this collection use [`set_evaluation_modes`](Self::set_evaluation_modes).
    ///
    /// <p>The modes the Config rule can be evaluated in. The valid values are distinct objects. By default, the value is Detective evaluation mode only.</p>
    pub fn evaluation_modes(mut self, input: crate::types::EvaluationModeConfiguration) -> Self {
        let mut v = self.evaluation_modes.unwrap_or_default();
        v.push(input);
        self.evaluation_modes = ::std::option::Option::Some(v);
        self
    }
    /// <p>The modes the Config rule can be evaluated in. The valid values are distinct objects. By default, the value is Detective evaluation mode only.</p>
    pub fn set_evaluation_modes(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::EvaluationModeConfiguration>>) -> Self {
        self.evaluation_modes = input;
        self
    }
    /// <p>The modes the Config rule can be evaluated in. The valid values are distinct objects. By default, the value is Detective evaluation mode only.</p>
    pub fn get_evaluation_modes(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::EvaluationModeConfiguration>> {
        &self.evaluation_modes
    }
    /// Consumes the builder and constructs a [`ConfigRule`](crate::types::ConfigRule).
    pub fn build(self) -> crate::types::ConfigRule {
        crate::types::ConfigRule {
            config_rule_name: self.config_rule_name,
            config_rule_arn: self.config_rule_arn,
            config_rule_id: self.config_rule_id,
            description: self.description,
            scope: self.scope,
            source: self.source,
            input_parameters: self.input_parameters,
            maximum_execution_frequency: self.maximum_execution_frequency,
            config_rule_state: self.config_rule_state,
            created_by: self.created_by,
            evaluation_modes: self.evaluation_modes,
        }
    }
}
