// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The current status of the configuration recorder.</p>
/// <p>For a detailed status of recording events over time, add your Config events to CloudWatch metrics and use CloudWatch metrics.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ConfigurationRecorderStatus {
    /// <p>The Amazon Resource Name (ARN) of the configuration recorder.</p>
    pub arn: ::std::option::Option<::std::string::String>,
    /// <p>The name of the configuration recorder.</p>
    pub name: ::std::option::Option<::std::string::String>,
    /// <p>The time the recorder was last started.</p>
    pub last_start_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>The time the recorder was last stopped.</p>
    pub last_stop_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>Specifies whether or not the recorder is currently recording.</p>
    pub recording: bool,
    /// <p>The status of the latest recording event processed by the recorder.</p>
    pub last_status: ::std::option::Option<crate::types::RecorderStatus>,
    /// <p>The latest error code from when the recorder last failed.</p>
    pub last_error_code: ::std::option::Option<::std::string::String>,
    /// <p>The latest error message from when the recorder last failed.</p>
    pub last_error_message: ::std::option::Option<::std::string::String>,
    /// <p>The time of the latest change in status of an recording event processed by the recorder.</p>
    pub last_status_change_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>For service-linked configuration recorders, the service principal of the linked Amazon Web Services service.</p>
    pub service_principal: ::std::option::Option<::std::string::String>,
}
impl ConfigurationRecorderStatus {
    /// <p>The Amazon Resource Name (ARN) of the configuration recorder.</p>
    pub fn arn(&self) -> ::std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the configuration recorder.</p>
    pub fn name(&self) -> ::std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The time the recorder was last started.</p>
    pub fn last_start_time(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.last_start_time.as_ref()
    }
    /// <p>The time the recorder was last stopped.</p>
    pub fn last_stop_time(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.last_stop_time.as_ref()
    }
    /// <p>Specifies whether or not the recorder is currently recording.</p>
    pub fn recording(&self) -> bool {
        self.recording
    }
    /// <p>The status of the latest recording event processed by the recorder.</p>
    pub fn last_status(&self) -> ::std::option::Option<&crate::types::RecorderStatus> {
        self.last_status.as_ref()
    }
    /// <p>The latest error code from when the recorder last failed.</p>
    pub fn last_error_code(&self) -> ::std::option::Option<&str> {
        self.last_error_code.as_deref()
    }
    /// <p>The latest error message from when the recorder last failed.</p>
    pub fn last_error_message(&self) -> ::std::option::Option<&str> {
        self.last_error_message.as_deref()
    }
    /// <p>The time of the latest change in status of an recording event processed by the recorder.</p>
    pub fn last_status_change_time(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.last_status_change_time.as_ref()
    }
    /// <p>For service-linked configuration recorders, the service principal of the linked Amazon Web Services service.</p>
    pub fn service_principal(&self) -> ::std::option::Option<&str> {
        self.service_principal.as_deref()
    }
}
impl ConfigurationRecorderStatus {
    /// Creates a new builder-style object to manufacture [`ConfigurationRecorderStatus`](crate::types::ConfigurationRecorderStatus).
    pub fn builder() -> crate::types::builders::ConfigurationRecorderStatusBuilder {
        crate::types::builders::ConfigurationRecorderStatusBuilder::default()
    }
}

/// A builder for [`ConfigurationRecorderStatus`](crate::types::ConfigurationRecorderStatus).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ConfigurationRecorderStatusBuilder {
    pub(crate) arn: ::std::option::Option<::std::string::String>,
    pub(crate) name: ::std::option::Option<::std::string::String>,
    pub(crate) last_start_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) last_stop_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) recording: ::std::option::Option<bool>,
    pub(crate) last_status: ::std::option::Option<crate::types::RecorderStatus>,
    pub(crate) last_error_code: ::std::option::Option<::std::string::String>,
    pub(crate) last_error_message: ::std::option::Option<::std::string::String>,
    pub(crate) last_status_change_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) service_principal: ::std::option::Option<::std::string::String>,
}
impl ConfigurationRecorderStatusBuilder {
    /// <p>The Amazon Resource Name (ARN) of the configuration recorder.</p>
    pub fn arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the configuration recorder.</p>
    pub fn set_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.arn = input;
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the configuration recorder.</p>
    pub fn get_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.arn
    }
    /// <p>The name of the configuration recorder.</p>
    pub fn name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the configuration recorder.</p>
    pub fn set_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.name = input;
        self
    }
    /// <p>The name of the configuration recorder.</p>
    pub fn get_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.name
    }
    /// <p>The time the recorder was last started.</p>
    pub fn last_start_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.last_start_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The time the recorder was last started.</p>
    pub fn set_last_start_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.last_start_time = input;
        self
    }
    /// <p>The time the recorder was last started.</p>
    pub fn get_last_start_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.last_start_time
    }
    /// <p>The time the recorder was last stopped.</p>
    pub fn last_stop_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.last_stop_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The time the recorder was last stopped.</p>
    pub fn set_last_stop_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.last_stop_time = input;
        self
    }
    /// <p>The time the recorder was last stopped.</p>
    pub fn get_last_stop_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.last_stop_time
    }
    /// <p>Specifies whether or not the recorder is currently recording.</p>
    pub fn recording(mut self, input: bool) -> Self {
        self.recording = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies whether or not the recorder is currently recording.</p>
    pub fn set_recording(mut self, input: ::std::option::Option<bool>) -> Self {
        self.recording = input;
        self
    }
    /// <p>Specifies whether or not the recorder is currently recording.</p>
    pub fn get_recording(&self) -> &::std::option::Option<bool> {
        &self.recording
    }
    /// <p>The status of the latest recording event processed by the recorder.</p>
    pub fn last_status(mut self, input: crate::types::RecorderStatus) -> Self {
        self.last_status = ::std::option::Option::Some(input);
        self
    }
    /// <p>The status of the latest recording event processed by the recorder.</p>
    pub fn set_last_status(mut self, input: ::std::option::Option<crate::types::RecorderStatus>) -> Self {
        self.last_status = input;
        self
    }
    /// <p>The status of the latest recording event processed by the recorder.</p>
    pub fn get_last_status(&self) -> &::std::option::Option<crate::types::RecorderStatus> {
        &self.last_status
    }
    /// <p>The latest error code from when the recorder last failed.</p>
    pub fn last_error_code(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.last_error_code = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The latest error code from when the recorder last failed.</p>
    pub fn set_last_error_code(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.last_error_code = input;
        self
    }
    /// <p>The latest error code from when the recorder last failed.</p>
    pub fn get_last_error_code(&self) -> &::std::option::Option<::std::string::String> {
        &self.last_error_code
    }
    /// <p>The latest error message from when the recorder last failed.</p>
    pub fn last_error_message(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.last_error_message = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The latest error message from when the recorder last failed.</p>
    pub fn set_last_error_message(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.last_error_message = input;
        self
    }
    /// <p>The latest error message from when the recorder last failed.</p>
    pub fn get_last_error_message(&self) -> &::std::option::Option<::std::string::String> {
        &self.last_error_message
    }
    /// <p>The time of the latest change in status of an recording event processed by the recorder.</p>
    pub fn last_status_change_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.last_status_change_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The time of the latest change in status of an recording event processed by the recorder.</p>
    pub fn set_last_status_change_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.last_status_change_time = input;
        self
    }
    /// <p>The time of the latest change in status of an recording event processed by the recorder.</p>
    pub fn get_last_status_change_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.last_status_change_time
    }
    /// <p>For service-linked configuration recorders, the service principal of the linked Amazon Web Services service.</p>
    pub fn service_principal(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.service_principal = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>For service-linked configuration recorders, the service principal of the linked Amazon Web Services service.</p>
    pub fn set_service_principal(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.service_principal = input;
        self
    }
    /// <p>For service-linked configuration recorders, the service principal of the linked Amazon Web Services service.</p>
    pub fn get_service_principal(&self) -> &::std::option::Option<::std::string::String> {
        &self.service_principal
    }
    /// Consumes the builder and constructs a [`ConfigurationRecorderStatus`](crate::types::ConfigurationRecorderStatus).
    pub fn build(self) -> crate::types::ConfigurationRecorderStatus {
        crate::types::ConfigurationRecorderStatus {
            arn: self.arn,
            name: self.name,
            last_start_time: self.last_start_time,
            last_stop_time: self.last_stop_time,
            recording: self.recording.unwrap_or_default(),
            last_status: self.last_status,
            last_error_code: self.last_error_code,
            last_error_message: self.last_error_message,
            last_status_change_time: self.last_status_change_time,
            service_principal: self.service_principal,
        }
    }
}
