// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The details of an Config evaluation. Provides the Amazon Web Services resource that was evaluated, the compliance of the resource, related time stamps, and supplementary information.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct EvaluationResult {
    /// <p>Uniquely identifies the evaluation result.</p>
    pub evaluation_result_identifier: ::std::option::Option<crate::types::EvaluationResultIdentifier>,
    /// <p>Indicates whether the Amazon Web Services resource complies with the Config rule that evaluated it.</p>
    /// <p>For the <code>EvaluationResult</code> data type, Config supports only the <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. Config does not support the <code>INSUFFICIENT_DATA</code> value for the <code>EvaluationResult</code> data type.</p>
    pub compliance_type: ::std::option::Option<crate::types::ComplianceType>,
    /// <p>The time when Config recorded the evaluation result.</p>
    pub result_recorded_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>The time when the Config rule evaluated the Amazon Web Services resource.</p>
    pub config_rule_invoked_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>Supplementary information about how the evaluation determined the compliance.</p>
    pub annotation: ::std::option::Option<::std::string::String>,
    /// <p>An encrypted token that associates an evaluation with an Config rule. The token identifies the rule, the Amazon Web Services resource being evaluated, and the event that triggered the evaluation.</p>
    pub result_token: ::std::option::Option<::std::string::String>,
}
impl EvaluationResult {
    /// <p>Uniquely identifies the evaluation result.</p>
    pub fn evaluation_result_identifier(&self) -> ::std::option::Option<&crate::types::EvaluationResultIdentifier> {
        self.evaluation_result_identifier.as_ref()
    }
    /// <p>Indicates whether the Amazon Web Services resource complies with the Config rule that evaluated it.</p>
    /// <p>For the <code>EvaluationResult</code> data type, Config supports only the <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. Config does not support the <code>INSUFFICIENT_DATA</code> value for the <code>EvaluationResult</code> data type.</p>
    pub fn compliance_type(&self) -> ::std::option::Option<&crate::types::ComplianceType> {
        self.compliance_type.as_ref()
    }
    /// <p>The time when Config recorded the evaluation result.</p>
    pub fn result_recorded_time(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.result_recorded_time.as_ref()
    }
    /// <p>The time when the Config rule evaluated the Amazon Web Services resource.</p>
    pub fn config_rule_invoked_time(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.config_rule_invoked_time.as_ref()
    }
    /// <p>Supplementary information about how the evaluation determined the compliance.</p>
    pub fn annotation(&self) -> ::std::option::Option<&str> {
        self.annotation.as_deref()
    }
    /// <p>An encrypted token that associates an evaluation with an Config rule. The token identifies the rule, the Amazon Web Services resource being evaluated, and the event that triggered the evaluation.</p>
    pub fn result_token(&self) -> ::std::option::Option<&str> {
        self.result_token.as_deref()
    }
}
impl EvaluationResult {
    /// Creates a new builder-style object to manufacture [`EvaluationResult`](crate::types::EvaluationResult).
    pub fn builder() -> crate::types::builders::EvaluationResultBuilder {
        crate::types::builders::EvaluationResultBuilder::default()
    }
}

/// A builder for [`EvaluationResult`](crate::types::EvaluationResult).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct EvaluationResultBuilder {
    pub(crate) evaluation_result_identifier: ::std::option::Option<crate::types::EvaluationResultIdentifier>,
    pub(crate) compliance_type: ::std::option::Option<crate::types::ComplianceType>,
    pub(crate) result_recorded_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) config_rule_invoked_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) annotation: ::std::option::Option<::std::string::String>,
    pub(crate) result_token: ::std::option::Option<::std::string::String>,
}
impl EvaluationResultBuilder {
    /// <p>Uniquely identifies the evaluation result.</p>
    pub fn evaluation_result_identifier(mut self, input: crate::types::EvaluationResultIdentifier) -> Self {
        self.evaluation_result_identifier = ::std::option::Option::Some(input);
        self
    }
    /// <p>Uniquely identifies the evaluation result.</p>
    pub fn set_evaluation_result_identifier(mut self, input: ::std::option::Option<crate::types::EvaluationResultIdentifier>) -> Self {
        self.evaluation_result_identifier = input;
        self
    }
    /// <p>Uniquely identifies the evaluation result.</p>
    pub fn get_evaluation_result_identifier(&self) -> &::std::option::Option<crate::types::EvaluationResultIdentifier> {
        &self.evaluation_result_identifier
    }
    /// <p>Indicates whether the Amazon Web Services resource complies with the Config rule that evaluated it.</p>
    /// <p>For the <code>EvaluationResult</code> data type, Config supports only the <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. Config does not support the <code>INSUFFICIENT_DATA</code> value for the <code>EvaluationResult</code> data type.</p>
    pub fn compliance_type(mut self, input: crate::types::ComplianceType) -> Self {
        self.compliance_type = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates whether the Amazon Web Services resource complies with the Config rule that evaluated it.</p>
    /// <p>For the <code>EvaluationResult</code> data type, Config supports only the <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. Config does not support the <code>INSUFFICIENT_DATA</code> value for the <code>EvaluationResult</code> data type.</p>
    pub fn set_compliance_type(mut self, input: ::std::option::Option<crate::types::ComplianceType>) -> Self {
        self.compliance_type = input;
        self
    }
    /// <p>Indicates whether the Amazon Web Services resource complies with the Config rule that evaluated it.</p>
    /// <p>For the <code>EvaluationResult</code> data type, Config supports only the <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. Config does not support the <code>INSUFFICIENT_DATA</code> value for the <code>EvaluationResult</code> data type.</p>
    pub fn get_compliance_type(&self) -> &::std::option::Option<crate::types::ComplianceType> {
        &self.compliance_type
    }
    /// <p>The time when Config recorded the evaluation result.</p>
    pub fn result_recorded_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.result_recorded_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The time when Config recorded the evaluation result.</p>
    pub fn set_result_recorded_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.result_recorded_time = input;
        self
    }
    /// <p>The time when Config recorded the evaluation result.</p>
    pub fn get_result_recorded_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.result_recorded_time
    }
    /// <p>The time when the Config rule evaluated the Amazon Web Services resource.</p>
    pub fn config_rule_invoked_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.config_rule_invoked_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The time when the Config rule evaluated the Amazon Web Services resource.</p>
    pub fn set_config_rule_invoked_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.config_rule_invoked_time = input;
        self
    }
    /// <p>The time when the Config rule evaluated the Amazon Web Services resource.</p>
    pub fn get_config_rule_invoked_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.config_rule_invoked_time
    }
    /// <p>Supplementary information about how the evaluation determined the compliance.</p>
    pub fn annotation(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.annotation = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Supplementary information about how the evaluation determined the compliance.</p>
    pub fn set_annotation(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.annotation = input;
        self
    }
    /// <p>Supplementary information about how the evaluation determined the compliance.</p>
    pub fn get_annotation(&self) -> &::std::option::Option<::std::string::String> {
        &self.annotation
    }
    /// <p>An encrypted token that associates an evaluation with an Config rule. The token identifies the rule, the Amazon Web Services resource being evaluated, and the event that triggered the evaluation.</p>
    pub fn result_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.result_token = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>An encrypted token that associates an evaluation with an Config rule. The token identifies the rule, the Amazon Web Services resource being evaluated, and the event that triggered the evaluation.</p>
    pub fn set_result_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.result_token = input;
        self
    }
    /// <p>An encrypted token that associates an evaluation with an Config rule. The token identifies the rule, the Amazon Web Services resource being evaluated, and the event that triggered the evaluation.</p>
    pub fn get_result_token(&self) -> &::std::option::Option<::std::string::String> {
        &self.result_token
    }
    /// Consumes the builder and constructs a [`EvaluationResult`](crate::types::EvaluationResult).
    pub fn build(self) -> crate::types::EvaluationResult {
        crate::types::EvaluationResult {
            evaluation_result_identifier: self.evaluation_result_identifier,
            compliance_type: self.compliance_type,
            result_recorded_time: self.result_recorded_time,
            config_rule_invoked_time: self.config_rule_invoked_time,
            annotation: self.annotation,
            result_token: self.result_token,
        }
    }
}
