// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Returns status details of an evaluation.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct EvaluationStatus {
    /// <p>The status of an execution. The valid values are In_Progress, Succeeded or Failed.</p>
    pub status: crate::types::ResourceEvaluationStatus,
    /// <p>An explanation for failed execution status.</p>
    pub failure_reason: ::std::option::Option<::std::string::String>,
}
impl EvaluationStatus {
    /// <p>The status of an execution. The valid values are In_Progress, Succeeded or Failed.</p>
    pub fn status(&self) -> &crate::types::ResourceEvaluationStatus {
        &self.status
    }
    /// <p>An explanation for failed execution status.</p>
    pub fn failure_reason(&self) -> ::std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
}
impl EvaluationStatus {
    /// Creates a new builder-style object to manufacture [`EvaluationStatus`](crate::types::EvaluationStatus).
    pub fn builder() -> crate::types::builders::EvaluationStatusBuilder {
        crate::types::builders::EvaluationStatusBuilder::default()
    }
}

/// A builder for [`EvaluationStatus`](crate::types::EvaluationStatus).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct EvaluationStatusBuilder {
    pub(crate) status: ::std::option::Option<crate::types::ResourceEvaluationStatus>,
    pub(crate) failure_reason: ::std::option::Option<::std::string::String>,
}
impl EvaluationStatusBuilder {
    /// <p>The status of an execution. The valid values are In_Progress, Succeeded or Failed.</p>
    /// This field is required.
    pub fn status(mut self, input: crate::types::ResourceEvaluationStatus) -> Self {
        self.status = ::std::option::Option::Some(input);
        self
    }
    /// <p>The status of an execution. The valid values are In_Progress, Succeeded or Failed.</p>
    pub fn set_status(mut self, input: ::std::option::Option<crate::types::ResourceEvaluationStatus>) -> Self {
        self.status = input;
        self
    }
    /// <p>The status of an execution. The valid values are In_Progress, Succeeded or Failed.</p>
    pub fn get_status(&self) -> &::std::option::Option<crate::types::ResourceEvaluationStatus> {
        &self.status
    }
    /// <p>An explanation for failed execution status.</p>
    pub fn failure_reason(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.failure_reason = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>An explanation for failed execution status.</p>
    pub fn set_failure_reason(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.failure_reason = input;
        self
    }
    /// <p>An explanation for failed execution status.</p>
    pub fn get_failure_reason(&self) -> &::std::option::Option<::std::string::String> {
        &self.failure_reason
    }
    /// Consumes the builder and constructs a [`EvaluationStatus`](crate::types::EvaluationStatus).
    /// This method will fail if any of the following fields are not set:
    /// - [`status`](crate::types::builders::EvaluationStatusBuilder::status)
    pub fn build(self) -> ::std::result::Result<crate::types::EvaluationStatus, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::EvaluationStatus {
            status: self.status.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "status",
                    "status was not specified but it is required when building EvaluationStatus",
                )
            })?,
            failure_reason: self.failure_reason,
        })
    }
}
