// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>An object that specifies metadata for your organization's Config Custom Policy rule. The metadata includes the runtime system in use, which accounts have debug logging enabled, and other custom rule metadata, such as resource type, resource ID of Amazon Web Services resource, and organization trigger types that initiate Config to evaluate Amazon Web Services resources against a rule.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct OrganizationCustomPolicyRuleMetadata {
    /// <p>The description that you provide for your organization Config Custom Policy rule.</p>
    pub description: ::std::option::Option<::std::string::String>,
    /// <p>The type of notification that initiates Config to run an evaluation for a rule. For Config Custom Policy rules, Config supports change-initiated notification types:</p>
    /// <ul>
    /// <li>
    /// <p><code>ConfigurationItemChangeNotification</code> - Initiates an evaluation when Config delivers a configuration item as a result of a resource change.</p></li>
    /// <li>
    /// <p><code>OversizedConfigurationItemChangeNotification</code> - Initiates an evaluation when Config delivers an oversized configuration item. Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.</p></li>
    /// </ul>
    pub organization_config_rule_trigger_types: ::std::option::Option<::std::vec::Vec<crate::types::OrganizationConfigRuleTriggerTypeNoSn>>,
    /// <p>A string, in JSON format, that is passed to your organization Config Custom Policy rule.</p>
    pub input_parameters: ::std::option::Option<::std::string::String>,
    /// <p>The maximum frequency with which Config runs evaluations for a rule. Your Config Custom Policy rule is triggered when Config delivers the configuration snapshot. For more information, see <code>ConfigSnapshotDeliveryProperties</code>.</p>
    pub maximum_execution_frequency: ::std::option::Option<crate::types::MaximumExecutionFrequency>,
    /// <p>The type of the Amazon Web Services resource that was evaluated.</p>
    pub resource_types_scope: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
    pub resource_id_scope: ::std::option::Option<::std::string::String>,
    /// <p>One part of a key-value pair that make up a tag. A key is a general label that acts like a category for more specific tag values.</p>
    pub tag_key_scope: ::std::option::Option<::std::string::String>,
    /// <p>The optional part of a key-value pair that make up a tag. A value acts as a descriptor within a tag category (key).</p>
    pub tag_value_scope: ::std::option::Option<::std::string::String>,
    /// <p>The runtime system for your organization Config Custom Policy rules. Guard is a policy-as-code language that allows you to write policies that are enforced by Config Custom Policy rules. For more information about Guard, see the <a href="https://github.com/aws-cloudformation/cloudformation-guard">Guard GitHub Repository</a>.</p>
    pub policy_runtime: ::std::string::String,
    /// <p>The policy definition containing the logic for your organization Config Custom Policy rule.</p>
    pub policy_text: ::std::string::String,
    /// <p>A list of accounts that you can enable debug logging for your organization Config Custom Policy rule. List is null when debug logging is enabled for all accounts.</p>
    pub debug_log_delivery_accounts: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
}
impl OrganizationCustomPolicyRuleMetadata {
    /// <p>The description that you provide for your organization Config Custom Policy rule.</p>
    pub fn description(&self) -> ::std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The type of notification that initiates Config to run an evaluation for a rule. For Config Custom Policy rules, Config supports change-initiated notification types:</p>
    /// <ul>
    /// <li>
    /// <p><code>ConfigurationItemChangeNotification</code> - Initiates an evaluation when Config delivers a configuration item as a result of a resource change.</p></li>
    /// <li>
    /// <p><code>OversizedConfigurationItemChangeNotification</code> - Initiates an evaluation when Config delivers an oversized configuration item. Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.</p></li>
    /// </ul>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.organization_config_rule_trigger_types.is_none()`.
    pub fn organization_config_rule_trigger_types(&self) -> &[crate::types::OrganizationConfigRuleTriggerTypeNoSn] {
        self.organization_config_rule_trigger_types.as_deref().unwrap_or_default()
    }
    /// <p>A string, in JSON format, that is passed to your organization Config Custom Policy rule.</p>
    pub fn input_parameters(&self) -> ::std::option::Option<&str> {
        self.input_parameters.as_deref()
    }
    /// <p>The maximum frequency with which Config runs evaluations for a rule. Your Config Custom Policy rule is triggered when Config delivers the configuration snapshot. For more information, see <code>ConfigSnapshotDeliveryProperties</code>.</p>
    pub fn maximum_execution_frequency(&self) -> ::std::option::Option<&crate::types::MaximumExecutionFrequency> {
        self.maximum_execution_frequency.as_ref()
    }
    /// <p>The type of the Amazon Web Services resource that was evaluated.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.resource_types_scope.is_none()`.
    pub fn resource_types_scope(&self) -> &[::std::string::String] {
        self.resource_types_scope.as_deref().unwrap_or_default()
    }
    /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
    pub fn resource_id_scope(&self) -> ::std::option::Option<&str> {
        self.resource_id_scope.as_deref()
    }
    /// <p>One part of a key-value pair that make up a tag. A key is a general label that acts like a category for more specific tag values.</p>
    pub fn tag_key_scope(&self) -> ::std::option::Option<&str> {
        self.tag_key_scope.as_deref()
    }
    /// <p>The optional part of a key-value pair that make up a tag. A value acts as a descriptor within a tag category (key).</p>
    pub fn tag_value_scope(&self) -> ::std::option::Option<&str> {
        self.tag_value_scope.as_deref()
    }
    /// <p>The runtime system for your organization Config Custom Policy rules. Guard is a policy-as-code language that allows you to write policies that are enforced by Config Custom Policy rules. For more information about Guard, see the <a href="https://github.com/aws-cloudformation/cloudformation-guard">Guard GitHub Repository</a>.</p>
    pub fn policy_runtime(&self) -> &str {
        use std::ops::Deref;
        self.policy_runtime.deref()
    }
    /// <p>The policy definition containing the logic for your organization Config Custom Policy rule.</p>
    pub fn policy_text(&self) -> &str {
        use std::ops::Deref;
        self.policy_text.deref()
    }
    /// <p>A list of accounts that you can enable debug logging for your organization Config Custom Policy rule. List is null when debug logging is enabled for all accounts.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.debug_log_delivery_accounts.is_none()`.
    pub fn debug_log_delivery_accounts(&self) -> &[::std::string::String] {
        self.debug_log_delivery_accounts.as_deref().unwrap_or_default()
    }
}
impl OrganizationCustomPolicyRuleMetadata {
    /// Creates a new builder-style object to manufacture [`OrganizationCustomPolicyRuleMetadata`](crate::types::OrganizationCustomPolicyRuleMetadata).
    pub fn builder() -> crate::types::builders::OrganizationCustomPolicyRuleMetadataBuilder {
        crate::types::builders::OrganizationCustomPolicyRuleMetadataBuilder::default()
    }
}

/// A builder for [`OrganizationCustomPolicyRuleMetadata`](crate::types::OrganizationCustomPolicyRuleMetadata).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct OrganizationCustomPolicyRuleMetadataBuilder {
    pub(crate) description: ::std::option::Option<::std::string::String>,
    pub(crate) organization_config_rule_trigger_types: ::std::option::Option<::std::vec::Vec<crate::types::OrganizationConfigRuleTriggerTypeNoSn>>,
    pub(crate) input_parameters: ::std::option::Option<::std::string::String>,
    pub(crate) maximum_execution_frequency: ::std::option::Option<crate::types::MaximumExecutionFrequency>,
    pub(crate) resource_types_scope: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    pub(crate) resource_id_scope: ::std::option::Option<::std::string::String>,
    pub(crate) tag_key_scope: ::std::option::Option<::std::string::String>,
    pub(crate) tag_value_scope: ::std::option::Option<::std::string::String>,
    pub(crate) policy_runtime: ::std::option::Option<::std::string::String>,
    pub(crate) policy_text: ::std::option::Option<::std::string::String>,
    pub(crate) debug_log_delivery_accounts: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
}
impl OrganizationCustomPolicyRuleMetadataBuilder {
    /// <p>The description that you provide for your organization Config Custom Policy rule.</p>
    pub fn description(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.description = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The description that you provide for your organization Config Custom Policy rule.</p>
    pub fn set_description(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.description = input;
        self
    }
    /// <p>The description that you provide for your organization Config Custom Policy rule.</p>
    pub fn get_description(&self) -> &::std::option::Option<::std::string::String> {
        &self.description
    }
    /// Appends an item to `organization_config_rule_trigger_types`.
    ///
    /// To override the contents of this collection use [`set_organization_config_rule_trigger_types`](Self::set_organization_config_rule_trigger_types).
    ///
    /// <p>The type of notification that initiates Config to run an evaluation for a rule. For Config Custom Policy rules, Config supports change-initiated notification types:</p>
    /// <ul>
    /// <li>
    /// <p><code>ConfigurationItemChangeNotification</code> - Initiates an evaluation when Config delivers a configuration item as a result of a resource change.</p></li>
    /// <li>
    /// <p><code>OversizedConfigurationItemChangeNotification</code> - Initiates an evaluation when Config delivers an oversized configuration item. Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.</p></li>
    /// </ul>
    pub fn organization_config_rule_trigger_types(mut self, input: crate::types::OrganizationConfigRuleTriggerTypeNoSn) -> Self {
        let mut v = self.organization_config_rule_trigger_types.unwrap_or_default();
        v.push(input);
        self.organization_config_rule_trigger_types = ::std::option::Option::Some(v);
        self
    }
    /// <p>The type of notification that initiates Config to run an evaluation for a rule. For Config Custom Policy rules, Config supports change-initiated notification types:</p>
    /// <ul>
    /// <li>
    /// <p><code>ConfigurationItemChangeNotification</code> - Initiates an evaluation when Config delivers a configuration item as a result of a resource change.</p></li>
    /// <li>
    /// <p><code>OversizedConfigurationItemChangeNotification</code> - Initiates an evaluation when Config delivers an oversized configuration item. Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.</p></li>
    /// </ul>
    pub fn set_organization_config_rule_trigger_types(
        mut self,
        input: ::std::option::Option<::std::vec::Vec<crate::types::OrganizationConfigRuleTriggerTypeNoSn>>,
    ) -> Self {
        self.organization_config_rule_trigger_types = input;
        self
    }
    /// <p>The type of notification that initiates Config to run an evaluation for a rule. For Config Custom Policy rules, Config supports change-initiated notification types:</p>
    /// <ul>
    /// <li>
    /// <p><code>ConfigurationItemChangeNotification</code> - Initiates an evaluation when Config delivers a configuration item as a result of a resource change.</p></li>
    /// <li>
    /// <p><code>OversizedConfigurationItemChangeNotification</code> - Initiates an evaluation when Config delivers an oversized configuration item. Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.</p></li>
    /// </ul>
    pub fn get_organization_config_rule_trigger_types(
        &self,
    ) -> &::std::option::Option<::std::vec::Vec<crate::types::OrganizationConfigRuleTriggerTypeNoSn>> {
        &self.organization_config_rule_trigger_types
    }
    /// <p>A string, in JSON format, that is passed to your organization Config Custom Policy rule.</p>
    pub fn input_parameters(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.input_parameters = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>A string, in JSON format, that is passed to your organization Config Custom Policy rule.</p>
    pub fn set_input_parameters(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.input_parameters = input;
        self
    }
    /// <p>A string, in JSON format, that is passed to your organization Config Custom Policy rule.</p>
    pub fn get_input_parameters(&self) -> &::std::option::Option<::std::string::String> {
        &self.input_parameters
    }
    /// <p>The maximum frequency with which Config runs evaluations for a rule. Your Config Custom Policy rule is triggered when Config delivers the configuration snapshot. For more information, see <code>ConfigSnapshotDeliveryProperties</code>.</p>
    pub fn maximum_execution_frequency(mut self, input: crate::types::MaximumExecutionFrequency) -> Self {
        self.maximum_execution_frequency = ::std::option::Option::Some(input);
        self
    }
    /// <p>The maximum frequency with which Config runs evaluations for a rule. Your Config Custom Policy rule is triggered when Config delivers the configuration snapshot. For more information, see <code>ConfigSnapshotDeliveryProperties</code>.</p>
    pub fn set_maximum_execution_frequency(mut self, input: ::std::option::Option<crate::types::MaximumExecutionFrequency>) -> Self {
        self.maximum_execution_frequency = input;
        self
    }
    /// <p>The maximum frequency with which Config runs evaluations for a rule. Your Config Custom Policy rule is triggered when Config delivers the configuration snapshot. For more information, see <code>ConfigSnapshotDeliveryProperties</code>.</p>
    pub fn get_maximum_execution_frequency(&self) -> &::std::option::Option<crate::types::MaximumExecutionFrequency> {
        &self.maximum_execution_frequency
    }
    /// Appends an item to `resource_types_scope`.
    ///
    /// To override the contents of this collection use [`set_resource_types_scope`](Self::set_resource_types_scope).
    ///
    /// <p>The type of the Amazon Web Services resource that was evaluated.</p>
    pub fn resource_types_scope(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        let mut v = self.resource_types_scope.unwrap_or_default();
        v.push(input.into());
        self.resource_types_scope = ::std::option::Option::Some(v);
        self
    }
    /// <p>The type of the Amazon Web Services resource that was evaluated.</p>
    pub fn set_resource_types_scope(mut self, input: ::std::option::Option<::std::vec::Vec<::std::string::String>>) -> Self {
        self.resource_types_scope = input;
        self
    }
    /// <p>The type of the Amazon Web Services resource that was evaluated.</p>
    pub fn get_resource_types_scope(&self) -> &::std::option::Option<::std::vec::Vec<::std::string::String>> {
        &self.resource_types_scope
    }
    /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
    pub fn resource_id_scope(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.resource_id_scope = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
    pub fn set_resource_id_scope(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.resource_id_scope = input;
        self
    }
    /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
    pub fn get_resource_id_scope(&self) -> &::std::option::Option<::std::string::String> {
        &self.resource_id_scope
    }
    /// <p>One part of a key-value pair that make up a tag. A key is a general label that acts like a category for more specific tag values.</p>
    pub fn tag_key_scope(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.tag_key_scope = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>One part of a key-value pair that make up a tag. A key is a general label that acts like a category for more specific tag values.</p>
    pub fn set_tag_key_scope(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.tag_key_scope = input;
        self
    }
    /// <p>One part of a key-value pair that make up a tag. A key is a general label that acts like a category for more specific tag values.</p>
    pub fn get_tag_key_scope(&self) -> &::std::option::Option<::std::string::String> {
        &self.tag_key_scope
    }
    /// <p>The optional part of a key-value pair that make up a tag. A value acts as a descriptor within a tag category (key).</p>
    pub fn tag_value_scope(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.tag_value_scope = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The optional part of a key-value pair that make up a tag. A value acts as a descriptor within a tag category (key).</p>
    pub fn set_tag_value_scope(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.tag_value_scope = input;
        self
    }
    /// <p>The optional part of a key-value pair that make up a tag. A value acts as a descriptor within a tag category (key).</p>
    pub fn get_tag_value_scope(&self) -> &::std::option::Option<::std::string::String> {
        &self.tag_value_scope
    }
    /// <p>The runtime system for your organization Config Custom Policy rules. Guard is a policy-as-code language that allows you to write policies that are enforced by Config Custom Policy rules. For more information about Guard, see the <a href="https://github.com/aws-cloudformation/cloudformation-guard">Guard GitHub Repository</a>.</p>
    /// This field is required.
    pub fn policy_runtime(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.policy_runtime = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The runtime system for your organization Config Custom Policy rules. Guard is a policy-as-code language that allows you to write policies that are enforced by Config Custom Policy rules. For more information about Guard, see the <a href="https://github.com/aws-cloudformation/cloudformation-guard">Guard GitHub Repository</a>.</p>
    pub fn set_policy_runtime(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.policy_runtime = input;
        self
    }
    /// <p>The runtime system for your organization Config Custom Policy rules. Guard is a policy-as-code language that allows you to write policies that are enforced by Config Custom Policy rules. For more information about Guard, see the <a href="https://github.com/aws-cloudformation/cloudformation-guard">Guard GitHub Repository</a>.</p>
    pub fn get_policy_runtime(&self) -> &::std::option::Option<::std::string::String> {
        &self.policy_runtime
    }
    /// <p>The policy definition containing the logic for your organization Config Custom Policy rule.</p>
    /// This field is required.
    pub fn policy_text(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.policy_text = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The policy definition containing the logic for your organization Config Custom Policy rule.</p>
    pub fn set_policy_text(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.policy_text = input;
        self
    }
    /// <p>The policy definition containing the logic for your organization Config Custom Policy rule.</p>
    pub fn get_policy_text(&self) -> &::std::option::Option<::std::string::String> {
        &self.policy_text
    }
    /// Appends an item to `debug_log_delivery_accounts`.
    ///
    /// To override the contents of this collection use [`set_debug_log_delivery_accounts`](Self::set_debug_log_delivery_accounts).
    ///
    /// <p>A list of accounts that you can enable debug logging for your organization Config Custom Policy rule. List is null when debug logging is enabled for all accounts.</p>
    pub fn debug_log_delivery_accounts(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        let mut v = self.debug_log_delivery_accounts.unwrap_or_default();
        v.push(input.into());
        self.debug_log_delivery_accounts = ::std::option::Option::Some(v);
        self
    }
    /// <p>A list of accounts that you can enable debug logging for your organization Config Custom Policy rule. List is null when debug logging is enabled for all accounts.</p>
    pub fn set_debug_log_delivery_accounts(mut self, input: ::std::option::Option<::std::vec::Vec<::std::string::String>>) -> Self {
        self.debug_log_delivery_accounts = input;
        self
    }
    /// <p>A list of accounts that you can enable debug logging for your organization Config Custom Policy rule. List is null when debug logging is enabled for all accounts.</p>
    pub fn get_debug_log_delivery_accounts(&self) -> &::std::option::Option<::std::vec::Vec<::std::string::String>> {
        &self.debug_log_delivery_accounts
    }
    /// Consumes the builder and constructs a [`OrganizationCustomPolicyRuleMetadata`](crate::types::OrganizationCustomPolicyRuleMetadata).
    /// This method will fail if any of the following fields are not set:
    /// - [`policy_runtime`](crate::types::builders::OrganizationCustomPolicyRuleMetadataBuilder::policy_runtime)
    /// - [`policy_text`](crate::types::builders::OrganizationCustomPolicyRuleMetadataBuilder::policy_text)
    pub fn build(
        self,
    ) -> ::std::result::Result<crate::types::OrganizationCustomPolicyRuleMetadata, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::OrganizationCustomPolicyRuleMetadata {
            description: self.description,
            organization_config_rule_trigger_types: self.organization_config_rule_trigger_types,
            input_parameters: self.input_parameters,
            maximum_execution_frequency: self.maximum_execution_frequency,
            resource_types_scope: self.resource_types_scope,
            resource_id_scope: self.resource_id_scope,
            tag_key_scope: self.tag_key_scope,
            tag_value_scope: self.tag_value_scope,
            policy_runtime: self.policy_runtime.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "policy_runtime",
                    "policy_runtime was not specified but it is required when building OrganizationCustomPolicyRuleMetadata",
                )
            })?,
            policy_text: self.policy_text.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "policy_text",
                    "policy_text was not specified but it is required when building OrganizationCustomPolicyRuleMetadata",
                )
            })?,
            debug_log_delivery_accounts: self.debug_log_delivery_accounts,
        })
    }
}
