// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>An object that specifies organization managed rule metadata such as resource type and ID of Amazon Web Services resource along with the rule identifier. It also provides the frequency with which you want Config to run evaluations for the rule if the trigger type is periodic.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct OrganizationManagedRuleMetadata {
    /// <p>The description that you provide for your organization Config rule.</p>
    pub description: ::std::option::Option<::std::string::String>,
    /// <p>For organization config managed rules, a predefined identifier from a list. For example, <code>IAM_PASSWORD_POLICY</code> is a managed rule. To reference a managed rule, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Using Config managed rules</a>.</p>
    pub rule_identifier: ::std::string::String,
    /// <p>A string, in JSON format, that is passed to your organization Config rule Lambda function.</p>
    pub input_parameters: ::std::option::Option<::std::string::String>,
    /// <p>The maximum frequency with which Config runs evaluations for a rule. This is for an Config managed rule that is triggered at a periodic frequency.</p><note>
    /// <p>By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.</p>
    /// </note>
    pub maximum_execution_frequency: ::std::option::Option<crate::types::MaximumExecutionFrequency>,
    /// <p>The type of the Amazon Web Services resource that was evaluated.</p>
    pub resource_types_scope: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
    pub resource_id_scope: ::std::option::Option<::std::string::String>,
    /// <p>One part of a key-value pair that make up a tag. A key is a general label that acts like a category for more specific tag values.</p>
    pub tag_key_scope: ::std::option::Option<::std::string::String>,
    /// <p>The optional part of a key-value pair that make up a tag. A value acts as a descriptor within a tag category (key).</p>
    pub tag_value_scope: ::std::option::Option<::std::string::String>,
}
impl OrganizationManagedRuleMetadata {
    /// <p>The description that you provide for your organization Config rule.</p>
    pub fn description(&self) -> ::std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>For organization config managed rules, a predefined identifier from a list. For example, <code>IAM_PASSWORD_POLICY</code> is a managed rule. To reference a managed rule, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Using Config managed rules</a>.</p>
    pub fn rule_identifier(&self) -> &str {
        use std::ops::Deref;
        self.rule_identifier.deref()
    }
    /// <p>A string, in JSON format, that is passed to your organization Config rule Lambda function.</p>
    pub fn input_parameters(&self) -> ::std::option::Option<&str> {
        self.input_parameters.as_deref()
    }
    /// <p>The maximum frequency with which Config runs evaluations for a rule. This is for an Config managed rule that is triggered at a periodic frequency.</p><note>
    /// <p>By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.</p>
    /// </note>
    pub fn maximum_execution_frequency(&self) -> ::std::option::Option<&crate::types::MaximumExecutionFrequency> {
        self.maximum_execution_frequency.as_ref()
    }
    /// <p>The type of the Amazon Web Services resource that was evaluated.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.resource_types_scope.is_none()`.
    pub fn resource_types_scope(&self) -> &[::std::string::String] {
        self.resource_types_scope.as_deref().unwrap_or_default()
    }
    /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
    pub fn resource_id_scope(&self) -> ::std::option::Option<&str> {
        self.resource_id_scope.as_deref()
    }
    /// <p>One part of a key-value pair that make up a tag. A key is a general label that acts like a category for more specific tag values.</p>
    pub fn tag_key_scope(&self) -> ::std::option::Option<&str> {
        self.tag_key_scope.as_deref()
    }
    /// <p>The optional part of a key-value pair that make up a tag. A value acts as a descriptor within a tag category (key).</p>
    pub fn tag_value_scope(&self) -> ::std::option::Option<&str> {
        self.tag_value_scope.as_deref()
    }
}
impl OrganizationManagedRuleMetadata {
    /// Creates a new builder-style object to manufacture [`OrganizationManagedRuleMetadata`](crate::types::OrganizationManagedRuleMetadata).
    pub fn builder() -> crate::types::builders::OrganizationManagedRuleMetadataBuilder {
        crate::types::builders::OrganizationManagedRuleMetadataBuilder::default()
    }
}

/// A builder for [`OrganizationManagedRuleMetadata`](crate::types::OrganizationManagedRuleMetadata).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct OrganizationManagedRuleMetadataBuilder {
    pub(crate) description: ::std::option::Option<::std::string::String>,
    pub(crate) rule_identifier: ::std::option::Option<::std::string::String>,
    pub(crate) input_parameters: ::std::option::Option<::std::string::String>,
    pub(crate) maximum_execution_frequency: ::std::option::Option<crate::types::MaximumExecutionFrequency>,
    pub(crate) resource_types_scope: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    pub(crate) resource_id_scope: ::std::option::Option<::std::string::String>,
    pub(crate) tag_key_scope: ::std::option::Option<::std::string::String>,
    pub(crate) tag_value_scope: ::std::option::Option<::std::string::String>,
}
impl OrganizationManagedRuleMetadataBuilder {
    /// <p>The description that you provide for your organization Config rule.</p>
    pub fn description(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.description = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The description that you provide for your organization Config rule.</p>
    pub fn set_description(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.description = input;
        self
    }
    /// <p>The description that you provide for your organization Config rule.</p>
    pub fn get_description(&self) -> &::std::option::Option<::std::string::String> {
        &self.description
    }
    /// <p>For organization config managed rules, a predefined identifier from a list. For example, <code>IAM_PASSWORD_POLICY</code> is a managed rule. To reference a managed rule, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Using Config managed rules</a>.</p>
    /// This field is required.
    pub fn rule_identifier(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.rule_identifier = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>For organization config managed rules, a predefined identifier from a list. For example, <code>IAM_PASSWORD_POLICY</code> is a managed rule. To reference a managed rule, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Using Config managed rules</a>.</p>
    pub fn set_rule_identifier(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.rule_identifier = input;
        self
    }
    /// <p>For organization config managed rules, a predefined identifier from a list. For example, <code>IAM_PASSWORD_POLICY</code> is a managed rule. To reference a managed rule, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Using Config managed rules</a>.</p>
    pub fn get_rule_identifier(&self) -> &::std::option::Option<::std::string::String> {
        &self.rule_identifier
    }
    /// <p>A string, in JSON format, that is passed to your organization Config rule Lambda function.</p>
    pub fn input_parameters(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.input_parameters = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>A string, in JSON format, that is passed to your organization Config rule Lambda function.</p>
    pub fn set_input_parameters(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.input_parameters = input;
        self
    }
    /// <p>A string, in JSON format, that is passed to your organization Config rule Lambda function.</p>
    pub fn get_input_parameters(&self) -> &::std::option::Option<::std::string::String> {
        &self.input_parameters
    }
    /// <p>The maximum frequency with which Config runs evaluations for a rule. This is for an Config managed rule that is triggered at a periodic frequency.</p><note>
    /// <p>By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.</p>
    /// </note>
    pub fn maximum_execution_frequency(mut self, input: crate::types::MaximumExecutionFrequency) -> Self {
        self.maximum_execution_frequency = ::std::option::Option::Some(input);
        self
    }
    /// <p>The maximum frequency with which Config runs evaluations for a rule. This is for an Config managed rule that is triggered at a periodic frequency.</p><note>
    /// <p>By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.</p>
    /// </note>
    pub fn set_maximum_execution_frequency(mut self, input: ::std::option::Option<crate::types::MaximumExecutionFrequency>) -> Self {
        self.maximum_execution_frequency = input;
        self
    }
    /// <p>The maximum frequency with which Config runs evaluations for a rule. This is for an Config managed rule that is triggered at a periodic frequency.</p><note>
    /// <p>By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.</p>
    /// </note>
    pub fn get_maximum_execution_frequency(&self) -> &::std::option::Option<crate::types::MaximumExecutionFrequency> {
        &self.maximum_execution_frequency
    }
    /// Appends an item to `resource_types_scope`.
    ///
    /// To override the contents of this collection use [`set_resource_types_scope`](Self::set_resource_types_scope).
    ///
    /// <p>The type of the Amazon Web Services resource that was evaluated.</p>
    pub fn resource_types_scope(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        let mut v = self.resource_types_scope.unwrap_or_default();
        v.push(input.into());
        self.resource_types_scope = ::std::option::Option::Some(v);
        self
    }
    /// <p>The type of the Amazon Web Services resource that was evaluated.</p>
    pub fn set_resource_types_scope(mut self, input: ::std::option::Option<::std::vec::Vec<::std::string::String>>) -> Self {
        self.resource_types_scope = input;
        self
    }
    /// <p>The type of the Amazon Web Services resource that was evaluated.</p>
    pub fn get_resource_types_scope(&self) -> &::std::option::Option<::std::vec::Vec<::std::string::String>> {
        &self.resource_types_scope
    }
    /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
    pub fn resource_id_scope(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.resource_id_scope = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
    pub fn set_resource_id_scope(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.resource_id_scope = input;
        self
    }
    /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
    pub fn get_resource_id_scope(&self) -> &::std::option::Option<::std::string::String> {
        &self.resource_id_scope
    }
    /// <p>One part of a key-value pair that make up a tag. A key is a general label that acts like a category for more specific tag values.</p>
    pub fn tag_key_scope(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.tag_key_scope = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>One part of a key-value pair that make up a tag. A key is a general label that acts like a category for more specific tag values.</p>
    pub fn set_tag_key_scope(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.tag_key_scope = input;
        self
    }
    /// <p>One part of a key-value pair that make up a tag. A key is a general label that acts like a category for more specific tag values.</p>
    pub fn get_tag_key_scope(&self) -> &::std::option::Option<::std::string::String> {
        &self.tag_key_scope
    }
    /// <p>The optional part of a key-value pair that make up a tag. A value acts as a descriptor within a tag category (key).</p>
    pub fn tag_value_scope(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.tag_value_scope = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The optional part of a key-value pair that make up a tag. A value acts as a descriptor within a tag category (key).</p>
    pub fn set_tag_value_scope(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.tag_value_scope = input;
        self
    }
    /// <p>The optional part of a key-value pair that make up a tag. A value acts as a descriptor within a tag category (key).</p>
    pub fn get_tag_value_scope(&self) -> &::std::option::Option<::std::string::String> {
        &self.tag_value_scope
    }
    /// Consumes the builder and constructs a [`OrganizationManagedRuleMetadata`](crate::types::OrganizationManagedRuleMetadata).
    /// This method will fail if any of the following fields are not set:
    /// - [`rule_identifier`](crate::types::builders::OrganizationManagedRuleMetadataBuilder::rule_identifier)
    pub fn build(self) -> ::std::result::Result<crate::types::OrganizationManagedRuleMetadata, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::OrganizationManagedRuleMetadata {
            description: self.description,
            rule_identifier: self.rule_identifier.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "rule_identifier",
                    "rule_identifier was not specified but it is required when building OrganizationManagedRuleMetadata",
                )
            })?,
            input_parameters: self.input_parameters,
            maximum_execution_frequency: self.maximum_execution_frequency,
            resource_types_scope: self.resource_types_scope,
            resource_id_scope: self.resource_id_scope,
            tag_key_scope: self.tag_key_scope,
            tag_value_scope: self.tag_value_scope,
        })
    }
}
