// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Status filter object to filter results based on specific member account ID or status type for an organization conformance pack.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct OrganizationResourceDetailedStatusFilters {
    /// <p>The 12-digit account ID of the member account within an organization.</p>
    pub account_id: ::std::option::Option<::std::string::String>,
    /// <p>Indicates deployment status for conformance pack in a member account. When management account calls <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is created in the member account. When management account calls <code>PutOrganizationConformancePack</code> action for the second time, conformance pack status is updated in the member account. Conformance pack status is deleted when the management account deletes <code>OrganizationConformancePack</code> and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.</p>
    /// <p>Config sets the state of the conformance pack to:</p>
    /// <ul>
    /// <li>
    /// <p><code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account.</p></li>
    /// <li>
    /// <p><code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.</p></li>
    /// <li>
    /// <p><code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.</p></li>
    /// <li>
    /// <p><code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.</p></li>
    /// <li>
    /// <p><code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.</p></li>
    /// <li>
    /// <p><code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account.</p></li>
    /// <li>
    /// <p><code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.</p></li>
    /// <li>
    /// <p><code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.</p></li>
    /// <li>
    /// <p><code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.</p></li>
    /// </ul>
    pub status: ::std::option::Option<crate::types::OrganizationResourceDetailedStatus>,
}
impl OrganizationResourceDetailedStatusFilters {
    /// <p>The 12-digit account ID of the member account within an organization.</p>
    pub fn account_id(&self) -> ::std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>Indicates deployment status for conformance pack in a member account. When management account calls <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is created in the member account. When management account calls <code>PutOrganizationConformancePack</code> action for the second time, conformance pack status is updated in the member account. Conformance pack status is deleted when the management account deletes <code>OrganizationConformancePack</code> and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.</p>
    /// <p>Config sets the state of the conformance pack to:</p>
    /// <ul>
    /// <li>
    /// <p><code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account.</p></li>
    /// <li>
    /// <p><code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.</p></li>
    /// <li>
    /// <p><code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.</p></li>
    /// <li>
    /// <p><code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.</p></li>
    /// <li>
    /// <p><code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.</p></li>
    /// <li>
    /// <p><code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account.</p></li>
    /// <li>
    /// <p><code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.</p></li>
    /// <li>
    /// <p><code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.</p></li>
    /// <li>
    /// <p><code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.</p></li>
    /// </ul>
    pub fn status(&self) -> ::std::option::Option<&crate::types::OrganizationResourceDetailedStatus> {
        self.status.as_ref()
    }
}
impl OrganizationResourceDetailedStatusFilters {
    /// Creates a new builder-style object to manufacture [`OrganizationResourceDetailedStatusFilters`](crate::types::OrganizationResourceDetailedStatusFilters).
    pub fn builder() -> crate::types::builders::OrganizationResourceDetailedStatusFiltersBuilder {
        crate::types::builders::OrganizationResourceDetailedStatusFiltersBuilder::default()
    }
}

/// A builder for [`OrganizationResourceDetailedStatusFilters`](crate::types::OrganizationResourceDetailedStatusFilters).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct OrganizationResourceDetailedStatusFiltersBuilder {
    pub(crate) account_id: ::std::option::Option<::std::string::String>,
    pub(crate) status: ::std::option::Option<crate::types::OrganizationResourceDetailedStatus>,
}
impl OrganizationResourceDetailedStatusFiltersBuilder {
    /// <p>The 12-digit account ID of the member account within an organization.</p>
    pub fn account_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.account_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The 12-digit account ID of the member account within an organization.</p>
    pub fn set_account_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.account_id = input;
        self
    }
    /// <p>The 12-digit account ID of the member account within an organization.</p>
    pub fn get_account_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.account_id
    }
    /// <p>Indicates deployment status for conformance pack in a member account. When management account calls <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is created in the member account. When management account calls <code>PutOrganizationConformancePack</code> action for the second time, conformance pack status is updated in the member account. Conformance pack status is deleted when the management account deletes <code>OrganizationConformancePack</code> and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.</p>
    /// <p>Config sets the state of the conformance pack to:</p>
    /// <ul>
    /// <li>
    /// <p><code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account.</p></li>
    /// <li>
    /// <p><code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.</p></li>
    /// <li>
    /// <p><code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.</p></li>
    /// <li>
    /// <p><code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.</p></li>
    /// <li>
    /// <p><code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.</p></li>
    /// <li>
    /// <p><code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account.</p></li>
    /// <li>
    /// <p><code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.</p></li>
    /// <li>
    /// <p><code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.</p></li>
    /// <li>
    /// <p><code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.</p></li>
    /// </ul>
    pub fn status(mut self, input: crate::types::OrganizationResourceDetailedStatus) -> Self {
        self.status = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates deployment status for conformance pack in a member account. When management account calls <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is created in the member account. When management account calls <code>PutOrganizationConformancePack</code> action for the second time, conformance pack status is updated in the member account. Conformance pack status is deleted when the management account deletes <code>OrganizationConformancePack</code> and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.</p>
    /// <p>Config sets the state of the conformance pack to:</p>
    /// <ul>
    /// <li>
    /// <p><code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account.</p></li>
    /// <li>
    /// <p><code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.</p></li>
    /// <li>
    /// <p><code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.</p></li>
    /// <li>
    /// <p><code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.</p></li>
    /// <li>
    /// <p><code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.</p></li>
    /// <li>
    /// <p><code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account.</p></li>
    /// <li>
    /// <p><code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.</p></li>
    /// <li>
    /// <p><code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.</p></li>
    /// <li>
    /// <p><code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.</p></li>
    /// </ul>
    pub fn set_status(mut self, input: ::std::option::Option<crate::types::OrganizationResourceDetailedStatus>) -> Self {
        self.status = input;
        self
    }
    /// <p>Indicates deployment status for conformance pack in a member account. When management account calls <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is created in the member account. When management account calls <code>PutOrganizationConformancePack</code> action for the second time, conformance pack status is updated in the member account. Conformance pack status is deleted when the management account deletes <code>OrganizationConformancePack</code> and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.</p>
    /// <p>Config sets the state of the conformance pack to:</p>
    /// <ul>
    /// <li>
    /// <p><code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account.</p></li>
    /// <li>
    /// <p><code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.</p></li>
    /// <li>
    /// <p><code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.</p></li>
    /// <li>
    /// <p><code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.</p></li>
    /// <li>
    /// <p><code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.</p></li>
    /// <li>
    /// <p><code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account.</p></li>
    /// <li>
    /// <p><code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.</p></li>
    /// <li>
    /// <p><code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.</p></li>
    /// <li>
    /// <p><code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.</p></li>
    /// </ul>
    pub fn get_status(&self) -> &::std::option::Option<crate::types::OrganizationResourceDetailedStatus> {
        &self.status
    }
    /// Consumes the builder and constructs a [`OrganizationResourceDetailedStatusFilters`](crate::types::OrganizationResourceDetailedStatusFilters).
    pub fn build(self) -> crate::types::OrganizationResourceDetailedStatusFilters {
        crate::types::OrganizationResourceDetailedStatusFilters {
            account_id: self.account_id,
            status: self.status,
        }
    }
}
