// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>An object that represents the details about the remediation exception. The details include the rule name, an explanation of an exception, the time when the exception will be deleted, the resource ID, and resource type.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct RemediationException {
    /// <p>The name of the Config rule.</p>
    pub config_rule_name: ::std::string::String,
    /// <p>The type of a resource.</p>
    pub resource_type: ::std::string::String,
    /// <p>The ID of the resource (for example., sg-xxxxxx).</p>
    pub resource_id: ::std::string::String,
    /// <p>An explanation of an remediation exception.</p>
    pub message: ::std::option::Option<::std::string::String>,
    /// <p>The time when the remediation exception will be deleted.</p>
    pub expiration_time: ::std::option::Option<::aws_smithy_types::DateTime>,
}
impl RemediationException {
    /// <p>The name of the Config rule.</p>
    pub fn config_rule_name(&self) -> &str {
        use std::ops::Deref;
        self.config_rule_name.deref()
    }
    /// <p>The type of a resource.</p>
    pub fn resource_type(&self) -> &str {
        use std::ops::Deref;
        self.resource_type.deref()
    }
    /// <p>The ID of the resource (for example., sg-xxxxxx).</p>
    pub fn resource_id(&self) -> &str {
        use std::ops::Deref;
        self.resource_id.deref()
    }
    /// <p>An explanation of an remediation exception.</p>
    pub fn message(&self) -> ::std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The time when the remediation exception will be deleted.</p>
    pub fn expiration_time(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.expiration_time.as_ref()
    }
}
impl RemediationException {
    /// Creates a new builder-style object to manufacture [`RemediationException`](crate::types::RemediationException).
    pub fn builder() -> crate::types::builders::RemediationExceptionBuilder {
        crate::types::builders::RemediationExceptionBuilder::default()
    }
}

/// A builder for [`RemediationException`](crate::types::RemediationException).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct RemediationExceptionBuilder {
    pub(crate) config_rule_name: ::std::option::Option<::std::string::String>,
    pub(crate) resource_type: ::std::option::Option<::std::string::String>,
    pub(crate) resource_id: ::std::option::Option<::std::string::String>,
    pub(crate) message: ::std::option::Option<::std::string::String>,
    pub(crate) expiration_time: ::std::option::Option<::aws_smithy_types::DateTime>,
}
impl RemediationExceptionBuilder {
    /// <p>The name of the Config rule.</p>
    /// This field is required.
    pub fn config_rule_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.config_rule_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the Config rule.</p>
    pub fn set_config_rule_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.config_rule_name = input;
        self
    }
    /// <p>The name of the Config rule.</p>
    pub fn get_config_rule_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.config_rule_name
    }
    /// <p>The type of a resource.</p>
    /// This field is required.
    pub fn resource_type(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.resource_type = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The type of a resource.</p>
    pub fn set_resource_type(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.resource_type = input;
        self
    }
    /// <p>The type of a resource.</p>
    pub fn get_resource_type(&self) -> &::std::option::Option<::std::string::String> {
        &self.resource_type
    }
    /// <p>The ID of the resource (for example., sg-xxxxxx).</p>
    /// This field is required.
    pub fn resource_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.resource_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The ID of the resource (for example., sg-xxxxxx).</p>
    pub fn set_resource_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.resource_id = input;
        self
    }
    /// <p>The ID of the resource (for example., sg-xxxxxx).</p>
    pub fn get_resource_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.resource_id
    }
    /// <p>An explanation of an remediation exception.</p>
    pub fn message(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.message = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>An explanation of an remediation exception.</p>
    pub fn set_message(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.message = input;
        self
    }
    /// <p>An explanation of an remediation exception.</p>
    pub fn get_message(&self) -> &::std::option::Option<::std::string::String> {
        &self.message
    }
    /// <p>The time when the remediation exception will be deleted.</p>
    pub fn expiration_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.expiration_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The time when the remediation exception will be deleted.</p>
    pub fn set_expiration_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.expiration_time = input;
        self
    }
    /// <p>The time when the remediation exception will be deleted.</p>
    pub fn get_expiration_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.expiration_time
    }
    /// Consumes the builder and constructs a [`RemediationException`](crate::types::RemediationException).
    /// This method will fail if any of the following fields are not set:
    /// - [`config_rule_name`](crate::types::builders::RemediationExceptionBuilder::config_rule_name)
    /// - [`resource_type`](crate::types::builders::RemediationExceptionBuilder::resource_type)
    /// - [`resource_id`](crate::types::builders::RemediationExceptionBuilder::resource_id)
    pub fn build(self) -> ::std::result::Result<crate::types::RemediationException, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::RemediationException {
            config_rule_name: self.config_rule_name.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "config_rule_name",
                    "config_rule_name was not specified but it is required when building RemediationException",
                )
            })?,
            resource_type: self.resource_type.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "resource_type",
                    "resource_type was not specified but it is required when building RemediationException",
                )
            })?,
            resource_id: self.resource_id.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "resource_id",
                    "resource_id was not specified but it is required when building RemediationException",
                )
            })?,
            message: self.message,
            expiration_time: self.expiration_time,
        })
    }
}
