// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// When writing a match expression against `ResourceType`, it is important to ensure
/// your code is forward-compatible. That is, if a match arm handles a case for a
/// feature that is supported by the service but has not been represented as an enum
/// variant in a current version of SDK, your code should continue to work when you
/// upgrade SDK to a future version in which the enum does include a variant for that
/// feature.
///
/// Here is an example of how you can make a match expression forward-compatible:
///
/// ```text
/// # let resourcetype = unimplemented!();
/// match resourcetype {
///     ResourceType::Certificate => { /* ... */ },
///     ResourceType::AcmpcaCertificateAuthority => { /* ... */ },
///     ResourceType::AcmpcaCertificateAuthorityActivation => { /* ... */ },
///     ResourceType::ApsRuleGroupsNamespace => { /* ... */ },
///     ResourceType::AccessAnalyzerAnalyzer => { /* ... */ },
///     ResourceType::AmazonMqBroker => { /* ... */ },
///     ResourceType::AmplifyApp => { /* ... */ },
///     ResourceType::AmplifyBranch => { /* ... */ },
///     ResourceType::RestApi => { /* ... */ },
///     ResourceType::Stage => { /* ... */ },
///     ResourceType::Api => { /* ... */ },
///     ResourceType::StageV2 => { /* ... */ },
///     ResourceType::AppConfigApplication => { /* ... */ },
///     ResourceType::AppConfigConfigurationProfile => { /* ... */ },
///     ResourceType::AppConfigDeploymentStrategy => { /* ... */ },
///     ResourceType::AppConfigEnvironment => { /* ... */ },
///     ResourceType::AppConfigHostedConfigurationVersion => { /* ... */ },
///     ResourceType::AppFlowFlow => { /* ... */ },
///     ResourceType::AppIntegrationsEventIntegration => { /* ... */ },
///     ResourceType::AppMeshGatewayRoute => { /* ... */ },
///     ResourceType::AppMeshMesh => { /* ... */ },
///     ResourceType::AppMeshRoute => { /* ... */ },
///     ResourceType::AppMeshVirtualGateway => { /* ... */ },
///     ResourceType::AppMeshVirtualNode => { /* ... */ },
///     ResourceType::AppMeshVirtualRouter => { /* ... */ },
///     ResourceType::AppMeshVirtualService => { /* ... */ },
///     ResourceType::AppRunnerService => { /* ... */ },
///     ResourceType::AppRunnerVpcConnector => { /* ... */ },
///     ResourceType::AppStreamApplication => { /* ... */ },
///     ResourceType::AppStreamDirectoryConfig => { /* ... */ },
///     ResourceType::AppStreamFleet => { /* ... */ },
///     ResourceType::AppStreamStack => { /* ... */ },
///     ResourceType::AppSyncGraphQlApi => { /* ... */ },
///     ResourceType::AthenaDataCatalog => { /* ... */ },
///     ResourceType::AthenaPreparedStatement => { /* ... */ },
///     ResourceType::AthenaWorkGroup => { /* ... */ },
///     ResourceType::AuditManagerAssessment => { /* ... */ },
///     ResourceType::AutoScalingGroup => { /* ... */ },
///     ResourceType::LaunchConfiguration => { /* ... */ },
///     ResourceType::ScalingPolicy => { /* ... */ },
///     ResourceType::ScheduledAction => { /* ... */ },
///     ResourceType::AutoScalingWarmPool => { /* ... */ },
///     ResourceType::BackupPlan => { /* ... */ },
///     ResourceType::BackupSelection => { /* ... */ },
///     ResourceType::BackupVault => { /* ... */ },
///     ResourceType::BackupRecoveryPoint => { /* ... */ },
///     ResourceType::BackupReportPlan => { /* ... */ },
///     ResourceType::BatchComputeEnvironment => { /* ... */ },
///     ResourceType::BatchJobQueue => { /* ... */ },
///     ResourceType::BatchSchedulingPolicy => { /* ... */ },
///     ResourceType::BudgetsBudgetsAction => { /* ... */ },
///     ResourceType::CassandraKeyspace => { /* ... */ },
///     ResourceType::Cloud9EnvironmentEc2 => { /* ... */ },
///     ResourceType::Stack => { /* ... */ },
///     ResourceType::Distribution => { /* ... */ },
///     ResourceType::StreamingDistribution => { /* ... */ },
///     ResourceType::Trail => { /* ... */ },
///     ResourceType::Alarm => { /* ... */ },
///     ResourceType::CloudWatchMetricStream => { /* ... */ },
///     ResourceType::CodeArtifactRepository => { /* ... */ },
///     ResourceType::Project => { /* ... */ },
///     ResourceType::CodeBuildReportGroup => { /* ... */ },
///     ResourceType::CodeDeployApplication => { /* ... */ },
///     ResourceType::CodeDeployDeploymentConfig => { /* ... */ },
///     ResourceType::CodeDeployDeploymentGroup => { /* ... */ },
///     ResourceType::CodeGuruProfilerProfilingGroup => { /* ... */ },
///     ResourceType::CodeGuruReviewerRepositoryAssociation => { /* ... */ },
///     ResourceType::Pipeline => { /* ... */ },
///     ResourceType::CognitoUserPool => { /* ... */ },
///     ResourceType::CognitoUserPoolClient => { /* ... */ },
///     ResourceType::CognitoUserPoolGroup => { /* ... */ },
///     ResourceType::ConformancePackCompliance => { /* ... */ },
///     ResourceType::ResourceCompliance => { /* ... */ },
///     ResourceType::ConnectInstance => { /* ... */ },
///     ResourceType::ConnectPhoneNumber => { /* ... */ },
///     ResourceType::ConnectQuickConnect => { /* ... */ },
///     ResourceType::CustomerProfilesDomain => { /* ... */ },
///     ResourceType::CustomerProfilesObjectType => { /* ... */ },
///     ResourceType::DmsCertificate => { /* ... */ },
///     ResourceType::DmsEndpoint => { /* ... */ },
///     ResourceType::DmsEventSubscription => { /* ... */ },
///     ResourceType::DmsReplicationSubnetGroup => { /* ... */ },
///     ResourceType::DataSyncLocationEfs => { /* ... */ },
///     ResourceType::DataSyncLocationFSxLustre => { /* ... */ },
///     ResourceType::DataSyncLocationFSxWindows => { /* ... */ },
///     ResourceType::DataSyncLocationHdfs => { /* ... */ },
///     ResourceType::DataSyncLocationNfs => { /* ... */ },
///     ResourceType::DataSyncLocationObjectStorage => { /* ... */ },
///     ResourceType::DataSyncLocationS3 => { /* ... */ },
///     ResourceType::DataSyncLocationSmb => { /* ... */ },
///     ResourceType::DataSyncTask => { /* ... */ },
///     ResourceType::DetectiveGraph => { /* ... */ },
///     ResourceType::DeviceFarmInstanceProfile => { /* ... */ },
///     ResourceType::DeviceFarmProject => { /* ... */ },
///     ResourceType::DeviceFarmTestGridProject => { /* ... */ },
///     ResourceType::Table => { /* ... */ },
///     ResourceType::Ec2CapacityReservation => { /* ... */ },
///     ResourceType::Ec2CarrierGateway => { /* ... */ },
///     ResourceType::Ec2ClientVpnEndpoint => { /* ... */ },
///     ResourceType::CustomerGateway => { /* ... */ },
///     ResourceType::Ec2DhcpOptions => { /* ... */ },
///     ResourceType::Ec2Ec2Fleet => { /* ... */ },
///     ResourceType::Eip => { /* ... */ },
///     ResourceType::EgressOnlyInternetGateway => { /* ... */ },
///     ResourceType::FlowLog => { /* ... */ },
///     ResourceType::Host => { /* ... */ },
///     ResourceType::Ec2Ipam => { /* ... */ },
///     ResourceType::Ec2IpamPool => { /* ... */ },
///     ResourceType::Ec2IpamScope => { /* ... */ },
///     ResourceType::Instance => { /* ... */ },
///     ResourceType::InternetGateway => { /* ... */ },
///     ResourceType::LaunchTemplate => { /* ... */ },
///     ResourceType::NatGateway => { /* ... */ },
///     ResourceType::NetworkAcl => { /* ... */ },
///     ResourceType::Ec2NetworkInsightsAccessScope => { /* ... */ },
///     ResourceType::NetworkInsightsAccessScopeAnalysis => { /* ... */ },
///     ResourceType::Ec2NetworkInsightsAnalysis => { /* ... */ },
///     ResourceType::Ec2NetworkInsightsPath => { /* ... */ },
///     ResourceType::NetworkInterface => { /* ... */ },
///     ResourceType::Ec2PrefixList => { /* ... */ },
///     ResourceType::RegisteredHaInstance => { /* ... */ },
///     ResourceType::RouteTable => { /* ... */ },
///     ResourceType::SecurityGroup => { /* ... */ },
///     ResourceType::Ec2SpotFleet => { /* ... */ },
///     ResourceType::Subnet => { /* ... */ },
///     ResourceType::Ec2SubnetRouteTableAssociation => { /* ... */ },
///     ResourceType::Ec2TrafficMirrorFilter => { /* ... */ },
///     ResourceType::Ec2TrafficMirrorSession => { /* ... */ },
///     ResourceType::Ec2TrafficMirrorTarget => { /* ... */ },
///     ResourceType::TransitGateway => { /* ... */ },
///     ResourceType::TransitGatewayAttachment => { /* ... */ },
///     ResourceType::Ec2TransitGatewayConnect => { /* ... */ },
///     ResourceType::Ec2TransitGatewayMulticastDomain => { /* ... */ },
///     ResourceType::TransitGatewayRouteTable => { /* ... */ },
///     ResourceType::Vpc => { /* ... */ },
///     ResourceType::VpcEndpoint => { /* ... */ },
///     ResourceType::VpcEndpointService => { /* ... */ },
///     ResourceType::VpcPeeringConnection => { /* ... */ },
///     ResourceType::VpnConnection => { /* ... */ },
///     ResourceType::VpnGateway => { /* ... */ },
///     ResourceType::Volume => { /* ... */ },
///     ResourceType::EcrPublicRepository => { /* ... */ },
///     ResourceType::EcrPullThroughCacheRule => { /* ... */ },
///     ResourceType::EcrRegistryPolicy => { /* ... */ },
///     ResourceType::EcrRepository => { /* ... */ },
///     ResourceType::EcsCapacityProvider => { /* ... */ },
///     ResourceType::EcsCluster => { /* ... */ },
///     ResourceType::EcsService => { /* ... */ },
///     ResourceType::EcsTaskDefinition => { /* ... */ },
///     ResourceType::EcsTaskSet => { /* ... */ },
///     ResourceType::EfsAccessPoint => { /* ... */ },
///     ResourceType::EfsFileSystem => { /* ... */ },
///     ResourceType::EksAddon => { /* ... */ },
///     ResourceType::EksCluster => { /* ... */ },
///     ResourceType::EksFargateProfile => { /* ... */ },
///     ResourceType::EksIdentityProviderConfig => { /* ... */ },
///     ResourceType::EmrSecurityConfiguration => { /* ... */ },
///     ResourceType::Application => { /* ... */ },
///     ResourceType::ApplicationVersion => { /* ... */ },
///     ResourceType::Environment => { /* ... */ },
///     ResourceType::LoadBalancer => { /* ... */ },
///     ResourceType::ListenerV2 => { /* ... */ },
///     ResourceType::LoadBalancerV2 => { /* ... */ },
///     ResourceType::Domain => { /* ... */ },
///     ResourceType::EventSchemasDiscoverer => { /* ... */ },
///     ResourceType::EventSchemasRegistry => { /* ... */ },
///     ResourceType::EventSchemasRegistryPolicy => { /* ... */ },
///     ResourceType::EventSchemasSchema => { /* ... */ },
///     ResourceType::EventsApiDestination => { /* ... */ },
///     ResourceType::EventsArchive => { /* ... */ },
///     ResourceType::EventsConnection => { /* ... */ },
///     ResourceType::EventsEndpoint => { /* ... */ },
///     ResourceType::EventsEventBus => { /* ... */ },
///     ResourceType::EventsRule => { /* ... */ },
///     ResourceType::EvidentlyLaunch => { /* ... */ },
///     ResourceType::EvidentlyProject => { /* ... */ },
///     ResourceType::FisExperimentTemplate => { /* ... */ },
///     ResourceType::ForecastDataset => { /* ... */ },
///     ResourceType::ForecastDatasetGroup => { /* ... */ },
///     ResourceType::FraudDetectorEntityType => { /* ... */ },
///     ResourceType::FraudDetectorLabel => { /* ... */ },
///     ResourceType::FraudDetectorOutcome => { /* ... */ },
///     ResourceType::FraudDetectorVariable => { /* ... */ },
///     ResourceType::GlobalAcceleratorAccelerator => { /* ... */ },
///     ResourceType::GlobalAcceleratorEndpointGroup => { /* ... */ },
///     ResourceType::GlobalAcceleratorListener => { /* ... */ },
///     ResourceType::GlueClassifier => { /* ... */ },
///     ResourceType::GlueJob => { /* ... */ },
///     ResourceType::GlueMlTransform => { /* ... */ },
///     ResourceType::GrafanaWorkspace => { /* ... */ },
///     ResourceType::GreengrassV2ComponentVersion => { /* ... */ },
///     ResourceType::GroundStationConfig => { /* ... */ },
///     ResourceType::GroundStationDataflowEndpointGroup => { /* ... */ },
///     ResourceType::GroundStationMissionProfile => { /* ... */ },
///     ResourceType::GuardDutyDetector => { /* ... */ },
///     ResourceType::GuardDutyFilter => { /* ... */ },
///     ResourceType::GuardDutyIpSet => { /* ... */ },
///     ResourceType::GuardDutyThreatIntelSet => { /* ... */ },
///     ResourceType::HealthLakeFhirDatastore => { /* ... */ },
///     ResourceType::Group => { /* ... */ },
///     ResourceType::IamInstanceProfile => { /* ... */ },
///     ResourceType::Policy => { /* ... */ },
///     ResourceType::Role => { /* ... */ },
///     ResourceType::IamsamlProvider => { /* ... */ },
///     ResourceType::IamServerCertificate => { /* ... */ },
///     ResourceType::User => { /* ... */ },
///     ResourceType::IvsChannel => { /* ... */ },
///     ResourceType::IvsPlaybackKeyPair => { /* ... */ },
///     ResourceType::IvsRecordingConfiguration => { /* ... */ },
///     ResourceType::ImageBuilderContainerRecipe => { /* ... */ },
///     ResourceType::ImageBuilderDistributionConfiguration => { /* ... */ },
///     ResourceType::ImageBuilderImagePipeline => { /* ... */ },
///     ResourceType::ImageBuilderImageRecipe => { /* ... */ },
///     ResourceType::ImageBuilderInfrastructureConfiguration => { /* ... */ },
///     ResourceType::InspectorV2Filter => { /* ... */ },
///     ResourceType::IoTAccountAuditConfiguration => { /* ... */ },
///     ResourceType::IoTAuthorizer => { /* ... */ },
///     ResourceType::IoTcaCertificate => { /* ... */ },
///     ResourceType::IoTCustomMetric => { /* ... */ },
///     ResourceType::IoTDimension => { /* ... */ },
///     ResourceType::IoTFleetMetric => { /* ... */ },
///     ResourceType::IoTJobTemplate => { /* ... */ },
///     ResourceType::IoTMitigationAction => { /* ... */ },
///     ResourceType::IoTPolicy => { /* ... */ },
///     ResourceType::IoTProvisioningTemplate => { /* ... */ },
///     ResourceType::IoTRoleAlias => { /* ... */ },
///     ResourceType::IoTScheduledAudit => { /* ... */ },
///     ResourceType::IoTSecurityProfile => { /* ... */ },
///     ResourceType::IoTAnalyticsChannel => { /* ... */ },
///     ResourceType::IoTAnalyticsDataset => { /* ... */ },
///     ResourceType::IoTAnalyticsDatastore => { /* ... */ },
///     ResourceType::IoTAnalyticsPipeline => { /* ... */ },
///     ResourceType::IoTEventsAlarmModel => { /* ... */ },
///     ResourceType::IoTEventsDetectorModel => { /* ... */ },
///     ResourceType::IoTEventsInput => { /* ... */ },
///     ResourceType::IoTSiteWiseAssetModel => { /* ... */ },
///     ResourceType::IoTSiteWiseDashboard => { /* ... */ },
///     ResourceType::IoTSiteWiseGateway => { /* ... */ },
///     ResourceType::IoTSiteWisePortal => { /* ... */ },
///     ResourceType::IoTSiteWiseProject => { /* ... */ },
///     ResourceType::IoTTwinMakerComponentType => { /* ... */ },
///     ResourceType::IoTTwinMakerEntity => { /* ... */ },
///     ResourceType::IoTTwinMakerScene => { /* ... */ },
///     ResourceType::IoTTwinMakerSyncJob => { /* ... */ },
///     ResourceType::IoTTwinMakerWorkspace => { /* ... */ },
///     ResourceType::IoTWirelessFuotaTask => { /* ... */ },
///     ResourceType::IoTWirelessMulticastGroup => { /* ... */ },
///     ResourceType::IoTWirelessServiceProfile => { /* ... */ },
///     ResourceType::KmsAlias => { /* ... */ },
///     ResourceType::Key => { /* ... */ },
///     ResourceType::KafkaConnectConnector => { /* ... */ },
///     ResourceType::KendraIndex => { /* ... */ },
///     ResourceType::KinesisStream => { /* ... */ },
///     ResourceType::KinesisStreamConsumer => { /* ... */ },
///     ResourceType::KinesisAnalyticsV2Application => { /* ... */ },
///     ResourceType::KinesisFirehoseDeliveryStream => { /* ... */ },
///     ResourceType::KinesisVideoSignalingChannel => { /* ... */ },
///     ResourceType::KinesisVideoStream => { /* ... */ },
///     ResourceType::LambdaCodeSigningConfig => { /* ... */ },
///     ResourceType::Function => { /* ... */ },
///     ResourceType::LexBot => { /* ... */ },
///     ResourceType::LexBotAlias => { /* ... */ },
///     ResourceType::LightsailBucket => { /* ... */ },
///     ResourceType::LightsailCertificate => { /* ... */ },
///     ResourceType::LightsailDisk => { /* ... */ },
///     ResourceType::LightsailStaticIp => { /* ... */ },
///     ResourceType::LogsDestination => { /* ... */ },
///     ResourceType::LookoutMetricsAlert => { /* ... */ },
///     ResourceType::LookoutVisionProject => { /* ... */ },
///     ResourceType::M2Environment => { /* ... */ },
///     ResourceType::MskBatchScramSecret => { /* ... */ },
///     ResourceType::MskCluster => { /* ... */ },
///     ResourceType::MskConfiguration => { /* ... */ },
///     ResourceType::MediaConnectFlowEntitlement => { /* ... */ },
///     ResourceType::MediaConnectFlowSource => { /* ... */ },
///     ResourceType::MediaConnectFlowVpcInterface => { /* ... */ },
///     ResourceType::MediaPackagePackagingConfiguration => { /* ... */ },
///     ResourceType::MediaPackagePackagingGroup => { /* ... */ },
///     ResourceType::MediaTailorPlaybackConfiguration => { /* ... */ },
///     ResourceType::NetworkFirewallFirewall => { /* ... */ },
///     ResourceType::NetworkFirewallFirewallPolicy => { /* ... */ },
///     ResourceType::NetworkFirewallRuleGroup => { /* ... */ },
///     ResourceType::NetworkManagerConnectPeer => { /* ... */ },
///     ResourceType::NetworkManagerCustomerGatewayAssociation => { /* ... */ },
///     ResourceType::NetworkManagerDevice => { /* ... */ },
///     ResourceType::NetworkManagerGlobalNetwork => { /* ... */ },
///     ResourceType::NetworkManagerLink => { /* ... */ },
///     ResourceType::NetworkManagerLinkAssociation => { /* ... */ },
///     ResourceType::NetworkManagerSite => { /* ... */ },
///     ResourceType::NetworkManagerTransitGatewayRegistration => { /* ... */ },
///     ResourceType::OpenSearchDomain => { /* ... */ },
///     ResourceType::PanoramaPackage => { /* ... */ },
///     ResourceType::PersonalizeDataset => { /* ... */ },
///     ResourceType::PersonalizeDatasetGroup => { /* ... */ },
///     ResourceType::PersonalizeSchema => { /* ... */ },
///     ResourceType::PersonalizeSolution => { /* ... */ },
///     ResourceType::PinpointApp => { /* ... */ },
///     ResourceType::PinpointApplicationSettings => { /* ... */ },
///     ResourceType::PinpointCampaign => { /* ... */ },
///     ResourceType::PinpointEmailChannel => { /* ... */ },
///     ResourceType::PinpointEmailTemplate => { /* ... */ },
///     ResourceType::PinpointEventStream => { /* ... */ },
///     ResourceType::PinpointInAppTemplate => { /* ... */ },
///     ResourceType::PinpointSegment => { /* ... */ },
///     ResourceType::QldbLedger => { /* ... */ },
///     ResourceType::QuickSightDataSource => { /* ... */ },
///     ResourceType::QuickSightTemplate => { /* ... */ },
///     ResourceType::QuickSightTheme => { /* ... */ },
///     ResourceType::DbCluster => { /* ... */ },
///     ResourceType::DbClusterSnapshot => { /* ... */ },
///     ResourceType::DbInstance => { /* ... */ },
///     ResourceType::DbSecurityGroup => { /* ... */ },
///     ResourceType::DbSnapshot => { /* ... */ },
///     ResourceType::DbSubnetGroup => { /* ... */ },
///     ResourceType::EventSubscription => { /* ... */ },
///     ResourceType::RdsGlobalCluster => { /* ... */ },
///     ResourceType::RdsOptionGroup => { /* ... */ },
///     ResourceType::RumAppMonitor => { /* ... */ },
///     ResourceType::Cluster => { /* ... */ },
///     ResourceType::ClusterParameterGroup => { /* ... */ },
///     ResourceType::ClusterSecurityGroup => { /* ... */ },
///     ResourceType::ClusterSnapshot => { /* ... */ },
///     ResourceType::ClusterSubnetGroup => { /* ... */ },
///     ResourceType::RedshiftEndpointAccess => { /* ... */ },
///     ResourceType::RedshiftEventSubscription => { /* ... */ },
///     ResourceType::RedshiftScheduledAction => { /* ... */ },
///     ResourceType::ResilienceHubApp => { /* ... */ },
///     ResourceType::ResilienceHubResiliencyPolicy => { /* ... */ },
///     ResourceType::ResourceExplorer2Index => { /* ... */ },
///     ResourceType::RoboMakerRobotApplication => { /* ... */ },
///     ResourceType::RoboMakerRobotApplicationVersion => { /* ... */ },
///     ResourceType::RoboMakerSimulationApplication => { /* ... */ },
///     ResourceType::Route53HostedZone => { /* ... */ },
///     ResourceType::Route53RecoveryControlCluster => { /* ... */ },
///     ResourceType::Route53RecoveryControlControlPanel => { /* ... */ },
///     ResourceType::Route53RecoveryControlRoutingControl => { /* ... */ },
///     ResourceType::Route53RecoveryControlSafetyRule => { /* ... */ },
///     ResourceType::Route53RecoveryReadinessCell => { /* ... */ },
///     ResourceType::Route53RecoveryReadinessReadinessCheck => { /* ... */ },
///     ResourceType::Route53RecoveryReadinessRecoveryGroup => { /* ... */ },
///     ResourceType::Route53RecoveryReadinessResourceSet => { /* ... */ },
///     ResourceType::Route53ResolverFirewallDomainList => { /* ... */ },
///     ResourceType::Route53ResolverFirewallRuleGroup => { /* ... */ },
///     ResourceType::Route53ResolverFirewallRuleGroupAssociation => { /* ... */ },
///     ResourceType::Route53ResolverResolverEndpoint => { /* ... */ },
///     ResourceType::Route53ResolverResolverQueryLoggingConfig => { /* ... */ },
///     ResourceType::Route53ResolverResolverQueryLoggingConfigAssociation => { /* ... */ },
///     ResourceType::Route53ResolverResolverRule => { /* ... */ },
///     ResourceType::Route53ResolverResolverRuleAssociation => { /* ... */ },
///     ResourceType::S3AccessPoint => { /* ... */ },
///     ResourceType::AccountPublicAccessBlock => { /* ... */ },
///     ResourceType::Bucket => { /* ... */ },
///     ResourceType::S3MultiRegionAccessPoint => { /* ... */ },
///     ResourceType::S3StorageLens => { /* ... */ },
///     ResourceType::SesConfigurationSet => { /* ... */ },
///     ResourceType::SesContactList => { /* ... */ },
///     ResourceType::SesReceiptFilter => { /* ... */ },
///     ResourceType::SesReceiptRuleSet => { /* ... */ },
///     ResourceType::SesTemplate => { /* ... */ },
///     ResourceType::Topic => { /* ... */ },
///     ResourceType::Queue => { /* ... */ },
///     ResourceType::AssociationCompliance => { /* ... */ },
///     ResourceType::SsmDocument => { /* ... */ },
///     ResourceType::FileData => { /* ... */ },
///     ResourceType::ManagedInstanceInventory => { /* ... */ },
///     ResourceType::PatchCompliance => { /* ... */ },
///     ResourceType::SageMakerAppImageConfig => { /* ... */ },
///     ResourceType::SageMakerCodeRepository => { /* ... */ },
///     ResourceType::SageMakerDomain => { /* ... */ },
///     ResourceType::SageMakerFeatureGroup => { /* ... */ },
///     ResourceType::SageMakerImage => { /* ... */ },
///     ResourceType::SageMakerModel => { /* ... */ },
///     ResourceType::SageMakerNotebookInstanceLifecycleConfig => { /* ... */ },
///     ResourceType::SageMakerWorkteam => { /* ... */ },
///     ResourceType::Secret => { /* ... */ },
///     ResourceType::CloudFormationProduct => { /* ... */ },
///     ResourceType::CloudFormationProvisionedProduct => { /* ... */ },
///     ResourceType::Portfolio => { /* ... */ },
///     ResourceType::ServiceDiscoveryHttpNamespace => { /* ... */ },
///     ResourceType::ServiceDiscoveryInstance => { /* ... */ },
///     ResourceType::ServiceDiscoveryPublicDnsNamespace => { /* ... */ },
///     ResourceType::ServiceDiscoveryService => { /* ... */ },
///     ResourceType::Protection => { /* ... */ },
///     ResourceType::RegionalProtection => { /* ... */ },
///     ResourceType::SignerSigningProfile => { /* ... */ },
///     ResourceType::StepFunctionsActivity => { /* ... */ },
///     ResourceType::StepFunctionsStateMachine => { /* ... */ },
///     ResourceType::TransferAgreement => { /* ... */ },
///     ResourceType::TransferCertificate => { /* ... */ },
///     ResourceType::TransferConnector => { /* ... */ },
///     ResourceType::TransferWorkflow => { /* ... */ },
///     ResourceType::RateBasedRule => { /* ... */ },
///     ResourceType::Rule => { /* ... */ },
///     ResourceType::RuleGroup => { /* ... */ },
///     ResourceType::WebAcl => { /* ... */ },
///     ResourceType::RegionalRateBasedRule => { /* ... */ },
///     ResourceType::RegionalRule => { /* ... */ },
///     ResourceType::RegionalRuleGroup => { /* ... */ },
///     ResourceType::RegionalWebAcl => { /* ... */ },
///     ResourceType::IpSetV2 => { /* ... */ },
///     ResourceType::ManagedRuleSetV2 => { /* ... */ },
///     ResourceType::RegexPatternSetV2 => { /* ... */ },
///     ResourceType::RuleGroupV2 => { /* ... */ },
///     ResourceType::WebAclv2 => { /* ... */ },
///     ResourceType::WorkSpacesConnectionAlias => { /* ... */ },
///     ResourceType::WorkSpacesWorkspace => { /* ... */ },
///     ResourceType::EncryptionConfig => { /* ... */ },
///     other @ _ if other.as_str() == "NewFeature" => { /* handles a case for `NewFeature` */ },
///     _ => { /* ... */ },
/// }
/// ```
/// The above code demonstrates that when `resourcetype` represents
/// `NewFeature`, the execution path will lead to the second last match arm,
/// even though the enum does not contain a variant `ResourceType::NewFeature`
/// in the current version of SDK. The reason is that the variable `other`,
/// created by the `@` operator, is bound to
/// `ResourceType::Unknown(UnknownVariantValue("NewFeature".to_owned()))`
/// and calling `as_str` on it yields `"NewFeature"`.
/// This match expression is forward-compatible when executed with a newer
/// version of SDK where the variant `ResourceType::NewFeature` is defined.
/// Specifically, when `resourcetype` represents `NewFeature`,
/// the execution path will hit the second last match arm as before by virtue of
/// calling `as_str` on `ResourceType::NewFeature` also yielding `"NewFeature"`.
///
/// Explicitly matching on the `Unknown` variant should
/// be avoided for two reasons:
/// - The inner data `UnknownVariantValue` is opaque, and no further information can be extracted.
/// - It might inadvertently shadow other intended match arms.
///
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    ::std::clone::Clone, ::std::cmp::Eq, ::std::cmp::Ord, ::std::cmp::PartialEq, ::std::cmp::PartialOrd, ::std::fmt::Debug, ::std::hash::Hash,
)]
pub enum ResourceType {
    #[allow(missing_docs)] // documentation missing in model
    Certificate,
    #[allow(missing_docs)] // documentation missing in model
    AcmpcaCertificateAuthority,
    #[allow(missing_docs)] // documentation missing in model
    AcmpcaCertificateAuthorityActivation,
    #[allow(missing_docs)] // documentation missing in model
    ApsRuleGroupsNamespace,
    #[allow(missing_docs)] // documentation missing in model
    AccessAnalyzerAnalyzer,
    #[allow(missing_docs)] // documentation missing in model
    AmazonMqBroker,
    #[allow(missing_docs)] // documentation missing in model
    AmplifyApp,
    #[allow(missing_docs)] // documentation missing in model
    AmplifyBranch,
    #[allow(missing_docs)] // documentation missing in model
    RestApi,
    #[allow(missing_docs)] // documentation missing in model
    Stage,
    #[allow(missing_docs)] // documentation missing in model
    Api,
    #[allow(missing_docs)] // documentation missing in model
    StageV2,
    #[allow(missing_docs)] // documentation missing in model
    AppConfigApplication,
    #[allow(missing_docs)] // documentation missing in model
    AppConfigConfigurationProfile,
    #[allow(missing_docs)] // documentation missing in model
    AppConfigDeploymentStrategy,
    #[allow(missing_docs)] // documentation missing in model
    AppConfigEnvironment,
    #[allow(missing_docs)] // documentation missing in model
    AppConfigHostedConfigurationVersion,
    #[allow(missing_docs)] // documentation missing in model
    AppFlowFlow,
    #[allow(missing_docs)] // documentation missing in model
    AppIntegrationsEventIntegration,
    #[allow(missing_docs)] // documentation missing in model
    AppMeshGatewayRoute,
    #[allow(missing_docs)] // documentation missing in model
    AppMeshMesh,
    #[allow(missing_docs)] // documentation missing in model
    AppMeshRoute,
    #[allow(missing_docs)] // documentation missing in model
    AppMeshVirtualGateway,
    #[allow(missing_docs)] // documentation missing in model
    AppMeshVirtualNode,
    #[allow(missing_docs)] // documentation missing in model
    AppMeshVirtualRouter,
    #[allow(missing_docs)] // documentation missing in model
    AppMeshVirtualService,
    #[allow(missing_docs)] // documentation missing in model
    AppRunnerService,
    #[allow(missing_docs)] // documentation missing in model
    AppRunnerVpcConnector,
    #[allow(missing_docs)] // documentation missing in model
    AppStreamApplication,
    #[allow(missing_docs)] // documentation missing in model
    AppStreamDirectoryConfig,
    #[allow(missing_docs)] // documentation missing in model
    AppStreamFleet,
    #[allow(missing_docs)] // documentation missing in model
    AppStreamStack,
    #[allow(missing_docs)] // documentation missing in model
    AppSyncGraphQlApi,
    #[allow(missing_docs)] // documentation missing in model
    AthenaDataCatalog,
    #[allow(missing_docs)] // documentation missing in model
    AthenaPreparedStatement,
    #[allow(missing_docs)] // documentation missing in model
    AthenaWorkGroup,
    #[allow(missing_docs)] // documentation missing in model
    AuditManagerAssessment,
    #[allow(missing_docs)] // documentation missing in model
    AutoScalingGroup,
    #[allow(missing_docs)] // documentation missing in model
    LaunchConfiguration,
    #[allow(missing_docs)] // documentation missing in model
    ScalingPolicy,
    #[allow(missing_docs)] // documentation missing in model
    ScheduledAction,
    #[allow(missing_docs)] // documentation missing in model
    AutoScalingWarmPool,
    #[allow(missing_docs)] // documentation missing in model
    BackupPlan,
    #[allow(missing_docs)] // documentation missing in model
    BackupSelection,
    #[allow(missing_docs)] // documentation missing in model
    BackupVault,
    #[allow(missing_docs)] // documentation missing in model
    BackupRecoveryPoint,
    #[allow(missing_docs)] // documentation missing in model
    BackupReportPlan,
    #[allow(missing_docs)] // documentation missing in model
    BatchComputeEnvironment,
    #[allow(missing_docs)] // documentation missing in model
    BatchJobQueue,
    #[allow(missing_docs)] // documentation missing in model
    BatchSchedulingPolicy,
    #[allow(missing_docs)] // documentation missing in model
    BudgetsBudgetsAction,
    #[allow(missing_docs)] // documentation missing in model
    CassandraKeyspace,
    #[allow(missing_docs)] // documentation missing in model
    Cloud9EnvironmentEc2,
    #[allow(missing_docs)] // documentation missing in model
    Stack,
    #[allow(missing_docs)] // documentation missing in model
    Distribution,
    #[allow(missing_docs)] // documentation missing in model
    StreamingDistribution,
    #[allow(missing_docs)] // documentation missing in model
    Trail,
    #[allow(missing_docs)] // documentation missing in model
    Alarm,
    #[allow(missing_docs)] // documentation missing in model
    CloudWatchMetricStream,
    #[allow(missing_docs)] // documentation missing in model
    CodeArtifactRepository,
    #[allow(missing_docs)] // documentation missing in model
    Project,
    #[allow(missing_docs)] // documentation missing in model
    CodeBuildReportGroup,
    #[allow(missing_docs)] // documentation missing in model
    CodeDeployApplication,
    #[allow(missing_docs)] // documentation missing in model
    CodeDeployDeploymentConfig,
    #[allow(missing_docs)] // documentation missing in model
    CodeDeployDeploymentGroup,
    #[allow(missing_docs)] // documentation missing in model
    CodeGuruProfilerProfilingGroup,
    #[allow(missing_docs)] // documentation missing in model
    CodeGuruReviewerRepositoryAssociation,
    #[allow(missing_docs)] // documentation missing in model
    Pipeline,
    #[allow(missing_docs)] // documentation missing in model
    CognitoUserPool,
    #[allow(missing_docs)] // documentation missing in model
    CognitoUserPoolClient,
    #[allow(missing_docs)] // documentation missing in model
    CognitoUserPoolGroup,
    #[allow(missing_docs)] // documentation missing in model
    ConformancePackCompliance,
    #[allow(missing_docs)] // documentation missing in model
    ResourceCompliance,
    #[allow(missing_docs)] // documentation missing in model
    ConnectInstance,
    #[allow(missing_docs)] // documentation missing in model
    ConnectPhoneNumber,
    #[allow(missing_docs)] // documentation missing in model
    ConnectQuickConnect,
    #[allow(missing_docs)] // documentation missing in model
    CustomerProfilesDomain,
    #[allow(missing_docs)] // documentation missing in model
    CustomerProfilesObjectType,
    #[allow(missing_docs)] // documentation missing in model
    DmsCertificate,
    #[allow(missing_docs)] // documentation missing in model
    DmsEndpoint,
    #[allow(missing_docs)] // documentation missing in model
    DmsEventSubscription,
    #[allow(missing_docs)] // documentation missing in model
    DmsReplicationSubnetGroup,
    #[allow(missing_docs)] // documentation missing in model
    DataSyncLocationEfs,
    #[allow(missing_docs)] // documentation missing in model
    DataSyncLocationFSxLustre,
    #[allow(missing_docs)] // documentation missing in model
    DataSyncLocationFSxWindows,
    #[allow(missing_docs)] // documentation missing in model
    DataSyncLocationHdfs,
    #[allow(missing_docs)] // documentation missing in model
    DataSyncLocationNfs,
    #[allow(missing_docs)] // documentation missing in model
    DataSyncLocationObjectStorage,
    #[allow(missing_docs)] // documentation missing in model
    DataSyncLocationS3,
    #[allow(missing_docs)] // documentation missing in model
    DataSyncLocationSmb,
    #[allow(missing_docs)] // documentation missing in model
    DataSyncTask,
    #[allow(missing_docs)] // documentation missing in model
    DetectiveGraph,
    #[allow(missing_docs)] // documentation missing in model
    DeviceFarmInstanceProfile,
    #[allow(missing_docs)] // documentation missing in model
    DeviceFarmProject,
    #[allow(missing_docs)] // documentation missing in model
    DeviceFarmTestGridProject,
    #[allow(missing_docs)] // documentation missing in model
    Table,
    #[allow(missing_docs)] // documentation missing in model
    Ec2CapacityReservation,
    #[allow(missing_docs)] // documentation missing in model
    Ec2CarrierGateway,
    #[allow(missing_docs)] // documentation missing in model
    Ec2ClientVpnEndpoint,
    #[allow(missing_docs)] // documentation missing in model
    CustomerGateway,
    #[allow(missing_docs)] // documentation missing in model
    Ec2DhcpOptions,
    #[allow(missing_docs)] // documentation missing in model
    Ec2Ec2Fleet,
    #[allow(missing_docs)] // documentation missing in model
    Eip,
    #[allow(missing_docs)] // documentation missing in model
    EgressOnlyInternetGateway,
    #[allow(missing_docs)] // documentation missing in model
    FlowLog,
    #[allow(missing_docs)] // documentation missing in model
    Host,
    #[allow(missing_docs)] // documentation missing in model
    Ec2Ipam,
    #[allow(missing_docs)] // documentation missing in model
    Ec2IpamPool,
    #[allow(missing_docs)] // documentation missing in model
    Ec2IpamScope,
    #[allow(missing_docs)] // documentation missing in model
    Instance,
    #[allow(missing_docs)] // documentation missing in model
    InternetGateway,
    #[allow(missing_docs)] // documentation missing in model
    LaunchTemplate,
    #[allow(missing_docs)] // documentation missing in model
    NatGateway,
    #[allow(missing_docs)] // documentation missing in model
    NetworkAcl,
    #[allow(missing_docs)] // documentation missing in model
    Ec2NetworkInsightsAccessScope,
    #[allow(missing_docs)] // documentation missing in model
    NetworkInsightsAccessScopeAnalysis,
    #[allow(missing_docs)] // documentation missing in model
    Ec2NetworkInsightsAnalysis,
    #[allow(missing_docs)] // documentation missing in model
    Ec2NetworkInsightsPath,
    #[allow(missing_docs)] // documentation missing in model
    NetworkInterface,
    #[allow(missing_docs)] // documentation missing in model
    Ec2PrefixList,
    #[allow(missing_docs)] // documentation missing in model
    RegisteredHaInstance,
    #[allow(missing_docs)] // documentation missing in model
    RouteTable,
    #[allow(missing_docs)] // documentation missing in model
    SecurityGroup,
    #[allow(missing_docs)] // documentation missing in model
    Ec2SpotFleet,
    #[allow(missing_docs)] // documentation missing in model
    Subnet,
    #[allow(missing_docs)] // documentation missing in model
    Ec2SubnetRouteTableAssociation,
    #[allow(missing_docs)] // documentation missing in model
    Ec2TrafficMirrorFilter,
    #[allow(missing_docs)] // documentation missing in model
    Ec2TrafficMirrorSession,
    #[allow(missing_docs)] // documentation missing in model
    Ec2TrafficMirrorTarget,
    #[allow(missing_docs)] // documentation missing in model
    TransitGateway,
    #[allow(missing_docs)] // documentation missing in model
    TransitGatewayAttachment,
    #[allow(missing_docs)] // documentation missing in model
    Ec2TransitGatewayConnect,
    #[allow(missing_docs)] // documentation missing in model
    Ec2TransitGatewayMulticastDomain,
    #[allow(missing_docs)] // documentation missing in model
    TransitGatewayRouteTable,
    #[allow(missing_docs)] // documentation missing in model
    Vpc,
    #[allow(missing_docs)] // documentation missing in model
    VpcEndpoint,
    #[allow(missing_docs)] // documentation missing in model
    VpcEndpointService,
    #[allow(missing_docs)] // documentation missing in model
    VpcPeeringConnection,
    #[allow(missing_docs)] // documentation missing in model
    VpnConnection,
    #[allow(missing_docs)] // documentation missing in model
    VpnGateway,
    #[allow(missing_docs)] // documentation missing in model
    Volume,
    #[allow(missing_docs)] // documentation missing in model
    EcrPublicRepository,
    #[allow(missing_docs)] // documentation missing in model
    EcrPullThroughCacheRule,
    #[allow(missing_docs)] // documentation missing in model
    EcrRegistryPolicy,
    #[allow(missing_docs)] // documentation missing in model
    EcrRepository,
    #[allow(missing_docs)] // documentation missing in model
    EcsCapacityProvider,
    #[allow(missing_docs)] // documentation missing in model
    EcsCluster,
    #[allow(missing_docs)] // documentation missing in model
    EcsService,
    #[allow(missing_docs)] // documentation missing in model
    EcsTaskDefinition,
    #[allow(missing_docs)] // documentation missing in model
    EcsTaskSet,
    #[allow(missing_docs)] // documentation missing in model
    EfsAccessPoint,
    #[allow(missing_docs)] // documentation missing in model
    EfsFileSystem,
    #[allow(missing_docs)] // documentation missing in model
    EksAddon,
    #[allow(missing_docs)] // documentation missing in model
    EksCluster,
    #[allow(missing_docs)] // documentation missing in model
    EksFargateProfile,
    #[allow(missing_docs)] // documentation missing in model
    EksIdentityProviderConfig,
    #[allow(missing_docs)] // documentation missing in model
    EmrSecurityConfiguration,
    #[allow(missing_docs)] // documentation missing in model
    Application,
    #[allow(missing_docs)] // documentation missing in model
    ApplicationVersion,
    #[allow(missing_docs)] // documentation missing in model
    Environment,
    #[allow(missing_docs)] // documentation missing in model
    LoadBalancer,
    #[allow(missing_docs)] // documentation missing in model
    ListenerV2,
    #[allow(missing_docs)] // documentation missing in model
    LoadBalancerV2,
    #[allow(missing_docs)] // documentation missing in model
    Domain,
    #[allow(missing_docs)] // documentation missing in model
    EventSchemasDiscoverer,
    #[allow(missing_docs)] // documentation missing in model
    EventSchemasRegistry,
    #[allow(missing_docs)] // documentation missing in model
    EventSchemasRegistryPolicy,
    #[allow(missing_docs)] // documentation missing in model
    EventSchemasSchema,
    #[allow(missing_docs)] // documentation missing in model
    EventsApiDestination,
    #[allow(missing_docs)] // documentation missing in model
    EventsArchive,
    #[allow(missing_docs)] // documentation missing in model
    EventsConnection,
    #[allow(missing_docs)] // documentation missing in model
    EventsEndpoint,
    #[allow(missing_docs)] // documentation missing in model
    EventsEventBus,
    #[allow(missing_docs)] // documentation missing in model
    EventsRule,
    #[allow(missing_docs)] // documentation missing in model
    EvidentlyLaunch,
    #[allow(missing_docs)] // documentation missing in model
    EvidentlyProject,
    #[allow(missing_docs)] // documentation missing in model
    FisExperimentTemplate,
    #[allow(missing_docs)] // documentation missing in model
    ForecastDataset,
    #[allow(missing_docs)] // documentation missing in model
    ForecastDatasetGroup,
    #[allow(missing_docs)] // documentation missing in model
    FraudDetectorEntityType,
    #[allow(missing_docs)] // documentation missing in model
    FraudDetectorLabel,
    #[allow(missing_docs)] // documentation missing in model
    FraudDetectorOutcome,
    #[allow(missing_docs)] // documentation missing in model
    FraudDetectorVariable,
    #[allow(missing_docs)] // documentation missing in model
    GlobalAcceleratorAccelerator,
    #[allow(missing_docs)] // documentation missing in model
    GlobalAcceleratorEndpointGroup,
    #[allow(missing_docs)] // documentation missing in model
    GlobalAcceleratorListener,
    #[allow(missing_docs)] // documentation missing in model
    GlueClassifier,
    #[allow(missing_docs)] // documentation missing in model
    GlueJob,
    #[allow(missing_docs)] // documentation missing in model
    GlueMlTransform,
    #[allow(missing_docs)] // documentation missing in model
    GrafanaWorkspace,
    #[allow(missing_docs)] // documentation missing in model
    GreengrassV2ComponentVersion,
    #[allow(missing_docs)] // documentation missing in model
    GroundStationConfig,
    #[allow(missing_docs)] // documentation missing in model
    GroundStationDataflowEndpointGroup,
    #[allow(missing_docs)] // documentation missing in model
    GroundStationMissionProfile,
    #[allow(missing_docs)] // documentation missing in model
    GuardDutyDetector,
    #[allow(missing_docs)] // documentation missing in model
    GuardDutyFilter,
    #[allow(missing_docs)] // documentation missing in model
    GuardDutyIpSet,
    #[allow(missing_docs)] // documentation missing in model
    GuardDutyThreatIntelSet,
    #[allow(missing_docs)] // documentation missing in model
    HealthLakeFhirDatastore,
    #[allow(missing_docs)] // documentation missing in model
    Group,
    #[allow(missing_docs)] // documentation missing in model
    IamInstanceProfile,
    #[allow(missing_docs)] // documentation missing in model
    Policy,
    #[allow(missing_docs)] // documentation missing in model
    Role,
    #[allow(missing_docs)] // documentation missing in model
    IamsamlProvider,
    #[allow(missing_docs)] // documentation missing in model
    IamServerCertificate,
    #[allow(missing_docs)] // documentation missing in model
    User,
    #[allow(missing_docs)] // documentation missing in model
    IvsChannel,
    #[allow(missing_docs)] // documentation missing in model
    IvsPlaybackKeyPair,
    #[allow(missing_docs)] // documentation missing in model
    IvsRecordingConfiguration,
    #[allow(missing_docs)] // documentation missing in model
    ImageBuilderContainerRecipe,
    #[allow(missing_docs)] // documentation missing in model
    ImageBuilderDistributionConfiguration,
    #[allow(missing_docs)] // documentation missing in model
    ImageBuilderImagePipeline,
    #[allow(missing_docs)] // documentation missing in model
    ImageBuilderImageRecipe,
    #[allow(missing_docs)] // documentation missing in model
    ImageBuilderInfrastructureConfiguration,
    #[allow(missing_docs)] // documentation missing in model
    InspectorV2Filter,
    #[allow(missing_docs)] // documentation missing in model
    IoTAccountAuditConfiguration,
    #[allow(missing_docs)] // documentation missing in model
    IoTAuthorizer,
    #[allow(missing_docs)] // documentation missing in model
    IoTcaCertificate,
    #[allow(missing_docs)] // documentation missing in model
    IoTCustomMetric,
    #[allow(missing_docs)] // documentation missing in model
    IoTDimension,
    #[allow(missing_docs)] // documentation missing in model
    IoTFleetMetric,
    #[allow(missing_docs)] // documentation missing in model
    IoTJobTemplate,
    #[allow(missing_docs)] // documentation missing in model
    IoTMitigationAction,
    #[allow(missing_docs)] // documentation missing in model
    IoTPolicy,
    #[allow(missing_docs)] // documentation missing in model
    IoTProvisioningTemplate,
    #[allow(missing_docs)] // documentation missing in model
    IoTRoleAlias,
    #[allow(missing_docs)] // documentation missing in model
    IoTScheduledAudit,
    #[allow(missing_docs)] // documentation missing in model
    IoTSecurityProfile,
    #[allow(missing_docs)] // documentation missing in model
    IoTAnalyticsChannel,
    #[allow(missing_docs)] // documentation missing in model
    IoTAnalyticsDataset,
    #[allow(missing_docs)] // documentation missing in model
    IoTAnalyticsDatastore,
    #[allow(missing_docs)] // documentation missing in model
    IoTAnalyticsPipeline,
    #[allow(missing_docs)] // documentation missing in model
    IoTEventsAlarmModel,
    #[allow(missing_docs)] // documentation missing in model
    IoTEventsDetectorModel,
    #[allow(missing_docs)] // documentation missing in model
    IoTEventsInput,
    #[allow(missing_docs)] // documentation missing in model
    IoTSiteWiseAssetModel,
    #[allow(missing_docs)] // documentation missing in model
    IoTSiteWiseDashboard,
    #[allow(missing_docs)] // documentation missing in model
    IoTSiteWiseGateway,
    #[allow(missing_docs)] // documentation missing in model
    IoTSiteWisePortal,
    #[allow(missing_docs)] // documentation missing in model
    IoTSiteWiseProject,
    #[allow(missing_docs)] // documentation missing in model
    IoTTwinMakerComponentType,
    #[allow(missing_docs)] // documentation missing in model
    IoTTwinMakerEntity,
    #[allow(missing_docs)] // documentation missing in model
    IoTTwinMakerScene,
    #[allow(missing_docs)] // documentation missing in model
    IoTTwinMakerSyncJob,
    #[allow(missing_docs)] // documentation missing in model
    IoTTwinMakerWorkspace,
    #[allow(missing_docs)] // documentation missing in model
    IoTWirelessFuotaTask,
    #[allow(missing_docs)] // documentation missing in model
    IoTWirelessMulticastGroup,
    #[allow(missing_docs)] // documentation missing in model
    IoTWirelessServiceProfile,
    #[allow(missing_docs)] // documentation missing in model
    KmsAlias,
    #[allow(missing_docs)] // documentation missing in model
    Key,
    #[allow(missing_docs)] // documentation missing in model
    KafkaConnectConnector,
    #[allow(missing_docs)] // documentation missing in model
    KendraIndex,
    #[allow(missing_docs)] // documentation missing in model
    KinesisStream,
    #[allow(missing_docs)] // documentation missing in model
    KinesisStreamConsumer,
    #[allow(missing_docs)] // documentation missing in model
    KinesisAnalyticsV2Application,
    #[allow(missing_docs)] // documentation missing in model
    KinesisFirehoseDeliveryStream,
    #[allow(missing_docs)] // documentation missing in model
    KinesisVideoSignalingChannel,
    #[allow(missing_docs)] // documentation missing in model
    KinesisVideoStream,
    #[allow(missing_docs)] // documentation missing in model
    LambdaCodeSigningConfig,
    #[allow(missing_docs)] // documentation missing in model
    Function,
    #[allow(missing_docs)] // documentation missing in model
    LexBot,
    #[allow(missing_docs)] // documentation missing in model
    LexBotAlias,
    #[allow(missing_docs)] // documentation missing in model
    LightsailBucket,
    #[allow(missing_docs)] // documentation missing in model
    LightsailCertificate,
    #[allow(missing_docs)] // documentation missing in model
    LightsailDisk,
    #[allow(missing_docs)] // documentation missing in model
    LightsailStaticIp,
    #[allow(missing_docs)] // documentation missing in model
    LogsDestination,
    #[allow(missing_docs)] // documentation missing in model
    LookoutMetricsAlert,
    #[allow(missing_docs)] // documentation missing in model
    LookoutVisionProject,
    #[allow(missing_docs)] // documentation missing in model
    M2Environment,
    #[allow(missing_docs)] // documentation missing in model
    MskBatchScramSecret,
    #[allow(missing_docs)] // documentation missing in model
    MskCluster,
    #[allow(missing_docs)] // documentation missing in model
    MskConfiguration,
    #[allow(missing_docs)] // documentation missing in model
    MediaConnectFlowEntitlement,
    #[allow(missing_docs)] // documentation missing in model
    MediaConnectFlowSource,
    #[allow(missing_docs)] // documentation missing in model
    MediaConnectFlowVpcInterface,
    #[allow(missing_docs)] // documentation missing in model
    MediaPackagePackagingConfiguration,
    #[allow(missing_docs)] // documentation missing in model
    MediaPackagePackagingGroup,
    #[allow(missing_docs)] // documentation missing in model
    MediaTailorPlaybackConfiguration,
    #[allow(missing_docs)] // documentation missing in model
    NetworkFirewallFirewall,
    #[allow(missing_docs)] // documentation missing in model
    NetworkFirewallFirewallPolicy,
    #[allow(missing_docs)] // documentation missing in model
    NetworkFirewallRuleGroup,
    #[allow(missing_docs)] // documentation missing in model
    NetworkManagerConnectPeer,
    #[allow(missing_docs)] // documentation missing in model
    NetworkManagerCustomerGatewayAssociation,
    #[allow(missing_docs)] // documentation missing in model
    NetworkManagerDevice,
    #[allow(missing_docs)] // documentation missing in model
    NetworkManagerGlobalNetwork,
    #[allow(missing_docs)] // documentation missing in model
    NetworkManagerLink,
    #[allow(missing_docs)] // documentation missing in model
    NetworkManagerLinkAssociation,
    #[allow(missing_docs)] // documentation missing in model
    NetworkManagerSite,
    #[allow(missing_docs)] // documentation missing in model
    NetworkManagerTransitGatewayRegistration,
    #[allow(missing_docs)] // documentation missing in model
    OpenSearchDomain,
    #[allow(missing_docs)] // documentation missing in model
    PanoramaPackage,
    #[allow(missing_docs)] // documentation missing in model
    PersonalizeDataset,
    #[allow(missing_docs)] // documentation missing in model
    PersonalizeDatasetGroup,
    #[allow(missing_docs)] // documentation missing in model
    PersonalizeSchema,
    #[allow(missing_docs)] // documentation missing in model
    PersonalizeSolution,
    #[allow(missing_docs)] // documentation missing in model
    PinpointApp,
    #[allow(missing_docs)] // documentation missing in model
    PinpointApplicationSettings,
    #[allow(missing_docs)] // documentation missing in model
    PinpointCampaign,
    #[allow(missing_docs)] // documentation missing in model
    PinpointEmailChannel,
    #[allow(missing_docs)] // documentation missing in model
    PinpointEmailTemplate,
    #[allow(missing_docs)] // documentation missing in model
    PinpointEventStream,
    #[allow(missing_docs)] // documentation missing in model
    PinpointInAppTemplate,
    #[allow(missing_docs)] // documentation missing in model
    PinpointSegment,
    #[allow(missing_docs)] // documentation missing in model
    QldbLedger,
    #[allow(missing_docs)] // documentation missing in model
    QuickSightDataSource,
    #[allow(missing_docs)] // documentation missing in model
    QuickSightTemplate,
    #[allow(missing_docs)] // documentation missing in model
    QuickSightTheme,
    #[allow(missing_docs)] // documentation missing in model
    DbCluster,
    #[allow(missing_docs)] // documentation missing in model
    DbClusterSnapshot,
    #[allow(missing_docs)] // documentation missing in model
    DbInstance,
    #[allow(missing_docs)] // documentation missing in model
    DbSecurityGroup,
    #[allow(missing_docs)] // documentation missing in model
    DbSnapshot,
    #[allow(missing_docs)] // documentation missing in model
    DbSubnetGroup,
    #[allow(missing_docs)] // documentation missing in model
    EventSubscription,
    #[allow(missing_docs)] // documentation missing in model
    RdsGlobalCluster,
    #[allow(missing_docs)] // documentation missing in model
    RdsOptionGroup,
    #[allow(missing_docs)] // documentation missing in model
    RumAppMonitor,
    #[allow(missing_docs)] // documentation missing in model
    Cluster,
    #[allow(missing_docs)] // documentation missing in model
    ClusterParameterGroup,
    #[allow(missing_docs)] // documentation missing in model
    ClusterSecurityGroup,
    #[allow(missing_docs)] // documentation missing in model
    ClusterSnapshot,
    #[allow(missing_docs)] // documentation missing in model
    ClusterSubnetGroup,
    #[allow(missing_docs)] // documentation missing in model
    RedshiftEndpointAccess,
    #[allow(missing_docs)] // documentation missing in model
    RedshiftEventSubscription,
    #[allow(missing_docs)] // documentation missing in model
    RedshiftScheduledAction,
    #[allow(missing_docs)] // documentation missing in model
    ResilienceHubApp,
    #[allow(missing_docs)] // documentation missing in model
    ResilienceHubResiliencyPolicy,
    #[allow(missing_docs)] // documentation missing in model
    ResourceExplorer2Index,
    #[allow(missing_docs)] // documentation missing in model
    RoboMakerRobotApplication,
    #[allow(missing_docs)] // documentation missing in model
    RoboMakerRobotApplicationVersion,
    #[allow(missing_docs)] // documentation missing in model
    RoboMakerSimulationApplication,
    #[allow(missing_docs)] // documentation missing in model
    Route53HostedZone,
    #[allow(missing_docs)] // documentation missing in model
    Route53RecoveryControlCluster,
    #[allow(missing_docs)] // documentation missing in model
    Route53RecoveryControlControlPanel,
    #[allow(missing_docs)] // documentation missing in model
    Route53RecoveryControlRoutingControl,
    #[allow(missing_docs)] // documentation missing in model
    Route53RecoveryControlSafetyRule,
    #[allow(missing_docs)] // documentation missing in model
    Route53RecoveryReadinessCell,
    #[allow(missing_docs)] // documentation missing in model
    Route53RecoveryReadinessReadinessCheck,
    #[allow(missing_docs)] // documentation missing in model
    Route53RecoveryReadinessRecoveryGroup,
    #[allow(missing_docs)] // documentation missing in model
    Route53RecoveryReadinessResourceSet,
    #[allow(missing_docs)] // documentation missing in model
    Route53ResolverFirewallDomainList,
    #[allow(missing_docs)] // documentation missing in model
    Route53ResolverFirewallRuleGroup,
    #[allow(missing_docs)] // documentation missing in model
    Route53ResolverFirewallRuleGroupAssociation,
    #[allow(missing_docs)] // documentation missing in model
    Route53ResolverResolverEndpoint,
    #[allow(missing_docs)] // documentation missing in model
    Route53ResolverResolverQueryLoggingConfig,
    #[allow(missing_docs)] // documentation missing in model
    Route53ResolverResolverQueryLoggingConfigAssociation,
    #[allow(missing_docs)] // documentation missing in model
    Route53ResolverResolverRule,
    #[allow(missing_docs)] // documentation missing in model
    Route53ResolverResolverRuleAssociation,
    #[allow(missing_docs)] // documentation missing in model
    S3AccessPoint,
    #[allow(missing_docs)] // documentation missing in model
    AccountPublicAccessBlock,
    #[allow(missing_docs)] // documentation missing in model
    Bucket,
    #[allow(missing_docs)] // documentation missing in model
    S3MultiRegionAccessPoint,
    #[allow(missing_docs)] // documentation missing in model
    S3StorageLens,
    #[allow(missing_docs)] // documentation missing in model
    SesConfigurationSet,
    #[allow(missing_docs)] // documentation missing in model
    SesContactList,
    #[allow(missing_docs)] // documentation missing in model
    SesReceiptFilter,
    #[allow(missing_docs)] // documentation missing in model
    SesReceiptRuleSet,
    #[allow(missing_docs)] // documentation missing in model
    SesTemplate,
    #[allow(missing_docs)] // documentation missing in model
    Topic,
    #[allow(missing_docs)] // documentation missing in model
    Queue,
    #[allow(missing_docs)] // documentation missing in model
    AssociationCompliance,
    #[allow(missing_docs)] // documentation missing in model
    SsmDocument,
    #[allow(missing_docs)] // documentation missing in model
    FileData,
    #[allow(missing_docs)] // documentation missing in model
    ManagedInstanceInventory,
    #[allow(missing_docs)] // documentation missing in model
    PatchCompliance,
    #[allow(missing_docs)] // documentation missing in model
    SageMakerAppImageConfig,
    #[allow(missing_docs)] // documentation missing in model
    SageMakerCodeRepository,
    #[allow(missing_docs)] // documentation missing in model
    SageMakerDomain,
    #[allow(missing_docs)] // documentation missing in model
    SageMakerFeatureGroup,
    #[allow(missing_docs)] // documentation missing in model
    SageMakerImage,
    #[allow(missing_docs)] // documentation missing in model
    SageMakerModel,
    #[allow(missing_docs)] // documentation missing in model
    SageMakerNotebookInstanceLifecycleConfig,
    #[allow(missing_docs)] // documentation missing in model
    SageMakerWorkteam,
    #[allow(missing_docs)] // documentation missing in model
    Secret,
    #[allow(missing_docs)] // documentation missing in model
    CloudFormationProduct,
    #[allow(missing_docs)] // documentation missing in model
    CloudFormationProvisionedProduct,
    #[allow(missing_docs)] // documentation missing in model
    Portfolio,
    #[allow(missing_docs)] // documentation missing in model
    ServiceDiscoveryHttpNamespace,
    #[allow(missing_docs)] // documentation missing in model
    ServiceDiscoveryInstance,
    #[allow(missing_docs)] // documentation missing in model
    ServiceDiscoveryPublicDnsNamespace,
    #[allow(missing_docs)] // documentation missing in model
    ServiceDiscoveryService,
    #[allow(missing_docs)] // documentation missing in model
    Protection,
    #[allow(missing_docs)] // documentation missing in model
    RegionalProtection,
    #[allow(missing_docs)] // documentation missing in model
    SignerSigningProfile,
    #[allow(missing_docs)] // documentation missing in model
    StepFunctionsActivity,
    #[allow(missing_docs)] // documentation missing in model
    StepFunctionsStateMachine,
    #[allow(missing_docs)] // documentation missing in model
    TransferAgreement,
    #[allow(missing_docs)] // documentation missing in model
    TransferCertificate,
    #[allow(missing_docs)] // documentation missing in model
    TransferConnector,
    #[allow(missing_docs)] // documentation missing in model
    TransferWorkflow,
    #[allow(missing_docs)] // documentation missing in model
    RateBasedRule,
    #[allow(missing_docs)] // documentation missing in model
    Rule,
    #[allow(missing_docs)] // documentation missing in model
    RuleGroup,
    #[allow(missing_docs)] // documentation missing in model
    WebAcl,
    #[allow(missing_docs)] // documentation missing in model
    RegionalRateBasedRule,
    #[allow(missing_docs)] // documentation missing in model
    RegionalRule,
    #[allow(missing_docs)] // documentation missing in model
    RegionalRuleGroup,
    #[allow(missing_docs)] // documentation missing in model
    RegionalWebAcl,
    #[allow(missing_docs)] // documentation missing in model
    IpSetV2,
    #[allow(missing_docs)] // documentation missing in model
    ManagedRuleSetV2,
    #[allow(missing_docs)] // documentation missing in model
    RegexPatternSetV2,
    #[allow(missing_docs)] // documentation missing in model
    RuleGroupV2,
    #[allow(missing_docs)] // documentation missing in model
    WebAclv2,
    #[allow(missing_docs)] // documentation missing in model
    WorkSpacesConnectionAlias,
    #[allow(missing_docs)] // documentation missing in model
    WorkSpacesWorkspace,
    #[allow(missing_docs)] // documentation missing in model
    EncryptionConfig,
    /// `Unknown` contains new variants that have been added since this code was generated.
    #[deprecated(note = "Don't directly match on `Unknown`. See the docs on this enum for the correct way to handle unknown variants.")]
    Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue),
}
impl ::std::convert::From<&str> for ResourceType {
    fn from(s: &str) -> Self {
        match s {
            "AWS::ACM::Certificate" => ResourceType::Certificate,
            "AWS::ACMPCA::CertificateAuthority" => ResourceType::AcmpcaCertificateAuthority,
            "AWS::ACMPCA::CertificateAuthorityActivation" => ResourceType::AcmpcaCertificateAuthorityActivation,
            "AWS::APS::RuleGroupsNamespace" => ResourceType::ApsRuleGroupsNamespace,
            "AWS::AccessAnalyzer::Analyzer" => ResourceType::AccessAnalyzerAnalyzer,
            "AWS::AmazonMQ::Broker" => ResourceType::AmazonMqBroker,
            "AWS::Amplify::App" => ResourceType::AmplifyApp,
            "AWS::Amplify::Branch" => ResourceType::AmplifyBranch,
            "AWS::ApiGateway::RestApi" => ResourceType::RestApi,
            "AWS::ApiGateway::Stage" => ResourceType::Stage,
            "AWS::ApiGatewayV2::Api" => ResourceType::Api,
            "AWS::ApiGatewayV2::Stage" => ResourceType::StageV2,
            "AWS::AppConfig::Application" => ResourceType::AppConfigApplication,
            "AWS::AppConfig::ConfigurationProfile" => ResourceType::AppConfigConfigurationProfile,
            "AWS::AppConfig::DeploymentStrategy" => ResourceType::AppConfigDeploymentStrategy,
            "AWS::AppConfig::Environment" => ResourceType::AppConfigEnvironment,
            "AWS::AppConfig::HostedConfigurationVersion" => ResourceType::AppConfigHostedConfigurationVersion,
            "AWS::AppFlow::Flow" => ResourceType::AppFlowFlow,
            "AWS::AppIntegrations::EventIntegration" => ResourceType::AppIntegrationsEventIntegration,
            "AWS::AppMesh::GatewayRoute" => ResourceType::AppMeshGatewayRoute,
            "AWS::AppMesh::Mesh" => ResourceType::AppMeshMesh,
            "AWS::AppMesh::Route" => ResourceType::AppMeshRoute,
            "AWS::AppMesh::VirtualGateway" => ResourceType::AppMeshVirtualGateway,
            "AWS::AppMesh::VirtualNode" => ResourceType::AppMeshVirtualNode,
            "AWS::AppMesh::VirtualRouter" => ResourceType::AppMeshVirtualRouter,
            "AWS::AppMesh::VirtualService" => ResourceType::AppMeshVirtualService,
            "AWS::AppRunner::Service" => ResourceType::AppRunnerService,
            "AWS::AppRunner::VpcConnector" => ResourceType::AppRunnerVpcConnector,
            "AWS::AppStream::Application" => ResourceType::AppStreamApplication,
            "AWS::AppStream::DirectoryConfig" => ResourceType::AppStreamDirectoryConfig,
            "AWS::AppStream::Fleet" => ResourceType::AppStreamFleet,
            "AWS::AppStream::Stack" => ResourceType::AppStreamStack,
            "AWS::AppSync::GraphQLApi" => ResourceType::AppSyncGraphQlApi,
            "AWS::Athena::DataCatalog" => ResourceType::AthenaDataCatalog,
            "AWS::Athena::PreparedStatement" => ResourceType::AthenaPreparedStatement,
            "AWS::Athena::WorkGroup" => ResourceType::AthenaWorkGroup,
            "AWS::AuditManager::Assessment" => ResourceType::AuditManagerAssessment,
            "AWS::AutoScaling::AutoScalingGroup" => ResourceType::AutoScalingGroup,
            "AWS::AutoScaling::LaunchConfiguration" => ResourceType::LaunchConfiguration,
            "AWS::AutoScaling::ScalingPolicy" => ResourceType::ScalingPolicy,
            "AWS::AutoScaling::ScheduledAction" => ResourceType::ScheduledAction,
            "AWS::AutoScaling::WarmPool" => ResourceType::AutoScalingWarmPool,
            "AWS::Backup::BackupPlan" => ResourceType::BackupPlan,
            "AWS::Backup::BackupSelection" => ResourceType::BackupSelection,
            "AWS::Backup::BackupVault" => ResourceType::BackupVault,
            "AWS::Backup::RecoveryPoint" => ResourceType::BackupRecoveryPoint,
            "AWS::Backup::ReportPlan" => ResourceType::BackupReportPlan,
            "AWS::Batch::ComputeEnvironment" => ResourceType::BatchComputeEnvironment,
            "AWS::Batch::JobQueue" => ResourceType::BatchJobQueue,
            "AWS::Batch::SchedulingPolicy" => ResourceType::BatchSchedulingPolicy,
            "AWS::Budgets::BudgetsAction" => ResourceType::BudgetsBudgetsAction,
            "AWS::Cassandra::Keyspace" => ResourceType::CassandraKeyspace,
            "AWS::Cloud9::EnvironmentEC2" => ResourceType::Cloud9EnvironmentEc2,
            "AWS::CloudFormation::Stack" => ResourceType::Stack,
            "AWS::CloudFront::Distribution" => ResourceType::Distribution,
            "AWS::CloudFront::StreamingDistribution" => ResourceType::StreamingDistribution,
            "AWS::CloudTrail::Trail" => ResourceType::Trail,
            "AWS::CloudWatch::Alarm" => ResourceType::Alarm,
            "AWS::CloudWatch::MetricStream" => ResourceType::CloudWatchMetricStream,
            "AWS::CodeArtifact::Repository" => ResourceType::CodeArtifactRepository,
            "AWS::CodeBuild::Project" => ResourceType::Project,
            "AWS::CodeBuild::ReportGroup" => ResourceType::CodeBuildReportGroup,
            "AWS::CodeDeploy::Application" => ResourceType::CodeDeployApplication,
            "AWS::CodeDeploy::DeploymentConfig" => ResourceType::CodeDeployDeploymentConfig,
            "AWS::CodeDeploy::DeploymentGroup" => ResourceType::CodeDeployDeploymentGroup,
            "AWS::CodeGuruProfiler::ProfilingGroup" => ResourceType::CodeGuruProfilerProfilingGroup,
            "AWS::CodeGuruReviewer::RepositoryAssociation" => ResourceType::CodeGuruReviewerRepositoryAssociation,
            "AWS::CodePipeline::Pipeline" => ResourceType::Pipeline,
            "AWS::Cognito::UserPool" => ResourceType::CognitoUserPool,
            "AWS::Cognito::UserPoolClient" => ResourceType::CognitoUserPoolClient,
            "AWS::Cognito::UserPoolGroup" => ResourceType::CognitoUserPoolGroup,
            "AWS::Config::ConformancePackCompliance" => ResourceType::ConformancePackCompliance,
            "AWS::Config::ResourceCompliance" => ResourceType::ResourceCompliance,
            "AWS::Connect::Instance" => ResourceType::ConnectInstance,
            "AWS::Connect::PhoneNumber" => ResourceType::ConnectPhoneNumber,
            "AWS::Connect::QuickConnect" => ResourceType::ConnectQuickConnect,
            "AWS::CustomerProfiles::Domain" => ResourceType::CustomerProfilesDomain,
            "AWS::CustomerProfiles::ObjectType" => ResourceType::CustomerProfilesObjectType,
            "AWS::DMS::Certificate" => ResourceType::DmsCertificate,
            "AWS::DMS::Endpoint" => ResourceType::DmsEndpoint,
            "AWS::DMS::EventSubscription" => ResourceType::DmsEventSubscription,
            "AWS::DMS::ReplicationSubnetGroup" => ResourceType::DmsReplicationSubnetGroup,
            "AWS::DataSync::LocationEFS" => ResourceType::DataSyncLocationEfs,
            "AWS::DataSync::LocationFSxLustre" => ResourceType::DataSyncLocationFSxLustre,
            "AWS::DataSync::LocationFSxWindows" => ResourceType::DataSyncLocationFSxWindows,
            "AWS::DataSync::LocationHDFS" => ResourceType::DataSyncLocationHdfs,
            "AWS::DataSync::LocationNFS" => ResourceType::DataSyncLocationNfs,
            "AWS::DataSync::LocationObjectStorage" => ResourceType::DataSyncLocationObjectStorage,
            "AWS::DataSync::LocationS3" => ResourceType::DataSyncLocationS3,
            "AWS::DataSync::LocationSMB" => ResourceType::DataSyncLocationSmb,
            "AWS::DataSync::Task" => ResourceType::DataSyncTask,
            "AWS::Detective::Graph" => ResourceType::DetectiveGraph,
            "AWS::DeviceFarm::InstanceProfile" => ResourceType::DeviceFarmInstanceProfile,
            "AWS::DeviceFarm::Project" => ResourceType::DeviceFarmProject,
            "AWS::DeviceFarm::TestGridProject" => ResourceType::DeviceFarmTestGridProject,
            "AWS::DynamoDB::Table" => ResourceType::Table,
            "AWS::EC2::CapacityReservation" => ResourceType::Ec2CapacityReservation,
            "AWS::EC2::CarrierGateway" => ResourceType::Ec2CarrierGateway,
            "AWS::EC2::ClientVpnEndpoint" => ResourceType::Ec2ClientVpnEndpoint,
            "AWS::EC2::CustomerGateway" => ResourceType::CustomerGateway,
            "AWS::EC2::DHCPOptions" => ResourceType::Ec2DhcpOptions,
            "AWS::EC2::EC2Fleet" => ResourceType::Ec2Ec2Fleet,
            "AWS::EC2::EIP" => ResourceType::Eip,
            "AWS::EC2::EgressOnlyInternetGateway" => ResourceType::EgressOnlyInternetGateway,
            "AWS::EC2::FlowLog" => ResourceType::FlowLog,
            "AWS::EC2::Host" => ResourceType::Host,
            "AWS::EC2::IPAM" => ResourceType::Ec2Ipam,
            "AWS::EC2::IPAMPool" => ResourceType::Ec2IpamPool,
            "AWS::EC2::IPAMScope" => ResourceType::Ec2IpamScope,
            "AWS::EC2::Instance" => ResourceType::Instance,
            "AWS::EC2::InternetGateway" => ResourceType::InternetGateway,
            "AWS::EC2::LaunchTemplate" => ResourceType::LaunchTemplate,
            "AWS::EC2::NatGateway" => ResourceType::NatGateway,
            "AWS::EC2::NetworkAcl" => ResourceType::NetworkAcl,
            "AWS::EC2::NetworkInsightsAccessScope" => ResourceType::Ec2NetworkInsightsAccessScope,
            "AWS::EC2::NetworkInsightsAccessScopeAnalysis" => ResourceType::NetworkInsightsAccessScopeAnalysis,
            "AWS::EC2::NetworkInsightsAnalysis" => ResourceType::Ec2NetworkInsightsAnalysis,
            "AWS::EC2::NetworkInsightsPath" => ResourceType::Ec2NetworkInsightsPath,
            "AWS::EC2::NetworkInterface" => ResourceType::NetworkInterface,
            "AWS::EC2::PrefixList" => ResourceType::Ec2PrefixList,
            "AWS::EC2::RegisteredHAInstance" => ResourceType::RegisteredHaInstance,
            "AWS::EC2::RouteTable" => ResourceType::RouteTable,
            "AWS::EC2::SecurityGroup" => ResourceType::SecurityGroup,
            "AWS::EC2::SpotFleet" => ResourceType::Ec2SpotFleet,
            "AWS::EC2::Subnet" => ResourceType::Subnet,
            "AWS::EC2::SubnetRouteTableAssociation" => ResourceType::Ec2SubnetRouteTableAssociation,
            "AWS::EC2::TrafficMirrorFilter" => ResourceType::Ec2TrafficMirrorFilter,
            "AWS::EC2::TrafficMirrorSession" => ResourceType::Ec2TrafficMirrorSession,
            "AWS::EC2::TrafficMirrorTarget" => ResourceType::Ec2TrafficMirrorTarget,
            "AWS::EC2::TransitGateway" => ResourceType::TransitGateway,
            "AWS::EC2::TransitGatewayAttachment" => ResourceType::TransitGatewayAttachment,
            "AWS::EC2::TransitGatewayConnect" => ResourceType::Ec2TransitGatewayConnect,
            "AWS::EC2::TransitGatewayMulticastDomain" => ResourceType::Ec2TransitGatewayMulticastDomain,
            "AWS::EC2::TransitGatewayRouteTable" => ResourceType::TransitGatewayRouteTable,
            "AWS::EC2::VPC" => ResourceType::Vpc,
            "AWS::EC2::VPCEndpoint" => ResourceType::VpcEndpoint,
            "AWS::EC2::VPCEndpointService" => ResourceType::VpcEndpointService,
            "AWS::EC2::VPCPeeringConnection" => ResourceType::VpcPeeringConnection,
            "AWS::EC2::VPNConnection" => ResourceType::VpnConnection,
            "AWS::EC2::VPNGateway" => ResourceType::VpnGateway,
            "AWS::EC2::Volume" => ResourceType::Volume,
            "AWS::ECR::PublicRepository" => ResourceType::EcrPublicRepository,
            "AWS::ECR::PullThroughCacheRule" => ResourceType::EcrPullThroughCacheRule,
            "AWS::ECR::RegistryPolicy" => ResourceType::EcrRegistryPolicy,
            "AWS::ECR::Repository" => ResourceType::EcrRepository,
            "AWS::ECS::CapacityProvider" => ResourceType::EcsCapacityProvider,
            "AWS::ECS::Cluster" => ResourceType::EcsCluster,
            "AWS::ECS::Service" => ResourceType::EcsService,
            "AWS::ECS::TaskDefinition" => ResourceType::EcsTaskDefinition,
            "AWS::ECS::TaskSet" => ResourceType::EcsTaskSet,
            "AWS::EFS::AccessPoint" => ResourceType::EfsAccessPoint,
            "AWS::EFS::FileSystem" => ResourceType::EfsFileSystem,
            "AWS::EKS::Addon" => ResourceType::EksAddon,
            "AWS::EKS::Cluster" => ResourceType::EksCluster,
            "AWS::EKS::FargateProfile" => ResourceType::EksFargateProfile,
            "AWS::EKS::IdentityProviderConfig" => ResourceType::EksIdentityProviderConfig,
            "AWS::EMR::SecurityConfiguration" => ResourceType::EmrSecurityConfiguration,
            "AWS::ElasticBeanstalk::Application" => ResourceType::Application,
            "AWS::ElasticBeanstalk::ApplicationVersion" => ResourceType::ApplicationVersion,
            "AWS::ElasticBeanstalk::Environment" => ResourceType::Environment,
            "AWS::ElasticLoadBalancing::LoadBalancer" => ResourceType::LoadBalancer,
            "AWS::ElasticLoadBalancingV2::Listener" => ResourceType::ListenerV2,
            "AWS::ElasticLoadBalancingV2::LoadBalancer" => ResourceType::LoadBalancerV2,
            "AWS::Elasticsearch::Domain" => ResourceType::Domain,
            "AWS::EventSchemas::Discoverer" => ResourceType::EventSchemasDiscoverer,
            "AWS::EventSchemas::Registry" => ResourceType::EventSchemasRegistry,
            "AWS::EventSchemas::RegistryPolicy" => ResourceType::EventSchemasRegistryPolicy,
            "AWS::EventSchemas::Schema" => ResourceType::EventSchemasSchema,
            "AWS::Events::ApiDestination" => ResourceType::EventsApiDestination,
            "AWS::Events::Archive" => ResourceType::EventsArchive,
            "AWS::Events::Connection" => ResourceType::EventsConnection,
            "AWS::Events::Endpoint" => ResourceType::EventsEndpoint,
            "AWS::Events::EventBus" => ResourceType::EventsEventBus,
            "AWS::Events::Rule" => ResourceType::EventsRule,
            "AWS::Evidently::Launch" => ResourceType::EvidentlyLaunch,
            "AWS::Evidently::Project" => ResourceType::EvidentlyProject,
            "AWS::FIS::ExperimentTemplate" => ResourceType::FisExperimentTemplate,
            "AWS::Forecast::Dataset" => ResourceType::ForecastDataset,
            "AWS::Forecast::DatasetGroup" => ResourceType::ForecastDatasetGroup,
            "AWS::FraudDetector::EntityType" => ResourceType::FraudDetectorEntityType,
            "AWS::FraudDetector::Label" => ResourceType::FraudDetectorLabel,
            "AWS::FraudDetector::Outcome" => ResourceType::FraudDetectorOutcome,
            "AWS::FraudDetector::Variable" => ResourceType::FraudDetectorVariable,
            "AWS::GlobalAccelerator::Accelerator" => ResourceType::GlobalAcceleratorAccelerator,
            "AWS::GlobalAccelerator::EndpointGroup" => ResourceType::GlobalAcceleratorEndpointGroup,
            "AWS::GlobalAccelerator::Listener" => ResourceType::GlobalAcceleratorListener,
            "AWS::Glue::Classifier" => ResourceType::GlueClassifier,
            "AWS::Glue::Job" => ResourceType::GlueJob,
            "AWS::Glue::MLTransform" => ResourceType::GlueMlTransform,
            "AWS::Grafana::Workspace" => ResourceType::GrafanaWorkspace,
            "AWS::GreengrassV2::ComponentVersion" => ResourceType::GreengrassV2ComponentVersion,
            "AWS::GroundStation::Config" => ResourceType::GroundStationConfig,
            "AWS::GroundStation::DataflowEndpointGroup" => ResourceType::GroundStationDataflowEndpointGroup,
            "AWS::GroundStation::MissionProfile" => ResourceType::GroundStationMissionProfile,
            "AWS::GuardDuty::Detector" => ResourceType::GuardDutyDetector,
            "AWS::GuardDuty::Filter" => ResourceType::GuardDutyFilter,
            "AWS::GuardDuty::IPSet" => ResourceType::GuardDutyIpSet,
            "AWS::GuardDuty::ThreatIntelSet" => ResourceType::GuardDutyThreatIntelSet,
            "AWS::HealthLake::FHIRDatastore" => ResourceType::HealthLakeFhirDatastore,
            "AWS::IAM::Group" => ResourceType::Group,
            "AWS::IAM::InstanceProfile" => ResourceType::IamInstanceProfile,
            "AWS::IAM::Policy" => ResourceType::Policy,
            "AWS::IAM::Role" => ResourceType::Role,
            "AWS::IAM::SAMLProvider" => ResourceType::IamsamlProvider,
            "AWS::IAM::ServerCertificate" => ResourceType::IamServerCertificate,
            "AWS::IAM::User" => ResourceType::User,
            "AWS::IVS::Channel" => ResourceType::IvsChannel,
            "AWS::IVS::PlaybackKeyPair" => ResourceType::IvsPlaybackKeyPair,
            "AWS::IVS::RecordingConfiguration" => ResourceType::IvsRecordingConfiguration,
            "AWS::ImageBuilder::ContainerRecipe" => ResourceType::ImageBuilderContainerRecipe,
            "AWS::ImageBuilder::DistributionConfiguration" => ResourceType::ImageBuilderDistributionConfiguration,
            "AWS::ImageBuilder::ImagePipeline" => ResourceType::ImageBuilderImagePipeline,
            "AWS::ImageBuilder::ImageRecipe" => ResourceType::ImageBuilderImageRecipe,
            "AWS::ImageBuilder::InfrastructureConfiguration" => ResourceType::ImageBuilderInfrastructureConfiguration,
            "AWS::InspectorV2::Filter" => ResourceType::InspectorV2Filter,
            "AWS::IoT::AccountAuditConfiguration" => ResourceType::IoTAccountAuditConfiguration,
            "AWS::IoT::Authorizer" => ResourceType::IoTAuthorizer,
            "AWS::IoT::CACertificate" => ResourceType::IoTcaCertificate,
            "AWS::IoT::CustomMetric" => ResourceType::IoTCustomMetric,
            "AWS::IoT::Dimension" => ResourceType::IoTDimension,
            "AWS::IoT::FleetMetric" => ResourceType::IoTFleetMetric,
            "AWS::IoT::JobTemplate" => ResourceType::IoTJobTemplate,
            "AWS::IoT::MitigationAction" => ResourceType::IoTMitigationAction,
            "AWS::IoT::Policy" => ResourceType::IoTPolicy,
            "AWS::IoT::ProvisioningTemplate" => ResourceType::IoTProvisioningTemplate,
            "AWS::IoT::RoleAlias" => ResourceType::IoTRoleAlias,
            "AWS::IoT::ScheduledAudit" => ResourceType::IoTScheduledAudit,
            "AWS::IoT::SecurityProfile" => ResourceType::IoTSecurityProfile,
            "AWS::IoTAnalytics::Channel" => ResourceType::IoTAnalyticsChannel,
            "AWS::IoTAnalytics::Dataset" => ResourceType::IoTAnalyticsDataset,
            "AWS::IoTAnalytics::Datastore" => ResourceType::IoTAnalyticsDatastore,
            "AWS::IoTAnalytics::Pipeline" => ResourceType::IoTAnalyticsPipeline,
            "AWS::IoTEvents::AlarmModel" => ResourceType::IoTEventsAlarmModel,
            "AWS::IoTEvents::DetectorModel" => ResourceType::IoTEventsDetectorModel,
            "AWS::IoTEvents::Input" => ResourceType::IoTEventsInput,
            "AWS::IoTSiteWise::AssetModel" => ResourceType::IoTSiteWiseAssetModel,
            "AWS::IoTSiteWise::Dashboard" => ResourceType::IoTSiteWiseDashboard,
            "AWS::IoTSiteWise::Gateway" => ResourceType::IoTSiteWiseGateway,
            "AWS::IoTSiteWise::Portal" => ResourceType::IoTSiteWisePortal,
            "AWS::IoTSiteWise::Project" => ResourceType::IoTSiteWiseProject,
            "AWS::IoTTwinMaker::ComponentType" => ResourceType::IoTTwinMakerComponentType,
            "AWS::IoTTwinMaker::Entity" => ResourceType::IoTTwinMakerEntity,
            "AWS::IoTTwinMaker::Scene" => ResourceType::IoTTwinMakerScene,
            "AWS::IoTTwinMaker::SyncJob" => ResourceType::IoTTwinMakerSyncJob,
            "AWS::IoTTwinMaker::Workspace" => ResourceType::IoTTwinMakerWorkspace,
            "AWS::IoTWireless::FuotaTask" => ResourceType::IoTWirelessFuotaTask,
            "AWS::IoTWireless::MulticastGroup" => ResourceType::IoTWirelessMulticastGroup,
            "AWS::IoTWireless::ServiceProfile" => ResourceType::IoTWirelessServiceProfile,
            "AWS::KMS::Alias" => ResourceType::KmsAlias,
            "AWS::KMS::Key" => ResourceType::Key,
            "AWS::KafkaConnect::Connector" => ResourceType::KafkaConnectConnector,
            "AWS::Kendra::Index" => ResourceType::KendraIndex,
            "AWS::Kinesis::Stream" => ResourceType::KinesisStream,
            "AWS::Kinesis::StreamConsumer" => ResourceType::KinesisStreamConsumer,
            "AWS::KinesisAnalyticsV2::Application" => ResourceType::KinesisAnalyticsV2Application,
            "AWS::KinesisFirehose::DeliveryStream" => ResourceType::KinesisFirehoseDeliveryStream,
            "AWS::KinesisVideo::SignalingChannel" => ResourceType::KinesisVideoSignalingChannel,
            "AWS::KinesisVideo::Stream" => ResourceType::KinesisVideoStream,
            "AWS::Lambda::CodeSigningConfig" => ResourceType::LambdaCodeSigningConfig,
            "AWS::Lambda::Function" => ResourceType::Function,
            "AWS::Lex::Bot" => ResourceType::LexBot,
            "AWS::Lex::BotAlias" => ResourceType::LexBotAlias,
            "AWS::Lightsail::Bucket" => ResourceType::LightsailBucket,
            "AWS::Lightsail::Certificate" => ResourceType::LightsailCertificate,
            "AWS::Lightsail::Disk" => ResourceType::LightsailDisk,
            "AWS::Lightsail::StaticIp" => ResourceType::LightsailStaticIp,
            "AWS::Logs::Destination" => ResourceType::LogsDestination,
            "AWS::LookoutMetrics::Alert" => ResourceType::LookoutMetricsAlert,
            "AWS::LookoutVision::Project" => ResourceType::LookoutVisionProject,
            "AWS::M2::Environment" => ResourceType::M2Environment,
            "AWS::MSK::BatchScramSecret" => ResourceType::MskBatchScramSecret,
            "AWS::MSK::Cluster" => ResourceType::MskCluster,
            "AWS::MSK::Configuration" => ResourceType::MskConfiguration,
            "AWS::MediaConnect::FlowEntitlement" => ResourceType::MediaConnectFlowEntitlement,
            "AWS::MediaConnect::FlowSource" => ResourceType::MediaConnectFlowSource,
            "AWS::MediaConnect::FlowVpcInterface" => ResourceType::MediaConnectFlowVpcInterface,
            "AWS::MediaPackage::PackagingConfiguration" => ResourceType::MediaPackagePackagingConfiguration,
            "AWS::MediaPackage::PackagingGroup" => ResourceType::MediaPackagePackagingGroup,
            "AWS::MediaTailor::PlaybackConfiguration" => ResourceType::MediaTailorPlaybackConfiguration,
            "AWS::NetworkFirewall::Firewall" => ResourceType::NetworkFirewallFirewall,
            "AWS::NetworkFirewall::FirewallPolicy" => ResourceType::NetworkFirewallFirewallPolicy,
            "AWS::NetworkFirewall::RuleGroup" => ResourceType::NetworkFirewallRuleGroup,
            "AWS::NetworkManager::ConnectPeer" => ResourceType::NetworkManagerConnectPeer,
            "AWS::NetworkManager::CustomerGatewayAssociation" => ResourceType::NetworkManagerCustomerGatewayAssociation,
            "AWS::NetworkManager::Device" => ResourceType::NetworkManagerDevice,
            "AWS::NetworkManager::GlobalNetwork" => ResourceType::NetworkManagerGlobalNetwork,
            "AWS::NetworkManager::Link" => ResourceType::NetworkManagerLink,
            "AWS::NetworkManager::LinkAssociation" => ResourceType::NetworkManagerLinkAssociation,
            "AWS::NetworkManager::Site" => ResourceType::NetworkManagerSite,
            "AWS::NetworkManager::TransitGatewayRegistration" => ResourceType::NetworkManagerTransitGatewayRegistration,
            "AWS::OpenSearch::Domain" => ResourceType::OpenSearchDomain,
            "AWS::Panorama::Package" => ResourceType::PanoramaPackage,
            "AWS::Personalize::Dataset" => ResourceType::PersonalizeDataset,
            "AWS::Personalize::DatasetGroup" => ResourceType::PersonalizeDatasetGroup,
            "AWS::Personalize::Schema" => ResourceType::PersonalizeSchema,
            "AWS::Personalize::Solution" => ResourceType::PersonalizeSolution,
            "AWS::Pinpoint::App" => ResourceType::PinpointApp,
            "AWS::Pinpoint::ApplicationSettings" => ResourceType::PinpointApplicationSettings,
            "AWS::Pinpoint::Campaign" => ResourceType::PinpointCampaign,
            "AWS::Pinpoint::EmailChannel" => ResourceType::PinpointEmailChannel,
            "AWS::Pinpoint::EmailTemplate" => ResourceType::PinpointEmailTemplate,
            "AWS::Pinpoint::EventStream" => ResourceType::PinpointEventStream,
            "AWS::Pinpoint::InAppTemplate" => ResourceType::PinpointInAppTemplate,
            "AWS::Pinpoint::Segment" => ResourceType::PinpointSegment,
            "AWS::QLDB::Ledger" => ResourceType::QldbLedger,
            "AWS::QuickSight::DataSource" => ResourceType::QuickSightDataSource,
            "AWS::QuickSight::Template" => ResourceType::QuickSightTemplate,
            "AWS::QuickSight::Theme" => ResourceType::QuickSightTheme,
            "AWS::RDS::DBCluster" => ResourceType::DbCluster,
            "AWS::RDS::DBClusterSnapshot" => ResourceType::DbClusterSnapshot,
            "AWS::RDS::DBInstance" => ResourceType::DbInstance,
            "AWS::RDS::DBSecurityGroup" => ResourceType::DbSecurityGroup,
            "AWS::RDS::DBSnapshot" => ResourceType::DbSnapshot,
            "AWS::RDS::DBSubnetGroup" => ResourceType::DbSubnetGroup,
            "AWS::RDS::EventSubscription" => ResourceType::EventSubscription,
            "AWS::RDS::GlobalCluster" => ResourceType::RdsGlobalCluster,
            "AWS::RDS::OptionGroup" => ResourceType::RdsOptionGroup,
            "AWS::RUM::AppMonitor" => ResourceType::RumAppMonitor,
            "AWS::Redshift::Cluster" => ResourceType::Cluster,
            "AWS::Redshift::ClusterParameterGroup" => ResourceType::ClusterParameterGroup,
            "AWS::Redshift::ClusterSecurityGroup" => ResourceType::ClusterSecurityGroup,
            "AWS::Redshift::ClusterSnapshot" => ResourceType::ClusterSnapshot,
            "AWS::Redshift::ClusterSubnetGroup" => ResourceType::ClusterSubnetGroup,
            "AWS::Redshift::EndpointAccess" => ResourceType::RedshiftEndpointAccess,
            "AWS::Redshift::EventSubscription" => ResourceType::RedshiftEventSubscription,
            "AWS::Redshift::ScheduledAction" => ResourceType::RedshiftScheduledAction,
            "AWS::ResilienceHub::App" => ResourceType::ResilienceHubApp,
            "AWS::ResilienceHub::ResiliencyPolicy" => ResourceType::ResilienceHubResiliencyPolicy,
            "AWS::ResourceExplorer2::Index" => ResourceType::ResourceExplorer2Index,
            "AWS::RoboMaker::RobotApplication" => ResourceType::RoboMakerRobotApplication,
            "AWS::RoboMaker::RobotApplicationVersion" => ResourceType::RoboMakerRobotApplicationVersion,
            "AWS::RoboMaker::SimulationApplication" => ResourceType::RoboMakerSimulationApplication,
            "AWS::Route53::HostedZone" => ResourceType::Route53HostedZone,
            "AWS::Route53RecoveryControl::Cluster" => ResourceType::Route53RecoveryControlCluster,
            "AWS::Route53RecoveryControl::ControlPanel" => ResourceType::Route53RecoveryControlControlPanel,
            "AWS::Route53RecoveryControl::RoutingControl" => ResourceType::Route53RecoveryControlRoutingControl,
            "AWS::Route53RecoveryControl::SafetyRule" => ResourceType::Route53RecoveryControlSafetyRule,
            "AWS::Route53RecoveryReadiness::Cell" => ResourceType::Route53RecoveryReadinessCell,
            "AWS::Route53RecoveryReadiness::ReadinessCheck" => ResourceType::Route53RecoveryReadinessReadinessCheck,
            "AWS::Route53RecoveryReadiness::RecoveryGroup" => ResourceType::Route53RecoveryReadinessRecoveryGroup,
            "AWS::Route53RecoveryReadiness::ResourceSet" => ResourceType::Route53RecoveryReadinessResourceSet,
            "AWS::Route53Resolver::FirewallDomainList" => ResourceType::Route53ResolverFirewallDomainList,
            "AWS::Route53Resolver::FirewallRuleGroup" => ResourceType::Route53ResolverFirewallRuleGroup,
            "AWS::Route53Resolver::FirewallRuleGroupAssociation" => ResourceType::Route53ResolverFirewallRuleGroupAssociation,
            "AWS::Route53Resolver::ResolverEndpoint" => ResourceType::Route53ResolverResolverEndpoint,
            "AWS::Route53Resolver::ResolverQueryLoggingConfig" => ResourceType::Route53ResolverResolverQueryLoggingConfig,
            "AWS::Route53Resolver::ResolverQueryLoggingConfigAssociation" => ResourceType::Route53ResolverResolverQueryLoggingConfigAssociation,
            "AWS::Route53Resolver::ResolverRule" => ResourceType::Route53ResolverResolverRule,
            "AWS::Route53Resolver::ResolverRuleAssociation" => ResourceType::Route53ResolverResolverRuleAssociation,
            "AWS::S3::AccessPoint" => ResourceType::S3AccessPoint,
            "AWS::S3::AccountPublicAccessBlock" => ResourceType::AccountPublicAccessBlock,
            "AWS::S3::Bucket" => ResourceType::Bucket,
            "AWS::S3::MultiRegionAccessPoint" => ResourceType::S3MultiRegionAccessPoint,
            "AWS::S3::StorageLens" => ResourceType::S3StorageLens,
            "AWS::SES::ConfigurationSet" => ResourceType::SesConfigurationSet,
            "AWS::SES::ContactList" => ResourceType::SesContactList,
            "AWS::SES::ReceiptFilter" => ResourceType::SesReceiptFilter,
            "AWS::SES::ReceiptRuleSet" => ResourceType::SesReceiptRuleSet,
            "AWS::SES::Template" => ResourceType::SesTemplate,
            "AWS::SNS::Topic" => ResourceType::Topic,
            "AWS::SQS::Queue" => ResourceType::Queue,
            "AWS::SSM::AssociationCompliance" => ResourceType::AssociationCompliance,
            "AWS::SSM::Document" => ResourceType::SsmDocument,
            "AWS::SSM::FileData" => ResourceType::FileData,
            "AWS::SSM::ManagedInstanceInventory" => ResourceType::ManagedInstanceInventory,
            "AWS::SSM::PatchCompliance" => ResourceType::PatchCompliance,
            "AWS::SageMaker::AppImageConfig" => ResourceType::SageMakerAppImageConfig,
            "AWS::SageMaker::CodeRepository" => ResourceType::SageMakerCodeRepository,
            "AWS::SageMaker::Domain" => ResourceType::SageMakerDomain,
            "AWS::SageMaker::FeatureGroup" => ResourceType::SageMakerFeatureGroup,
            "AWS::SageMaker::Image" => ResourceType::SageMakerImage,
            "AWS::SageMaker::Model" => ResourceType::SageMakerModel,
            "AWS::SageMaker::NotebookInstanceLifecycleConfig" => ResourceType::SageMakerNotebookInstanceLifecycleConfig,
            "AWS::SageMaker::Workteam" => ResourceType::SageMakerWorkteam,
            "AWS::SecretsManager::Secret" => ResourceType::Secret,
            "AWS::ServiceCatalog::CloudFormationProduct" => ResourceType::CloudFormationProduct,
            "AWS::ServiceCatalog::CloudFormationProvisionedProduct" => ResourceType::CloudFormationProvisionedProduct,
            "AWS::ServiceCatalog::Portfolio" => ResourceType::Portfolio,
            "AWS::ServiceDiscovery::HttpNamespace" => ResourceType::ServiceDiscoveryHttpNamespace,
            "AWS::ServiceDiscovery::Instance" => ResourceType::ServiceDiscoveryInstance,
            "AWS::ServiceDiscovery::PublicDnsNamespace" => ResourceType::ServiceDiscoveryPublicDnsNamespace,
            "AWS::ServiceDiscovery::Service" => ResourceType::ServiceDiscoveryService,
            "AWS::Shield::Protection" => ResourceType::Protection,
            "AWS::ShieldRegional::Protection" => ResourceType::RegionalProtection,
            "AWS::Signer::SigningProfile" => ResourceType::SignerSigningProfile,
            "AWS::StepFunctions::Activity" => ResourceType::StepFunctionsActivity,
            "AWS::StepFunctions::StateMachine" => ResourceType::StepFunctionsStateMachine,
            "AWS::Transfer::Agreement" => ResourceType::TransferAgreement,
            "AWS::Transfer::Certificate" => ResourceType::TransferCertificate,
            "AWS::Transfer::Connector" => ResourceType::TransferConnector,
            "AWS::Transfer::Workflow" => ResourceType::TransferWorkflow,
            "AWS::WAF::RateBasedRule" => ResourceType::RateBasedRule,
            "AWS::WAF::Rule" => ResourceType::Rule,
            "AWS::WAF::RuleGroup" => ResourceType::RuleGroup,
            "AWS::WAF::WebACL" => ResourceType::WebAcl,
            "AWS::WAFRegional::RateBasedRule" => ResourceType::RegionalRateBasedRule,
            "AWS::WAFRegional::Rule" => ResourceType::RegionalRule,
            "AWS::WAFRegional::RuleGroup" => ResourceType::RegionalRuleGroup,
            "AWS::WAFRegional::WebACL" => ResourceType::RegionalWebAcl,
            "AWS::WAFv2::IPSet" => ResourceType::IpSetV2,
            "AWS::WAFv2::ManagedRuleSet" => ResourceType::ManagedRuleSetV2,
            "AWS::WAFv2::RegexPatternSet" => ResourceType::RegexPatternSetV2,
            "AWS::WAFv2::RuleGroup" => ResourceType::RuleGroupV2,
            "AWS::WAFv2::WebACL" => ResourceType::WebAclv2,
            "AWS::WorkSpaces::ConnectionAlias" => ResourceType::WorkSpacesConnectionAlias,
            "AWS::WorkSpaces::Workspace" => ResourceType::WorkSpacesWorkspace,
            "AWS::XRay::EncryptionConfig" => ResourceType::EncryptionConfig,
            other => ResourceType::Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue(other.to_owned())),
        }
    }
}
impl ::std::str::FromStr for ResourceType {
    type Err = ::std::convert::Infallible;

    fn from_str(s: &str) -> ::std::result::Result<Self, <Self as ::std::str::FromStr>::Err> {
        ::std::result::Result::Ok(ResourceType::from(s))
    }
}
impl ResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceType::Certificate => "AWS::ACM::Certificate",
            ResourceType::AcmpcaCertificateAuthority => "AWS::ACMPCA::CertificateAuthority",
            ResourceType::AcmpcaCertificateAuthorityActivation => "AWS::ACMPCA::CertificateAuthorityActivation",
            ResourceType::ApsRuleGroupsNamespace => "AWS::APS::RuleGroupsNamespace",
            ResourceType::AccessAnalyzerAnalyzer => "AWS::AccessAnalyzer::Analyzer",
            ResourceType::AmazonMqBroker => "AWS::AmazonMQ::Broker",
            ResourceType::AmplifyApp => "AWS::Amplify::App",
            ResourceType::AmplifyBranch => "AWS::Amplify::Branch",
            ResourceType::RestApi => "AWS::ApiGateway::RestApi",
            ResourceType::Stage => "AWS::ApiGateway::Stage",
            ResourceType::Api => "AWS::ApiGatewayV2::Api",
            ResourceType::StageV2 => "AWS::ApiGatewayV2::Stage",
            ResourceType::AppConfigApplication => "AWS::AppConfig::Application",
            ResourceType::AppConfigConfigurationProfile => "AWS::AppConfig::ConfigurationProfile",
            ResourceType::AppConfigDeploymentStrategy => "AWS::AppConfig::DeploymentStrategy",
            ResourceType::AppConfigEnvironment => "AWS::AppConfig::Environment",
            ResourceType::AppConfigHostedConfigurationVersion => "AWS::AppConfig::HostedConfigurationVersion",
            ResourceType::AppFlowFlow => "AWS::AppFlow::Flow",
            ResourceType::AppIntegrationsEventIntegration => "AWS::AppIntegrations::EventIntegration",
            ResourceType::AppMeshGatewayRoute => "AWS::AppMesh::GatewayRoute",
            ResourceType::AppMeshMesh => "AWS::AppMesh::Mesh",
            ResourceType::AppMeshRoute => "AWS::AppMesh::Route",
            ResourceType::AppMeshVirtualGateway => "AWS::AppMesh::VirtualGateway",
            ResourceType::AppMeshVirtualNode => "AWS::AppMesh::VirtualNode",
            ResourceType::AppMeshVirtualRouter => "AWS::AppMesh::VirtualRouter",
            ResourceType::AppMeshVirtualService => "AWS::AppMesh::VirtualService",
            ResourceType::AppRunnerService => "AWS::AppRunner::Service",
            ResourceType::AppRunnerVpcConnector => "AWS::AppRunner::VpcConnector",
            ResourceType::AppStreamApplication => "AWS::AppStream::Application",
            ResourceType::AppStreamDirectoryConfig => "AWS::AppStream::DirectoryConfig",
            ResourceType::AppStreamFleet => "AWS::AppStream::Fleet",
            ResourceType::AppStreamStack => "AWS::AppStream::Stack",
            ResourceType::AppSyncGraphQlApi => "AWS::AppSync::GraphQLApi",
            ResourceType::AthenaDataCatalog => "AWS::Athena::DataCatalog",
            ResourceType::AthenaPreparedStatement => "AWS::Athena::PreparedStatement",
            ResourceType::AthenaWorkGroup => "AWS::Athena::WorkGroup",
            ResourceType::AuditManagerAssessment => "AWS::AuditManager::Assessment",
            ResourceType::AutoScalingGroup => "AWS::AutoScaling::AutoScalingGroup",
            ResourceType::LaunchConfiguration => "AWS::AutoScaling::LaunchConfiguration",
            ResourceType::ScalingPolicy => "AWS::AutoScaling::ScalingPolicy",
            ResourceType::ScheduledAction => "AWS::AutoScaling::ScheduledAction",
            ResourceType::AutoScalingWarmPool => "AWS::AutoScaling::WarmPool",
            ResourceType::BackupPlan => "AWS::Backup::BackupPlan",
            ResourceType::BackupSelection => "AWS::Backup::BackupSelection",
            ResourceType::BackupVault => "AWS::Backup::BackupVault",
            ResourceType::BackupRecoveryPoint => "AWS::Backup::RecoveryPoint",
            ResourceType::BackupReportPlan => "AWS::Backup::ReportPlan",
            ResourceType::BatchComputeEnvironment => "AWS::Batch::ComputeEnvironment",
            ResourceType::BatchJobQueue => "AWS::Batch::JobQueue",
            ResourceType::BatchSchedulingPolicy => "AWS::Batch::SchedulingPolicy",
            ResourceType::BudgetsBudgetsAction => "AWS::Budgets::BudgetsAction",
            ResourceType::CassandraKeyspace => "AWS::Cassandra::Keyspace",
            ResourceType::Cloud9EnvironmentEc2 => "AWS::Cloud9::EnvironmentEC2",
            ResourceType::Stack => "AWS::CloudFormation::Stack",
            ResourceType::Distribution => "AWS::CloudFront::Distribution",
            ResourceType::StreamingDistribution => "AWS::CloudFront::StreamingDistribution",
            ResourceType::Trail => "AWS::CloudTrail::Trail",
            ResourceType::Alarm => "AWS::CloudWatch::Alarm",
            ResourceType::CloudWatchMetricStream => "AWS::CloudWatch::MetricStream",
            ResourceType::CodeArtifactRepository => "AWS::CodeArtifact::Repository",
            ResourceType::Project => "AWS::CodeBuild::Project",
            ResourceType::CodeBuildReportGroup => "AWS::CodeBuild::ReportGroup",
            ResourceType::CodeDeployApplication => "AWS::CodeDeploy::Application",
            ResourceType::CodeDeployDeploymentConfig => "AWS::CodeDeploy::DeploymentConfig",
            ResourceType::CodeDeployDeploymentGroup => "AWS::CodeDeploy::DeploymentGroup",
            ResourceType::CodeGuruProfilerProfilingGroup => "AWS::CodeGuruProfiler::ProfilingGroup",
            ResourceType::CodeGuruReviewerRepositoryAssociation => "AWS::CodeGuruReviewer::RepositoryAssociation",
            ResourceType::Pipeline => "AWS::CodePipeline::Pipeline",
            ResourceType::CognitoUserPool => "AWS::Cognito::UserPool",
            ResourceType::CognitoUserPoolClient => "AWS::Cognito::UserPoolClient",
            ResourceType::CognitoUserPoolGroup => "AWS::Cognito::UserPoolGroup",
            ResourceType::ConformancePackCompliance => "AWS::Config::ConformancePackCompliance",
            ResourceType::ResourceCompliance => "AWS::Config::ResourceCompliance",
            ResourceType::ConnectInstance => "AWS::Connect::Instance",
            ResourceType::ConnectPhoneNumber => "AWS::Connect::PhoneNumber",
            ResourceType::ConnectQuickConnect => "AWS::Connect::QuickConnect",
            ResourceType::CustomerProfilesDomain => "AWS::CustomerProfiles::Domain",
            ResourceType::CustomerProfilesObjectType => "AWS::CustomerProfiles::ObjectType",
            ResourceType::DmsCertificate => "AWS::DMS::Certificate",
            ResourceType::DmsEndpoint => "AWS::DMS::Endpoint",
            ResourceType::DmsEventSubscription => "AWS::DMS::EventSubscription",
            ResourceType::DmsReplicationSubnetGroup => "AWS::DMS::ReplicationSubnetGroup",
            ResourceType::DataSyncLocationEfs => "AWS::DataSync::LocationEFS",
            ResourceType::DataSyncLocationFSxLustre => "AWS::DataSync::LocationFSxLustre",
            ResourceType::DataSyncLocationFSxWindows => "AWS::DataSync::LocationFSxWindows",
            ResourceType::DataSyncLocationHdfs => "AWS::DataSync::LocationHDFS",
            ResourceType::DataSyncLocationNfs => "AWS::DataSync::LocationNFS",
            ResourceType::DataSyncLocationObjectStorage => "AWS::DataSync::LocationObjectStorage",
            ResourceType::DataSyncLocationS3 => "AWS::DataSync::LocationS3",
            ResourceType::DataSyncLocationSmb => "AWS::DataSync::LocationSMB",
            ResourceType::DataSyncTask => "AWS::DataSync::Task",
            ResourceType::DetectiveGraph => "AWS::Detective::Graph",
            ResourceType::DeviceFarmInstanceProfile => "AWS::DeviceFarm::InstanceProfile",
            ResourceType::DeviceFarmProject => "AWS::DeviceFarm::Project",
            ResourceType::DeviceFarmTestGridProject => "AWS::DeviceFarm::TestGridProject",
            ResourceType::Table => "AWS::DynamoDB::Table",
            ResourceType::Ec2CapacityReservation => "AWS::EC2::CapacityReservation",
            ResourceType::Ec2CarrierGateway => "AWS::EC2::CarrierGateway",
            ResourceType::Ec2ClientVpnEndpoint => "AWS::EC2::ClientVpnEndpoint",
            ResourceType::CustomerGateway => "AWS::EC2::CustomerGateway",
            ResourceType::Ec2DhcpOptions => "AWS::EC2::DHCPOptions",
            ResourceType::Ec2Ec2Fleet => "AWS::EC2::EC2Fleet",
            ResourceType::Eip => "AWS::EC2::EIP",
            ResourceType::EgressOnlyInternetGateway => "AWS::EC2::EgressOnlyInternetGateway",
            ResourceType::FlowLog => "AWS::EC2::FlowLog",
            ResourceType::Host => "AWS::EC2::Host",
            ResourceType::Ec2Ipam => "AWS::EC2::IPAM",
            ResourceType::Ec2IpamPool => "AWS::EC2::IPAMPool",
            ResourceType::Ec2IpamScope => "AWS::EC2::IPAMScope",
            ResourceType::Instance => "AWS::EC2::Instance",
            ResourceType::InternetGateway => "AWS::EC2::InternetGateway",
            ResourceType::LaunchTemplate => "AWS::EC2::LaunchTemplate",
            ResourceType::NatGateway => "AWS::EC2::NatGateway",
            ResourceType::NetworkAcl => "AWS::EC2::NetworkAcl",
            ResourceType::Ec2NetworkInsightsAccessScope => "AWS::EC2::NetworkInsightsAccessScope",
            ResourceType::NetworkInsightsAccessScopeAnalysis => "AWS::EC2::NetworkInsightsAccessScopeAnalysis",
            ResourceType::Ec2NetworkInsightsAnalysis => "AWS::EC2::NetworkInsightsAnalysis",
            ResourceType::Ec2NetworkInsightsPath => "AWS::EC2::NetworkInsightsPath",
            ResourceType::NetworkInterface => "AWS::EC2::NetworkInterface",
            ResourceType::Ec2PrefixList => "AWS::EC2::PrefixList",
            ResourceType::RegisteredHaInstance => "AWS::EC2::RegisteredHAInstance",
            ResourceType::RouteTable => "AWS::EC2::RouteTable",
            ResourceType::SecurityGroup => "AWS::EC2::SecurityGroup",
            ResourceType::Ec2SpotFleet => "AWS::EC2::SpotFleet",
            ResourceType::Subnet => "AWS::EC2::Subnet",
            ResourceType::Ec2SubnetRouteTableAssociation => "AWS::EC2::SubnetRouteTableAssociation",
            ResourceType::Ec2TrafficMirrorFilter => "AWS::EC2::TrafficMirrorFilter",
            ResourceType::Ec2TrafficMirrorSession => "AWS::EC2::TrafficMirrorSession",
            ResourceType::Ec2TrafficMirrorTarget => "AWS::EC2::TrafficMirrorTarget",
            ResourceType::TransitGateway => "AWS::EC2::TransitGateway",
            ResourceType::TransitGatewayAttachment => "AWS::EC2::TransitGatewayAttachment",
            ResourceType::Ec2TransitGatewayConnect => "AWS::EC2::TransitGatewayConnect",
            ResourceType::Ec2TransitGatewayMulticastDomain => "AWS::EC2::TransitGatewayMulticastDomain",
            ResourceType::TransitGatewayRouteTable => "AWS::EC2::TransitGatewayRouteTable",
            ResourceType::Vpc => "AWS::EC2::VPC",
            ResourceType::VpcEndpoint => "AWS::EC2::VPCEndpoint",
            ResourceType::VpcEndpointService => "AWS::EC2::VPCEndpointService",
            ResourceType::VpcPeeringConnection => "AWS::EC2::VPCPeeringConnection",
            ResourceType::VpnConnection => "AWS::EC2::VPNConnection",
            ResourceType::VpnGateway => "AWS::EC2::VPNGateway",
            ResourceType::Volume => "AWS::EC2::Volume",
            ResourceType::EcrPublicRepository => "AWS::ECR::PublicRepository",
            ResourceType::EcrPullThroughCacheRule => "AWS::ECR::PullThroughCacheRule",
            ResourceType::EcrRegistryPolicy => "AWS::ECR::RegistryPolicy",
            ResourceType::EcrRepository => "AWS::ECR::Repository",
            ResourceType::EcsCapacityProvider => "AWS::ECS::CapacityProvider",
            ResourceType::EcsCluster => "AWS::ECS::Cluster",
            ResourceType::EcsService => "AWS::ECS::Service",
            ResourceType::EcsTaskDefinition => "AWS::ECS::TaskDefinition",
            ResourceType::EcsTaskSet => "AWS::ECS::TaskSet",
            ResourceType::EfsAccessPoint => "AWS::EFS::AccessPoint",
            ResourceType::EfsFileSystem => "AWS::EFS::FileSystem",
            ResourceType::EksAddon => "AWS::EKS::Addon",
            ResourceType::EksCluster => "AWS::EKS::Cluster",
            ResourceType::EksFargateProfile => "AWS::EKS::FargateProfile",
            ResourceType::EksIdentityProviderConfig => "AWS::EKS::IdentityProviderConfig",
            ResourceType::EmrSecurityConfiguration => "AWS::EMR::SecurityConfiguration",
            ResourceType::Application => "AWS::ElasticBeanstalk::Application",
            ResourceType::ApplicationVersion => "AWS::ElasticBeanstalk::ApplicationVersion",
            ResourceType::Environment => "AWS::ElasticBeanstalk::Environment",
            ResourceType::LoadBalancer => "AWS::ElasticLoadBalancing::LoadBalancer",
            ResourceType::ListenerV2 => "AWS::ElasticLoadBalancingV2::Listener",
            ResourceType::LoadBalancerV2 => "AWS::ElasticLoadBalancingV2::LoadBalancer",
            ResourceType::Domain => "AWS::Elasticsearch::Domain",
            ResourceType::EventSchemasDiscoverer => "AWS::EventSchemas::Discoverer",
            ResourceType::EventSchemasRegistry => "AWS::EventSchemas::Registry",
            ResourceType::EventSchemasRegistryPolicy => "AWS::EventSchemas::RegistryPolicy",
            ResourceType::EventSchemasSchema => "AWS::EventSchemas::Schema",
            ResourceType::EventsApiDestination => "AWS::Events::ApiDestination",
            ResourceType::EventsArchive => "AWS::Events::Archive",
            ResourceType::EventsConnection => "AWS::Events::Connection",
            ResourceType::EventsEndpoint => "AWS::Events::Endpoint",
            ResourceType::EventsEventBus => "AWS::Events::EventBus",
            ResourceType::EventsRule => "AWS::Events::Rule",
            ResourceType::EvidentlyLaunch => "AWS::Evidently::Launch",
            ResourceType::EvidentlyProject => "AWS::Evidently::Project",
            ResourceType::FisExperimentTemplate => "AWS::FIS::ExperimentTemplate",
            ResourceType::ForecastDataset => "AWS::Forecast::Dataset",
            ResourceType::ForecastDatasetGroup => "AWS::Forecast::DatasetGroup",
            ResourceType::FraudDetectorEntityType => "AWS::FraudDetector::EntityType",
            ResourceType::FraudDetectorLabel => "AWS::FraudDetector::Label",
            ResourceType::FraudDetectorOutcome => "AWS::FraudDetector::Outcome",
            ResourceType::FraudDetectorVariable => "AWS::FraudDetector::Variable",
            ResourceType::GlobalAcceleratorAccelerator => "AWS::GlobalAccelerator::Accelerator",
            ResourceType::GlobalAcceleratorEndpointGroup => "AWS::GlobalAccelerator::EndpointGroup",
            ResourceType::GlobalAcceleratorListener => "AWS::GlobalAccelerator::Listener",
            ResourceType::GlueClassifier => "AWS::Glue::Classifier",
            ResourceType::GlueJob => "AWS::Glue::Job",
            ResourceType::GlueMlTransform => "AWS::Glue::MLTransform",
            ResourceType::GrafanaWorkspace => "AWS::Grafana::Workspace",
            ResourceType::GreengrassV2ComponentVersion => "AWS::GreengrassV2::ComponentVersion",
            ResourceType::GroundStationConfig => "AWS::GroundStation::Config",
            ResourceType::GroundStationDataflowEndpointGroup => "AWS::GroundStation::DataflowEndpointGroup",
            ResourceType::GroundStationMissionProfile => "AWS::GroundStation::MissionProfile",
            ResourceType::GuardDutyDetector => "AWS::GuardDuty::Detector",
            ResourceType::GuardDutyFilter => "AWS::GuardDuty::Filter",
            ResourceType::GuardDutyIpSet => "AWS::GuardDuty::IPSet",
            ResourceType::GuardDutyThreatIntelSet => "AWS::GuardDuty::ThreatIntelSet",
            ResourceType::HealthLakeFhirDatastore => "AWS::HealthLake::FHIRDatastore",
            ResourceType::Group => "AWS::IAM::Group",
            ResourceType::IamInstanceProfile => "AWS::IAM::InstanceProfile",
            ResourceType::Policy => "AWS::IAM::Policy",
            ResourceType::Role => "AWS::IAM::Role",
            ResourceType::IamsamlProvider => "AWS::IAM::SAMLProvider",
            ResourceType::IamServerCertificate => "AWS::IAM::ServerCertificate",
            ResourceType::User => "AWS::IAM::User",
            ResourceType::IvsChannel => "AWS::IVS::Channel",
            ResourceType::IvsPlaybackKeyPair => "AWS::IVS::PlaybackKeyPair",
            ResourceType::IvsRecordingConfiguration => "AWS::IVS::RecordingConfiguration",
            ResourceType::ImageBuilderContainerRecipe => "AWS::ImageBuilder::ContainerRecipe",
            ResourceType::ImageBuilderDistributionConfiguration => "AWS::ImageBuilder::DistributionConfiguration",
            ResourceType::ImageBuilderImagePipeline => "AWS::ImageBuilder::ImagePipeline",
            ResourceType::ImageBuilderImageRecipe => "AWS::ImageBuilder::ImageRecipe",
            ResourceType::ImageBuilderInfrastructureConfiguration => "AWS::ImageBuilder::InfrastructureConfiguration",
            ResourceType::InspectorV2Filter => "AWS::InspectorV2::Filter",
            ResourceType::IoTAccountAuditConfiguration => "AWS::IoT::AccountAuditConfiguration",
            ResourceType::IoTAuthorizer => "AWS::IoT::Authorizer",
            ResourceType::IoTcaCertificate => "AWS::IoT::CACertificate",
            ResourceType::IoTCustomMetric => "AWS::IoT::CustomMetric",
            ResourceType::IoTDimension => "AWS::IoT::Dimension",
            ResourceType::IoTFleetMetric => "AWS::IoT::FleetMetric",
            ResourceType::IoTJobTemplate => "AWS::IoT::JobTemplate",
            ResourceType::IoTMitigationAction => "AWS::IoT::MitigationAction",
            ResourceType::IoTPolicy => "AWS::IoT::Policy",
            ResourceType::IoTProvisioningTemplate => "AWS::IoT::ProvisioningTemplate",
            ResourceType::IoTRoleAlias => "AWS::IoT::RoleAlias",
            ResourceType::IoTScheduledAudit => "AWS::IoT::ScheduledAudit",
            ResourceType::IoTSecurityProfile => "AWS::IoT::SecurityProfile",
            ResourceType::IoTAnalyticsChannel => "AWS::IoTAnalytics::Channel",
            ResourceType::IoTAnalyticsDataset => "AWS::IoTAnalytics::Dataset",
            ResourceType::IoTAnalyticsDatastore => "AWS::IoTAnalytics::Datastore",
            ResourceType::IoTAnalyticsPipeline => "AWS::IoTAnalytics::Pipeline",
            ResourceType::IoTEventsAlarmModel => "AWS::IoTEvents::AlarmModel",
            ResourceType::IoTEventsDetectorModel => "AWS::IoTEvents::DetectorModel",
            ResourceType::IoTEventsInput => "AWS::IoTEvents::Input",
            ResourceType::IoTSiteWiseAssetModel => "AWS::IoTSiteWise::AssetModel",
            ResourceType::IoTSiteWiseDashboard => "AWS::IoTSiteWise::Dashboard",
            ResourceType::IoTSiteWiseGateway => "AWS::IoTSiteWise::Gateway",
            ResourceType::IoTSiteWisePortal => "AWS::IoTSiteWise::Portal",
            ResourceType::IoTSiteWiseProject => "AWS::IoTSiteWise::Project",
            ResourceType::IoTTwinMakerComponentType => "AWS::IoTTwinMaker::ComponentType",
            ResourceType::IoTTwinMakerEntity => "AWS::IoTTwinMaker::Entity",
            ResourceType::IoTTwinMakerScene => "AWS::IoTTwinMaker::Scene",
            ResourceType::IoTTwinMakerSyncJob => "AWS::IoTTwinMaker::SyncJob",
            ResourceType::IoTTwinMakerWorkspace => "AWS::IoTTwinMaker::Workspace",
            ResourceType::IoTWirelessFuotaTask => "AWS::IoTWireless::FuotaTask",
            ResourceType::IoTWirelessMulticastGroup => "AWS::IoTWireless::MulticastGroup",
            ResourceType::IoTWirelessServiceProfile => "AWS::IoTWireless::ServiceProfile",
            ResourceType::KmsAlias => "AWS::KMS::Alias",
            ResourceType::Key => "AWS::KMS::Key",
            ResourceType::KafkaConnectConnector => "AWS::KafkaConnect::Connector",
            ResourceType::KendraIndex => "AWS::Kendra::Index",
            ResourceType::KinesisStream => "AWS::Kinesis::Stream",
            ResourceType::KinesisStreamConsumer => "AWS::Kinesis::StreamConsumer",
            ResourceType::KinesisAnalyticsV2Application => "AWS::KinesisAnalyticsV2::Application",
            ResourceType::KinesisFirehoseDeliveryStream => "AWS::KinesisFirehose::DeliveryStream",
            ResourceType::KinesisVideoSignalingChannel => "AWS::KinesisVideo::SignalingChannel",
            ResourceType::KinesisVideoStream => "AWS::KinesisVideo::Stream",
            ResourceType::LambdaCodeSigningConfig => "AWS::Lambda::CodeSigningConfig",
            ResourceType::Function => "AWS::Lambda::Function",
            ResourceType::LexBot => "AWS::Lex::Bot",
            ResourceType::LexBotAlias => "AWS::Lex::BotAlias",
            ResourceType::LightsailBucket => "AWS::Lightsail::Bucket",
            ResourceType::LightsailCertificate => "AWS::Lightsail::Certificate",
            ResourceType::LightsailDisk => "AWS::Lightsail::Disk",
            ResourceType::LightsailStaticIp => "AWS::Lightsail::StaticIp",
            ResourceType::LogsDestination => "AWS::Logs::Destination",
            ResourceType::LookoutMetricsAlert => "AWS::LookoutMetrics::Alert",
            ResourceType::LookoutVisionProject => "AWS::LookoutVision::Project",
            ResourceType::M2Environment => "AWS::M2::Environment",
            ResourceType::MskBatchScramSecret => "AWS::MSK::BatchScramSecret",
            ResourceType::MskCluster => "AWS::MSK::Cluster",
            ResourceType::MskConfiguration => "AWS::MSK::Configuration",
            ResourceType::MediaConnectFlowEntitlement => "AWS::MediaConnect::FlowEntitlement",
            ResourceType::MediaConnectFlowSource => "AWS::MediaConnect::FlowSource",
            ResourceType::MediaConnectFlowVpcInterface => "AWS::MediaConnect::FlowVpcInterface",
            ResourceType::MediaPackagePackagingConfiguration => "AWS::MediaPackage::PackagingConfiguration",
            ResourceType::MediaPackagePackagingGroup => "AWS::MediaPackage::PackagingGroup",
            ResourceType::MediaTailorPlaybackConfiguration => "AWS::MediaTailor::PlaybackConfiguration",
            ResourceType::NetworkFirewallFirewall => "AWS::NetworkFirewall::Firewall",
            ResourceType::NetworkFirewallFirewallPolicy => "AWS::NetworkFirewall::FirewallPolicy",
            ResourceType::NetworkFirewallRuleGroup => "AWS::NetworkFirewall::RuleGroup",
            ResourceType::NetworkManagerConnectPeer => "AWS::NetworkManager::ConnectPeer",
            ResourceType::NetworkManagerCustomerGatewayAssociation => "AWS::NetworkManager::CustomerGatewayAssociation",
            ResourceType::NetworkManagerDevice => "AWS::NetworkManager::Device",
            ResourceType::NetworkManagerGlobalNetwork => "AWS::NetworkManager::GlobalNetwork",
            ResourceType::NetworkManagerLink => "AWS::NetworkManager::Link",
            ResourceType::NetworkManagerLinkAssociation => "AWS::NetworkManager::LinkAssociation",
            ResourceType::NetworkManagerSite => "AWS::NetworkManager::Site",
            ResourceType::NetworkManagerTransitGatewayRegistration => "AWS::NetworkManager::TransitGatewayRegistration",
            ResourceType::OpenSearchDomain => "AWS::OpenSearch::Domain",
            ResourceType::PanoramaPackage => "AWS::Panorama::Package",
            ResourceType::PersonalizeDataset => "AWS::Personalize::Dataset",
            ResourceType::PersonalizeDatasetGroup => "AWS::Personalize::DatasetGroup",
            ResourceType::PersonalizeSchema => "AWS::Personalize::Schema",
            ResourceType::PersonalizeSolution => "AWS::Personalize::Solution",
            ResourceType::PinpointApp => "AWS::Pinpoint::App",
            ResourceType::PinpointApplicationSettings => "AWS::Pinpoint::ApplicationSettings",
            ResourceType::PinpointCampaign => "AWS::Pinpoint::Campaign",
            ResourceType::PinpointEmailChannel => "AWS::Pinpoint::EmailChannel",
            ResourceType::PinpointEmailTemplate => "AWS::Pinpoint::EmailTemplate",
            ResourceType::PinpointEventStream => "AWS::Pinpoint::EventStream",
            ResourceType::PinpointInAppTemplate => "AWS::Pinpoint::InAppTemplate",
            ResourceType::PinpointSegment => "AWS::Pinpoint::Segment",
            ResourceType::QldbLedger => "AWS::QLDB::Ledger",
            ResourceType::QuickSightDataSource => "AWS::QuickSight::DataSource",
            ResourceType::QuickSightTemplate => "AWS::QuickSight::Template",
            ResourceType::QuickSightTheme => "AWS::QuickSight::Theme",
            ResourceType::DbCluster => "AWS::RDS::DBCluster",
            ResourceType::DbClusterSnapshot => "AWS::RDS::DBClusterSnapshot",
            ResourceType::DbInstance => "AWS::RDS::DBInstance",
            ResourceType::DbSecurityGroup => "AWS::RDS::DBSecurityGroup",
            ResourceType::DbSnapshot => "AWS::RDS::DBSnapshot",
            ResourceType::DbSubnetGroup => "AWS::RDS::DBSubnetGroup",
            ResourceType::EventSubscription => "AWS::RDS::EventSubscription",
            ResourceType::RdsGlobalCluster => "AWS::RDS::GlobalCluster",
            ResourceType::RdsOptionGroup => "AWS::RDS::OptionGroup",
            ResourceType::RumAppMonitor => "AWS::RUM::AppMonitor",
            ResourceType::Cluster => "AWS::Redshift::Cluster",
            ResourceType::ClusterParameterGroup => "AWS::Redshift::ClusterParameterGroup",
            ResourceType::ClusterSecurityGroup => "AWS::Redshift::ClusterSecurityGroup",
            ResourceType::ClusterSnapshot => "AWS::Redshift::ClusterSnapshot",
            ResourceType::ClusterSubnetGroup => "AWS::Redshift::ClusterSubnetGroup",
            ResourceType::RedshiftEndpointAccess => "AWS::Redshift::EndpointAccess",
            ResourceType::RedshiftEventSubscription => "AWS::Redshift::EventSubscription",
            ResourceType::RedshiftScheduledAction => "AWS::Redshift::ScheduledAction",
            ResourceType::ResilienceHubApp => "AWS::ResilienceHub::App",
            ResourceType::ResilienceHubResiliencyPolicy => "AWS::ResilienceHub::ResiliencyPolicy",
            ResourceType::ResourceExplorer2Index => "AWS::ResourceExplorer2::Index",
            ResourceType::RoboMakerRobotApplication => "AWS::RoboMaker::RobotApplication",
            ResourceType::RoboMakerRobotApplicationVersion => "AWS::RoboMaker::RobotApplicationVersion",
            ResourceType::RoboMakerSimulationApplication => "AWS::RoboMaker::SimulationApplication",
            ResourceType::Route53HostedZone => "AWS::Route53::HostedZone",
            ResourceType::Route53RecoveryControlCluster => "AWS::Route53RecoveryControl::Cluster",
            ResourceType::Route53RecoveryControlControlPanel => "AWS::Route53RecoveryControl::ControlPanel",
            ResourceType::Route53RecoveryControlRoutingControl => "AWS::Route53RecoveryControl::RoutingControl",
            ResourceType::Route53RecoveryControlSafetyRule => "AWS::Route53RecoveryControl::SafetyRule",
            ResourceType::Route53RecoveryReadinessCell => "AWS::Route53RecoveryReadiness::Cell",
            ResourceType::Route53RecoveryReadinessReadinessCheck => "AWS::Route53RecoveryReadiness::ReadinessCheck",
            ResourceType::Route53RecoveryReadinessRecoveryGroup => "AWS::Route53RecoveryReadiness::RecoveryGroup",
            ResourceType::Route53RecoveryReadinessResourceSet => "AWS::Route53RecoveryReadiness::ResourceSet",
            ResourceType::Route53ResolverFirewallDomainList => "AWS::Route53Resolver::FirewallDomainList",
            ResourceType::Route53ResolverFirewallRuleGroup => "AWS::Route53Resolver::FirewallRuleGroup",
            ResourceType::Route53ResolverFirewallRuleGroupAssociation => "AWS::Route53Resolver::FirewallRuleGroupAssociation",
            ResourceType::Route53ResolverResolverEndpoint => "AWS::Route53Resolver::ResolverEndpoint",
            ResourceType::Route53ResolverResolverQueryLoggingConfig => "AWS::Route53Resolver::ResolverQueryLoggingConfig",
            ResourceType::Route53ResolverResolverQueryLoggingConfigAssociation => "AWS::Route53Resolver::ResolverQueryLoggingConfigAssociation",
            ResourceType::Route53ResolverResolverRule => "AWS::Route53Resolver::ResolverRule",
            ResourceType::Route53ResolverResolverRuleAssociation => "AWS::Route53Resolver::ResolverRuleAssociation",
            ResourceType::S3AccessPoint => "AWS::S3::AccessPoint",
            ResourceType::AccountPublicAccessBlock => "AWS::S3::AccountPublicAccessBlock",
            ResourceType::Bucket => "AWS::S3::Bucket",
            ResourceType::S3MultiRegionAccessPoint => "AWS::S3::MultiRegionAccessPoint",
            ResourceType::S3StorageLens => "AWS::S3::StorageLens",
            ResourceType::SesConfigurationSet => "AWS::SES::ConfigurationSet",
            ResourceType::SesContactList => "AWS::SES::ContactList",
            ResourceType::SesReceiptFilter => "AWS::SES::ReceiptFilter",
            ResourceType::SesReceiptRuleSet => "AWS::SES::ReceiptRuleSet",
            ResourceType::SesTemplate => "AWS::SES::Template",
            ResourceType::Topic => "AWS::SNS::Topic",
            ResourceType::Queue => "AWS::SQS::Queue",
            ResourceType::AssociationCompliance => "AWS::SSM::AssociationCompliance",
            ResourceType::SsmDocument => "AWS::SSM::Document",
            ResourceType::FileData => "AWS::SSM::FileData",
            ResourceType::ManagedInstanceInventory => "AWS::SSM::ManagedInstanceInventory",
            ResourceType::PatchCompliance => "AWS::SSM::PatchCompliance",
            ResourceType::SageMakerAppImageConfig => "AWS::SageMaker::AppImageConfig",
            ResourceType::SageMakerCodeRepository => "AWS::SageMaker::CodeRepository",
            ResourceType::SageMakerDomain => "AWS::SageMaker::Domain",
            ResourceType::SageMakerFeatureGroup => "AWS::SageMaker::FeatureGroup",
            ResourceType::SageMakerImage => "AWS::SageMaker::Image",
            ResourceType::SageMakerModel => "AWS::SageMaker::Model",
            ResourceType::SageMakerNotebookInstanceLifecycleConfig => "AWS::SageMaker::NotebookInstanceLifecycleConfig",
            ResourceType::SageMakerWorkteam => "AWS::SageMaker::Workteam",
            ResourceType::Secret => "AWS::SecretsManager::Secret",
            ResourceType::CloudFormationProduct => "AWS::ServiceCatalog::CloudFormationProduct",
            ResourceType::CloudFormationProvisionedProduct => "AWS::ServiceCatalog::CloudFormationProvisionedProduct",
            ResourceType::Portfolio => "AWS::ServiceCatalog::Portfolio",
            ResourceType::ServiceDiscoveryHttpNamespace => "AWS::ServiceDiscovery::HttpNamespace",
            ResourceType::ServiceDiscoveryInstance => "AWS::ServiceDiscovery::Instance",
            ResourceType::ServiceDiscoveryPublicDnsNamespace => "AWS::ServiceDiscovery::PublicDnsNamespace",
            ResourceType::ServiceDiscoveryService => "AWS::ServiceDiscovery::Service",
            ResourceType::Protection => "AWS::Shield::Protection",
            ResourceType::RegionalProtection => "AWS::ShieldRegional::Protection",
            ResourceType::SignerSigningProfile => "AWS::Signer::SigningProfile",
            ResourceType::StepFunctionsActivity => "AWS::StepFunctions::Activity",
            ResourceType::StepFunctionsStateMachine => "AWS::StepFunctions::StateMachine",
            ResourceType::TransferAgreement => "AWS::Transfer::Agreement",
            ResourceType::TransferCertificate => "AWS::Transfer::Certificate",
            ResourceType::TransferConnector => "AWS::Transfer::Connector",
            ResourceType::TransferWorkflow => "AWS::Transfer::Workflow",
            ResourceType::RateBasedRule => "AWS::WAF::RateBasedRule",
            ResourceType::Rule => "AWS::WAF::Rule",
            ResourceType::RuleGroup => "AWS::WAF::RuleGroup",
            ResourceType::WebAcl => "AWS::WAF::WebACL",
            ResourceType::RegionalRateBasedRule => "AWS::WAFRegional::RateBasedRule",
            ResourceType::RegionalRule => "AWS::WAFRegional::Rule",
            ResourceType::RegionalRuleGroup => "AWS::WAFRegional::RuleGroup",
            ResourceType::RegionalWebAcl => "AWS::WAFRegional::WebACL",
            ResourceType::IpSetV2 => "AWS::WAFv2::IPSet",
            ResourceType::ManagedRuleSetV2 => "AWS::WAFv2::ManagedRuleSet",
            ResourceType::RegexPatternSetV2 => "AWS::WAFv2::RegexPatternSet",
            ResourceType::RuleGroupV2 => "AWS::WAFv2::RuleGroup",
            ResourceType::WebAclv2 => "AWS::WAFv2::WebACL",
            ResourceType::WorkSpacesConnectionAlias => "AWS::WorkSpaces::ConnectionAlias",
            ResourceType::WorkSpacesWorkspace => "AWS::WorkSpaces::Workspace",
            ResourceType::EncryptionConfig => "AWS::XRay::EncryptionConfig",
            ResourceType::Unknown(value) => value.as_str(),
        }
    }
    /// Returns all the `&str` representations of the enum members.
    pub const fn values() -> &'static [&'static str] {
        &[
            "AWS::ACM::Certificate",
            "AWS::ACMPCA::CertificateAuthority",
            "AWS::ACMPCA::CertificateAuthorityActivation",
            "AWS::APS::RuleGroupsNamespace",
            "AWS::AccessAnalyzer::Analyzer",
            "AWS::AmazonMQ::Broker",
            "AWS::Amplify::App",
            "AWS::Amplify::Branch",
            "AWS::ApiGateway::RestApi",
            "AWS::ApiGateway::Stage",
            "AWS::ApiGatewayV2::Api",
            "AWS::ApiGatewayV2::Stage",
            "AWS::AppConfig::Application",
            "AWS::AppConfig::ConfigurationProfile",
            "AWS::AppConfig::DeploymentStrategy",
            "AWS::AppConfig::Environment",
            "AWS::AppConfig::HostedConfigurationVersion",
            "AWS::AppFlow::Flow",
            "AWS::AppIntegrations::EventIntegration",
            "AWS::AppMesh::GatewayRoute",
            "AWS::AppMesh::Mesh",
            "AWS::AppMesh::Route",
            "AWS::AppMesh::VirtualGateway",
            "AWS::AppMesh::VirtualNode",
            "AWS::AppMesh::VirtualRouter",
            "AWS::AppMesh::VirtualService",
            "AWS::AppRunner::Service",
            "AWS::AppRunner::VpcConnector",
            "AWS::AppStream::Application",
            "AWS::AppStream::DirectoryConfig",
            "AWS::AppStream::Fleet",
            "AWS::AppStream::Stack",
            "AWS::AppSync::GraphQLApi",
            "AWS::Athena::DataCatalog",
            "AWS::Athena::PreparedStatement",
            "AWS::Athena::WorkGroup",
            "AWS::AuditManager::Assessment",
            "AWS::AutoScaling::AutoScalingGroup",
            "AWS::AutoScaling::LaunchConfiguration",
            "AWS::AutoScaling::ScalingPolicy",
            "AWS::AutoScaling::ScheduledAction",
            "AWS::AutoScaling::WarmPool",
            "AWS::Backup::BackupPlan",
            "AWS::Backup::BackupSelection",
            "AWS::Backup::BackupVault",
            "AWS::Backup::RecoveryPoint",
            "AWS::Backup::ReportPlan",
            "AWS::Batch::ComputeEnvironment",
            "AWS::Batch::JobQueue",
            "AWS::Batch::SchedulingPolicy",
            "AWS::Budgets::BudgetsAction",
            "AWS::Cassandra::Keyspace",
            "AWS::Cloud9::EnvironmentEC2",
            "AWS::CloudFormation::Stack",
            "AWS::CloudFront::Distribution",
            "AWS::CloudFront::StreamingDistribution",
            "AWS::CloudTrail::Trail",
            "AWS::CloudWatch::Alarm",
            "AWS::CloudWatch::MetricStream",
            "AWS::CodeArtifact::Repository",
            "AWS::CodeBuild::Project",
            "AWS::CodeBuild::ReportGroup",
            "AWS::CodeDeploy::Application",
            "AWS::CodeDeploy::DeploymentConfig",
            "AWS::CodeDeploy::DeploymentGroup",
            "AWS::CodeGuruProfiler::ProfilingGroup",
            "AWS::CodeGuruReviewer::RepositoryAssociation",
            "AWS::CodePipeline::Pipeline",
            "AWS::Cognito::UserPool",
            "AWS::Cognito::UserPoolClient",
            "AWS::Cognito::UserPoolGroup",
            "AWS::Config::ConformancePackCompliance",
            "AWS::Config::ResourceCompliance",
            "AWS::Connect::Instance",
            "AWS::Connect::PhoneNumber",
            "AWS::Connect::QuickConnect",
            "AWS::CustomerProfiles::Domain",
            "AWS::CustomerProfiles::ObjectType",
            "AWS::DMS::Certificate",
            "AWS::DMS::Endpoint",
            "AWS::DMS::EventSubscription",
            "AWS::DMS::ReplicationSubnetGroup",
            "AWS::DataSync::LocationEFS",
            "AWS::DataSync::LocationFSxLustre",
            "AWS::DataSync::LocationFSxWindows",
            "AWS::DataSync::LocationHDFS",
            "AWS::DataSync::LocationNFS",
            "AWS::DataSync::LocationObjectStorage",
            "AWS::DataSync::LocationS3",
            "AWS::DataSync::LocationSMB",
            "AWS::DataSync::Task",
            "AWS::Detective::Graph",
            "AWS::DeviceFarm::InstanceProfile",
            "AWS::DeviceFarm::Project",
            "AWS::DeviceFarm::TestGridProject",
            "AWS::DynamoDB::Table",
            "AWS::EC2::CapacityReservation",
            "AWS::EC2::CarrierGateway",
            "AWS::EC2::ClientVpnEndpoint",
            "AWS::EC2::CustomerGateway",
            "AWS::EC2::DHCPOptions",
            "AWS::EC2::EC2Fleet",
            "AWS::EC2::EIP",
            "AWS::EC2::EgressOnlyInternetGateway",
            "AWS::EC2::FlowLog",
            "AWS::EC2::Host",
            "AWS::EC2::IPAM",
            "AWS::EC2::IPAMPool",
            "AWS::EC2::IPAMScope",
            "AWS::EC2::Instance",
            "AWS::EC2::InternetGateway",
            "AWS::EC2::LaunchTemplate",
            "AWS::EC2::NatGateway",
            "AWS::EC2::NetworkAcl",
            "AWS::EC2::NetworkInsightsAccessScope",
            "AWS::EC2::NetworkInsightsAccessScopeAnalysis",
            "AWS::EC2::NetworkInsightsAnalysis",
            "AWS::EC2::NetworkInsightsPath",
            "AWS::EC2::NetworkInterface",
            "AWS::EC2::PrefixList",
            "AWS::EC2::RegisteredHAInstance",
            "AWS::EC2::RouteTable",
            "AWS::EC2::SecurityGroup",
            "AWS::EC2::SpotFleet",
            "AWS::EC2::Subnet",
            "AWS::EC2::SubnetRouteTableAssociation",
            "AWS::EC2::TrafficMirrorFilter",
            "AWS::EC2::TrafficMirrorSession",
            "AWS::EC2::TrafficMirrorTarget",
            "AWS::EC2::TransitGateway",
            "AWS::EC2::TransitGatewayAttachment",
            "AWS::EC2::TransitGatewayConnect",
            "AWS::EC2::TransitGatewayMulticastDomain",
            "AWS::EC2::TransitGatewayRouteTable",
            "AWS::EC2::VPC",
            "AWS::EC2::VPCEndpoint",
            "AWS::EC2::VPCEndpointService",
            "AWS::EC2::VPCPeeringConnection",
            "AWS::EC2::VPNConnection",
            "AWS::EC2::VPNGateway",
            "AWS::EC2::Volume",
            "AWS::ECR::PublicRepository",
            "AWS::ECR::PullThroughCacheRule",
            "AWS::ECR::RegistryPolicy",
            "AWS::ECR::Repository",
            "AWS::ECS::CapacityProvider",
            "AWS::ECS::Cluster",
            "AWS::ECS::Service",
            "AWS::ECS::TaskDefinition",
            "AWS::ECS::TaskSet",
            "AWS::EFS::AccessPoint",
            "AWS::EFS::FileSystem",
            "AWS::EKS::Addon",
            "AWS::EKS::Cluster",
            "AWS::EKS::FargateProfile",
            "AWS::EKS::IdentityProviderConfig",
            "AWS::EMR::SecurityConfiguration",
            "AWS::ElasticBeanstalk::Application",
            "AWS::ElasticBeanstalk::ApplicationVersion",
            "AWS::ElasticBeanstalk::Environment",
            "AWS::ElasticLoadBalancing::LoadBalancer",
            "AWS::ElasticLoadBalancingV2::Listener",
            "AWS::ElasticLoadBalancingV2::LoadBalancer",
            "AWS::Elasticsearch::Domain",
            "AWS::EventSchemas::Discoverer",
            "AWS::EventSchemas::Registry",
            "AWS::EventSchemas::RegistryPolicy",
            "AWS::EventSchemas::Schema",
            "AWS::Events::ApiDestination",
            "AWS::Events::Archive",
            "AWS::Events::Connection",
            "AWS::Events::Endpoint",
            "AWS::Events::EventBus",
            "AWS::Events::Rule",
            "AWS::Evidently::Launch",
            "AWS::Evidently::Project",
            "AWS::FIS::ExperimentTemplate",
            "AWS::Forecast::Dataset",
            "AWS::Forecast::DatasetGroup",
            "AWS::FraudDetector::EntityType",
            "AWS::FraudDetector::Label",
            "AWS::FraudDetector::Outcome",
            "AWS::FraudDetector::Variable",
            "AWS::GlobalAccelerator::Accelerator",
            "AWS::GlobalAccelerator::EndpointGroup",
            "AWS::GlobalAccelerator::Listener",
            "AWS::Glue::Classifier",
            "AWS::Glue::Job",
            "AWS::Glue::MLTransform",
            "AWS::Grafana::Workspace",
            "AWS::GreengrassV2::ComponentVersion",
            "AWS::GroundStation::Config",
            "AWS::GroundStation::DataflowEndpointGroup",
            "AWS::GroundStation::MissionProfile",
            "AWS::GuardDuty::Detector",
            "AWS::GuardDuty::Filter",
            "AWS::GuardDuty::IPSet",
            "AWS::GuardDuty::ThreatIntelSet",
            "AWS::HealthLake::FHIRDatastore",
            "AWS::IAM::Group",
            "AWS::IAM::InstanceProfile",
            "AWS::IAM::Policy",
            "AWS::IAM::Role",
            "AWS::IAM::SAMLProvider",
            "AWS::IAM::ServerCertificate",
            "AWS::IAM::User",
            "AWS::IVS::Channel",
            "AWS::IVS::PlaybackKeyPair",
            "AWS::IVS::RecordingConfiguration",
            "AWS::ImageBuilder::ContainerRecipe",
            "AWS::ImageBuilder::DistributionConfiguration",
            "AWS::ImageBuilder::ImagePipeline",
            "AWS::ImageBuilder::ImageRecipe",
            "AWS::ImageBuilder::InfrastructureConfiguration",
            "AWS::InspectorV2::Filter",
            "AWS::IoT::AccountAuditConfiguration",
            "AWS::IoT::Authorizer",
            "AWS::IoT::CACertificate",
            "AWS::IoT::CustomMetric",
            "AWS::IoT::Dimension",
            "AWS::IoT::FleetMetric",
            "AWS::IoT::JobTemplate",
            "AWS::IoT::MitigationAction",
            "AWS::IoT::Policy",
            "AWS::IoT::ProvisioningTemplate",
            "AWS::IoT::RoleAlias",
            "AWS::IoT::ScheduledAudit",
            "AWS::IoT::SecurityProfile",
            "AWS::IoTAnalytics::Channel",
            "AWS::IoTAnalytics::Dataset",
            "AWS::IoTAnalytics::Datastore",
            "AWS::IoTAnalytics::Pipeline",
            "AWS::IoTEvents::AlarmModel",
            "AWS::IoTEvents::DetectorModel",
            "AWS::IoTEvents::Input",
            "AWS::IoTSiteWise::AssetModel",
            "AWS::IoTSiteWise::Dashboard",
            "AWS::IoTSiteWise::Gateway",
            "AWS::IoTSiteWise::Portal",
            "AWS::IoTSiteWise::Project",
            "AWS::IoTTwinMaker::ComponentType",
            "AWS::IoTTwinMaker::Entity",
            "AWS::IoTTwinMaker::Scene",
            "AWS::IoTTwinMaker::SyncJob",
            "AWS::IoTTwinMaker::Workspace",
            "AWS::IoTWireless::FuotaTask",
            "AWS::IoTWireless::MulticastGroup",
            "AWS::IoTWireless::ServiceProfile",
            "AWS::KMS::Alias",
            "AWS::KMS::Key",
            "AWS::KafkaConnect::Connector",
            "AWS::Kendra::Index",
            "AWS::Kinesis::Stream",
            "AWS::Kinesis::StreamConsumer",
            "AWS::KinesisAnalyticsV2::Application",
            "AWS::KinesisFirehose::DeliveryStream",
            "AWS::KinesisVideo::SignalingChannel",
            "AWS::KinesisVideo::Stream",
            "AWS::Lambda::CodeSigningConfig",
            "AWS::Lambda::Function",
            "AWS::Lex::Bot",
            "AWS::Lex::BotAlias",
            "AWS::Lightsail::Bucket",
            "AWS::Lightsail::Certificate",
            "AWS::Lightsail::Disk",
            "AWS::Lightsail::StaticIp",
            "AWS::Logs::Destination",
            "AWS::LookoutMetrics::Alert",
            "AWS::LookoutVision::Project",
            "AWS::M2::Environment",
            "AWS::MSK::BatchScramSecret",
            "AWS::MSK::Cluster",
            "AWS::MSK::Configuration",
            "AWS::MediaConnect::FlowEntitlement",
            "AWS::MediaConnect::FlowSource",
            "AWS::MediaConnect::FlowVpcInterface",
            "AWS::MediaPackage::PackagingConfiguration",
            "AWS::MediaPackage::PackagingGroup",
            "AWS::MediaTailor::PlaybackConfiguration",
            "AWS::NetworkFirewall::Firewall",
            "AWS::NetworkFirewall::FirewallPolicy",
            "AWS::NetworkFirewall::RuleGroup",
            "AWS::NetworkManager::ConnectPeer",
            "AWS::NetworkManager::CustomerGatewayAssociation",
            "AWS::NetworkManager::Device",
            "AWS::NetworkManager::GlobalNetwork",
            "AWS::NetworkManager::Link",
            "AWS::NetworkManager::LinkAssociation",
            "AWS::NetworkManager::Site",
            "AWS::NetworkManager::TransitGatewayRegistration",
            "AWS::OpenSearch::Domain",
            "AWS::Panorama::Package",
            "AWS::Personalize::Dataset",
            "AWS::Personalize::DatasetGroup",
            "AWS::Personalize::Schema",
            "AWS::Personalize::Solution",
            "AWS::Pinpoint::App",
            "AWS::Pinpoint::ApplicationSettings",
            "AWS::Pinpoint::Campaign",
            "AWS::Pinpoint::EmailChannel",
            "AWS::Pinpoint::EmailTemplate",
            "AWS::Pinpoint::EventStream",
            "AWS::Pinpoint::InAppTemplate",
            "AWS::Pinpoint::Segment",
            "AWS::QLDB::Ledger",
            "AWS::QuickSight::DataSource",
            "AWS::QuickSight::Template",
            "AWS::QuickSight::Theme",
            "AWS::RDS::DBCluster",
            "AWS::RDS::DBClusterSnapshot",
            "AWS::RDS::DBInstance",
            "AWS::RDS::DBSecurityGroup",
            "AWS::RDS::DBSnapshot",
            "AWS::RDS::DBSubnetGroup",
            "AWS::RDS::EventSubscription",
            "AWS::RDS::GlobalCluster",
            "AWS::RDS::OptionGroup",
            "AWS::RUM::AppMonitor",
            "AWS::Redshift::Cluster",
            "AWS::Redshift::ClusterParameterGroup",
            "AWS::Redshift::ClusterSecurityGroup",
            "AWS::Redshift::ClusterSnapshot",
            "AWS::Redshift::ClusterSubnetGroup",
            "AWS::Redshift::EndpointAccess",
            "AWS::Redshift::EventSubscription",
            "AWS::Redshift::ScheduledAction",
            "AWS::ResilienceHub::App",
            "AWS::ResilienceHub::ResiliencyPolicy",
            "AWS::ResourceExplorer2::Index",
            "AWS::RoboMaker::RobotApplication",
            "AWS::RoboMaker::RobotApplicationVersion",
            "AWS::RoboMaker::SimulationApplication",
            "AWS::Route53::HostedZone",
            "AWS::Route53RecoveryControl::Cluster",
            "AWS::Route53RecoveryControl::ControlPanel",
            "AWS::Route53RecoveryControl::RoutingControl",
            "AWS::Route53RecoveryControl::SafetyRule",
            "AWS::Route53RecoveryReadiness::Cell",
            "AWS::Route53RecoveryReadiness::ReadinessCheck",
            "AWS::Route53RecoveryReadiness::RecoveryGroup",
            "AWS::Route53RecoveryReadiness::ResourceSet",
            "AWS::Route53Resolver::FirewallDomainList",
            "AWS::Route53Resolver::FirewallRuleGroup",
            "AWS::Route53Resolver::FirewallRuleGroupAssociation",
            "AWS::Route53Resolver::ResolverEndpoint",
            "AWS::Route53Resolver::ResolverQueryLoggingConfig",
            "AWS::Route53Resolver::ResolverQueryLoggingConfigAssociation",
            "AWS::Route53Resolver::ResolverRule",
            "AWS::Route53Resolver::ResolverRuleAssociation",
            "AWS::S3::AccessPoint",
            "AWS::S3::AccountPublicAccessBlock",
            "AWS::S3::Bucket",
            "AWS::S3::MultiRegionAccessPoint",
            "AWS::S3::StorageLens",
            "AWS::SES::ConfigurationSet",
            "AWS::SES::ContactList",
            "AWS::SES::ReceiptFilter",
            "AWS::SES::ReceiptRuleSet",
            "AWS::SES::Template",
            "AWS::SNS::Topic",
            "AWS::SQS::Queue",
            "AWS::SSM::AssociationCompliance",
            "AWS::SSM::Document",
            "AWS::SSM::FileData",
            "AWS::SSM::ManagedInstanceInventory",
            "AWS::SSM::PatchCompliance",
            "AWS::SageMaker::AppImageConfig",
            "AWS::SageMaker::CodeRepository",
            "AWS::SageMaker::Domain",
            "AWS::SageMaker::FeatureGroup",
            "AWS::SageMaker::Image",
            "AWS::SageMaker::Model",
            "AWS::SageMaker::NotebookInstanceLifecycleConfig",
            "AWS::SageMaker::Workteam",
            "AWS::SecretsManager::Secret",
            "AWS::ServiceCatalog::CloudFormationProduct",
            "AWS::ServiceCatalog::CloudFormationProvisionedProduct",
            "AWS::ServiceCatalog::Portfolio",
            "AWS::ServiceDiscovery::HttpNamespace",
            "AWS::ServiceDiscovery::Instance",
            "AWS::ServiceDiscovery::PublicDnsNamespace",
            "AWS::ServiceDiscovery::Service",
            "AWS::Shield::Protection",
            "AWS::ShieldRegional::Protection",
            "AWS::Signer::SigningProfile",
            "AWS::StepFunctions::Activity",
            "AWS::StepFunctions::StateMachine",
            "AWS::Transfer::Agreement",
            "AWS::Transfer::Certificate",
            "AWS::Transfer::Connector",
            "AWS::Transfer::Workflow",
            "AWS::WAF::RateBasedRule",
            "AWS::WAF::Rule",
            "AWS::WAF::RuleGroup",
            "AWS::WAF::WebACL",
            "AWS::WAFRegional::RateBasedRule",
            "AWS::WAFRegional::Rule",
            "AWS::WAFRegional::RuleGroup",
            "AWS::WAFRegional::WebACL",
            "AWS::WAFv2::IPSet",
            "AWS::WAFv2::ManagedRuleSet",
            "AWS::WAFv2::RegexPatternSet",
            "AWS::WAFv2::RuleGroup",
            "AWS::WAFv2::WebACL",
            "AWS::WorkSpaces::ConnectionAlias",
            "AWS::WorkSpaces::Workspace",
            "AWS::XRay::EncryptionConfig",
        ]
    }
}
impl ::std::convert::AsRef<str> for ResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
impl ResourceType {
    /// Parses the enum value while disallowing unknown variants.
    ///
    /// Unknown variants will result in an error.
    pub fn try_parse(value: &str) -> ::std::result::Result<Self, crate::error::UnknownVariantError> {
        match Self::from(value) {
            #[allow(deprecated)]
            Self::Unknown(_) => ::std::result::Result::Err(crate::error::UnknownVariantError::new(value)),
            known => Ok(known),
        }
    }
}
impl ::std::fmt::Display for ResourceType {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        match self {
            ResourceType::Certificate => write!(f, "AWS::ACM::Certificate"),
            ResourceType::AcmpcaCertificateAuthority => write!(f, "AWS::ACMPCA::CertificateAuthority"),
            ResourceType::AcmpcaCertificateAuthorityActivation => write!(f, "AWS::ACMPCA::CertificateAuthorityActivation"),
            ResourceType::ApsRuleGroupsNamespace => write!(f, "AWS::APS::RuleGroupsNamespace"),
            ResourceType::AccessAnalyzerAnalyzer => write!(f, "AWS::AccessAnalyzer::Analyzer"),
            ResourceType::AmazonMqBroker => write!(f, "AWS::AmazonMQ::Broker"),
            ResourceType::AmplifyApp => write!(f, "AWS::Amplify::App"),
            ResourceType::AmplifyBranch => write!(f, "AWS::Amplify::Branch"),
            ResourceType::RestApi => write!(f, "AWS::ApiGateway::RestApi"),
            ResourceType::Stage => write!(f, "AWS::ApiGateway::Stage"),
            ResourceType::Api => write!(f, "AWS::ApiGatewayV2::Api"),
            ResourceType::StageV2 => write!(f, "AWS::ApiGatewayV2::Stage"),
            ResourceType::AppConfigApplication => write!(f, "AWS::AppConfig::Application"),
            ResourceType::AppConfigConfigurationProfile => write!(f, "AWS::AppConfig::ConfigurationProfile"),
            ResourceType::AppConfigDeploymentStrategy => write!(f, "AWS::AppConfig::DeploymentStrategy"),
            ResourceType::AppConfigEnvironment => write!(f, "AWS::AppConfig::Environment"),
            ResourceType::AppConfigHostedConfigurationVersion => write!(f, "AWS::AppConfig::HostedConfigurationVersion"),
            ResourceType::AppFlowFlow => write!(f, "AWS::AppFlow::Flow"),
            ResourceType::AppIntegrationsEventIntegration => write!(f, "AWS::AppIntegrations::EventIntegration"),
            ResourceType::AppMeshGatewayRoute => write!(f, "AWS::AppMesh::GatewayRoute"),
            ResourceType::AppMeshMesh => write!(f, "AWS::AppMesh::Mesh"),
            ResourceType::AppMeshRoute => write!(f, "AWS::AppMesh::Route"),
            ResourceType::AppMeshVirtualGateway => write!(f, "AWS::AppMesh::VirtualGateway"),
            ResourceType::AppMeshVirtualNode => write!(f, "AWS::AppMesh::VirtualNode"),
            ResourceType::AppMeshVirtualRouter => write!(f, "AWS::AppMesh::VirtualRouter"),
            ResourceType::AppMeshVirtualService => write!(f, "AWS::AppMesh::VirtualService"),
            ResourceType::AppRunnerService => write!(f, "AWS::AppRunner::Service"),
            ResourceType::AppRunnerVpcConnector => write!(f, "AWS::AppRunner::VpcConnector"),
            ResourceType::AppStreamApplication => write!(f, "AWS::AppStream::Application"),
            ResourceType::AppStreamDirectoryConfig => write!(f, "AWS::AppStream::DirectoryConfig"),
            ResourceType::AppStreamFleet => write!(f, "AWS::AppStream::Fleet"),
            ResourceType::AppStreamStack => write!(f, "AWS::AppStream::Stack"),
            ResourceType::AppSyncGraphQlApi => write!(f, "AWS::AppSync::GraphQLApi"),
            ResourceType::AthenaDataCatalog => write!(f, "AWS::Athena::DataCatalog"),
            ResourceType::AthenaPreparedStatement => write!(f, "AWS::Athena::PreparedStatement"),
            ResourceType::AthenaWorkGroup => write!(f, "AWS::Athena::WorkGroup"),
            ResourceType::AuditManagerAssessment => write!(f, "AWS::AuditManager::Assessment"),
            ResourceType::AutoScalingGroup => write!(f, "AWS::AutoScaling::AutoScalingGroup"),
            ResourceType::LaunchConfiguration => write!(f, "AWS::AutoScaling::LaunchConfiguration"),
            ResourceType::ScalingPolicy => write!(f, "AWS::AutoScaling::ScalingPolicy"),
            ResourceType::ScheduledAction => write!(f, "AWS::AutoScaling::ScheduledAction"),
            ResourceType::AutoScalingWarmPool => write!(f, "AWS::AutoScaling::WarmPool"),
            ResourceType::BackupPlan => write!(f, "AWS::Backup::BackupPlan"),
            ResourceType::BackupSelection => write!(f, "AWS::Backup::BackupSelection"),
            ResourceType::BackupVault => write!(f, "AWS::Backup::BackupVault"),
            ResourceType::BackupRecoveryPoint => write!(f, "AWS::Backup::RecoveryPoint"),
            ResourceType::BackupReportPlan => write!(f, "AWS::Backup::ReportPlan"),
            ResourceType::BatchComputeEnvironment => write!(f, "AWS::Batch::ComputeEnvironment"),
            ResourceType::BatchJobQueue => write!(f, "AWS::Batch::JobQueue"),
            ResourceType::BatchSchedulingPolicy => write!(f, "AWS::Batch::SchedulingPolicy"),
            ResourceType::BudgetsBudgetsAction => write!(f, "AWS::Budgets::BudgetsAction"),
            ResourceType::CassandraKeyspace => write!(f, "AWS::Cassandra::Keyspace"),
            ResourceType::Cloud9EnvironmentEc2 => write!(f, "AWS::Cloud9::EnvironmentEC2"),
            ResourceType::Stack => write!(f, "AWS::CloudFormation::Stack"),
            ResourceType::Distribution => write!(f, "AWS::CloudFront::Distribution"),
            ResourceType::StreamingDistribution => write!(f, "AWS::CloudFront::StreamingDistribution"),
            ResourceType::Trail => write!(f, "AWS::CloudTrail::Trail"),
            ResourceType::Alarm => write!(f, "AWS::CloudWatch::Alarm"),
            ResourceType::CloudWatchMetricStream => write!(f, "AWS::CloudWatch::MetricStream"),
            ResourceType::CodeArtifactRepository => write!(f, "AWS::CodeArtifact::Repository"),
            ResourceType::Project => write!(f, "AWS::CodeBuild::Project"),
            ResourceType::CodeBuildReportGroup => write!(f, "AWS::CodeBuild::ReportGroup"),
            ResourceType::CodeDeployApplication => write!(f, "AWS::CodeDeploy::Application"),
            ResourceType::CodeDeployDeploymentConfig => write!(f, "AWS::CodeDeploy::DeploymentConfig"),
            ResourceType::CodeDeployDeploymentGroup => write!(f, "AWS::CodeDeploy::DeploymentGroup"),
            ResourceType::CodeGuruProfilerProfilingGroup => write!(f, "AWS::CodeGuruProfiler::ProfilingGroup"),
            ResourceType::CodeGuruReviewerRepositoryAssociation => write!(f, "AWS::CodeGuruReviewer::RepositoryAssociation"),
            ResourceType::Pipeline => write!(f, "AWS::CodePipeline::Pipeline"),
            ResourceType::CognitoUserPool => write!(f, "AWS::Cognito::UserPool"),
            ResourceType::CognitoUserPoolClient => write!(f, "AWS::Cognito::UserPoolClient"),
            ResourceType::CognitoUserPoolGroup => write!(f, "AWS::Cognito::UserPoolGroup"),
            ResourceType::ConformancePackCompliance => write!(f, "AWS::Config::ConformancePackCompliance"),
            ResourceType::ResourceCompliance => write!(f, "AWS::Config::ResourceCompliance"),
            ResourceType::ConnectInstance => write!(f, "AWS::Connect::Instance"),
            ResourceType::ConnectPhoneNumber => write!(f, "AWS::Connect::PhoneNumber"),
            ResourceType::ConnectQuickConnect => write!(f, "AWS::Connect::QuickConnect"),
            ResourceType::CustomerProfilesDomain => write!(f, "AWS::CustomerProfiles::Domain"),
            ResourceType::CustomerProfilesObjectType => write!(f, "AWS::CustomerProfiles::ObjectType"),
            ResourceType::DmsCertificate => write!(f, "AWS::DMS::Certificate"),
            ResourceType::DmsEndpoint => write!(f, "AWS::DMS::Endpoint"),
            ResourceType::DmsEventSubscription => write!(f, "AWS::DMS::EventSubscription"),
            ResourceType::DmsReplicationSubnetGroup => write!(f, "AWS::DMS::ReplicationSubnetGroup"),
            ResourceType::DataSyncLocationEfs => write!(f, "AWS::DataSync::LocationEFS"),
            ResourceType::DataSyncLocationFSxLustre => write!(f, "AWS::DataSync::LocationFSxLustre"),
            ResourceType::DataSyncLocationFSxWindows => write!(f, "AWS::DataSync::LocationFSxWindows"),
            ResourceType::DataSyncLocationHdfs => write!(f, "AWS::DataSync::LocationHDFS"),
            ResourceType::DataSyncLocationNfs => write!(f, "AWS::DataSync::LocationNFS"),
            ResourceType::DataSyncLocationObjectStorage => write!(f, "AWS::DataSync::LocationObjectStorage"),
            ResourceType::DataSyncLocationS3 => write!(f, "AWS::DataSync::LocationS3"),
            ResourceType::DataSyncLocationSmb => write!(f, "AWS::DataSync::LocationSMB"),
            ResourceType::DataSyncTask => write!(f, "AWS::DataSync::Task"),
            ResourceType::DetectiveGraph => write!(f, "AWS::Detective::Graph"),
            ResourceType::DeviceFarmInstanceProfile => write!(f, "AWS::DeviceFarm::InstanceProfile"),
            ResourceType::DeviceFarmProject => write!(f, "AWS::DeviceFarm::Project"),
            ResourceType::DeviceFarmTestGridProject => write!(f, "AWS::DeviceFarm::TestGridProject"),
            ResourceType::Table => write!(f, "AWS::DynamoDB::Table"),
            ResourceType::Ec2CapacityReservation => write!(f, "AWS::EC2::CapacityReservation"),
            ResourceType::Ec2CarrierGateway => write!(f, "AWS::EC2::CarrierGateway"),
            ResourceType::Ec2ClientVpnEndpoint => write!(f, "AWS::EC2::ClientVpnEndpoint"),
            ResourceType::CustomerGateway => write!(f, "AWS::EC2::CustomerGateway"),
            ResourceType::Ec2DhcpOptions => write!(f, "AWS::EC2::DHCPOptions"),
            ResourceType::Ec2Ec2Fleet => write!(f, "AWS::EC2::EC2Fleet"),
            ResourceType::Eip => write!(f, "AWS::EC2::EIP"),
            ResourceType::EgressOnlyInternetGateway => write!(f, "AWS::EC2::EgressOnlyInternetGateway"),
            ResourceType::FlowLog => write!(f, "AWS::EC2::FlowLog"),
            ResourceType::Host => write!(f, "AWS::EC2::Host"),
            ResourceType::Ec2Ipam => write!(f, "AWS::EC2::IPAM"),
            ResourceType::Ec2IpamPool => write!(f, "AWS::EC2::IPAMPool"),
            ResourceType::Ec2IpamScope => write!(f, "AWS::EC2::IPAMScope"),
            ResourceType::Instance => write!(f, "AWS::EC2::Instance"),
            ResourceType::InternetGateway => write!(f, "AWS::EC2::InternetGateway"),
            ResourceType::LaunchTemplate => write!(f, "AWS::EC2::LaunchTemplate"),
            ResourceType::NatGateway => write!(f, "AWS::EC2::NatGateway"),
            ResourceType::NetworkAcl => write!(f, "AWS::EC2::NetworkAcl"),
            ResourceType::Ec2NetworkInsightsAccessScope => write!(f, "AWS::EC2::NetworkInsightsAccessScope"),
            ResourceType::NetworkInsightsAccessScopeAnalysis => write!(f, "AWS::EC2::NetworkInsightsAccessScopeAnalysis"),
            ResourceType::Ec2NetworkInsightsAnalysis => write!(f, "AWS::EC2::NetworkInsightsAnalysis"),
            ResourceType::Ec2NetworkInsightsPath => write!(f, "AWS::EC2::NetworkInsightsPath"),
            ResourceType::NetworkInterface => write!(f, "AWS::EC2::NetworkInterface"),
            ResourceType::Ec2PrefixList => write!(f, "AWS::EC2::PrefixList"),
            ResourceType::RegisteredHaInstance => write!(f, "AWS::EC2::RegisteredHAInstance"),
            ResourceType::RouteTable => write!(f, "AWS::EC2::RouteTable"),
            ResourceType::SecurityGroup => write!(f, "AWS::EC2::SecurityGroup"),
            ResourceType::Ec2SpotFleet => write!(f, "AWS::EC2::SpotFleet"),
            ResourceType::Subnet => write!(f, "AWS::EC2::Subnet"),
            ResourceType::Ec2SubnetRouteTableAssociation => write!(f, "AWS::EC2::SubnetRouteTableAssociation"),
            ResourceType::Ec2TrafficMirrorFilter => write!(f, "AWS::EC2::TrafficMirrorFilter"),
            ResourceType::Ec2TrafficMirrorSession => write!(f, "AWS::EC2::TrafficMirrorSession"),
            ResourceType::Ec2TrafficMirrorTarget => write!(f, "AWS::EC2::TrafficMirrorTarget"),
            ResourceType::TransitGateway => write!(f, "AWS::EC2::TransitGateway"),
            ResourceType::TransitGatewayAttachment => write!(f, "AWS::EC2::TransitGatewayAttachment"),
            ResourceType::Ec2TransitGatewayConnect => write!(f, "AWS::EC2::TransitGatewayConnect"),
            ResourceType::Ec2TransitGatewayMulticastDomain => write!(f, "AWS::EC2::TransitGatewayMulticastDomain"),
            ResourceType::TransitGatewayRouteTable => write!(f, "AWS::EC2::TransitGatewayRouteTable"),
            ResourceType::Vpc => write!(f, "AWS::EC2::VPC"),
            ResourceType::VpcEndpoint => write!(f, "AWS::EC2::VPCEndpoint"),
            ResourceType::VpcEndpointService => write!(f, "AWS::EC2::VPCEndpointService"),
            ResourceType::VpcPeeringConnection => write!(f, "AWS::EC2::VPCPeeringConnection"),
            ResourceType::VpnConnection => write!(f, "AWS::EC2::VPNConnection"),
            ResourceType::VpnGateway => write!(f, "AWS::EC2::VPNGateway"),
            ResourceType::Volume => write!(f, "AWS::EC2::Volume"),
            ResourceType::EcrPublicRepository => write!(f, "AWS::ECR::PublicRepository"),
            ResourceType::EcrPullThroughCacheRule => write!(f, "AWS::ECR::PullThroughCacheRule"),
            ResourceType::EcrRegistryPolicy => write!(f, "AWS::ECR::RegistryPolicy"),
            ResourceType::EcrRepository => write!(f, "AWS::ECR::Repository"),
            ResourceType::EcsCapacityProvider => write!(f, "AWS::ECS::CapacityProvider"),
            ResourceType::EcsCluster => write!(f, "AWS::ECS::Cluster"),
            ResourceType::EcsService => write!(f, "AWS::ECS::Service"),
            ResourceType::EcsTaskDefinition => write!(f, "AWS::ECS::TaskDefinition"),
            ResourceType::EcsTaskSet => write!(f, "AWS::ECS::TaskSet"),
            ResourceType::EfsAccessPoint => write!(f, "AWS::EFS::AccessPoint"),
            ResourceType::EfsFileSystem => write!(f, "AWS::EFS::FileSystem"),
            ResourceType::EksAddon => write!(f, "AWS::EKS::Addon"),
            ResourceType::EksCluster => write!(f, "AWS::EKS::Cluster"),
            ResourceType::EksFargateProfile => write!(f, "AWS::EKS::FargateProfile"),
            ResourceType::EksIdentityProviderConfig => write!(f, "AWS::EKS::IdentityProviderConfig"),
            ResourceType::EmrSecurityConfiguration => write!(f, "AWS::EMR::SecurityConfiguration"),
            ResourceType::Application => write!(f, "AWS::ElasticBeanstalk::Application"),
            ResourceType::ApplicationVersion => write!(f, "AWS::ElasticBeanstalk::ApplicationVersion"),
            ResourceType::Environment => write!(f, "AWS::ElasticBeanstalk::Environment"),
            ResourceType::LoadBalancer => write!(f, "AWS::ElasticLoadBalancing::LoadBalancer"),
            ResourceType::ListenerV2 => write!(f, "AWS::ElasticLoadBalancingV2::Listener"),
            ResourceType::LoadBalancerV2 => write!(f, "AWS::ElasticLoadBalancingV2::LoadBalancer"),
            ResourceType::Domain => write!(f, "AWS::Elasticsearch::Domain"),
            ResourceType::EventSchemasDiscoverer => write!(f, "AWS::EventSchemas::Discoverer"),
            ResourceType::EventSchemasRegistry => write!(f, "AWS::EventSchemas::Registry"),
            ResourceType::EventSchemasRegistryPolicy => write!(f, "AWS::EventSchemas::RegistryPolicy"),
            ResourceType::EventSchemasSchema => write!(f, "AWS::EventSchemas::Schema"),
            ResourceType::EventsApiDestination => write!(f, "AWS::Events::ApiDestination"),
            ResourceType::EventsArchive => write!(f, "AWS::Events::Archive"),
            ResourceType::EventsConnection => write!(f, "AWS::Events::Connection"),
            ResourceType::EventsEndpoint => write!(f, "AWS::Events::Endpoint"),
            ResourceType::EventsEventBus => write!(f, "AWS::Events::EventBus"),
            ResourceType::EventsRule => write!(f, "AWS::Events::Rule"),
            ResourceType::EvidentlyLaunch => write!(f, "AWS::Evidently::Launch"),
            ResourceType::EvidentlyProject => write!(f, "AWS::Evidently::Project"),
            ResourceType::FisExperimentTemplate => write!(f, "AWS::FIS::ExperimentTemplate"),
            ResourceType::ForecastDataset => write!(f, "AWS::Forecast::Dataset"),
            ResourceType::ForecastDatasetGroup => write!(f, "AWS::Forecast::DatasetGroup"),
            ResourceType::FraudDetectorEntityType => write!(f, "AWS::FraudDetector::EntityType"),
            ResourceType::FraudDetectorLabel => write!(f, "AWS::FraudDetector::Label"),
            ResourceType::FraudDetectorOutcome => write!(f, "AWS::FraudDetector::Outcome"),
            ResourceType::FraudDetectorVariable => write!(f, "AWS::FraudDetector::Variable"),
            ResourceType::GlobalAcceleratorAccelerator => write!(f, "AWS::GlobalAccelerator::Accelerator"),
            ResourceType::GlobalAcceleratorEndpointGroup => write!(f, "AWS::GlobalAccelerator::EndpointGroup"),
            ResourceType::GlobalAcceleratorListener => write!(f, "AWS::GlobalAccelerator::Listener"),
            ResourceType::GlueClassifier => write!(f, "AWS::Glue::Classifier"),
            ResourceType::GlueJob => write!(f, "AWS::Glue::Job"),
            ResourceType::GlueMlTransform => write!(f, "AWS::Glue::MLTransform"),
            ResourceType::GrafanaWorkspace => write!(f, "AWS::Grafana::Workspace"),
            ResourceType::GreengrassV2ComponentVersion => write!(f, "AWS::GreengrassV2::ComponentVersion"),
            ResourceType::GroundStationConfig => write!(f, "AWS::GroundStation::Config"),
            ResourceType::GroundStationDataflowEndpointGroup => write!(f, "AWS::GroundStation::DataflowEndpointGroup"),
            ResourceType::GroundStationMissionProfile => write!(f, "AWS::GroundStation::MissionProfile"),
            ResourceType::GuardDutyDetector => write!(f, "AWS::GuardDuty::Detector"),
            ResourceType::GuardDutyFilter => write!(f, "AWS::GuardDuty::Filter"),
            ResourceType::GuardDutyIpSet => write!(f, "AWS::GuardDuty::IPSet"),
            ResourceType::GuardDutyThreatIntelSet => write!(f, "AWS::GuardDuty::ThreatIntelSet"),
            ResourceType::HealthLakeFhirDatastore => write!(f, "AWS::HealthLake::FHIRDatastore"),
            ResourceType::Group => write!(f, "AWS::IAM::Group"),
            ResourceType::IamInstanceProfile => write!(f, "AWS::IAM::InstanceProfile"),
            ResourceType::Policy => write!(f, "AWS::IAM::Policy"),
            ResourceType::Role => write!(f, "AWS::IAM::Role"),
            ResourceType::IamsamlProvider => write!(f, "AWS::IAM::SAMLProvider"),
            ResourceType::IamServerCertificate => write!(f, "AWS::IAM::ServerCertificate"),
            ResourceType::User => write!(f, "AWS::IAM::User"),
            ResourceType::IvsChannel => write!(f, "AWS::IVS::Channel"),
            ResourceType::IvsPlaybackKeyPair => write!(f, "AWS::IVS::PlaybackKeyPair"),
            ResourceType::IvsRecordingConfiguration => write!(f, "AWS::IVS::RecordingConfiguration"),
            ResourceType::ImageBuilderContainerRecipe => write!(f, "AWS::ImageBuilder::ContainerRecipe"),
            ResourceType::ImageBuilderDistributionConfiguration => write!(f, "AWS::ImageBuilder::DistributionConfiguration"),
            ResourceType::ImageBuilderImagePipeline => write!(f, "AWS::ImageBuilder::ImagePipeline"),
            ResourceType::ImageBuilderImageRecipe => write!(f, "AWS::ImageBuilder::ImageRecipe"),
            ResourceType::ImageBuilderInfrastructureConfiguration => write!(f, "AWS::ImageBuilder::InfrastructureConfiguration"),
            ResourceType::InspectorV2Filter => write!(f, "AWS::InspectorV2::Filter"),
            ResourceType::IoTAccountAuditConfiguration => write!(f, "AWS::IoT::AccountAuditConfiguration"),
            ResourceType::IoTAuthorizer => write!(f, "AWS::IoT::Authorizer"),
            ResourceType::IoTcaCertificate => write!(f, "AWS::IoT::CACertificate"),
            ResourceType::IoTCustomMetric => write!(f, "AWS::IoT::CustomMetric"),
            ResourceType::IoTDimension => write!(f, "AWS::IoT::Dimension"),
            ResourceType::IoTFleetMetric => write!(f, "AWS::IoT::FleetMetric"),
            ResourceType::IoTJobTemplate => write!(f, "AWS::IoT::JobTemplate"),
            ResourceType::IoTMitigationAction => write!(f, "AWS::IoT::MitigationAction"),
            ResourceType::IoTPolicy => write!(f, "AWS::IoT::Policy"),
            ResourceType::IoTProvisioningTemplate => write!(f, "AWS::IoT::ProvisioningTemplate"),
            ResourceType::IoTRoleAlias => write!(f, "AWS::IoT::RoleAlias"),
            ResourceType::IoTScheduledAudit => write!(f, "AWS::IoT::ScheduledAudit"),
            ResourceType::IoTSecurityProfile => write!(f, "AWS::IoT::SecurityProfile"),
            ResourceType::IoTAnalyticsChannel => write!(f, "AWS::IoTAnalytics::Channel"),
            ResourceType::IoTAnalyticsDataset => write!(f, "AWS::IoTAnalytics::Dataset"),
            ResourceType::IoTAnalyticsDatastore => write!(f, "AWS::IoTAnalytics::Datastore"),
            ResourceType::IoTAnalyticsPipeline => write!(f, "AWS::IoTAnalytics::Pipeline"),
            ResourceType::IoTEventsAlarmModel => write!(f, "AWS::IoTEvents::AlarmModel"),
            ResourceType::IoTEventsDetectorModel => write!(f, "AWS::IoTEvents::DetectorModel"),
            ResourceType::IoTEventsInput => write!(f, "AWS::IoTEvents::Input"),
            ResourceType::IoTSiteWiseAssetModel => write!(f, "AWS::IoTSiteWise::AssetModel"),
            ResourceType::IoTSiteWiseDashboard => write!(f, "AWS::IoTSiteWise::Dashboard"),
            ResourceType::IoTSiteWiseGateway => write!(f, "AWS::IoTSiteWise::Gateway"),
            ResourceType::IoTSiteWisePortal => write!(f, "AWS::IoTSiteWise::Portal"),
            ResourceType::IoTSiteWiseProject => write!(f, "AWS::IoTSiteWise::Project"),
            ResourceType::IoTTwinMakerComponentType => write!(f, "AWS::IoTTwinMaker::ComponentType"),
            ResourceType::IoTTwinMakerEntity => write!(f, "AWS::IoTTwinMaker::Entity"),
            ResourceType::IoTTwinMakerScene => write!(f, "AWS::IoTTwinMaker::Scene"),
            ResourceType::IoTTwinMakerSyncJob => write!(f, "AWS::IoTTwinMaker::SyncJob"),
            ResourceType::IoTTwinMakerWorkspace => write!(f, "AWS::IoTTwinMaker::Workspace"),
            ResourceType::IoTWirelessFuotaTask => write!(f, "AWS::IoTWireless::FuotaTask"),
            ResourceType::IoTWirelessMulticastGroup => write!(f, "AWS::IoTWireless::MulticastGroup"),
            ResourceType::IoTWirelessServiceProfile => write!(f, "AWS::IoTWireless::ServiceProfile"),
            ResourceType::KmsAlias => write!(f, "AWS::KMS::Alias"),
            ResourceType::Key => write!(f, "AWS::KMS::Key"),
            ResourceType::KafkaConnectConnector => write!(f, "AWS::KafkaConnect::Connector"),
            ResourceType::KendraIndex => write!(f, "AWS::Kendra::Index"),
            ResourceType::KinesisStream => write!(f, "AWS::Kinesis::Stream"),
            ResourceType::KinesisStreamConsumer => write!(f, "AWS::Kinesis::StreamConsumer"),
            ResourceType::KinesisAnalyticsV2Application => write!(f, "AWS::KinesisAnalyticsV2::Application"),
            ResourceType::KinesisFirehoseDeliveryStream => write!(f, "AWS::KinesisFirehose::DeliveryStream"),
            ResourceType::KinesisVideoSignalingChannel => write!(f, "AWS::KinesisVideo::SignalingChannel"),
            ResourceType::KinesisVideoStream => write!(f, "AWS::KinesisVideo::Stream"),
            ResourceType::LambdaCodeSigningConfig => write!(f, "AWS::Lambda::CodeSigningConfig"),
            ResourceType::Function => write!(f, "AWS::Lambda::Function"),
            ResourceType::LexBot => write!(f, "AWS::Lex::Bot"),
            ResourceType::LexBotAlias => write!(f, "AWS::Lex::BotAlias"),
            ResourceType::LightsailBucket => write!(f, "AWS::Lightsail::Bucket"),
            ResourceType::LightsailCertificate => write!(f, "AWS::Lightsail::Certificate"),
            ResourceType::LightsailDisk => write!(f, "AWS::Lightsail::Disk"),
            ResourceType::LightsailStaticIp => write!(f, "AWS::Lightsail::StaticIp"),
            ResourceType::LogsDestination => write!(f, "AWS::Logs::Destination"),
            ResourceType::LookoutMetricsAlert => write!(f, "AWS::LookoutMetrics::Alert"),
            ResourceType::LookoutVisionProject => write!(f, "AWS::LookoutVision::Project"),
            ResourceType::M2Environment => write!(f, "AWS::M2::Environment"),
            ResourceType::MskBatchScramSecret => write!(f, "AWS::MSK::BatchScramSecret"),
            ResourceType::MskCluster => write!(f, "AWS::MSK::Cluster"),
            ResourceType::MskConfiguration => write!(f, "AWS::MSK::Configuration"),
            ResourceType::MediaConnectFlowEntitlement => write!(f, "AWS::MediaConnect::FlowEntitlement"),
            ResourceType::MediaConnectFlowSource => write!(f, "AWS::MediaConnect::FlowSource"),
            ResourceType::MediaConnectFlowVpcInterface => write!(f, "AWS::MediaConnect::FlowVpcInterface"),
            ResourceType::MediaPackagePackagingConfiguration => write!(f, "AWS::MediaPackage::PackagingConfiguration"),
            ResourceType::MediaPackagePackagingGroup => write!(f, "AWS::MediaPackage::PackagingGroup"),
            ResourceType::MediaTailorPlaybackConfiguration => write!(f, "AWS::MediaTailor::PlaybackConfiguration"),
            ResourceType::NetworkFirewallFirewall => write!(f, "AWS::NetworkFirewall::Firewall"),
            ResourceType::NetworkFirewallFirewallPolicy => write!(f, "AWS::NetworkFirewall::FirewallPolicy"),
            ResourceType::NetworkFirewallRuleGroup => write!(f, "AWS::NetworkFirewall::RuleGroup"),
            ResourceType::NetworkManagerConnectPeer => write!(f, "AWS::NetworkManager::ConnectPeer"),
            ResourceType::NetworkManagerCustomerGatewayAssociation => write!(f, "AWS::NetworkManager::CustomerGatewayAssociation"),
            ResourceType::NetworkManagerDevice => write!(f, "AWS::NetworkManager::Device"),
            ResourceType::NetworkManagerGlobalNetwork => write!(f, "AWS::NetworkManager::GlobalNetwork"),
            ResourceType::NetworkManagerLink => write!(f, "AWS::NetworkManager::Link"),
            ResourceType::NetworkManagerLinkAssociation => write!(f, "AWS::NetworkManager::LinkAssociation"),
            ResourceType::NetworkManagerSite => write!(f, "AWS::NetworkManager::Site"),
            ResourceType::NetworkManagerTransitGatewayRegistration => write!(f, "AWS::NetworkManager::TransitGatewayRegistration"),
            ResourceType::OpenSearchDomain => write!(f, "AWS::OpenSearch::Domain"),
            ResourceType::PanoramaPackage => write!(f, "AWS::Panorama::Package"),
            ResourceType::PersonalizeDataset => write!(f, "AWS::Personalize::Dataset"),
            ResourceType::PersonalizeDatasetGroup => write!(f, "AWS::Personalize::DatasetGroup"),
            ResourceType::PersonalizeSchema => write!(f, "AWS::Personalize::Schema"),
            ResourceType::PersonalizeSolution => write!(f, "AWS::Personalize::Solution"),
            ResourceType::PinpointApp => write!(f, "AWS::Pinpoint::App"),
            ResourceType::PinpointApplicationSettings => write!(f, "AWS::Pinpoint::ApplicationSettings"),
            ResourceType::PinpointCampaign => write!(f, "AWS::Pinpoint::Campaign"),
            ResourceType::PinpointEmailChannel => write!(f, "AWS::Pinpoint::EmailChannel"),
            ResourceType::PinpointEmailTemplate => write!(f, "AWS::Pinpoint::EmailTemplate"),
            ResourceType::PinpointEventStream => write!(f, "AWS::Pinpoint::EventStream"),
            ResourceType::PinpointInAppTemplate => write!(f, "AWS::Pinpoint::InAppTemplate"),
            ResourceType::PinpointSegment => write!(f, "AWS::Pinpoint::Segment"),
            ResourceType::QldbLedger => write!(f, "AWS::QLDB::Ledger"),
            ResourceType::QuickSightDataSource => write!(f, "AWS::QuickSight::DataSource"),
            ResourceType::QuickSightTemplate => write!(f, "AWS::QuickSight::Template"),
            ResourceType::QuickSightTheme => write!(f, "AWS::QuickSight::Theme"),
            ResourceType::DbCluster => write!(f, "AWS::RDS::DBCluster"),
            ResourceType::DbClusterSnapshot => write!(f, "AWS::RDS::DBClusterSnapshot"),
            ResourceType::DbInstance => write!(f, "AWS::RDS::DBInstance"),
            ResourceType::DbSecurityGroup => write!(f, "AWS::RDS::DBSecurityGroup"),
            ResourceType::DbSnapshot => write!(f, "AWS::RDS::DBSnapshot"),
            ResourceType::DbSubnetGroup => write!(f, "AWS::RDS::DBSubnetGroup"),
            ResourceType::EventSubscription => write!(f, "AWS::RDS::EventSubscription"),
            ResourceType::RdsGlobalCluster => write!(f, "AWS::RDS::GlobalCluster"),
            ResourceType::RdsOptionGroup => write!(f, "AWS::RDS::OptionGroup"),
            ResourceType::RumAppMonitor => write!(f, "AWS::RUM::AppMonitor"),
            ResourceType::Cluster => write!(f, "AWS::Redshift::Cluster"),
            ResourceType::ClusterParameterGroup => write!(f, "AWS::Redshift::ClusterParameterGroup"),
            ResourceType::ClusterSecurityGroup => write!(f, "AWS::Redshift::ClusterSecurityGroup"),
            ResourceType::ClusterSnapshot => write!(f, "AWS::Redshift::ClusterSnapshot"),
            ResourceType::ClusterSubnetGroup => write!(f, "AWS::Redshift::ClusterSubnetGroup"),
            ResourceType::RedshiftEndpointAccess => write!(f, "AWS::Redshift::EndpointAccess"),
            ResourceType::RedshiftEventSubscription => write!(f, "AWS::Redshift::EventSubscription"),
            ResourceType::RedshiftScheduledAction => write!(f, "AWS::Redshift::ScheduledAction"),
            ResourceType::ResilienceHubApp => write!(f, "AWS::ResilienceHub::App"),
            ResourceType::ResilienceHubResiliencyPolicy => write!(f, "AWS::ResilienceHub::ResiliencyPolicy"),
            ResourceType::ResourceExplorer2Index => write!(f, "AWS::ResourceExplorer2::Index"),
            ResourceType::RoboMakerRobotApplication => write!(f, "AWS::RoboMaker::RobotApplication"),
            ResourceType::RoboMakerRobotApplicationVersion => write!(f, "AWS::RoboMaker::RobotApplicationVersion"),
            ResourceType::RoboMakerSimulationApplication => write!(f, "AWS::RoboMaker::SimulationApplication"),
            ResourceType::Route53HostedZone => write!(f, "AWS::Route53::HostedZone"),
            ResourceType::Route53RecoveryControlCluster => write!(f, "AWS::Route53RecoveryControl::Cluster"),
            ResourceType::Route53RecoveryControlControlPanel => write!(f, "AWS::Route53RecoveryControl::ControlPanel"),
            ResourceType::Route53RecoveryControlRoutingControl => write!(f, "AWS::Route53RecoveryControl::RoutingControl"),
            ResourceType::Route53RecoveryControlSafetyRule => write!(f, "AWS::Route53RecoveryControl::SafetyRule"),
            ResourceType::Route53RecoveryReadinessCell => write!(f, "AWS::Route53RecoveryReadiness::Cell"),
            ResourceType::Route53RecoveryReadinessReadinessCheck => write!(f, "AWS::Route53RecoveryReadiness::ReadinessCheck"),
            ResourceType::Route53RecoveryReadinessRecoveryGroup => write!(f, "AWS::Route53RecoveryReadiness::RecoveryGroup"),
            ResourceType::Route53RecoveryReadinessResourceSet => write!(f, "AWS::Route53RecoveryReadiness::ResourceSet"),
            ResourceType::Route53ResolverFirewallDomainList => write!(f, "AWS::Route53Resolver::FirewallDomainList"),
            ResourceType::Route53ResolverFirewallRuleGroup => write!(f, "AWS::Route53Resolver::FirewallRuleGroup"),
            ResourceType::Route53ResolverFirewallRuleGroupAssociation => write!(f, "AWS::Route53Resolver::FirewallRuleGroupAssociation"),
            ResourceType::Route53ResolverResolverEndpoint => write!(f, "AWS::Route53Resolver::ResolverEndpoint"),
            ResourceType::Route53ResolverResolverQueryLoggingConfig => write!(f, "AWS::Route53Resolver::ResolverQueryLoggingConfig"),
            ResourceType::Route53ResolverResolverQueryLoggingConfigAssociation => {
                write!(f, "AWS::Route53Resolver::ResolverQueryLoggingConfigAssociation")
            }
            ResourceType::Route53ResolverResolverRule => write!(f, "AWS::Route53Resolver::ResolverRule"),
            ResourceType::Route53ResolverResolverRuleAssociation => write!(f, "AWS::Route53Resolver::ResolverRuleAssociation"),
            ResourceType::S3AccessPoint => write!(f, "AWS::S3::AccessPoint"),
            ResourceType::AccountPublicAccessBlock => write!(f, "AWS::S3::AccountPublicAccessBlock"),
            ResourceType::Bucket => write!(f, "AWS::S3::Bucket"),
            ResourceType::S3MultiRegionAccessPoint => write!(f, "AWS::S3::MultiRegionAccessPoint"),
            ResourceType::S3StorageLens => write!(f, "AWS::S3::StorageLens"),
            ResourceType::SesConfigurationSet => write!(f, "AWS::SES::ConfigurationSet"),
            ResourceType::SesContactList => write!(f, "AWS::SES::ContactList"),
            ResourceType::SesReceiptFilter => write!(f, "AWS::SES::ReceiptFilter"),
            ResourceType::SesReceiptRuleSet => write!(f, "AWS::SES::ReceiptRuleSet"),
            ResourceType::SesTemplate => write!(f, "AWS::SES::Template"),
            ResourceType::Topic => write!(f, "AWS::SNS::Topic"),
            ResourceType::Queue => write!(f, "AWS::SQS::Queue"),
            ResourceType::AssociationCompliance => write!(f, "AWS::SSM::AssociationCompliance"),
            ResourceType::SsmDocument => write!(f, "AWS::SSM::Document"),
            ResourceType::FileData => write!(f, "AWS::SSM::FileData"),
            ResourceType::ManagedInstanceInventory => write!(f, "AWS::SSM::ManagedInstanceInventory"),
            ResourceType::PatchCompliance => write!(f, "AWS::SSM::PatchCompliance"),
            ResourceType::SageMakerAppImageConfig => write!(f, "AWS::SageMaker::AppImageConfig"),
            ResourceType::SageMakerCodeRepository => write!(f, "AWS::SageMaker::CodeRepository"),
            ResourceType::SageMakerDomain => write!(f, "AWS::SageMaker::Domain"),
            ResourceType::SageMakerFeatureGroup => write!(f, "AWS::SageMaker::FeatureGroup"),
            ResourceType::SageMakerImage => write!(f, "AWS::SageMaker::Image"),
            ResourceType::SageMakerModel => write!(f, "AWS::SageMaker::Model"),
            ResourceType::SageMakerNotebookInstanceLifecycleConfig => write!(f, "AWS::SageMaker::NotebookInstanceLifecycleConfig"),
            ResourceType::SageMakerWorkteam => write!(f, "AWS::SageMaker::Workteam"),
            ResourceType::Secret => write!(f, "AWS::SecretsManager::Secret"),
            ResourceType::CloudFormationProduct => write!(f, "AWS::ServiceCatalog::CloudFormationProduct"),
            ResourceType::CloudFormationProvisionedProduct => write!(f, "AWS::ServiceCatalog::CloudFormationProvisionedProduct"),
            ResourceType::Portfolio => write!(f, "AWS::ServiceCatalog::Portfolio"),
            ResourceType::ServiceDiscoveryHttpNamespace => write!(f, "AWS::ServiceDiscovery::HttpNamespace"),
            ResourceType::ServiceDiscoveryInstance => write!(f, "AWS::ServiceDiscovery::Instance"),
            ResourceType::ServiceDiscoveryPublicDnsNamespace => write!(f, "AWS::ServiceDiscovery::PublicDnsNamespace"),
            ResourceType::ServiceDiscoveryService => write!(f, "AWS::ServiceDiscovery::Service"),
            ResourceType::Protection => write!(f, "AWS::Shield::Protection"),
            ResourceType::RegionalProtection => write!(f, "AWS::ShieldRegional::Protection"),
            ResourceType::SignerSigningProfile => write!(f, "AWS::Signer::SigningProfile"),
            ResourceType::StepFunctionsActivity => write!(f, "AWS::StepFunctions::Activity"),
            ResourceType::StepFunctionsStateMachine => write!(f, "AWS::StepFunctions::StateMachine"),
            ResourceType::TransferAgreement => write!(f, "AWS::Transfer::Agreement"),
            ResourceType::TransferCertificate => write!(f, "AWS::Transfer::Certificate"),
            ResourceType::TransferConnector => write!(f, "AWS::Transfer::Connector"),
            ResourceType::TransferWorkflow => write!(f, "AWS::Transfer::Workflow"),
            ResourceType::RateBasedRule => write!(f, "AWS::WAF::RateBasedRule"),
            ResourceType::Rule => write!(f, "AWS::WAF::Rule"),
            ResourceType::RuleGroup => write!(f, "AWS::WAF::RuleGroup"),
            ResourceType::WebAcl => write!(f, "AWS::WAF::WebACL"),
            ResourceType::RegionalRateBasedRule => write!(f, "AWS::WAFRegional::RateBasedRule"),
            ResourceType::RegionalRule => write!(f, "AWS::WAFRegional::Rule"),
            ResourceType::RegionalRuleGroup => write!(f, "AWS::WAFRegional::RuleGroup"),
            ResourceType::RegionalWebAcl => write!(f, "AWS::WAFRegional::WebACL"),
            ResourceType::IpSetV2 => write!(f, "AWS::WAFv2::IPSet"),
            ResourceType::ManagedRuleSetV2 => write!(f, "AWS::WAFv2::ManagedRuleSet"),
            ResourceType::RegexPatternSetV2 => write!(f, "AWS::WAFv2::RegexPatternSet"),
            ResourceType::RuleGroupV2 => write!(f, "AWS::WAFv2::RuleGroup"),
            ResourceType::WebAclv2 => write!(f, "AWS::WAFv2::WebACL"),
            ResourceType::WorkSpacesConnectionAlias => write!(f, "AWS::WorkSpaces::ConnectionAlias"),
            ResourceType::WorkSpacesWorkspace => write!(f, "AWS::WorkSpaces::Workspace"),
            ResourceType::EncryptionConfig => write!(f, "AWS::XRay::EncryptionConfig"),
            ResourceType::Unknown(value) => write!(f, "{}", value),
        }
    }
}
