// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Provides the CustomPolicyDetails, the rule owner (<code>Amazon Web Services</code> for managed rules, <code>CUSTOM_POLICY</code> for Custom Policy rules, and <code>CUSTOM_LAMBDA</code> for Custom Lambda rules), the rule identifier, and the events that cause the evaluation of your Amazon Web Services resources.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct Source {
    /// <p>Indicates whether Amazon Web Services or the customer owns and manages the Config rule.</p>
    /// <p>Config Managed Rules are predefined rules owned by Amazon Web Services. For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Config Managed Rules</a> in the <i>Config developer guide</i>.</p>
    /// <p>Config Custom Rules are rules that you can develop either with Guard (<code>CUSTOM_POLICY</code>) or Lambda (<code>CUSTOM_LAMBDA</code>). For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html">Config Custom Rules </a> in the <i>Config developer guide</i>.</p>
    pub owner: crate::types::Owner,
    /// <p>For Config Managed rules, a predefined identifier from a list. For example, <code>IAM_PASSWORD_POLICY</code> is a managed rule. To reference a managed rule, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html">List of Config Managed Rules</a>.</p>
    /// <p>For Config Custom Lambda rules, the identifier is the Amazon Resource Name (ARN) of the rule's Lambda function, such as <code>arn:aws:lambda:us-east-2:123456789012:function:custom_rule_name</code>.</p>
    /// <p>For Config Custom Policy rules, this field will be ignored.</p>
    pub source_identifier: ::std::option::Option<::std::string::String>,
    /// <p>Provides the source and the message types that cause Config to evaluate your Amazon Web Services resources against a rule. It also provides the frequency with which you want Config to run evaluations for the rule if the trigger type is periodic.</p>
    /// <p>If the owner is set to <code>CUSTOM_POLICY</code>, the only acceptable values for the Config rule trigger message type are <code>ConfigurationItemChangeNotification</code> and <code>OversizedConfigurationItemChangeNotification</code>.</p>
    pub source_details: ::std::option::Option<::std::vec::Vec<crate::types::SourceDetail>>,
    /// <p>Provides the runtime system, policy definition, and whether debug logging is enabled. Required when owner is set to <code>CUSTOM_POLICY</code>.</p>
    pub custom_policy_details: ::std::option::Option<crate::types::CustomPolicyDetails>,
}
impl Source {
    /// <p>Indicates whether Amazon Web Services or the customer owns and manages the Config rule.</p>
    /// <p>Config Managed Rules are predefined rules owned by Amazon Web Services. For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Config Managed Rules</a> in the <i>Config developer guide</i>.</p>
    /// <p>Config Custom Rules are rules that you can develop either with Guard (<code>CUSTOM_POLICY</code>) or Lambda (<code>CUSTOM_LAMBDA</code>). For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html">Config Custom Rules </a> in the <i>Config developer guide</i>.</p>
    pub fn owner(&self) -> &crate::types::Owner {
        &self.owner
    }
    /// <p>For Config Managed rules, a predefined identifier from a list. For example, <code>IAM_PASSWORD_POLICY</code> is a managed rule. To reference a managed rule, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html">List of Config Managed Rules</a>.</p>
    /// <p>For Config Custom Lambda rules, the identifier is the Amazon Resource Name (ARN) of the rule's Lambda function, such as <code>arn:aws:lambda:us-east-2:123456789012:function:custom_rule_name</code>.</p>
    /// <p>For Config Custom Policy rules, this field will be ignored.</p>
    pub fn source_identifier(&self) -> ::std::option::Option<&str> {
        self.source_identifier.as_deref()
    }
    /// <p>Provides the source and the message types that cause Config to evaluate your Amazon Web Services resources against a rule. It also provides the frequency with which you want Config to run evaluations for the rule if the trigger type is periodic.</p>
    /// <p>If the owner is set to <code>CUSTOM_POLICY</code>, the only acceptable values for the Config rule trigger message type are <code>ConfigurationItemChangeNotification</code> and <code>OversizedConfigurationItemChangeNotification</code>.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.source_details.is_none()`.
    pub fn source_details(&self) -> &[crate::types::SourceDetail] {
        self.source_details.as_deref().unwrap_or_default()
    }
    /// <p>Provides the runtime system, policy definition, and whether debug logging is enabled. Required when owner is set to <code>CUSTOM_POLICY</code>.</p>
    pub fn custom_policy_details(&self) -> ::std::option::Option<&crate::types::CustomPolicyDetails> {
        self.custom_policy_details.as_ref()
    }
}
impl Source {
    /// Creates a new builder-style object to manufacture [`Source`](crate::types::Source).
    pub fn builder() -> crate::types::builders::SourceBuilder {
        crate::types::builders::SourceBuilder::default()
    }
}

/// A builder for [`Source`](crate::types::Source).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct SourceBuilder {
    pub(crate) owner: ::std::option::Option<crate::types::Owner>,
    pub(crate) source_identifier: ::std::option::Option<::std::string::String>,
    pub(crate) source_details: ::std::option::Option<::std::vec::Vec<crate::types::SourceDetail>>,
    pub(crate) custom_policy_details: ::std::option::Option<crate::types::CustomPolicyDetails>,
}
impl SourceBuilder {
    /// <p>Indicates whether Amazon Web Services or the customer owns and manages the Config rule.</p>
    /// <p>Config Managed Rules are predefined rules owned by Amazon Web Services. For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Config Managed Rules</a> in the <i>Config developer guide</i>.</p>
    /// <p>Config Custom Rules are rules that you can develop either with Guard (<code>CUSTOM_POLICY</code>) or Lambda (<code>CUSTOM_LAMBDA</code>). For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html">Config Custom Rules </a> in the <i>Config developer guide</i>.</p>
    /// This field is required.
    pub fn owner(mut self, input: crate::types::Owner) -> Self {
        self.owner = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates whether Amazon Web Services or the customer owns and manages the Config rule.</p>
    /// <p>Config Managed Rules are predefined rules owned by Amazon Web Services. For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Config Managed Rules</a> in the <i>Config developer guide</i>.</p>
    /// <p>Config Custom Rules are rules that you can develop either with Guard (<code>CUSTOM_POLICY</code>) or Lambda (<code>CUSTOM_LAMBDA</code>). For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html">Config Custom Rules </a> in the <i>Config developer guide</i>.</p>
    pub fn set_owner(mut self, input: ::std::option::Option<crate::types::Owner>) -> Self {
        self.owner = input;
        self
    }
    /// <p>Indicates whether Amazon Web Services or the customer owns and manages the Config rule.</p>
    /// <p>Config Managed Rules are predefined rules owned by Amazon Web Services. For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Config Managed Rules</a> in the <i>Config developer guide</i>.</p>
    /// <p>Config Custom Rules are rules that you can develop either with Guard (<code>CUSTOM_POLICY</code>) or Lambda (<code>CUSTOM_LAMBDA</code>). For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html">Config Custom Rules </a> in the <i>Config developer guide</i>.</p>
    pub fn get_owner(&self) -> &::std::option::Option<crate::types::Owner> {
        &self.owner
    }
    /// <p>For Config Managed rules, a predefined identifier from a list. For example, <code>IAM_PASSWORD_POLICY</code> is a managed rule. To reference a managed rule, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html">List of Config Managed Rules</a>.</p>
    /// <p>For Config Custom Lambda rules, the identifier is the Amazon Resource Name (ARN) of the rule's Lambda function, such as <code>arn:aws:lambda:us-east-2:123456789012:function:custom_rule_name</code>.</p>
    /// <p>For Config Custom Policy rules, this field will be ignored.</p>
    pub fn source_identifier(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.source_identifier = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>For Config Managed rules, a predefined identifier from a list. For example, <code>IAM_PASSWORD_POLICY</code> is a managed rule. To reference a managed rule, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html">List of Config Managed Rules</a>.</p>
    /// <p>For Config Custom Lambda rules, the identifier is the Amazon Resource Name (ARN) of the rule's Lambda function, such as <code>arn:aws:lambda:us-east-2:123456789012:function:custom_rule_name</code>.</p>
    /// <p>For Config Custom Policy rules, this field will be ignored.</p>
    pub fn set_source_identifier(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.source_identifier = input;
        self
    }
    /// <p>For Config Managed rules, a predefined identifier from a list. For example, <code>IAM_PASSWORD_POLICY</code> is a managed rule. To reference a managed rule, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html">List of Config Managed Rules</a>.</p>
    /// <p>For Config Custom Lambda rules, the identifier is the Amazon Resource Name (ARN) of the rule's Lambda function, such as <code>arn:aws:lambda:us-east-2:123456789012:function:custom_rule_name</code>.</p>
    /// <p>For Config Custom Policy rules, this field will be ignored.</p>
    pub fn get_source_identifier(&self) -> &::std::option::Option<::std::string::String> {
        &self.source_identifier
    }
    /// Appends an item to `source_details`.
    ///
    /// To override the contents of this collection use [`set_source_details`](Self::set_source_details).
    ///
    /// <p>Provides the source and the message types that cause Config to evaluate your Amazon Web Services resources against a rule. It also provides the frequency with which you want Config to run evaluations for the rule if the trigger type is periodic.</p>
    /// <p>If the owner is set to <code>CUSTOM_POLICY</code>, the only acceptable values for the Config rule trigger message type are <code>ConfigurationItemChangeNotification</code> and <code>OversizedConfigurationItemChangeNotification</code>.</p>
    pub fn source_details(mut self, input: crate::types::SourceDetail) -> Self {
        let mut v = self.source_details.unwrap_or_default();
        v.push(input);
        self.source_details = ::std::option::Option::Some(v);
        self
    }
    /// <p>Provides the source and the message types that cause Config to evaluate your Amazon Web Services resources against a rule. It also provides the frequency with which you want Config to run evaluations for the rule if the trigger type is periodic.</p>
    /// <p>If the owner is set to <code>CUSTOM_POLICY</code>, the only acceptable values for the Config rule trigger message type are <code>ConfigurationItemChangeNotification</code> and <code>OversizedConfigurationItemChangeNotification</code>.</p>
    pub fn set_source_details(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::SourceDetail>>) -> Self {
        self.source_details = input;
        self
    }
    /// <p>Provides the source and the message types that cause Config to evaluate your Amazon Web Services resources against a rule. It also provides the frequency with which you want Config to run evaluations for the rule if the trigger type is periodic.</p>
    /// <p>If the owner is set to <code>CUSTOM_POLICY</code>, the only acceptable values for the Config rule trigger message type are <code>ConfigurationItemChangeNotification</code> and <code>OversizedConfigurationItemChangeNotification</code>.</p>
    pub fn get_source_details(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::SourceDetail>> {
        &self.source_details
    }
    /// <p>Provides the runtime system, policy definition, and whether debug logging is enabled. Required when owner is set to <code>CUSTOM_POLICY</code>.</p>
    pub fn custom_policy_details(mut self, input: crate::types::CustomPolicyDetails) -> Self {
        self.custom_policy_details = ::std::option::Option::Some(input);
        self
    }
    /// <p>Provides the runtime system, policy definition, and whether debug logging is enabled. Required when owner is set to <code>CUSTOM_POLICY</code>.</p>
    pub fn set_custom_policy_details(mut self, input: ::std::option::Option<crate::types::CustomPolicyDetails>) -> Self {
        self.custom_policy_details = input;
        self
    }
    /// <p>Provides the runtime system, policy definition, and whether debug logging is enabled. Required when owner is set to <code>CUSTOM_POLICY</code>.</p>
    pub fn get_custom_policy_details(&self) -> &::std::option::Option<crate::types::CustomPolicyDetails> {
        &self.custom_policy_details
    }
    /// Consumes the builder and constructs a [`Source`](crate::types::Source).
    /// This method will fail if any of the following fields are not set:
    /// - [`owner`](crate::types::builders::SourceBuilder::owner)
    pub fn build(self) -> ::std::result::Result<crate::types::Source, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::Source {
            owner: self.owner.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "owner",
                    "owner was not specified but it is required when building Source",
                )
            })?,
            source_identifier: self.source_identifier,
            source_details: self.source_details,
            custom_policy_details: self.custom_policy_details,
        })
    }
}
