// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Amazon Web Services Systems Manager (SSM) specific remediation controls.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct SsmControls {
    /// <p>The maximum percentage of remediation actions allowed to run in parallel on the non-compliant resources for that specific rule. You can specify a percentage, such as 10%. The default value is 10.</p>
    pub concurrent_execution_rate_percentage: ::std::option::Option<i32>,
    /// <p>The percentage of errors that are allowed before SSM stops running automations on non-compliant resources for that specific rule. You can specify a percentage of errors, for example 10%. If you do not specifiy a percentage, the default is 50%. For example, if you set the ErrorPercentage to 40% for 10 non-compliant resources, then SSM stops running the automations when the fifth error is received.</p>
    pub error_percentage: ::std::option::Option<i32>,
}
impl SsmControls {
    /// <p>The maximum percentage of remediation actions allowed to run in parallel on the non-compliant resources for that specific rule. You can specify a percentage, such as 10%. The default value is 10.</p>
    pub fn concurrent_execution_rate_percentage(&self) -> ::std::option::Option<i32> {
        self.concurrent_execution_rate_percentage
    }
    /// <p>The percentage of errors that are allowed before SSM stops running automations on non-compliant resources for that specific rule. You can specify a percentage of errors, for example 10%. If you do not specifiy a percentage, the default is 50%. For example, if you set the ErrorPercentage to 40% for 10 non-compliant resources, then SSM stops running the automations when the fifth error is received.</p>
    pub fn error_percentage(&self) -> ::std::option::Option<i32> {
        self.error_percentage
    }
}
impl SsmControls {
    /// Creates a new builder-style object to manufacture [`SsmControls`](crate::types::SsmControls).
    pub fn builder() -> crate::types::builders::SsmControlsBuilder {
        crate::types::builders::SsmControlsBuilder::default()
    }
}

/// A builder for [`SsmControls`](crate::types::SsmControls).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct SsmControlsBuilder {
    pub(crate) concurrent_execution_rate_percentage: ::std::option::Option<i32>,
    pub(crate) error_percentage: ::std::option::Option<i32>,
}
impl SsmControlsBuilder {
    /// <p>The maximum percentage of remediation actions allowed to run in parallel on the non-compliant resources for that specific rule. You can specify a percentage, such as 10%. The default value is 10.</p>
    pub fn concurrent_execution_rate_percentage(mut self, input: i32) -> Self {
        self.concurrent_execution_rate_percentage = ::std::option::Option::Some(input);
        self
    }
    /// <p>The maximum percentage of remediation actions allowed to run in parallel on the non-compliant resources for that specific rule. You can specify a percentage, such as 10%. The default value is 10.</p>
    pub fn set_concurrent_execution_rate_percentage(mut self, input: ::std::option::Option<i32>) -> Self {
        self.concurrent_execution_rate_percentage = input;
        self
    }
    /// <p>The maximum percentage of remediation actions allowed to run in parallel on the non-compliant resources for that specific rule. You can specify a percentage, such as 10%. The default value is 10.</p>
    pub fn get_concurrent_execution_rate_percentage(&self) -> &::std::option::Option<i32> {
        &self.concurrent_execution_rate_percentage
    }
    /// <p>The percentage of errors that are allowed before SSM stops running automations on non-compliant resources for that specific rule. You can specify a percentage of errors, for example 10%. If you do not specifiy a percentage, the default is 50%. For example, if you set the ErrorPercentage to 40% for 10 non-compliant resources, then SSM stops running the automations when the fifth error is received.</p>
    pub fn error_percentage(mut self, input: i32) -> Self {
        self.error_percentage = ::std::option::Option::Some(input);
        self
    }
    /// <p>The percentage of errors that are allowed before SSM stops running automations on non-compliant resources for that specific rule. You can specify a percentage of errors, for example 10%. If you do not specifiy a percentage, the default is 50%. For example, if you set the ErrorPercentage to 40% for 10 non-compliant resources, then SSM stops running the automations when the fifth error is received.</p>
    pub fn set_error_percentage(mut self, input: ::std::option::Option<i32>) -> Self {
        self.error_percentage = input;
        self
    }
    /// <p>The percentage of errors that are allowed before SSM stops running automations on non-compliant resources for that specific rule. You can specify a percentage of errors, for example 10%. If you do not specifiy a percentage, the default is 50%. For example, if you set the ErrorPercentage to 40% for 10 non-compliant resources, then SSM stops running the automations when the fifth error is received.</p>
    pub fn get_error_percentage(&self) -> &::std::option::Option<i32> {
        &self.error_percentage
    }
    /// Consumes the builder and constructs a [`SsmControls`](crate::types::SsmControls).
    pub fn build(self) -> crate::types::SsmControls {
        crate::types::SsmControls {
            concurrent_execution_rate_percentage: self.concurrent_execution_rate_percentage,
            error_percentage: self.error_percentage,
        }
    }
}
