// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Provides the details of a stored query.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct StoredQuery {
    /// <p>The ID of the query.</p>
    pub query_id: ::std::option::Option<::std::string::String>,
    /// <p>Amazon Resource Name (ARN) of the query. For example, arn:partition:service:region:account-id:resource-type/resource-name/resource-id.</p>
    pub query_arn: ::std::option::Option<::std::string::String>,
    /// <p>The name of the query.</p>
    pub query_name: ::std::string::String,
    /// <p>A unique description for the query.</p>
    pub description: ::std::option::Option<::std::string::String>,
    /// <p>The expression of the query. For example, <code>SELECT resourceId, resourceType, supplementaryConfiguration.BucketVersioningConfiguration.status WHERE resourceType = 'AWS::S3::Bucket' AND supplementaryConfiguration.BucketVersioningConfiguration.status = 'Off'.</code></p>
    pub expression: ::std::option::Option<::std::string::String>,
}
impl StoredQuery {
    /// <p>The ID of the query.</p>
    pub fn query_id(&self) -> ::std::option::Option<&str> {
        self.query_id.as_deref()
    }
    /// <p>Amazon Resource Name (ARN) of the query. For example, arn:partition:service:region:account-id:resource-type/resource-name/resource-id.</p>
    pub fn query_arn(&self) -> ::std::option::Option<&str> {
        self.query_arn.as_deref()
    }
    /// <p>The name of the query.</p>
    pub fn query_name(&self) -> &str {
        use std::ops::Deref;
        self.query_name.deref()
    }
    /// <p>A unique description for the query.</p>
    pub fn description(&self) -> ::std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The expression of the query. For example, <code>SELECT resourceId, resourceType, supplementaryConfiguration.BucketVersioningConfiguration.status WHERE resourceType = 'AWS::S3::Bucket' AND supplementaryConfiguration.BucketVersioningConfiguration.status = 'Off'.</code></p>
    pub fn expression(&self) -> ::std::option::Option<&str> {
        self.expression.as_deref()
    }
}
impl StoredQuery {
    /// Creates a new builder-style object to manufacture [`StoredQuery`](crate::types::StoredQuery).
    pub fn builder() -> crate::types::builders::StoredQueryBuilder {
        crate::types::builders::StoredQueryBuilder::default()
    }
}

/// A builder for [`StoredQuery`](crate::types::StoredQuery).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct StoredQueryBuilder {
    pub(crate) query_id: ::std::option::Option<::std::string::String>,
    pub(crate) query_arn: ::std::option::Option<::std::string::String>,
    pub(crate) query_name: ::std::option::Option<::std::string::String>,
    pub(crate) description: ::std::option::Option<::std::string::String>,
    pub(crate) expression: ::std::option::Option<::std::string::String>,
}
impl StoredQueryBuilder {
    /// <p>The ID of the query.</p>
    pub fn query_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.query_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The ID of the query.</p>
    pub fn set_query_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.query_id = input;
        self
    }
    /// <p>The ID of the query.</p>
    pub fn get_query_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.query_id
    }
    /// <p>Amazon Resource Name (ARN) of the query. For example, arn:partition:service:region:account-id:resource-type/resource-name/resource-id.</p>
    pub fn query_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.query_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Amazon Resource Name (ARN) of the query. For example, arn:partition:service:region:account-id:resource-type/resource-name/resource-id.</p>
    pub fn set_query_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.query_arn = input;
        self
    }
    /// <p>Amazon Resource Name (ARN) of the query. For example, arn:partition:service:region:account-id:resource-type/resource-name/resource-id.</p>
    pub fn get_query_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.query_arn
    }
    /// <p>The name of the query.</p>
    /// This field is required.
    pub fn query_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.query_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the query.</p>
    pub fn set_query_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.query_name = input;
        self
    }
    /// <p>The name of the query.</p>
    pub fn get_query_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.query_name
    }
    /// <p>A unique description for the query.</p>
    pub fn description(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.description = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>A unique description for the query.</p>
    pub fn set_description(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.description = input;
        self
    }
    /// <p>A unique description for the query.</p>
    pub fn get_description(&self) -> &::std::option::Option<::std::string::String> {
        &self.description
    }
    /// <p>The expression of the query. For example, <code>SELECT resourceId, resourceType, supplementaryConfiguration.BucketVersioningConfiguration.status WHERE resourceType = 'AWS::S3::Bucket' AND supplementaryConfiguration.BucketVersioningConfiguration.status = 'Off'.</code></p>
    pub fn expression(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.expression = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The expression of the query. For example, <code>SELECT resourceId, resourceType, supplementaryConfiguration.BucketVersioningConfiguration.status WHERE resourceType = 'AWS::S3::Bucket' AND supplementaryConfiguration.BucketVersioningConfiguration.status = 'Off'.</code></p>
    pub fn set_expression(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.expression = input;
        self
    }
    /// <p>The expression of the query. For example, <code>SELECT resourceId, resourceType, supplementaryConfiguration.BucketVersioningConfiguration.status WHERE resourceType = 'AWS::S3::Bucket' AND supplementaryConfiguration.BucketVersioningConfiguration.status = 'Off'.</code></p>
    pub fn get_expression(&self) -> &::std::option::Option<::std::string::String> {
        &self.expression
    }
    /// Consumes the builder and constructs a [`StoredQuery`](crate::types::StoredQuery).
    /// This method will fail if any of the following fields are not set:
    /// - [`query_name`](crate::types::builders::StoredQueryBuilder::query_name)
    pub fn build(self) -> ::std::result::Result<crate::types::StoredQuery, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::StoredQuery {
            query_id: self.query_id,
            query_arn: self.query_arn,
            query_name: self.query_name.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "query_name",
                    "query_name was not specified but it is required when building StoredQuery",
                )
            })?,
            description: self.description,
            expression: self.expression,
        })
    }
}
