// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) conf: crate::Config,
    #[allow(dead_code)] // unused when a service does not provide any operations
    pub(crate) runtime_plugins: ::aws_smithy_runtime_api::client::runtime_plugin::RuntimePlugins,
}

/// Client for AWS Config
///
/// Client for invoking operations on AWS Config. Each operation on AWS Config is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
/// ## Constructing a `Client`
///
/// A [`Config`] is required to construct a client. For most use cases, the [`aws-config`]
/// crate should be used to automatically resolve this config using
/// [`aws_config::load_from_env()`], since this will resolve an [`SdkConfig`] which can be shared
/// across multiple different AWS SDK clients. This config resolution process can be customized
/// by calling [`aws_config::from_env()`] instead, which returns a [`ConfigLoader`] that uses
/// the [builder pattern] to customize the default config.
///
/// In the simplest case, creating a client looks as follows:
/// ```rust,no_run
/// # async fn wrapper() {
/// let config = aws_config::load_from_env().await;
/// let client = aws_sdk_config::Client::new(&config);
/// # }
/// ```
///
/// Occasionally, SDKs may have additional service-specific values that can be set on the [`Config`] that
/// is absent from [`SdkConfig`], or slightly different settings for a specific client may be desired.
/// The [`Builder`](crate::config::Builder) struct implements `From<&SdkConfig>`, so setting these specific settings can be
/// done as follows:
///
/// ```rust,no_run
/// # async fn wrapper() {
/// let sdk_config = ::aws_config::load_from_env().await;
/// let config = aws_sdk_config::config::Builder::from(&sdk_config)
/// # /*
///     .some_service_specific_setting("value")
/// # */
///     .build();
/// # }
/// ```
///
/// See the [`aws-config` docs] and [`Config`] for more information on customizing configuration.
///
/// _Note:_ Client construction is expensive due to connection thread pool initialization, and should
/// be done once at application start-up.
///
/// [`Config`]: crate::Config
/// [`ConfigLoader`]: https://docs.rs/aws-config/*/aws_config/struct.ConfigLoader.html
/// [`SdkConfig`]: https://docs.rs/aws-config/*/aws_config/struct.SdkConfig.html
/// [`aws-config` docs]: https://docs.rs/aws-config/*
/// [`aws-config`]: https://crates.io/crates/aws-config
/// [`aws_config::from_env()`]: https://docs.rs/aws-config/*/aws_config/fn.from_env.html
/// [`aws_config::load_from_env()`]: https://docs.rs/aws-config/*/aws_config/fn.load_from_env.html
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#builders-enable-construction-of-complex-values-c-builder
/// # Using the `Client`
///
/// A client has a function for every operation that can be performed by the service.
/// For example, the [`AssociateResourceTypes`](crate::operation::associate_resource_types) operation has
/// a [`Client::associate_resource_types`], function which returns a builder for that operation.
/// The fluent builder ultimately has a `send()` function that returns an async future that
/// returns a result, as illustrated below:
///
/// ```rust,ignore
/// let result = client.associate_resource_types()
///     .configuration_recorder_arn("example")
///     .send()
///     .await;
/// ```
///
/// The underlying HTTP requests that get made by this can be modified with the `customize_operation`
/// function on the fluent builder. See the [`customize`](crate::client::customize) module for more
/// information.
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct Client {
    handle: ::std::sync::Arc<Handle>,
}

impl Client {
    /// Creates a new client from the service [`Config`](crate::Config).
    ///
    /// # Panics
    ///
    /// This method will panic in the following cases:
    ///
    /// - Retries or timeouts are enabled without a `sleep_impl` configured.
    /// - Identity caching is enabled without a `sleep_impl` and `time_source` configured.
    /// - No `behavior_version` is provided.
    ///
    /// The panic message for each of these will have instructions on how to resolve them.
    #[track_caller]
    pub fn from_conf(conf: crate::Config) -> Self {
        let handle = Handle {
            conf: conf.clone(),
            runtime_plugins: crate::config::base_client_runtime_plugins(conf),
        };
        if let Err(err) = Self::validate_config(&handle) {
            panic!("Invalid client configuration: {err}");
        }
        Self {
            handle: ::std::sync::Arc::new(handle),
        }
    }

    /// Returns the client's configuration.
    pub fn config(&self) -> &crate::Config {
        &self.handle.conf
    }

    fn validate_config(handle: &Handle) -> ::std::result::Result<(), ::aws_smithy_runtime_api::box_error::BoxError> {
        let mut cfg = ::aws_smithy_types::config_bag::ConfigBag::base();
        handle
            .runtime_plugins
            .apply_client_configuration(&mut cfg)?
            .validate_base_client_config(&cfg)?;
        Ok(())
    }
}

impl Client {
    /// Creates a new client from an [SDK Config](::aws_types::sdk_config::SdkConfig).
    ///
    /// # Panics
    ///
    /// - This method will panic if the `sdk_config` is missing an async sleep implementation. If you experience this panic, set
    ///   the `sleep_impl` on the Config passed into this function to fix it.
    /// - This method will panic if the `sdk_config` is missing an HTTP connector. If you experience this panic, set the
    ///   `http_connector` on the Config passed into this function to fix it.
    /// - This method will panic if no `BehaviorVersion` is provided. If you experience this panic, set `behavior_version` on the Config or enable the `behavior-version-latest` Cargo feature.
    #[track_caller]
    pub fn new(sdk_config: &::aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }
}

mod associate_resource_types;

mod batch_get_aggregate_resource_config;

mod batch_get_resource_config;

/// Operation customization and supporting types.
///
/// The underlying HTTP requests made during an operation can be customized
/// by calling the `customize()` method on the builder returned from a client
/// operation call. For example, this can be used to add an additional HTTP header:
///
/// ```ignore
/// # async fn wrapper() -> ::std::result::Result<(), aws_sdk_config::Error> {
/// # let client: aws_sdk_config::Client = unimplemented!();
/// use ::http::header::{HeaderName, HeaderValue};
///
/// let result = client.associate_resource_types()
///     .customize()
///     .mutate_request(|req| {
///         // Add `x-example-header` with value
///         req.headers_mut()
///             .insert(
///                 HeaderName::from_static("x-example-header"),
///                 HeaderValue::from_static("1"),
///             );
///     })
///     .send()
///     .await;
/// # }
/// ```
pub mod customize;

mod delete_aggregation_authorization;

mod delete_config_rule;

mod delete_configuration_aggregator;

mod delete_configuration_recorder;

mod delete_conformance_pack;

mod delete_delivery_channel;

mod delete_evaluation_results;

mod delete_organization_config_rule;

mod delete_organization_conformance_pack;

mod delete_pending_aggregation_request;

mod delete_remediation_configuration;

mod delete_remediation_exceptions;

mod delete_resource_config;

mod delete_retention_configuration;

mod delete_service_linked_configuration_recorder;

mod delete_stored_query;

mod deliver_config_snapshot;

mod describe_aggregate_compliance_by_config_rules;

mod describe_aggregate_compliance_by_conformance_packs;

mod describe_aggregation_authorizations;

mod describe_compliance_by_config_rule;

mod describe_compliance_by_resource;

mod describe_config_rule_evaluation_status;

mod describe_config_rules;

mod describe_configuration_aggregator_sources_status;

mod describe_configuration_aggregators;

mod describe_configuration_recorder_status;

mod describe_configuration_recorders;

mod describe_conformance_pack_compliance;

mod describe_conformance_pack_status;

mod describe_conformance_packs;

mod describe_delivery_channel_status;

mod describe_delivery_channels;

mod describe_organization_config_rule_statuses;

mod describe_organization_config_rules;

mod describe_organization_conformance_pack_statuses;

mod describe_organization_conformance_packs;

mod describe_pending_aggregation_requests;

mod describe_remediation_configurations;

mod describe_remediation_exceptions;

mod describe_remediation_execution_status;

mod describe_retention_configurations;

mod disassociate_resource_types;

mod get_aggregate_compliance_details_by_config_rule;

mod get_aggregate_config_rule_compliance_summary;

mod get_aggregate_conformance_pack_compliance_summary;

mod get_aggregate_discovered_resource_counts;

mod get_aggregate_resource_config;

mod get_compliance_details_by_config_rule;

mod get_compliance_details_by_resource;

mod get_compliance_summary_by_config_rule;

mod get_compliance_summary_by_resource_type;

mod get_conformance_pack_compliance_details;

mod get_conformance_pack_compliance_summary;

mod get_custom_rule_policy;

mod get_discovered_resource_counts;

mod get_organization_config_rule_detailed_status;

mod get_organization_conformance_pack_detailed_status;

mod get_organization_custom_rule_policy;

mod get_resource_config_history;

mod get_resource_evaluation_summary;

mod get_stored_query;

mod list_aggregate_discovered_resources;

mod list_configuration_recorders;

mod list_conformance_pack_compliance_scores;

mod list_discovered_resources;

mod list_resource_evaluations;

mod list_stored_queries;

mod list_tags_for_resource;

mod put_aggregation_authorization;

mod put_config_rule;

mod put_configuration_aggregator;

mod put_configuration_recorder;

mod put_conformance_pack;

mod put_delivery_channel;

mod put_evaluations;

mod put_external_evaluation;

mod put_organization_config_rule;

mod put_organization_conformance_pack;

mod put_remediation_configurations;

mod put_remediation_exceptions;

mod put_resource_config;

mod put_retention_configuration;

mod put_service_linked_configuration_recorder;

mod put_stored_query;

mod select_aggregate_resource_config;

mod select_resource_config;

mod start_config_rules_evaluation;

mod start_configuration_recorder;

mod start_remediation_execution;

mod start_resource_evaluation;

mod stop_configuration_recorder;

mod tag_resource;

mod untag_resource;
