// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`GetDiscoveredResourceCounts`](crate::operation::get_discovered_resource_counts::builders::GetDiscoveredResourceCountsFluentBuilder) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::operation::get_discovered_resource_counts::builders::GetDiscoveredResourceCountsFluentBuilder::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_types(impl Into<String>)`](crate::operation::get_discovered_resource_counts::builders::GetDiscoveredResourceCountsFluentBuilder::resource_types) / [`set_resource_types(Option<Vec::<String>>)`](crate::operation::get_discovered_resource_counts::builders::GetDiscoveredResourceCountsFluentBuilder::set_resource_types):<br>required: **false**<br><p>The comma-separated list that specifies the resource types that you want Config to return (for example, <code>"AWS::EC2::Instance"</code>, <code>"AWS::IAM::User"</code>).</p> <p>If a value for <code>resourceTypes</code> is not specified, Config returns all resource types that Config is recording in the region for your account.</p><note>  <p>If the configuration recorder is turned off, Config returns an empty list of <code>ResourceCount</code> objects. If the configuration recorder is not recording a specific resource type (for example, S3 buckets), that resource type is not returned in the list of <code>ResourceCount</code> objects.</p> </note><br>
    ///   - [`limit(i32)`](crate::operation::get_discovered_resource_counts::builders::GetDiscoveredResourceCountsFluentBuilder::limit) / [`set_limit(Option<i32>)`](crate::operation::get_discovered_resource_counts::builders::GetDiscoveredResourceCountsFluentBuilder::set_limit):<br>required: **false**<br><p>The maximum number of <code>ResourceCount</code> objects returned on each page. The default is 100. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p><br>
    ///   - [`next_token(impl Into<String>)`](crate::operation::get_discovered_resource_counts::builders::GetDiscoveredResourceCountsFluentBuilder::next_token) / [`set_next_token(Option<String>)`](crate::operation::get_discovered_resource_counts::builders::GetDiscoveredResourceCountsFluentBuilder::set_next_token):<br>required: **false**<br><p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p><br>
    /// - On success, responds with [`GetDiscoveredResourceCountsOutput`](crate::operation::get_discovered_resource_counts::GetDiscoveredResourceCountsOutput) with field(s):
    ///   - [`total_discovered_resources(i64)`](crate::operation::get_discovered_resource_counts::GetDiscoveredResourceCountsOutput::total_discovered_resources): <p>The total number of resources that Config is recording in the region for your account. If you specify resource types in the request, Config returns only the total number of resources for those resource types.</p> <p class="title"><b>Example</b></p> <ol>  <li>   <p>Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances, 20 IAM users, and 15 S3 buckets, for a total of 60 resources.</p></li>  <li>   <p>You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify the resource type, <code>"AWS::EC2::Instances"</code>, in the request.</p></li>  <li>   <p>Config returns 25 for <code>totalDiscoveredResources</code>.</p></li> </ol>
    ///   - [`resource_counts(Option<Vec::<ResourceCount>>)`](crate::operation::get_discovered_resource_counts::GetDiscoveredResourceCountsOutput::resource_counts): <p>The list of <code>ResourceCount</code> objects. Each object is listed in descending order by the number of resources.</p>
    ///   - [`next_token(Option<String>)`](crate::operation::get_discovered_resource_counts::GetDiscoveredResourceCountsOutput::next_token): <p>The string that you use in a subsequent request to get the next page of results in a paginated response.</p>
    /// - On failure, responds with [`SdkError<GetDiscoveredResourceCountsError>`](crate::operation::get_discovered_resource_counts::GetDiscoveredResourceCountsError)
    pub fn get_discovered_resource_counts(
        &self,
    ) -> crate::operation::get_discovered_resource_counts::builders::GetDiscoveredResourceCountsFluentBuilder {
        crate::operation::get_discovered_resource_counts::builders::GetDiscoveredResourceCountsFluentBuilder::new(self.handle.clone())
    }
}
