// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`PutConformancePack`](crate::operation::put_conformance_pack::builders::PutConformancePackFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`conformance_pack_name(impl Into<String>)`](crate::operation::put_conformance_pack::builders::PutConformancePackFluentBuilder::conformance_pack_name) / [`set_conformance_pack_name(Option<String>)`](crate::operation::put_conformance_pack::builders::PutConformancePackFluentBuilder::set_conformance_pack_name):<br>required: **true**<br><p>The unique name of the conformance pack you want to deploy.</p><br>
    ///   - [`template_s3_uri(impl Into<String>)`](crate::operation::put_conformance_pack::builders::PutConformancePackFluentBuilder::template_s3_uri) / [`set_template_s3_uri(Option<String>)`](crate::operation::put_conformance_pack::builders::PutConformancePackFluentBuilder::set_template_s3_uri):<br>required: **false**<br><p>The location of the file containing the template body (<code>s3://bucketname/prefix</code>). The uri must point to a conformance pack template (max size: 300 KB) that is located in an Amazon S3 bucket in the same Region as the conformance pack.</p><note>  <p>You must have access to read Amazon S3 bucket. In addition, in order to ensure a successful deployment, the template object must not be in an <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-class-intro.html">archived storage class</a> if this parameter is passed.</p> </note><br>
    ///   - [`template_body(impl Into<String>)`](crate::operation::put_conformance_pack::builders::PutConformancePackFluentBuilder::template_body) / [`set_template_body(Option<String>)`](crate::operation::put_conformance_pack::builders::PutConformancePackFluentBuilder::set_template_body):<br>required: **false**<br><p>A string that contains the full conformance pack template body. The structure containing the template body has a minimum length of 1 byte and a maximum length of 51,200 bytes.</p><note>  <p>You can use a YAML template with two resource types: Config rule (<code>AWS::Config::ConfigRule</code>) and remediation action (<code>AWS::Config::RemediationConfiguration</code>).</p> </note><br>
    ///   - [`delivery_s3_bucket(impl Into<String>)`](crate::operation::put_conformance_pack::builders::PutConformancePackFluentBuilder::delivery_s3_bucket) / [`set_delivery_s3_bucket(Option<String>)`](crate::operation::put_conformance_pack::builders::PutConformancePackFluentBuilder::set_delivery_s3_bucket):<br>required: **false**<br><p>The name of the Amazon S3 bucket where Config stores conformance pack templates.</p><note>  <p>This field is optional.</p> </note><br>
    ///   - [`delivery_s3_key_prefix(impl Into<String>)`](crate::operation::put_conformance_pack::builders::PutConformancePackFluentBuilder::delivery_s3_key_prefix) / [`set_delivery_s3_key_prefix(Option<String>)`](crate::operation::put_conformance_pack::builders::PutConformancePackFluentBuilder::set_delivery_s3_key_prefix):<br>required: **false**<br><p>The prefix for the Amazon S3 bucket.</p><note>  <p>This field is optional.</p> </note><br>
    ///   - [`conformance_pack_input_parameters(ConformancePackInputParameter)`](crate::operation::put_conformance_pack::builders::PutConformancePackFluentBuilder::conformance_pack_input_parameters) / [`set_conformance_pack_input_parameters(Option<Vec::<ConformancePackInputParameter>>)`](crate::operation::put_conformance_pack::builders::PutConformancePackFluentBuilder::set_conformance_pack_input_parameters):<br>required: **false**<br><p>A list of <code>ConformancePackInputParameter</code> objects.</p><br>
    ///   - [`template_ssm_document_details(TemplateSsmDocumentDetails)`](crate::operation::put_conformance_pack::builders::PutConformancePackFluentBuilder::template_ssm_document_details) / [`set_template_ssm_document_details(Option<TemplateSsmDocumentDetails>)`](crate::operation::put_conformance_pack::builders::PutConformancePackFluentBuilder::set_template_ssm_document_details):<br>required: **false**<br><p>An object of type <code>TemplateSSMDocumentDetails</code>, which contains the name or the Amazon Resource Name (ARN) of the Amazon Web Services Systems Manager document (SSM document) and the version of the SSM document that is used to create a conformance pack.</p><br>
    ///   - [`tags(Tag)`](crate::operation::put_conformance_pack::builders::PutConformancePackFluentBuilder::tags) / [`set_tags(Option<Vec::<Tag>>)`](crate::operation::put_conformance_pack::builders::PutConformancePackFluentBuilder::set_tags):<br>required: **false**<br><p>The tags for the conformance pack. Each tag consists of a key and an optional value, both of which you define.</p><br>
    /// - On success, responds with [`PutConformancePackOutput`](crate::operation::put_conformance_pack::PutConformancePackOutput) with field(s):
    ///   - [`conformance_pack_arn(Option<String>)`](crate::operation::put_conformance_pack::PutConformancePackOutput::conformance_pack_arn): <p>ARN of the conformance pack.</p>
    /// - On failure, responds with [`SdkError<PutConformancePackError>`](crate::operation::put_conformance_pack::PutConformancePackError)
    pub fn put_conformance_pack(&self) -> crate::operation::put_conformance_pack::builders::PutConformancePackFluentBuilder {
        crate::operation::put_conformance_pack::builders::PutConformancePackFluentBuilder::new(self.handle.clone())
    }
}
