// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`PutOrganizationConformancePack`](crate::operation::put_organization_conformance_pack::builders::PutOrganizationConformancePackFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_conformance_pack_name(impl Into<String>)`](crate::operation::put_organization_conformance_pack::builders::PutOrganizationConformancePackFluentBuilder::organization_conformance_pack_name) / [`set_organization_conformance_pack_name(Option<String>)`](crate::operation::put_organization_conformance_pack::builders::PutOrganizationConformancePackFluentBuilder::set_organization_conformance_pack_name):<br>required: **true**<br><p>Name of the organization conformance pack you want to create.</p><br>
    ///   - [`template_s3_uri(impl Into<String>)`](crate::operation::put_organization_conformance_pack::builders::PutOrganizationConformancePackFluentBuilder::template_s3_uri) / [`set_template_s3_uri(Option<String>)`](crate::operation::put_organization_conformance_pack::builders::PutOrganizationConformancePackFluentBuilder::set_template_s3_uri):<br>required: **false**<br><p>Location of file containing the template body. The uri must point to the conformance pack template (max size: 300 KB).</p><note>  <p>You must have access to read Amazon S3 bucket. In addition, in order to ensure a successful deployment, the template object must not be in an <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-class-intro.html">archived storage class</a> if this parameter is passed.</p> </note><br>
    ///   - [`template_body(impl Into<String>)`](crate::operation::put_organization_conformance_pack::builders::PutOrganizationConformancePackFluentBuilder::template_body) / [`set_template_body(Option<String>)`](crate::operation::put_organization_conformance_pack::builders::PutOrganizationConformancePackFluentBuilder::set_template_body):<br>required: **false**<br><p>A string that contains the full conformance pack template body. Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.</p><br>
    ///   - [`delivery_s3_bucket(impl Into<String>)`](crate::operation::put_organization_conformance_pack::builders::PutOrganizationConformancePackFluentBuilder::delivery_s3_bucket) / [`set_delivery_s3_bucket(Option<String>)`](crate::operation::put_organization_conformance_pack::builders::PutOrganizationConformancePackFluentBuilder::set_delivery_s3_bucket):<br>required: **false**<br><p>The name of the Amazon S3 bucket where Config stores conformance pack templates.</p><note>  <p>This field is optional. If used, it must be prefixed with <code>awsconfigconforms</code>.</p> </note><br>
    ///   - [`delivery_s3_key_prefix(impl Into<String>)`](crate::operation::put_organization_conformance_pack::builders::PutOrganizationConformancePackFluentBuilder::delivery_s3_key_prefix) / [`set_delivery_s3_key_prefix(Option<String>)`](crate::operation::put_organization_conformance_pack::builders::PutOrganizationConformancePackFluentBuilder::set_delivery_s3_key_prefix):<br>required: **false**<br><p>The prefix for the Amazon S3 bucket.</p><note>  <p>This field is optional.</p> </note><br>
    ///   - [`conformance_pack_input_parameters(ConformancePackInputParameter)`](crate::operation::put_organization_conformance_pack::builders::PutOrganizationConformancePackFluentBuilder::conformance_pack_input_parameters) / [`set_conformance_pack_input_parameters(Option<Vec::<ConformancePackInputParameter>>)`](crate::operation::put_organization_conformance_pack::builders::PutOrganizationConformancePackFluentBuilder::set_conformance_pack_input_parameters):<br>required: **false**<br><p>A list of <code>ConformancePackInputParameter</code> objects.</p><br>
    ///   - [`excluded_accounts(impl Into<String>)`](crate::operation::put_organization_conformance_pack::builders::PutOrganizationConformancePackFluentBuilder::excluded_accounts) / [`set_excluded_accounts(Option<Vec::<String>>)`](crate::operation::put_organization_conformance_pack::builders::PutOrganizationConformancePackFluentBuilder::set_excluded_accounts):<br>required: **false**<br><p>A list of Amazon Web Services accounts to be excluded from an organization conformance pack while deploying a conformance pack.</p><br>
    /// - On success, responds with [`PutOrganizationConformancePackOutput`](crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackOutput) with field(s):
    ///   - [`organization_conformance_pack_arn(Option<String>)`](crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackOutput::organization_conformance_pack_arn): <p>ARN of the organization conformance pack.</p>
    /// - On failure, responds with [`SdkError<PutOrganizationConformancePackError>`](crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackError)
    pub fn put_organization_conformance_pack(
        &self,
    ) -> crate::operation::put_organization_conformance_pack::builders::PutOrganizationConformancePackFluentBuilder {
        crate::operation::put_organization_conformance_pack::builders::PutOrganizationConformancePackFluentBuilder::new(self.handle.clone())
    }
}
