// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(::std::fmt::Debug)]
pub enum Error {
    /// <p>For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutServiceLinkedConfigurationRecorder.html">PutServiceLinkedConfigurationRecorder</a>, you cannot create a service-linked recorder because a service-linked recorder already exists for the specified service.</p>
    /// <p>For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteServiceLinkedConfigurationRecorder.html">DeleteServiceLinkedConfigurationRecorder</a>, you cannot delete the service-linked recorder because it is currently in use by the linked Amazon Web Services service.</p>
    /// <p>For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteDeliveryChannel.html">DeleteDeliveryChannel</a>, you cannot delete the specified delivery channel because the customer managed configuration recorder is running. Use the <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_StopConfigurationRecorder.html">StopConfigurationRecorder</a> operation to stop the customer managed configuration recorder.</p>
    /// <p>For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">AssociateResourceTypes</a> and <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html">DisassociateResourceTypes</a>, one of the following errors:</p>
    /// <ul>
    /// <li>
    /// <p>For service-linked configuration recorders, the configuration recorder is not in use by the service. No association or dissociation of resource types is permitted.</p></li>
    /// <li>
    /// <p>For service-linked configuration recorders, your requested change to the configuration recorder has been denied by its linked Amazon Web Services service.</p></li>
    /// </ul>
    ConflictException(crate::types::error::ConflictException),
    /// <p>You have specified a template that is not valid or supported.</p>
    ConformancePackTemplateValidationException(crate::types::error::ConformancePackTemplateValidationException),
    /// <p>Using the same client token with one or more different parameters. Specify a new client token with the parameter changes and try again.</p>
    IdempotentParameterMismatch(crate::types::error::IdempotentParameterMismatch),
    /// <p>Your Amazon S3 bucket policy does not allow Config to write to it.</p>
    InsufficientDeliveryPolicyException(crate::types::error::InsufficientDeliveryPolicyException),
    /// <p>Indicates one of the following errors:</p>
    /// <ul>
    /// <li>
    /// <p>For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigRule.html">PutConfigRule</a>, the rule cannot be created because the IAM role assigned to Config lacks permissions to perform the config:Put* action.</p></li>
    /// <li>
    /// <p>For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigRule.html">PutConfigRule</a>, the Lambda function cannot be invoked. Check the function ARN, and check the function's permissions.</p></li>
    /// <li>
    /// <p>For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutOrganizationConfigRule.html">PutOrganizationConfigRule</a>, organization Config rule cannot be created because you do not have permissions to call IAM <code>GetRole</code> action or create a service-linked role.</p></li>
    /// <li>
    /// <p>For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutConformancePack.html">PutConformancePack</a> and <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutOrganizationConformancePack.html">PutOrganizationConformancePack</a>, a conformance pack cannot be created because you do not have the following permissions:</p>
    /// <ul>
    /// <li>
    /// <p>You do not have permission to call IAM <code>GetRole</code> action or create a service-linked role.</p></li>
    /// <li>
    /// <p>You do not have permission to read Amazon S3 bucket or call SSM:GetDocument.</p></li>
    /// </ul></li>
    /// <li>
    /// <p>For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutServiceLinkedConfigurationRecorder.html">PutServiceLinkedConfigurationRecorder</a>, a service-linked configuration recorder cannot be created because you do not have the following permissions: IAM <code>CreateServiceLinkedRole</code>.</p></li>
    /// </ul>
    InsufficientPermissionsException(crate::types::error::InsufficientPermissionsException),
    /// <p>The configuration recorder name is not valid. The prefix "<code>AWSConfigurationRecorderFor</code>" is reserved for service-linked configuration recorders.</p>
    InvalidConfigurationRecorderNameException(crate::types::error::InvalidConfigurationRecorderNameException),
    /// <p>The specified delivery channel name is not valid.</p>
    InvalidDeliveryChannelNameException(crate::types::error::InvalidDeliveryChannelNameException),
    /// <p>The syntax of the query is incorrect.</p>
    InvalidExpressionException(crate::types::error::InvalidExpressionException),
    /// <p>The specified limit is outside the allowable range.</p>
    InvalidLimitException(crate::types::error::InvalidLimitException),
    /// <p>The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::types::error::InvalidNextTokenException),
    /// <p>One or more of the specified parameters are not valid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::types::error::InvalidParameterValueException),
    /// <p>One of the following errors:</p>
    /// <ul>
    /// <li>
    /// <p>You have provided a combination of parameter values that is not valid. For example:</p>
    /// <ul>
    /// <li>
    /// <p>Setting the <code>allSupported</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> to <code>true</code>, but providing a non-empty list for the <code>resourceTypes</code>field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a>.</p></li>
    /// <li>
    /// <p>Setting the <code>allSupported</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> to <code>true</code>, but also setting the <code>useOnly</code> field of <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html">RecordingStrategy</a> to <code>EXCLUSION_BY_RESOURCE_TYPES</code>.</p></li>
    /// </ul></li>
    /// <li>
    /// <p>Every parameter is either null, false, or empty.</p></li>
    /// <li>
    /// <p>You have reached the limit of the number of resource types you can provide for the recording group.</p></li>
    /// <li>
    /// <p>You have provided resource types or a recording strategy that are not valid.</p></li>
    /// </ul>
    InvalidRecordingGroupException(crate::types::error::InvalidRecordingGroupException),
    /// <p>The specified <code>ResultToken</code> is not valid.</p>
    InvalidResultTokenException(crate::types::error::InvalidResultTokenException),
    /// <p>You have provided a null or empty Amazon Resource Name (ARN) for the IAM role assumed by Config and used by the customer managed configuration recorder.</p>
    InvalidRoleException(crate::types::error::InvalidRoleException),
    /// <p>The specified Amazon S3 key prefix is not valid.</p>
    InvalidS3KeyPrefixException(crate::types::error::InvalidS3KeyPrefixException),
    /// <p>The specified Amazon KMS Key ARN is not valid.</p>
    InvalidS3KmsKeyArnException(crate::types::error::InvalidS3KmsKeyArnException),
    /// <p>The specified Amazon SNS topic does not exist.</p>
    InvalidSnsTopicArnException(crate::types::error::InvalidSnsTopicArnException),
    /// <p>The specified time range is not valid. The earlier time is not chronologically before the later time.</p>
    InvalidTimeRangeException(crate::types::error::InvalidTimeRangeException),
    /// <p>You cannot delete the delivery channel you specified because the customer managed configuration recorder is running.</p>
    LastDeliveryChannelDeleteFailedException(crate::types::error::LastDeliveryChannelDeleteFailedException),
    /// <p>For <code>PutServiceLinkedConfigurationRecorder</code> API, this exception is thrown if the number of service-linked roles in the account exceeds the limit.</p>
    /// <p>For <code>StartConfigRulesEvaluation</code> API, this exception is thrown if an evaluation is in progress or if you call the <code>StartConfigRulesEvaluation</code> API more than once per minute.</p>
    /// <p>For <code>PutConfigurationAggregator</code> API, this exception is thrown if the number of accounts and aggregators exceeds the limit.</p>
    LimitExceededException(crate::types::error::LimitExceededException),
    /// <p>You have reached the limit of active custom resource types in your account. There is a limit of 100,000. Delete unused resources using <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteResourceConfig.html">DeleteResourceConfig</a> <code></code>.</p>
    MaxActiveResourcesExceededException(crate::types::error::MaxActiveResourcesExceededException),
    /// <p>Failed to add the Config rule because the account already contains the maximum number of 1000 rules. Consider deleting any deactivated rules before you add new rules.</p>
    MaxNumberOfConfigRulesExceededException(crate::types::error::MaxNumberOfConfigRulesExceededException),
    /// <p>You have reached the limit of the number of configuration recorders you can create.</p>
    MaxNumberOfConfigurationRecordersExceededException(crate::types::error::MaxNumberOfConfigurationRecordersExceededException),
    /// <p>You have reached the limit of the number of conformance packs you can create in an account. For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html"> <b>Service Limits</b> </a> in the <i>Config Developer Guide</i>.</p>
    MaxNumberOfConformancePacksExceededException(crate::types::error::MaxNumberOfConformancePacksExceededException),
    /// <p>You have reached the limit of the number of delivery channels you can create.</p>
    MaxNumberOfDeliveryChannelsExceededException(crate::types::error::MaxNumberOfDeliveryChannelsExceededException),
    /// <p>You have reached the limit of the number of organization Config rules you can create. For more information, see see <a href="https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html"> <b>Service Limits</b> </a> in the <i>Config Developer Guide</i>.</p>
    MaxNumberOfOrganizationConfigRulesExceededException(crate::types::error::MaxNumberOfOrganizationConfigRulesExceededException),
    /// <p>You have reached the limit of the number of organization conformance packs you can create in an account. For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html"> <b>Service Limits</b> </a> in the <i>Config Developer Guide</i>.</p>
    MaxNumberOfOrganizationConformancePacksExceededException(crate::types::error::MaxNumberOfOrganizationConformancePacksExceededException),
    /// <p>Failed to add the retention configuration because a retention configuration with that name already exists.</p>
    MaxNumberOfRetentionConfigurationsExceededException(crate::types::error::MaxNumberOfRetentionConfigurationsExceededException),
    /// <p>There are no customer managed configuration recorders available to record your resources. Use the <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigurationRecorder.html">PutConfigurationRecorder</a> operation to create the customer managed configuration recorder.</p>
    NoAvailableConfigurationRecorderException(crate::types::error::NoAvailableConfigurationRecorderException),
    /// <p>There is no delivery channel available to record configurations.</p>
    NoAvailableDeliveryChannelException(crate::types::error::NoAvailableDeliveryChannelException),
    /// <p>Organization is no longer available.</p>
    NoAvailableOrganizationException(crate::types::error::NoAvailableOrganizationException),
    /// <p>There is no configuration recorder running.</p>
    NoRunningConfigurationRecorderException(crate::types::error::NoRunningConfigurationRecorderException),
    /// <p>The specified Amazon S3 bucket does not exist.</p>
    NoSuchBucketException(crate::types::error::NoSuchBucketException),
    /// <p>The Config rule in the request is not valid. Verify that the rule is an Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.</p>
    NoSuchConfigRuleException(crate::types::error::NoSuchConfigRuleException),
    /// <p>Config rule that you passed in the filter does not exist.</p>
    NoSuchConfigRuleInConformancePackException(crate::types::error::NoSuchConfigRuleInConformancePackException),
    /// <p>You have specified a configuration aggregator that does not exist.</p>
    NoSuchConfigurationAggregatorException(crate::types::error::NoSuchConfigurationAggregatorException),
    /// <p>You have specified a configuration recorder that does not exist.</p>
    NoSuchConfigurationRecorderException(crate::types::error::NoSuchConfigurationRecorderException),
    /// <p>You specified one or more conformance packs that do not exist.</p>
    NoSuchConformancePackException(crate::types::error::NoSuchConformancePackException),
    /// <p>You have specified a delivery channel that does not exist.</p>
    NoSuchDeliveryChannelException(crate::types::error::NoSuchDeliveryChannelException),
    /// <p>The Config rule in the request is not valid. Verify that the rule is an organization Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.</p>
    NoSuchOrganizationConfigRuleException(crate::types::error::NoSuchOrganizationConfigRuleException),
    /// <p>Config organization conformance pack that you passed in the filter does not exist.</p>
    /// <p>For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not exist.</p>
    NoSuchOrganizationConformancePackException(crate::types::error::NoSuchOrganizationConformancePackException),
    /// <p>You specified an Config rule without a remediation configuration.</p>
    NoSuchRemediationConfigurationException(crate::types::error::NoSuchRemediationConfigurationException),
    /// <p>You tried to delete a remediation exception that does not exist.</p>
    NoSuchRemediationExceptionException(crate::types::error::NoSuchRemediationExceptionException),
    /// <p>You have specified a retention configuration that does not exist.</p>
    NoSuchRetentionConfigurationException(crate::types::error::NoSuchRetentionConfigurationException),
    /// <p>For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:</p>
    /// <ul>
    /// <li>
    /// <p>No permission to call <code>EnableAWSServiceAccess</code> API</p></li>
    /// <li>
    /// <p>The configuration aggregator cannot be updated because your Amazon Web Services Organization management account or the delegated administrator role changed. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p></li>
    /// <li>
    /// <p>The configuration aggregator is associated with a previous Amazon Web Services Organization and Config cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p></li>
    /// <li>
    /// <p>You are not a registered delegated administrator for Config with permissions to call <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated administrator for Config service principal name before the delegated administrator creates an aggregator.</p></li>
    /// </ul>
    /// <p>For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config throws an exception if APIs are called from member accounts. All APIs must be called from organization management account.</p>
    OrganizationAccessDeniedException(crate::types::error::OrganizationAccessDeniedException),
    /// <p>Config resource cannot be created because your organization does not have all features enabled.</p>
    OrganizationAllFeaturesNotEnabledException(crate::types::error::OrganizationAllFeaturesNotEnabledException),
    /// <p>You have specified a template that is not valid or supported.</p>
    OrganizationConformancePackTemplateValidationException(crate::types::error::OrganizationConformancePackTemplateValidationException),
    /// <p>The configuration item size is outside the allowable range.</p>
    OversizedConfigurationItemException(crate::types::error::OversizedConfigurationItemException),
    /// <p>Remediation action is in progress. You can either cancel execution in Amazon Web Services Systems Manager or wait and try again later.</p>
    RemediationInProgressException(crate::types::error::RemediationInProgressException),
    /// <p>Two users are trying to modify the same query at the same time. Wait for a moment and try again.</p>
    ResourceConcurrentModificationException(crate::types::error::ResourceConcurrentModificationException),
    /// <p>You see this exception in the following cases:</p>
    /// <ul>
    /// <li>
    /// <p>For DeleteConfigRule, Config is deleting this rule. Try your request again later.</p></li>
    /// <li>
    /// <p>For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.</p></li>
    /// <li>
    /// <p>For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this rule. Delete the remediation action associated with the rule before deleting the rule and try your request again later.</p></li>
    /// <li>
    /// <p>For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again later.</p></li>
    /// <li>
    /// <p>For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request again later.</p></li>
    /// <li>
    /// <p>For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and deletion is in progress. Try your request again later.</p></li>
    /// <li>
    /// <p>For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your request again later.</p></li>
    /// </ul>
    ResourceInUseException(crate::types::error::ResourceInUseException),
    /// <p>You have specified a resource that is either unknown or has not been discovered.</p>
    ResourceNotDiscoveredException(crate::types::error::ResourceNotDiscoveredException),
    /// <p>You have specified a resource that does not exist.</p>
    ResourceNotFoundException(crate::types::error::ResourceNotFoundException),
    /// <p>You have reached the limit of the number of tags you can use. For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html"> <b>Service Limits</b> </a> in the <i>Config Developer Guide</i>.</p>
    TooManyTagsException(crate::types::error::TooManyTagsException),
    /// <p>The requested operation is not valid.</p>
    /// <p>For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigurationRecorder.html">PutConfigurationRecorder</a>, you will see this exception because you cannot use this operation to create a service-linked configuration recorder. Use the <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutServiceLinkedConfigurationRecorder.html">PutServiceLinkedConfigurationRecorder</a> operation to create a service-linked configuration recorder.</p>
    /// <p>For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteConfigurationRecorder.html">DeleteConfigurationRecorder</a>, you will see this exception because you cannot use this operation to delete a service-linked configuration recorder. Use the <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteServiceLinkedConfigurationRecorder.html">DeleteServiceLinkedConfigurationRecorder</a> operation to delete a service-linked configuration recorder.</p>
    /// <p>For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_StartConfigurationRecorder.html">StartConfigurationRecorder</a> and <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_StopConfigurationRecorder.html">StopConfigurationRecorder</a>, you will see this exception because these operations do not affect service-linked configuration recorders. Service-linked configuration recorders are always recording. To stop recording, you must delete the service-linked configuration recorder. Use the <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteServiceLinkedConfigurationRecorder.html">DeleteServiceLinkedConfigurationRecorder</a> operation to delete a service-linked configuration recorder.</p>
    UnmodifiableEntityException(crate::types::error::UnmodifiableEntityException),
    /// <p>The requested operation is not valid. You will see this exception if there are missing required fields or if the input value fails the validation.</p>
    /// <p>For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>, one of the following errors:</p>
    /// <ul>
    /// <li>
    /// <p>There are missing required fields.</p></li>
    /// <li>
    /// <p>The input value fails the validation.</p></li>
    /// <li>
    /// <p>You are trying to create more than 300 queries.</p></li>
    /// </ul>
    /// <p>For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html">DescribeConfigurationRecorders</a> and <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html">DescribeConfigurationRecorderStatus</a>, one of the following errors:</p>
    /// <ul>
    /// <li>
    /// <p>You have specified more than one configuration recorder.</p></li>
    /// <li>
    /// <p>You have provided a service principal for service-linked configuration recorder that is not valid.</p></li>
    /// </ul>
    /// <p>For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">AssociateResourceTypes</a> and <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html">DisassociateResourceTypes</a>, one of the following errors:</p>
    /// <ul>
    /// <li>
    /// <p>Your configuraiton recorder has a recording strategy that does not allow the association or disassociation of resource types.</p></li>
    /// <li>
    /// <p>One or more of the specified resource types are already associated or disassociated with the configuration recorder.</p></li>
    /// <li>
    /// <p>For service-linked configuration recorders, the configuration recorder does not record one or more of the specified resource types.</p></li>
    /// </ul>
    ValidationException(crate::types::error::ValidationException),
    /// An unexpected error occurred (e.g., invalid JSON returned by the service or an unknown error code).
    #[deprecated(note = "Matching `Unhandled` directly is not forwards compatible. Instead, match using a \
    variable wildcard pattern and check `.code()`:
     \
    &nbsp;&nbsp;&nbsp;`err if err.code() == Some(\"SpecificExceptionCode\") => { /* handle the error */ }`
     \
    See [`ProvideErrorMetadata`](#impl-ProvideErrorMetadata-for-Error) for what information is available for the error.")]
    Unhandled(crate::error::sealed_unhandled::Unhandled),
}
impl ::std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::ConflictException(inner) => inner.fmt(f),
            Error::ConformancePackTemplateValidationException(inner) => inner.fmt(f),
            Error::IdempotentParameterMismatch(inner) => inner.fmt(f),
            Error::InsufficientDeliveryPolicyException(inner) => inner.fmt(f),
            Error::InsufficientPermissionsException(inner) => inner.fmt(f),
            Error::InvalidConfigurationRecorderNameException(inner) => inner.fmt(f),
            Error::InvalidDeliveryChannelNameException(inner) => inner.fmt(f),
            Error::InvalidExpressionException(inner) => inner.fmt(f),
            Error::InvalidLimitException(inner) => inner.fmt(f),
            Error::InvalidNextTokenException(inner) => inner.fmt(f),
            Error::InvalidParameterValueException(inner) => inner.fmt(f),
            Error::InvalidRecordingGroupException(inner) => inner.fmt(f),
            Error::InvalidResultTokenException(inner) => inner.fmt(f),
            Error::InvalidRoleException(inner) => inner.fmt(f),
            Error::InvalidS3KeyPrefixException(inner) => inner.fmt(f),
            Error::InvalidS3KmsKeyArnException(inner) => inner.fmt(f),
            Error::InvalidSnsTopicArnException(inner) => inner.fmt(f),
            Error::InvalidTimeRangeException(inner) => inner.fmt(f),
            Error::LastDeliveryChannelDeleteFailedException(inner) => inner.fmt(f),
            Error::LimitExceededException(inner) => inner.fmt(f),
            Error::MaxActiveResourcesExceededException(inner) => inner.fmt(f),
            Error::MaxNumberOfConfigRulesExceededException(inner) => inner.fmt(f),
            Error::MaxNumberOfConfigurationRecordersExceededException(inner) => inner.fmt(f),
            Error::MaxNumberOfConformancePacksExceededException(inner) => inner.fmt(f),
            Error::MaxNumberOfDeliveryChannelsExceededException(inner) => inner.fmt(f),
            Error::MaxNumberOfOrganizationConfigRulesExceededException(inner) => inner.fmt(f),
            Error::MaxNumberOfOrganizationConformancePacksExceededException(inner) => inner.fmt(f),
            Error::MaxNumberOfRetentionConfigurationsExceededException(inner) => inner.fmt(f),
            Error::NoAvailableConfigurationRecorderException(inner) => inner.fmt(f),
            Error::NoAvailableDeliveryChannelException(inner) => inner.fmt(f),
            Error::NoAvailableOrganizationException(inner) => inner.fmt(f),
            Error::NoRunningConfigurationRecorderException(inner) => inner.fmt(f),
            Error::NoSuchBucketException(inner) => inner.fmt(f),
            Error::NoSuchConfigRuleException(inner) => inner.fmt(f),
            Error::NoSuchConfigRuleInConformancePackException(inner) => inner.fmt(f),
            Error::NoSuchConfigurationAggregatorException(inner) => inner.fmt(f),
            Error::NoSuchConfigurationRecorderException(inner) => inner.fmt(f),
            Error::NoSuchConformancePackException(inner) => inner.fmt(f),
            Error::NoSuchDeliveryChannelException(inner) => inner.fmt(f),
            Error::NoSuchOrganizationConfigRuleException(inner) => inner.fmt(f),
            Error::NoSuchOrganizationConformancePackException(inner) => inner.fmt(f),
            Error::NoSuchRemediationConfigurationException(inner) => inner.fmt(f),
            Error::NoSuchRemediationExceptionException(inner) => inner.fmt(f),
            Error::NoSuchRetentionConfigurationException(inner) => inner.fmt(f),
            Error::OrganizationAccessDeniedException(inner) => inner.fmt(f),
            Error::OrganizationAllFeaturesNotEnabledException(inner) => inner.fmt(f),
            Error::OrganizationConformancePackTemplateValidationException(inner) => inner.fmt(f),
            Error::OversizedConfigurationItemException(inner) => inner.fmt(f),
            Error::RemediationInProgressException(inner) => inner.fmt(f),
            Error::ResourceConcurrentModificationException(inner) => inner.fmt(f),
            Error::ResourceInUseException(inner) => inner.fmt(f),
            Error::ResourceNotDiscoveredException(inner) => inner.fmt(f),
            Error::ResourceNotFoundException(inner) => inner.fmt(f),
            Error::TooManyTagsException(inner) => inner.fmt(f),
            Error::UnmodifiableEntityException(inner) => inner.fmt(f),
            Error::ValidationException(inner) => inner.fmt(f),
            Error::Unhandled(_) => {
                if let ::std::option::Option::Some(code) = ::aws_smithy_types::error::metadata::ProvideErrorMetadata::code(self) {
                    write!(f, "unhandled error ({code})")
                } else {
                    f.write_str("unhandled error")
                }
            }
        }
    }
}
impl From<::aws_smithy_types::error::operation::BuildError> for Error {
    fn from(value: ::aws_smithy_types::error::operation::BuildError) -> Self {
        Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
            source: value.into(),
            meta: ::std::default::Default::default(),
        })
    }
}
impl ::aws_smithy_types::error::metadata::ProvideErrorMetadata for Error {
    fn meta(&self) -> &::aws_smithy_types::error::metadata::ErrorMetadata {
        match self {
            Self::ConflictException(inner) => inner.meta(),
            Self::ConformancePackTemplateValidationException(inner) => inner.meta(),
            Self::IdempotentParameterMismatch(inner) => inner.meta(),
            Self::InsufficientDeliveryPolicyException(inner) => inner.meta(),
            Self::InsufficientPermissionsException(inner) => inner.meta(),
            Self::InvalidConfigurationRecorderNameException(inner) => inner.meta(),
            Self::InvalidDeliveryChannelNameException(inner) => inner.meta(),
            Self::InvalidExpressionException(inner) => inner.meta(),
            Self::InvalidLimitException(inner) => inner.meta(),
            Self::InvalidNextTokenException(inner) => inner.meta(),
            Self::InvalidParameterValueException(inner) => inner.meta(),
            Self::InvalidRecordingGroupException(inner) => inner.meta(),
            Self::InvalidResultTokenException(inner) => inner.meta(),
            Self::InvalidRoleException(inner) => inner.meta(),
            Self::InvalidS3KeyPrefixException(inner) => inner.meta(),
            Self::InvalidS3KmsKeyArnException(inner) => inner.meta(),
            Self::InvalidSnsTopicArnException(inner) => inner.meta(),
            Self::InvalidTimeRangeException(inner) => inner.meta(),
            Self::LastDeliveryChannelDeleteFailedException(inner) => inner.meta(),
            Self::LimitExceededException(inner) => inner.meta(),
            Self::MaxActiveResourcesExceededException(inner) => inner.meta(),
            Self::MaxNumberOfConfigRulesExceededException(inner) => inner.meta(),
            Self::MaxNumberOfConfigurationRecordersExceededException(inner) => inner.meta(),
            Self::MaxNumberOfConformancePacksExceededException(inner) => inner.meta(),
            Self::MaxNumberOfDeliveryChannelsExceededException(inner) => inner.meta(),
            Self::MaxNumberOfOrganizationConfigRulesExceededException(inner) => inner.meta(),
            Self::MaxNumberOfOrganizationConformancePacksExceededException(inner) => inner.meta(),
            Self::MaxNumberOfRetentionConfigurationsExceededException(inner) => inner.meta(),
            Self::NoAvailableConfigurationRecorderException(inner) => inner.meta(),
            Self::NoAvailableDeliveryChannelException(inner) => inner.meta(),
            Self::NoAvailableOrganizationException(inner) => inner.meta(),
            Self::NoRunningConfigurationRecorderException(inner) => inner.meta(),
            Self::NoSuchBucketException(inner) => inner.meta(),
            Self::NoSuchConfigRuleException(inner) => inner.meta(),
            Self::NoSuchConfigRuleInConformancePackException(inner) => inner.meta(),
            Self::NoSuchConfigurationAggregatorException(inner) => inner.meta(),
            Self::NoSuchConfigurationRecorderException(inner) => inner.meta(),
            Self::NoSuchConformancePackException(inner) => inner.meta(),
            Self::NoSuchDeliveryChannelException(inner) => inner.meta(),
            Self::NoSuchOrganizationConfigRuleException(inner) => inner.meta(),
            Self::NoSuchOrganizationConformancePackException(inner) => inner.meta(),
            Self::NoSuchRemediationConfigurationException(inner) => inner.meta(),
            Self::NoSuchRemediationExceptionException(inner) => inner.meta(),
            Self::NoSuchRetentionConfigurationException(inner) => inner.meta(),
            Self::OrganizationAccessDeniedException(inner) => inner.meta(),
            Self::OrganizationAllFeaturesNotEnabledException(inner) => inner.meta(),
            Self::OrganizationConformancePackTemplateValidationException(inner) => inner.meta(),
            Self::OversizedConfigurationItemException(inner) => inner.meta(),
            Self::RemediationInProgressException(inner) => inner.meta(),
            Self::ResourceConcurrentModificationException(inner) => inner.meta(),
            Self::ResourceInUseException(inner) => inner.meta(),
            Self::ResourceNotDiscoveredException(inner) => inner.meta(),
            Self::ResourceNotFoundException(inner) => inner.meta(),
            Self::TooManyTagsException(inner) => inner.meta(),
            Self::UnmodifiableEntityException(inner) => inner.meta(),
            Self::ValidationException(inner) => inner.meta(),
            Self::Unhandled(inner) => &inner.meta,
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::associate_resource_types::AssociateResourceTypesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::associate_resource_types::AssociateResourceTypesError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::associate_resource_types::AssociateResourceTypesError> for Error {
    fn from(err: crate::operation::associate_resource_types::AssociateResourceTypesError) -> Self {
        match err {
            crate::operation::associate_resource_types::AssociateResourceTypesError::ConflictException(inner) => Error::ConflictException(inner),
            crate::operation::associate_resource_types::AssociateResourceTypesError::NoSuchConfigurationRecorderException(inner) => {
                Error::NoSuchConfigurationRecorderException(inner)
            }
            crate::operation::associate_resource_types::AssociateResourceTypesError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::associate_resource_types::AssociateResourceTypesError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::batch_get_aggregate_resource_config::BatchGetAggregateResourceConfigError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::batch_get_aggregate_resource_config::BatchGetAggregateResourceConfigError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::batch_get_aggregate_resource_config::BatchGetAggregateResourceConfigError> for Error {
    fn from(err: crate::operation::batch_get_aggregate_resource_config::BatchGetAggregateResourceConfigError) -> Self {
        match err {
            crate::operation::batch_get_aggregate_resource_config::BatchGetAggregateResourceConfigError::NoSuchConfigurationAggregatorException(
                inner,
            ) => Error::NoSuchConfigurationAggregatorException(inner),
            crate::operation::batch_get_aggregate_resource_config::BatchGetAggregateResourceConfigError::ValidationException(inner) => {
                Error::ValidationException(inner)
            }
            crate::operation::batch_get_aggregate_resource_config::BatchGetAggregateResourceConfigError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::batch_get_resource_config::BatchGetResourceConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::batch_get_resource_config::BatchGetResourceConfigError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::batch_get_resource_config::BatchGetResourceConfigError> for Error {
    fn from(err: crate::operation::batch_get_resource_config::BatchGetResourceConfigError) -> Self {
        match err {
            crate::operation::batch_get_resource_config::BatchGetResourceConfigError::NoAvailableConfigurationRecorderException(inner) => {
                Error::NoAvailableConfigurationRecorderException(inner)
            }
            crate::operation::batch_get_resource_config::BatchGetResourceConfigError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::batch_get_resource_config::BatchGetResourceConfigError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_aggregation_authorization::DeleteAggregationAuthorizationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_aggregation_authorization::DeleteAggregationAuthorizationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_aggregation_authorization::DeleteAggregationAuthorizationError> for Error {
    fn from(err: crate::operation::delete_aggregation_authorization::DeleteAggregationAuthorizationError) -> Self {
        match err {
            crate::operation::delete_aggregation_authorization::DeleteAggregationAuthorizationError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::delete_aggregation_authorization::DeleteAggregationAuthorizationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_config_rule::DeleteConfigRuleError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_config_rule::DeleteConfigRuleError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_config_rule::DeleteConfigRuleError> for Error {
    fn from(err: crate::operation::delete_config_rule::DeleteConfigRuleError) -> Self {
        match err {
            crate::operation::delete_config_rule::DeleteConfigRuleError::NoSuchConfigRuleException(inner) => Error::NoSuchConfigRuleException(inner),
            crate::operation::delete_config_rule::DeleteConfigRuleError::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
            crate::operation::delete_config_rule::DeleteConfigRuleError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_configuration_aggregator::DeleteConfigurationAggregatorError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_configuration_aggregator::DeleteConfigurationAggregatorError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_configuration_aggregator::DeleteConfigurationAggregatorError> for Error {
    fn from(err: crate::operation::delete_configuration_aggregator::DeleteConfigurationAggregatorError) -> Self {
        match err {
            crate::operation::delete_configuration_aggregator::DeleteConfigurationAggregatorError::NoSuchConfigurationAggregatorException(inner) => {
                Error::NoSuchConfigurationAggregatorException(inner)
            }
            crate::operation::delete_configuration_aggregator::DeleteConfigurationAggregatorError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_configuration_recorder::DeleteConfigurationRecorderError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_configuration_recorder::DeleteConfigurationRecorderError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_configuration_recorder::DeleteConfigurationRecorderError> for Error {
    fn from(err: crate::operation::delete_configuration_recorder::DeleteConfigurationRecorderError) -> Self {
        match err {
            crate::operation::delete_configuration_recorder::DeleteConfigurationRecorderError::NoSuchConfigurationRecorderException(inner) => {
                Error::NoSuchConfigurationRecorderException(inner)
            }
            crate::operation::delete_configuration_recorder::DeleteConfigurationRecorderError::UnmodifiableEntityException(inner) => {
                Error::UnmodifiableEntityException(inner)
            }
            crate::operation::delete_configuration_recorder::DeleteConfigurationRecorderError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_conformance_pack::DeleteConformancePackError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_conformance_pack::DeleteConformancePackError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_conformance_pack::DeleteConformancePackError> for Error {
    fn from(err: crate::operation::delete_conformance_pack::DeleteConformancePackError) -> Self {
        match err {
            crate::operation::delete_conformance_pack::DeleteConformancePackError::NoSuchConformancePackException(inner) => {
                Error::NoSuchConformancePackException(inner)
            }
            crate::operation::delete_conformance_pack::DeleteConformancePackError::ResourceInUseException(inner) => {
                Error::ResourceInUseException(inner)
            }
            crate::operation::delete_conformance_pack::DeleteConformancePackError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_delivery_channel::DeleteDeliveryChannelError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_delivery_channel::DeleteDeliveryChannelError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_delivery_channel::DeleteDeliveryChannelError> for Error {
    fn from(err: crate::operation::delete_delivery_channel::DeleteDeliveryChannelError) -> Self {
        match err {
            crate::operation::delete_delivery_channel::DeleteDeliveryChannelError::LastDeliveryChannelDeleteFailedException(inner) => {
                Error::LastDeliveryChannelDeleteFailedException(inner)
            }
            crate::operation::delete_delivery_channel::DeleteDeliveryChannelError::NoSuchDeliveryChannelException(inner) => {
                Error::NoSuchDeliveryChannelException(inner)
            }
            crate::operation::delete_delivery_channel::DeleteDeliveryChannelError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_evaluation_results::DeleteEvaluationResultsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_evaluation_results::DeleteEvaluationResultsError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_evaluation_results::DeleteEvaluationResultsError> for Error {
    fn from(err: crate::operation::delete_evaluation_results::DeleteEvaluationResultsError) -> Self {
        match err {
            crate::operation::delete_evaluation_results::DeleteEvaluationResultsError::NoSuchConfigRuleException(inner) => {
                Error::NoSuchConfigRuleException(inner)
            }
            crate::operation::delete_evaluation_results::DeleteEvaluationResultsError::ResourceInUseException(inner) => {
                Error::ResourceInUseException(inner)
            }
            crate::operation::delete_evaluation_results::DeleteEvaluationResultsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_organization_config_rule::DeleteOrganizationConfigRuleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_organization_config_rule::DeleteOrganizationConfigRuleError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_organization_config_rule::DeleteOrganizationConfigRuleError> for Error {
    fn from(err: crate::operation::delete_organization_config_rule::DeleteOrganizationConfigRuleError) -> Self {
        match err {
            crate::operation::delete_organization_config_rule::DeleteOrganizationConfigRuleError::NoSuchOrganizationConfigRuleException(inner) => {
                Error::NoSuchOrganizationConfigRuleException(inner)
            }
            crate::operation::delete_organization_config_rule::DeleteOrganizationConfigRuleError::OrganizationAccessDeniedException(inner) => {
                Error::OrganizationAccessDeniedException(inner)
            }
            crate::operation::delete_organization_config_rule::DeleteOrganizationConfigRuleError::ResourceInUseException(inner) => {
                Error::ResourceInUseException(inner)
            }
            crate::operation::delete_organization_config_rule::DeleteOrganizationConfigRuleError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_organization_conformance_pack::DeleteOrganizationConformancePackError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_organization_conformance_pack::DeleteOrganizationConformancePackError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_organization_conformance_pack::DeleteOrganizationConformancePackError> for Error {
    fn from(err: crate::operation::delete_organization_conformance_pack::DeleteOrganizationConformancePackError) -> Self {
        match err {
            crate::operation::delete_organization_conformance_pack::DeleteOrganizationConformancePackError::NoSuchOrganizationConformancePackException(inner) => Error::NoSuchOrganizationConformancePackException(inner),
            crate::operation::delete_organization_conformance_pack::DeleteOrganizationConformancePackError::OrganizationAccessDeniedException(inner) => Error::OrganizationAccessDeniedException(inner),
            crate::operation::delete_organization_conformance_pack::DeleteOrganizationConformancePackError::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
            crate::operation::delete_organization_conformance_pack::DeleteOrganizationConformancePackError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_pending_aggregation_request::DeletePendingAggregationRequestError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_pending_aggregation_request::DeletePendingAggregationRequestError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_pending_aggregation_request::DeletePendingAggregationRequestError> for Error {
    fn from(err: crate::operation::delete_pending_aggregation_request::DeletePendingAggregationRequestError) -> Self {
        match err {
            crate::operation::delete_pending_aggregation_request::DeletePendingAggregationRequestError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::delete_pending_aggregation_request::DeletePendingAggregationRequestError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_remediation_configuration::DeleteRemediationConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_remediation_configuration::DeleteRemediationConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_remediation_configuration::DeleteRemediationConfigurationError> for Error {
    fn from(err: crate::operation::delete_remediation_configuration::DeleteRemediationConfigurationError) -> Self {
        match err {
            crate::operation::delete_remediation_configuration::DeleteRemediationConfigurationError::InsufficientPermissionsException(inner) => {
                Error::InsufficientPermissionsException(inner)
            }
            crate::operation::delete_remediation_configuration::DeleteRemediationConfigurationError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::delete_remediation_configuration::DeleteRemediationConfigurationError::NoSuchRemediationConfigurationException(
                inner,
            ) => Error::NoSuchRemediationConfigurationException(inner),
            crate::operation::delete_remediation_configuration::DeleteRemediationConfigurationError::RemediationInProgressException(inner) => {
                Error::RemediationInProgressException(inner)
            }
            crate::operation::delete_remediation_configuration::DeleteRemediationConfigurationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_remediation_exceptions::DeleteRemediationExceptionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_remediation_exceptions::DeleteRemediationExceptionsError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_remediation_exceptions::DeleteRemediationExceptionsError> for Error {
    fn from(err: crate::operation::delete_remediation_exceptions::DeleteRemediationExceptionsError) -> Self {
        match err {
            crate::operation::delete_remediation_exceptions::DeleteRemediationExceptionsError::NoSuchRemediationExceptionException(inner) => {
                Error::NoSuchRemediationExceptionException(inner)
            }
            crate::operation::delete_remediation_exceptions::DeleteRemediationExceptionsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_resource_config::DeleteResourceConfigError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_resource_config::DeleteResourceConfigError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_resource_config::DeleteResourceConfigError> for Error {
    fn from(err: crate::operation::delete_resource_config::DeleteResourceConfigError) -> Self {
        match err {
            crate::operation::delete_resource_config::DeleteResourceConfigError::NoRunningConfigurationRecorderException(inner) => {
                Error::NoRunningConfigurationRecorderException(inner)
            }
            crate::operation::delete_resource_config::DeleteResourceConfigError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::delete_resource_config::DeleteResourceConfigError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_retention_configuration::DeleteRetentionConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_retention_configuration::DeleteRetentionConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_retention_configuration::DeleteRetentionConfigurationError> for Error {
    fn from(err: crate::operation::delete_retention_configuration::DeleteRetentionConfigurationError) -> Self {
        match err {
            crate::operation::delete_retention_configuration::DeleteRetentionConfigurationError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::delete_retention_configuration::DeleteRetentionConfigurationError::NoSuchRetentionConfigurationException(inner) => {
                Error::NoSuchRetentionConfigurationException(inner)
            }
            crate::operation::delete_retention_configuration::DeleteRetentionConfigurationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_service_linked_configuration_recorder::DeleteServiceLinkedConfigurationRecorderError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_service_linked_configuration_recorder::DeleteServiceLinkedConfigurationRecorderError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_service_linked_configuration_recorder::DeleteServiceLinkedConfigurationRecorderError> for Error {
    fn from(err: crate::operation::delete_service_linked_configuration_recorder::DeleteServiceLinkedConfigurationRecorderError) -> Self {
        match err {
            crate::operation::delete_service_linked_configuration_recorder::DeleteServiceLinkedConfigurationRecorderError::ConflictException(inner) => Error::ConflictException(inner),
            crate::operation::delete_service_linked_configuration_recorder::DeleteServiceLinkedConfigurationRecorderError::NoSuchConfigurationRecorderException(inner) => Error::NoSuchConfigurationRecorderException(inner),
            crate::operation::delete_service_linked_configuration_recorder::DeleteServiceLinkedConfigurationRecorderError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::delete_service_linked_configuration_recorder::DeleteServiceLinkedConfigurationRecorderError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_stored_query::DeleteStoredQueryError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_stored_query::DeleteStoredQueryError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_stored_query::DeleteStoredQueryError> for Error {
    fn from(err: crate::operation::delete_stored_query::DeleteStoredQueryError) -> Self {
        match err {
            crate::operation::delete_stored_query::DeleteStoredQueryError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::delete_stored_query::DeleteStoredQueryError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::delete_stored_query::DeleteStoredQueryError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::deliver_config_snapshot::DeliverConfigSnapshotError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::deliver_config_snapshot::DeliverConfigSnapshotError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::deliver_config_snapshot::DeliverConfigSnapshotError> for Error {
    fn from(err: crate::operation::deliver_config_snapshot::DeliverConfigSnapshotError) -> Self {
        match err {
            crate::operation::deliver_config_snapshot::DeliverConfigSnapshotError::NoAvailableConfigurationRecorderException(inner) => {
                Error::NoAvailableConfigurationRecorderException(inner)
            }
            crate::operation::deliver_config_snapshot::DeliverConfigSnapshotError::NoRunningConfigurationRecorderException(inner) => {
                Error::NoRunningConfigurationRecorderException(inner)
            }
            crate::operation::deliver_config_snapshot::DeliverConfigSnapshotError::NoSuchDeliveryChannelException(inner) => {
                Error::NoSuchDeliveryChannelException(inner)
            }
            crate::operation::deliver_config_snapshot::DeliverConfigSnapshotError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_aggregate_compliance_by_config_rules::DescribeAggregateComplianceByConfigRulesError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_aggregate_compliance_by_config_rules::DescribeAggregateComplianceByConfigRulesError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_aggregate_compliance_by_config_rules::DescribeAggregateComplianceByConfigRulesError> for Error {
    fn from(err: crate::operation::describe_aggregate_compliance_by_config_rules::DescribeAggregateComplianceByConfigRulesError) -> Self {
        match err {
            crate::operation::describe_aggregate_compliance_by_config_rules::DescribeAggregateComplianceByConfigRulesError::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
            crate::operation::describe_aggregate_compliance_by_config_rules::DescribeAggregateComplianceByConfigRulesError::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
            crate::operation::describe_aggregate_compliance_by_config_rules::DescribeAggregateComplianceByConfigRulesError::NoSuchConfigurationAggregatorException(inner) => Error::NoSuchConfigurationAggregatorException(inner),
            crate::operation::describe_aggregate_compliance_by_config_rules::DescribeAggregateComplianceByConfigRulesError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::describe_aggregate_compliance_by_config_rules::DescribeAggregateComplianceByConfigRulesError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_aggregate_compliance_by_conformance_packs::DescribeAggregateComplianceByConformancePacksError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_aggregate_compliance_by_conformance_packs::DescribeAggregateComplianceByConformancePacksError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_aggregate_compliance_by_conformance_packs::DescribeAggregateComplianceByConformancePacksError> for Error {
    fn from(err: crate::operation::describe_aggregate_compliance_by_conformance_packs::DescribeAggregateComplianceByConformancePacksError) -> Self {
        match err {
            crate::operation::describe_aggregate_compliance_by_conformance_packs::DescribeAggregateComplianceByConformancePacksError::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
            crate::operation::describe_aggregate_compliance_by_conformance_packs::DescribeAggregateComplianceByConformancePacksError::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
            crate::operation::describe_aggregate_compliance_by_conformance_packs::DescribeAggregateComplianceByConformancePacksError::NoSuchConfigurationAggregatorException(inner) => Error::NoSuchConfigurationAggregatorException(inner),
            crate::operation::describe_aggregate_compliance_by_conformance_packs::DescribeAggregateComplianceByConformancePacksError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::describe_aggregate_compliance_by_conformance_packs::DescribeAggregateComplianceByConformancePacksError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_aggregation_authorizations::DescribeAggregationAuthorizationsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_aggregation_authorizations::DescribeAggregationAuthorizationsError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_aggregation_authorizations::DescribeAggregationAuthorizationsError> for Error {
    fn from(err: crate::operation::describe_aggregation_authorizations::DescribeAggregationAuthorizationsError) -> Self {
        match err {
            crate::operation::describe_aggregation_authorizations::DescribeAggregationAuthorizationsError::InvalidLimitException(inner) => {
                Error::InvalidLimitException(inner)
            }
            crate::operation::describe_aggregation_authorizations::DescribeAggregationAuthorizationsError::InvalidNextTokenException(inner) => {
                Error::InvalidNextTokenException(inner)
            }
            crate::operation::describe_aggregation_authorizations::DescribeAggregationAuthorizationsError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::describe_aggregation_authorizations::DescribeAggregationAuthorizationsError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_compliance_by_config_rule::DescribeComplianceByConfigRuleError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_compliance_by_config_rule::DescribeComplianceByConfigRuleError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_compliance_by_config_rule::DescribeComplianceByConfigRuleError> for Error {
    fn from(err: crate::operation::describe_compliance_by_config_rule::DescribeComplianceByConfigRuleError) -> Self {
        match err {
            crate::operation::describe_compliance_by_config_rule::DescribeComplianceByConfigRuleError::InvalidNextTokenException(inner) => {
                Error::InvalidNextTokenException(inner)
            }
            crate::operation::describe_compliance_by_config_rule::DescribeComplianceByConfigRuleError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::describe_compliance_by_config_rule::DescribeComplianceByConfigRuleError::NoSuchConfigRuleException(inner) => {
                Error::NoSuchConfigRuleException(inner)
            }
            crate::operation::describe_compliance_by_config_rule::DescribeComplianceByConfigRuleError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::describe_compliance_by_resource::DescribeComplianceByResourceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_compliance_by_resource::DescribeComplianceByResourceError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_compliance_by_resource::DescribeComplianceByResourceError> for Error {
    fn from(err: crate::operation::describe_compliance_by_resource::DescribeComplianceByResourceError) -> Self {
        match err {
            crate::operation::describe_compliance_by_resource::DescribeComplianceByResourceError::InvalidNextTokenException(inner) => {
                Error::InvalidNextTokenException(inner)
            }
            crate::operation::describe_compliance_by_resource::DescribeComplianceByResourceError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::describe_compliance_by_resource::DescribeComplianceByResourceError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_config_rule_evaluation_status::DescribeConfigRuleEvaluationStatusError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_config_rule_evaluation_status::DescribeConfigRuleEvaluationStatusError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_config_rule_evaluation_status::DescribeConfigRuleEvaluationStatusError> for Error {
    fn from(err: crate::operation::describe_config_rule_evaluation_status::DescribeConfigRuleEvaluationStatusError) -> Self {
        match err {
            crate::operation::describe_config_rule_evaluation_status::DescribeConfigRuleEvaluationStatusError::InvalidNextTokenException(inner) => {
                Error::InvalidNextTokenException(inner)
            }
            crate::operation::describe_config_rule_evaluation_status::DescribeConfigRuleEvaluationStatusError::InvalidParameterValueException(
                inner,
            ) => Error::InvalidParameterValueException(inner),
            crate::operation::describe_config_rule_evaluation_status::DescribeConfigRuleEvaluationStatusError::NoSuchConfigRuleException(inner) => {
                Error::NoSuchConfigRuleException(inner)
            }
            crate::operation::describe_config_rule_evaluation_status::DescribeConfigRuleEvaluationStatusError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::describe_config_rules::DescribeConfigRulesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::describe_config_rules::DescribeConfigRulesError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_config_rules::DescribeConfigRulesError> for Error {
    fn from(err: crate::operation::describe_config_rules::DescribeConfigRulesError) -> Self {
        match err {
            crate::operation::describe_config_rules::DescribeConfigRulesError::InvalidNextTokenException(inner) => {
                Error::InvalidNextTokenException(inner)
            }
            crate::operation::describe_config_rules::DescribeConfigRulesError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::describe_config_rules::DescribeConfigRulesError::NoSuchConfigRuleException(inner) => {
                Error::NoSuchConfigRuleException(inner)
            }
            crate::operation::describe_config_rules::DescribeConfigRulesError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_configuration_aggregators::DescribeConfigurationAggregatorsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_configuration_aggregators::DescribeConfigurationAggregatorsError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_configuration_aggregators::DescribeConfigurationAggregatorsError> for Error {
    fn from(err: crate::operation::describe_configuration_aggregators::DescribeConfigurationAggregatorsError) -> Self {
        match err {
            crate::operation::describe_configuration_aggregators::DescribeConfigurationAggregatorsError::InvalidLimitException(inner) => {
                Error::InvalidLimitException(inner)
            }
            crate::operation::describe_configuration_aggregators::DescribeConfigurationAggregatorsError::InvalidNextTokenException(inner) => {
                Error::InvalidNextTokenException(inner)
            }
            crate::operation::describe_configuration_aggregators::DescribeConfigurationAggregatorsError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::describe_configuration_aggregators::DescribeConfigurationAggregatorsError::NoSuchConfigurationAggregatorException(
                inner,
            ) => Error::NoSuchConfigurationAggregatorException(inner),
            crate::operation::describe_configuration_aggregators::DescribeConfigurationAggregatorsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_configuration_aggregator_sources_status::DescribeConfigurationAggregatorSourcesStatusError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_configuration_aggregator_sources_status::DescribeConfigurationAggregatorSourcesStatusError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_configuration_aggregator_sources_status::DescribeConfigurationAggregatorSourcesStatusError> for Error {
    fn from(err: crate::operation::describe_configuration_aggregator_sources_status::DescribeConfigurationAggregatorSourcesStatusError) -> Self {
        match err {
            crate::operation::describe_configuration_aggregator_sources_status::DescribeConfigurationAggregatorSourcesStatusError::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
            crate::operation::describe_configuration_aggregator_sources_status::DescribeConfigurationAggregatorSourcesStatusError::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
            crate::operation::describe_configuration_aggregator_sources_status::DescribeConfigurationAggregatorSourcesStatusError::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
            crate::operation::describe_configuration_aggregator_sources_status::DescribeConfigurationAggregatorSourcesStatusError::NoSuchConfigurationAggregatorException(inner) => Error::NoSuchConfigurationAggregatorException(inner),
            crate::operation::describe_configuration_aggregator_sources_status::DescribeConfigurationAggregatorSourcesStatusError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_configuration_recorders::DescribeConfigurationRecordersError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_configuration_recorders::DescribeConfigurationRecordersError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_configuration_recorders::DescribeConfigurationRecordersError> for Error {
    fn from(err: crate::operation::describe_configuration_recorders::DescribeConfigurationRecordersError) -> Self {
        match err {
            crate::operation::describe_configuration_recorders::DescribeConfigurationRecordersError::NoSuchConfigurationRecorderException(inner) => {
                Error::NoSuchConfigurationRecorderException(inner)
            }
            crate::operation::describe_configuration_recorders::DescribeConfigurationRecordersError::ValidationException(inner) => {
                Error::ValidationException(inner)
            }
            crate::operation::describe_configuration_recorders::DescribeConfigurationRecordersError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_configuration_recorder_status::DescribeConfigurationRecorderStatusError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_configuration_recorder_status::DescribeConfigurationRecorderStatusError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_configuration_recorder_status::DescribeConfigurationRecorderStatusError> for Error {
    fn from(err: crate::operation::describe_configuration_recorder_status::DescribeConfigurationRecorderStatusError) -> Self {
        match err {
            crate::operation::describe_configuration_recorder_status::DescribeConfigurationRecorderStatusError::NoSuchConfigurationRecorderException(inner) => Error::NoSuchConfigurationRecorderException(inner),
            crate::operation::describe_configuration_recorder_status::DescribeConfigurationRecorderStatusError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::describe_configuration_recorder_status::DescribeConfigurationRecorderStatusError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_conformance_pack_compliance::DescribeConformancePackComplianceError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_conformance_pack_compliance::DescribeConformancePackComplianceError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_conformance_pack_compliance::DescribeConformancePackComplianceError> for Error {
    fn from(err: crate::operation::describe_conformance_pack_compliance::DescribeConformancePackComplianceError) -> Self {
        match err {
            crate::operation::describe_conformance_pack_compliance::DescribeConformancePackComplianceError::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
            crate::operation::describe_conformance_pack_compliance::DescribeConformancePackComplianceError::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
            crate::operation::describe_conformance_pack_compliance::DescribeConformancePackComplianceError::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
            crate::operation::describe_conformance_pack_compliance::DescribeConformancePackComplianceError::NoSuchConfigRuleInConformancePackException(inner) => Error::NoSuchConfigRuleInConformancePackException(inner),
            crate::operation::describe_conformance_pack_compliance::DescribeConformancePackComplianceError::NoSuchConformancePackException(inner) => Error::NoSuchConformancePackException(inner),
            crate::operation::describe_conformance_pack_compliance::DescribeConformancePackComplianceError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::describe_conformance_packs::DescribeConformancePacksError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::describe_conformance_packs::DescribeConformancePacksError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_conformance_packs::DescribeConformancePacksError> for Error {
    fn from(err: crate::operation::describe_conformance_packs::DescribeConformancePacksError) -> Self {
        match err {
            crate::operation::describe_conformance_packs::DescribeConformancePacksError::InvalidLimitException(inner) => {
                Error::InvalidLimitException(inner)
            }
            crate::operation::describe_conformance_packs::DescribeConformancePacksError::InvalidNextTokenException(inner) => {
                Error::InvalidNextTokenException(inner)
            }
            crate::operation::describe_conformance_packs::DescribeConformancePacksError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::describe_conformance_packs::DescribeConformancePacksError::NoSuchConformancePackException(inner) => {
                Error::NoSuchConformancePackException(inner)
            }
            crate::operation::describe_conformance_packs::DescribeConformancePacksError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::describe_conformance_pack_status::DescribeConformancePackStatusError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_conformance_pack_status::DescribeConformancePackStatusError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_conformance_pack_status::DescribeConformancePackStatusError> for Error {
    fn from(err: crate::operation::describe_conformance_pack_status::DescribeConformancePackStatusError) -> Self {
        match err {
            crate::operation::describe_conformance_pack_status::DescribeConformancePackStatusError::InvalidLimitException(inner) => {
                Error::InvalidLimitException(inner)
            }
            crate::operation::describe_conformance_pack_status::DescribeConformancePackStatusError::InvalidNextTokenException(inner) => {
                Error::InvalidNextTokenException(inner)
            }
            crate::operation::describe_conformance_pack_status::DescribeConformancePackStatusError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::describe_conformance_pack_status::DescribeConformancePackStatusError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::describe_delivery_channels::DescribeDeliveryChannelsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::describe_delivery_channels::DescribeDeliveryChannelsError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_delivery_channels::DescribeDeliveryChannelsError> for Error {
    fn from(err: crate::operation::describe_delivery_channels::DescribeDeliveryChannelsError) -> Self {
        match err {
            crate::operation::describe_delivery_channels::DescribeDeliveryChannelsError::NoSuchDeliveryChannelException(inner) => {
                Error::NoSuchDeliveryChannelException(inner)
            }
            crate::operation::describe_delivery_channels::DescribeDeliveryChannelsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::describe_delivery_channel_status::DescribeDeliveryChannelStatusError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_delivery_channel_status::DescribeDeliveryChannelStatusError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_delivery_channel_status::DescribeDeliveryChannelStatusError> for Error {
    fn from(err: crate::operation::describe_delivery_channel_status::DescribeDeliveryChannelStatusError) -> Self {
        match err {
            crate::operation::describe_delivery_channel_status::DescribeDeliveryChannelStatusError::NoSuchDeliveryChannelException(inner) => {
                Error::NoSuchDeliveryChannelException(inner)
            }
            crate::operation::describe_delivery_channel_status::DescribeDeliveryChannelStatusError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_organization_config_rules::DescribeOrganizationConfigRulesError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_organization_config_rules::DescribeOrganizationConfigRulesError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_organization_config_rules::DescribeOrganizationConfigRulesError> for Error {
    fn from(err: crate::operation::describe_organization_config_rules::DescribeOrganizationConfigRulesError) -> Self {
        match err {
            crate::operation::describe_organization_config_rules::DescribeOrganizationConfigRulesError::InvalidLimitException(inner) => {
                Error::InvalidLimitException(inner)
            }
            crate::operation::describe_organization_config_rules::DescribeOrganizationConfigRulesError::InvalidNextTokenException(inner) => {
                Error::InvalidNextTokenException(inner)
            }
            crate::operation::describe_organization_config_rules::DescribeOrganizationConfigRulesError::NoSuchOrganizationConfigRuleException(
                inner,
            ) => Error::NoSuchOrganizationConfigRuleException(inner),
            crate::operation::describe_organization_config_rules::DescribeOrganizationConfigRulesError::OrganizationAccessDeniedException(inner) => {
                Error::OrganizationAccessDeniedException(inner)
            }
            crate::operation::describe_organization_config_rules::DescribeOrganizationConfigRulesError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_organization_config_rule_statuses::DescribeOrganizationConfigRuleStatusesError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_organization_config_rule_statuses::DescribeOrganizationConfigRuleStatusesError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_organization_config_rule_statuses::DescribeOrganizationConfigRuleStatusesError> for Error {
    fn from(err: crate::operation::describe_organization_config_rule_statuses::DescribeOrganizationConfigRuleStatusesError) -> Self {
        match err {
            crate::operation::describe_organization_config_rule_statuses::DescribeOrganizationConfigRuleStatusesError::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
            crate::operation::describe_organization_config_rule_statuses::DescribeOrganizationConfigRuleStatusesError::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
            crate::operation::describe_organization_config_rule_statuses::DescribeOrganizationConfigRuleStatusesError::NoSuchOrganizationConfigRuleException(inner) => Error::NoSuchOrganizationConfigRuleException(inner),
            crate::operation::describe_organization_config_rule_statuses::DescribeOrganizationConfigRuleStatusesError::OrganizationAccessDeniedException(inner) => Error::OrganizationAccessDeniedException(inner),
            crate::operation::describe_organization_config_rule_statuses::DescribeOrganizationConfigRuleStatusesError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_organization_conformance_packs::DescribeOrganizationConformancePacksError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_organization_conformance_packs::DescribeOrganizationConformancePacksError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_organization_conformance_packs::DescribeOrganizationConformancePacksError> for Error {
    fn from(err: crate::operation::describe_organization_conformance_packs::DescribeOrganizationConformancePacksError) -> Self {
        match err {
            crate::operation::describe_organization_conformance_packs::DescribeOrganizationConformancePacksError::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
            crate::operation::describe_organization_conformance_packs::DescribeOrganizationConformancePacksError::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
            crate::operation::describe_organization_conformance_packs::DescribeOrganizationConformancePacksError::NoSuchOrganizationConformancePackException(inner) => Error::NoSuchOrganizationConformancePackException(inner),
            crate::operation::describe_organization_conformance_packs::DescribeOrganizationConformancePacksError::OrganizationAccessDeniedException(inner) => Error::OrganizationAccessDeniedException(inner),
            crate::operation::describe_organization_conformance_packs::DescribeOrganizationConformancePacksError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_organization_conformance_pack_statuses::DescribeOrganizationConformancePackStatusesError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_organization_conformance_pack_statuses::DescribeOrganizationConformancePackStatusesError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_organization_conformance_pack_statuses::DescribeOrganizationConformancePackStatusesError> for Error {
    fn from(err: crate::operation::describe_organization_conformance_pack_statuses::DescribeOrganizationConformancePackStatusesError) -> Self {
        match err {
            crate::operation::describe_organization_conformance_pack_statuses::DescribeOrganizationConformancePackStatusesError::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
            crate::operation::describe_organization_conformance_pack_statuses::DescribeOrganizationConformancePackStatusesError::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
            crate::operation::describe_organization_conformance_pack_statuses::DescribeOrganizationConformancePackStatusesError::NoSuchOrganizationConformancePackException(inner) => Error::NoSuchOrganizationConformancePackException(inner),
            crate::operation::describe_organization_conformance_pack_statuses::DescribeOrganizationConformancePackStatusesError::OrganizationAccessDeniedException(inner) => Error::OrganizationAccessDeniedException(inner),
            crate::operation::describe_organization_conformance_pack_statuses::DescribeOrganizationConformancePackStatusesError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_pending_aggregation_requests::DescribePendingAggregationRequestsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_pending_aggregation_requests::DescribePendingAggregationRequestsError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_pending_aggregation_requests::DescribePendingAggregationRequestsError> for Error {
    fn from(err: crate::operation::describe_pending_aggregation_requests::DescribePendingAggregationRequestsError) -> Self {
        match err {
            crate::operation::describe_pending_aggregation_requests::DescribePendingAggregationRequestsError::InvalidLimitException(inner) => {
                Error::InvalidLimitException(inner)
            }
            crate::operation::describe_pending_aggregation_requests::DescribePendingAggregationRequestsError::InvalidNextTokenException(inner) => {
                Error::InvalidNextTokenException(inner)
            }
            crate::operation::describe_pending_aggregation_requests::DescribePendingAggregationRequestsError::InvalidParameterValueException(
                inner,
            ) => Error::InvalidParameterValueException(inner),
            crate::operation::describe_pending_aggregation_requests::DescribePendingAggregationRequestsError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_remediation_configurations::DescribeRemediationConfigurationsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_remediation_configurations::DescribeRemediationConfigurationsError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_remediation_configurations::DescribeRemediationConfigurationsError> for Error {
    fn from(err: crate::operation::describe_remediation_configurations::DescribeRemediationConfigurationsError) -> Self {
        match err {
            crate::operation::describe_remediation_configurations::DescribeRemediationConfigurationsError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R>
    From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::describe_remediation_exceptions::DescribeRemediationExceptionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_remediation_exceptions::DescribeRemediationExceptionsError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_remediation_exceptions::DescribeRemediationExceptionsError> for Error {
    fn from(err: crate::operation::describe_remediation_exceptions::DescribeRemediationExceptionsError) -> Self {
        match err {
            crate::operation::describe_remediation_exceptions::DescribeRemediationExceptionsError::InvalidNextTokenException(inner) => {
                Error::InvalidNextTokenException(inner)
            }
            crate::operation::describe_remediation_exceptions::DescribeRemediationExceptionsError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::describe_remediation_exceptions::DescribeRemediationExceptionsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_remediation_execution_status::DescribeRemediationExecutionStatusError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_remediation_execution_status::DescribeRemediationExecutionStatusError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_remediation_execution_status::DescribeRemediationExecutionStatusError> for Error {
    fn from(err: crate::operation::describe_remediation_execution_status::DescribeRemediationExecutionStatusError) -> Self {
        match err {
            crate::operation::describe_remediation_execution_status::DescribeRemediationExecutionStatusError::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
            crate::operation::describe_remediation_execution_status::DescribeRemediationExecutionStatusError::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
            crate::operation::describe_remediation_execution_status::DescribeRemediationExecutionStatusError::NoSuchRemediationConfigurationException(inner) => Error::NoSuchRemediationConfigurationException(inner),
            crate::operation::describe_remediation_execution_status::DescribeRemediationExecutionStatusError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_retention_configurations::DescribeRetentionConfigurationsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_retention_configurations::DescribeRetentionConfigurationsError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_retention_configurations::DescribeRetentionConfigurationsError> for Error {
    fn from(err: crate::operation::describe_retention_configurations::DescribeRetentionConfigurationsError) -> Self {
        match err {
            crate::operation::describe_retention_configurations::DescribeRetentionConfigurationsError::InvalidNextTokenException(inner) => {
                Error::InvalidNextTokenException(inner)
            }
            crate::operation::describe_retention_configurations::DescribeRetentionConfigurationsError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::describe_retention_configurations::DescribeRetentionConfigurationsError::NoSuchRetentionConfigurationException(
                inner,
            ) => Error::NoSuchRetentionConfigurationException(inner),
            crate::operation::describe_retention_configurations::DescribeRetentionConfigurationsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::disassociate_resource_types::DisassociateResourceTypesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::disassociate_resource_types::DisassociateResourceTypesError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::disassociate_resource_types::DisassociateResourceTypesError> for Error {
    fn from(err: crate::operation::disassociate_resource_types::DisassociateResourceTypesError) -> Self {
        match err {
            crate::operation::disassociate_resource_types::DisassociateResourceTypesError::ConflictException(inner) => {
                Error::ConflictException(inner)
            }
            crate::operation::disassociate_resource_types::DisassociateResourceTypesError::NoSuchConfigurationRecorderException(inner) => {
                Error::NoSuchConfigurationRecorderException(inner)
            }
            crate::operation::disassociate_resource_types::DisassociateResourceTypesError::ValidationException(inner) => {
                Error::ValidationException(inner)
            }
            crate::operation::disassociate_resource_types::DisassociateResourceTypesError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_aggregate_compliance_details_by_config_rule::GetAggregateComplianceDetailsByConfigRuleError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_aggregate_compliance_details_by_config_rule::GetAggregateComplianceDetailsByConfigRuleError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_aggregate_compliance_details_by_config_rule::GetAggregateComplianceDetailsByConfigRuleError> for Error {
    fn from(err: crate::operation::get_aggregate_compliance_details_by_config_rule::GetAggregateComplianceDetailsByConfigRuleError) -> Self {
        match err {
            crate::operation::get_aggregate_compliance_details_by_config_rule::GetAggregateComplianceDetailsByConfigRuleError::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
            crate::operation::get_aggregate_compliance_details_by_config_rule::GetAggregateComplianceDetailsByConfigRuleError::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
            crate::operation::get_aggregate_compliance_details_by_config_rule::GetAggregateComplianceDetailsByConfigRuleError::NoSuchConfigurationAggregatorException(inner) => Error::NoSuchConfigurationAggregatorException(inner),
            crate::operation::get_aggregate_compliance_details_by_config_rule::GetAggregateComplianceDetailsByConfigRuleError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::get_aggregate_compliance_details_by_config_rule::GetAggregateComplianceDetailsByConfigRuleError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_aggregate_config_rule_compliance_summary::GetAggregateConfigRuleComplianceSummaryError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_aggregate_config_rule_compliance_summary::GetAggregateConfigRuleComplianceSummaryError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_aggregate_config_rule_compliance_summary::GetAggregateConfigRuleComplianceSummaryError> for Error {
    fn from(err: crate::operation::get_aggregate_config_rule_compliance_summary::GetAggregateConfigRuleComplianceSummaryError) -> Self {
        match err {
            crate::operation::get_aggregate_config_rule_compliance_summary::GetAggregateConfigRuleComplianceSummaryError::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
            crate::operation::get_aggregate_config_rule_compliance_summary::GetAggregateConfigRuleComplianceSummaryError::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
            crate::operation::get_aggregate_config_rule_compliance_summary::GetAggregateConfigRuleComplianceSummaryError::NoSuchConfigurationAggregatorException(inner) => Error::NoSuchConfigurationAggregatorException(inner),
            crate::operation::get_aggregate_config_rule_compliance_summary::GetAggregateConfigRuleComplianceSummaryError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::get_aggregate_config_rule_compliance_summary::GetAggregateConfigRuleComplianceSummaryError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_aggregate_conformance_pack_compliance_summary::GetAggregateConformancePackComplianceSummaryError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_aggregate_conformance_pack_compliance_summary::GetAggregateConformancePackComplianceSummaryError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_aggregate_conformance_pack_compliance_summary::GetAggregateConformancePackComplianceSummaryError> for Error {
    fn from(err: crate::operation::get_aggregate_conformance_pack_compliance_summary::GetAggregateConformancePackComplianceSummaryError) -> Self {
        match err {
            crate::operation::get_aggregate_conformance_pack_compliance_summary::GetAggregateConformancePackComplianceSummaryError::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
            crate::operation::get_aggregate_conformance_pack_compliance_summary::GetAggregateConformancePackComplianceSummaryError::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
            crate::operation::get_aggregate_conformance_pack_compliance_summary::GetAggregateConformancePackComplianceSummaryError::NoSuchConfigurationAggregatorException(inner) => Error::NoSuchConfigurationAggregatorException(inner),
            crate::operation::get_aggregate_conformance_pack_compliance_summary::GetAggregateConformancePackComplianceSummaryError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::get_aggregate_conformance_pack_compliance_summary::GetAggregateConformancePackComplianceSummaryError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_aggregate_discovered_resource_counts::GetAggregateDiscoveredResourceCountsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_aggregate_discovered_resource_counts::GetAggregateDiscoveredResourceCountsError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_aggregate_discovered_resource_counts::GetAggregateDiscoveredResourceCountsError> for Error {
    fn from(err: crate::operation::get_aggregate_discovered_resource_counts::GetAggregateDiscoveredResourceCountsError) -> Self {
        match err {
            crate::operation::get_aggregate_discovered_resource_counts::GetAggregateDiscoveredResourceCountsError::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
            crate::operation::get_aggregate_discovered_resource_counts::GetAggregateDiscoveredResourceCountsError::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
            crate::operation::get_aggregate_discovered_resource_counts::GetAggregateDiscoveredResourceCountsError::NoSuchConfigurationAggregatorException(inner) => Error::NoSuchConfigurationAggregatorException(inner),
            crate::operation::get_aggregate_discovered_resource_counts::GetAggregateDiscoveredResourceCountsError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::get_aggregate_discovered_resource_counts::GetAggregateDiscoveredResourceCountsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_aggregate_resource_config::GetAggregateResourceConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_aggregate_resource_config::GetAggregateResourceConfigError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_aggregate_resource_config::GetAggregateResourceConfigError> for Error {
    fn from(err: crate::operation::get_aggregate_resource_config::GetAggregateResourceConfigError) -> Self {
        match err {
            crate::operation::get_aggregate_resource_config::GetAggregateResourceConfigError::NoSuchConfigurationAggregatorException(inner) => {
                Error::NoSuchConfigurationAggregatorException(inner)
            }
            crate::operation::get_aggregate_resource_config::GetAggregateResourceConfigError::OversizedConfigurationItemException(inner) => {
                Error::OversizedConfigurationItemException(inner)
            }
            crate::operation::get_aggregate_resource_config::GetAggregateResourceConfigError::ResourceNotDiscoveredException(inner) => {
                Error::ResourceNotDiscoveredException(inner)
            }
            crate::operation::get_aggregate_resource_config::GetAggregateResourceConfigError::ValidationException(inner) => {
                Error::ValidationException(inner)
            }
            crate::operation::get_aggregate_resource_config::GetAggregateResourceConfigError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_compliance_details_by_config_rule::GetComplianceDetailsByConfigRuleError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_compliance_details_by_config_rule::GetComplianceDetailsByConfigRuleError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_compliance_details_by_config_rule::GetComplianceDetailsByConfigRuleError> for Error {
    fn from(err: crate::operation::get_compliance_details_by_config_rule::GetComplianceDetailsByConfigRuleError) -> Self {
        match err {
            crate::operation::get_compliance_details_by_config_rule::GetComplianceDetailsByConfigRuleError::InvalidNextTokenException(inner) => {
                Error::InvalidNextTokenException(inner)
            }
            crate::operation::get_compliance_details_by_config_rule::GetComplianceDetailsByConfigRuleError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::get_compliance_details_by_config_rule::GetComplianceDetailsByConfigRuleError::NoSuchConfigRuleException(inner) => {
                Error::NoSuchConfigRuleException(inner)
            }
            crate::operation::get_compliance_details_by_config_rule::GetComplianceDetailsByConfigRuleError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_compliance_details_by_resource::GetComplianceDetailsByResourceError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_compliance_details_by_resource::GetComplianceDetailsByResourceError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_compliance_details_by_resource::GetComplianceDetailsByResourceError> for Error {
    fn from(err: crate::operation::get_compliance_details_by_resource::GetComplianceDetailsByResourceError) -> Self {
        match err {
            crate::operation::get_compliance_details_by_resource::GetComplianceDetailsByResourceError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::get_compliance_details_by_resource::GetComplianceDetailsByResourceError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_compliance_summary_by_config_rule::GetComplianceSummaryByConfigRuleError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_compliance_summary_by_config_rule::GetComplianceSummaryByConfigRuleError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_compliance_summary_by_config_rule::GetComplianceSummaryByConfigRuleError> for Error {
    fn from(err: crate::operation::get_compliance_summary_by_config_rule::GetComplianceSummaryByConfigRuleError) -> Self {
        match err {
            crate::operation::get_compliance_summary_by_config_rule::GetComplianceSummaryByConfigRuleError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_compliance_summary_by_resource_type::GetComplianceSummaryByResourceTypeError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_compliance_summary_by_resource_type::GetComplianceSummaryByResourceTypeError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_compliance_summary_by_resource_type::GetComplianceSummaryByResourceTypeError> for Error {
    fn from(err: crate::operation::get_compliance_summary_by_resource_type::GetComplianceSummaryByResourceTypeError) -> Self {
        match err {
            crate::operation::get_compliance_summary_by_resource_type::GetComplianceSummaryByResourceTypeError::InvalidParameterValueException(
                inner,
            ) => Error::InvalidParameterValueException(inner),
            crate::operation::get_compliance_summary_by_resource_type::GetComplianceSummaryByResourceTypeError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_conformance_pack_compliance_details::GetConformancePackComplianceDetailsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_conformance_pack_compliance_details::GetConformancePackComplianceDetailsError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_conformance_pack_compliance_details::GetConformancePackComplianceDetailsError> for Error {
    fn from(err: crate::operation::get_conformance_pack_compliance_details::GetConformancePackComplianceDetailsError) -> Self {
        match err {
            crate::operation::get_conformance_pack_compliance_details::GetConformancePackComplianceDetailsError::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
            crate::operation::get_conformance_pack_compliance_details::GetConformancePackComplianceDetailsError::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
            crate::operation::get_conformance_pack_compliance_details::GetConformancePackComplianceDetailsError::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
            crate::operation::get_conformance_pack_compliance_details::GetConformancePackComplianceDetailsError::NoSuchConfigRuleInConformancePackException(inner) => Error::NoSuchConfigRuleInConformancePackException(inner),
            crate::operation::get_conformance_pack_compliance_details::GetConformancePackComplianceDetailsError::NoSuchConformancePackException(inner) => Error::NoSuchConformancePackException(inner),
            crate::operation::get_conformance_pack_compliance_details::GetConformancePackComplianceDetailsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_conformance_pack_compliance_summary::GetConformancePackComplianceSummaryError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_conformance_pack_compliance_summary::GetConformancePackComplianceSummaryError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_conformance_pack_compliance_summary::GetConformancePackComplianceSummaryError> for Error {
    fn from(err: crate::operation::get_conformance_pack_compliance_summary::GetConformancePackComplianceSummaryError) -> Self {
        match err {
            crate::operation::get_conformance_pack_compliance_summary::GetConformancePackComplianceSummaryError::InvalidLimitException(inner) => {
                Error::InvalidLimitException(inner)
            }
            crate::operation::get_conformance_pack_compliance_summary::GetConformancePackComplianceSummaryError::InvalidNextTokenException(inner) => {
                Error::InvalidNextTokenException(inner)
            }
            crate::operation::get_conformance_pack_compliance_summary::GetConformancePackComplianceSummaryError::NoSuchConformancePackException(
                inner,
            ) => Error::NoSuchConformancePackException(inner),
            crate::operation::get_conformance_pack_compliance_summary::GetConformancePackComplianceSummaryError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_custom_rule_policy::GetCustomRulePolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_custom_rule_policy::GetCustomRulePolicyError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_custom_rule_policy::GetCustomRulePolicyError> for Error {
    fn from(err: crate::operation::get_custom_rule_policy::GetCustomRulePolicyError) -> Self {
        match err {
            crate::operation::get_custom_rule_policy::GetCustomRulePolicyError::NoSuchConfigRuleException(inner) => {
                Error::NoSuchConfigRuleException(inner)
            }
            crate::operation::get_custom_rule_policy::GetCustomRulePolicyError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_discovered_resource_counts::GetDiscoveredResourceCountsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_discovered_resource_counts::GetDiscoveredResourceCountsError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_discovered_resource_counts::GetDiscoveredResourceCountsError> for Error {
    fn from(err: crate::operation::get_discovered_resource_counts::GetDiscoveredResourceCountsError) -> Self {
        match err {
            crate::operation::get_discovered_resource_counts::GetDiscoveredResourceCountsError::InvalidLimitException(inner) => {
                Error::InvalidLimitException(inner)
            }
            crate::operation::get_discovered_resource_counts::GetDiscoveredResourceCountsError::InvalidNextTokenException(inner) => {
                Error::InvalidNextTokenException(inner)
            }
            crate::operation::get_discovered_resource_counts::GetDiscoveredResourceCountsError::ValidationException(inner) => {
                Error::ValidationException(inner)
            }
            crate::operation::get_discovered_resource_counts::GetDiscoveredResourceCountsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_organization_config_rule_detailed_status::GetOrganizationConfigRuleDetailedStatusError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_organization_config_rule_detailed_status::GetOrganizationConfigRuleDetailedStatusError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_organization_config_rule_detailed_status::GetOrganizationConfigRuleDetailedStatusError> for Error {
    fn from(err: crate::operation::get_organization_config_rule_detailed_status::GetOrganizationConfigRuleDetailedStatusError) -> Self {
        match err {
            crate::operation::get_organization_config_rule_detailed_status::GetOrganizationConfigRuleDetailedStatusError::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
            crate::operation::get_organization_config_rule_detailed_status::GetOrganizationConfigRuleDetailedStatusError::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
            crate::operation::get_organization_config_rule_detailed_status::GetOrganizationConfigRuleDetailedStatusError::NoSuchOrganizationConfigRuleException(inner) => Error::NoSuchOrganizationConfigRuleException(inner),
            crate::operation::get_organization_config_rule_detailed_status::GetOrganizationConfigRuleDetailedStatusError::OrganizationAccessDeniedException(inner) => Error::OrganizationAccessDeniedException(inner),
            crate::operation::get_organization_config_rule_detailed_status::GetOrganizationConfigRuleDetailedStatusError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_organization_conformance_pack_detailed_status::GetOrganizationConformancePackDetailedStatusError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_organization_conformance_pack_detailed_status::GetOrganizationConformancePackDetailedStatusError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_organization_conformance_pack_detailed_status::GetOrganizationConformancePackDetailedStatusError> for Error {
    fn from(err: crate::operation::get_organization_conformance_pack_detailed_status::GetOrganizationConformancePackDetailedStatusError) -> Self {
        match err {
            crate::operation::get_organization_conformance_pack_detailed_status::GetOrganizationConformancePackDetailedStatusError::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
            crate::operation::get_organization_conformance_pack_detailed_status::GetOrganizationConformancePackDetailedStatusError::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
            crate::operation::get_organization_conformance_pack_detailed_status::GetOrganizationConformancePackDetailedStatusError::NoSuchOrganizationConformancePackException(inner) => Error::NoSuchOrganizationConformancePackException(inner),
            crate::operation::get_organization_conformance_pack_detailed_status::GetOrganizationConformancePackDetailedStatusError::OrganizationAccessDeniedException(inner) => Error::OrganizationAccessDeniedException(inner),
            crate::operation::get_organization_conformance_pack_detailed_status::GetOrganizationConformancePackDetailedStatusError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_organization_custom_rule_policy::GetOrganizationCustomRulePolicyError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_organization_custom_rule_policy::GetOrganizationCustomRulePolicyError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_organization_custom_rule_policy::GetOrganizationCustomRulePolicyError> for Error {
    fn from(err: crate::operation::get_organization_custom_rule_policy::GetOrganizationCustomRulePolicyError) -> Self {
        match err {
            crate::operation::get_organization_custom_rule_policy::GetOrganizationCustomRulePolicyError::NoSuchOrganizationConfigRuleException(
                inner,
            ) => Error::NoSuchOrganizationConfigRuleException(inner),
            crate::operation::get_organization_custom_rule_policy::GetOrganizationCustomRulePolicyError::OrganizationAccessDeniedException(inner) => {
                Error::OrganizationAccessDeniedException(inner)
            }
            crate::operation::get_organization_custom_rule_policy::GetOrganizationCustomRulePolicyError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_resource_config_history::GetResourceConfigHistoryError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_resource_config_history::GetResourceConfigHistoryError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_resource_config_history::GetResourceConfigHistoryError> for Error {
    fn from(err: crate::operation::get_resource_config_history::GetResourceConfigHistoryError) -> Self {
        match err {
            crate::operation::get_resource_config_history::GetResourceConfigHistoryError::InvalidLimitException(inner) => {
                Error::InvalidLimitException(inner)
            }
            crate::operation::get_resource_config_history::GetResourceConfigHistoryError::InvalidNextTokenException(inner) => {
                Error::InvalidNextTokenException(inner)
            }
            crate::operation::get_resource_config_history::GetResourceConfigHistoryError::InvalidTimeRangeException(inner) => {
                Error::InvalidTimeRangeException(inner)
            }
            crate::operation::get_resource_config_history::GetResourceConfigHistoryError::NoAvailableConfigurationRecorderException(inner) => {
                Error::NoAvailableConfigurationRecorderException(inner)
            }
            crate::operation::get_resource_config_history::GetResourceConfigHistoryError::ResourceNotDiscoveredException(inner) => {
                Error::ResourceNotDiscoveredException(inner)
            }
            crate::operation::get_resource_config_history::GetResourceConfigHistoryError::ValidationException(inner) => {
                Error::ValidationException(inner)
            }
            crate::operation::get_resource_config_history::GetResourceConfigHistoryError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_resource_evaluation_summary::GetResourceEvaluationSummaryError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_resource_evaluation_summary::GetResourceEvaluationSummaryError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_resource_evaluation_summary::GetResourceEvaluationSummaryError> for Error {
    fn from(err: crate::operation::get_resource_evaluation_summary::GetResourceEvaluationSummaryError) -> Self {
        match err {
            crate::operation::get_resource_evaluation_summary::GetResourceEvaluationSummaryError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::get_resource_evaluation_summary::GetResourceEvaluationSummaryError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_stored_query::GetStoredQueryError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_stored_query::GetStoredQueryError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_stored_query::GetStoredQueryError> for Error {
    fn from(err: crate::operation::get_stored_query::GetStoredQueryError) -> Self {
        match err {
            crate::operation::get_stored_query::GetStoredQueryError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::get_stored_query::GetStoredQueryError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::get_stored_query::GetStoredQueryError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::list_aggregate_discovered_resources::ListAggregateDiscoveredResourcesError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::list_aggregate_discovered_resources::ListAggregateDiscoveredResourcesError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_aggregate_discovered_resources::ListAggregateDiscoveredResourcesError> for Error {
    fn from(err: crate::operation::list_aggregate_discovered_resources::ListAggregateDiscoveredResourcesError) -> Self {
        match err {
            crate::operation::list_aggregate_discovered_resources::ListAggregateDiscoveredResourcesError::InvalidLimitException(inner) => {
                Error::InvalidLimitException(inner)
            }
            crate::operation::list_aggregate_discovered_resources::ListAggregateDiscoveredResourcesError::InvalidNextTokenException(inner) => {
                Error::InvalidNextTokenException(inner)
            }
            crate::operation::list_aggregate_discovered_resources::ListAggregateDiscoveredResourcesError::NoSuchConfigurationAggregatorException(
                inner,
            ) => Error::NoSuchConfigurationAggregatorException(inner),
            crate::operation::list_aggregate_discovered_resources::ListAggregateDiscoveredResourcesError::ValidationException(inner) => {
                Error::ValidationException(inner)
            }
            crate::operation::list_aggregate_discovered_resources::ListAggregateDiscoveredResourcesError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_configuration_recorders::ListConfigurationRecordersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_configuration_recorders::ListConfigurationRecordersError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_configuration_recorders::ListConfigurationRecordersError> for Error {
    fn from(err: crate::operation::list_configuration_recorders::ListConfigurationRecordersError) -> Self {
        match err {
            crate::operation::list_configuration_recorders::ListConfigurationRecordersError::ValidationException(inner) => {
                Error::ValidationException(inner)
            }
            crate::operation::list_configuration_recorders::ListConfigurationRecordersError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::list_conformance_pack_compliance_scores::ListConformancePackComplianceScoresError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::list_conformance_pack_compliance_scores::ListConformancePackComplianceScoresError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_conformance_pack_compliance_scores::ListConformancePackComplianceScoresError> for Error {
    fn from(err: crate::operation::list_conformance_pack_compliance_scores::ListConformancePackComplianceScoresError) -> Self {
        match err {
            crate::operation::list_conformance_pack_compliance_scores::ListConformancePackComplianceScoresError::InvalidLimitException(inner) => {
                Error::InvalidLimitException(inner)
            }
            crate::operation::list_conformance_pack_compliance_scores::ListConformancePackComplianceScoresError::InvalidNextTokenException(inner) => {
                Error::InvalidNextTokenException(inner)
            }
            crate::operation::list_conformance_pack_compliance_scores::ListConformancePackComplianceScoresError::InvalidParameterValueException(
                inner,
            ) => Error::InvalidParameterValueException(inner),
            crate::operation::list_conformance_pack_compliance_scores::ListConformancePackComplianceScoresError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_discovered_resources::ListDiscoveredResourcesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_discovered_resources::ListDiscoveredResourcesError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_discovered_resources::ListDiscoveredResourcesError> for Error {
    fn from(err: crate::operation::list_discovered_resources::ListDiscoveredResourcesError) -> Self {
        match err {
            crate::operation::list_discovered_resources::ListDiscoveredResourcesError::InvalidLimitException(inner) => {
                Error::InvalidLimitException(inner)
            }
            crate::operation::list_discovered_resources::ListDiscoveredResourcesError::InvalidNextTokenException(inner) => {
                Error::InvalidNextTokenException(inner)
            }
            crate::operation::list_discovered_resources::ListDiscoveredResourcesError::NoAvailableConfigurationRecorderException(inner) => {
                Error::NoAvailableConfigurationRecorderException(inner)
            }
            crate::operation::list_discovered_resources::ListDiscoveredResourcesError::ValidationException(inner) => {
                Error::ValidationException(inner)
            }
            crate::operation::list_discovered_resources::ListDiscoveredResourcesError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_resource_evaluations::ListResourceEvaluationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_resource_evaluations::ListResourceEvaluationsError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_resource_evaluations::ListResourceEvaluationsError> for Error {
    fn from(err: crate::operation::list_resource_evaluations::ListResourceEvaluationsError) -> Self {
        match err {
            crate::operation::list_resource_evaluations::ListResourceEvaluationsError::InvalidNextTokenException(inner) => {
                Error::InvalidNextTokenException(inner)
            }
            crate::operation::list_resource_evaluations::ListResourceEvaluationsError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::list_resource_evaluations::ListResourceEvaluationsError::InvalidTimeRangeException(inner) => {
                Error::InvalidTimeRangeException(inner)
            }
            crate::operation::list_resource_evaluations::ListResourceEvaluationsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_stored_queries::ListStoredQueriesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_stored_queries::ListStoredQueriesError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_stored_queries::ListStoredQueriesError> for Error {
    fn from(err: crate::operation::list_stored_queries::ListStoredQueriesError) -> Self {
        match err {
            crate::operation::list_stored_queries::ListStoredQueriesError::InvalidNextTokenException(inner) => {
                Error::InvalidNextTokenException(inner)
            }
            crate::operation::list_stored_queries::ListStoredQueriesError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::list_stored_queries::ListStoredQueriesError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_tags_for_resource::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_tags_for_resource::ListTagsForResourceError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_tags_for_resource::ListTagsForResourceError> for Error {
    fn from(err: crate::operation::list_tags_for_resource::ListTagsForResourceError) -> Self {
        match err {
            crate::operation::list_tags_for_resource::ListTagsForResourceError::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
            crate::operation::list_tags_for_resource::ListTagsForResourceError::InvalidNextTokenException(inner) => {
                Error::InvalidNextTokenException(inner)
            }
            crate::operation::list_tags_for_resource::ListTagsForResourceError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::list_tags_for_resource::ListTagsForResourceError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::list_tags_for_resource::ListTagsForResourceError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_aggregation_authorization::PutAggregationAuthorizationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_aggregation_authorization::PutAggregationAuthorizationError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_aggregation_authorization::PutAggregationAuthorizationError> for Error {
    fn from(err: crate::operation::put_aggregation_authorization::PutAggregationAuthorizationError) -> Self {
        match err {
            crate::operation::put_aggregation_authorization::PutAggregationAuthorizationError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::put_aggregation_authorization::PutAggregationAuthorizationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_config_rule::PutConfigRuleError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_config_rule::PutConfigRuleError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_config_rule::PutConfigRuleError> for Error {
    fn from(err: crate::operation::put_config_rule::PutConfigRuleError) -> Self {
        match err {
            crate::operation::put_config_rule::PutConfigRuleError::InsufficientPermissionsException(inner) => {
                Error::InsufficientPermissionsException(inner)
            }
            crate::operation::put_config_rule::PutConfigRuleError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::put_config_rule::PutConfigRuleError::MaxNumberOfConfigRulesExceededException(inner) => {
                Error::MaxNumberOfConfigRulesExceededException(inner)
            }
            crate::operation::put_config_rule::PutConfigRuleError::NoAvailableConfigurationRecorderException(inner) => {
                Error::NoAvailableConfigurationRecorderException(inner)
            }
            crate::operation::put_config_rule::PutConfigRuleError::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
            crate::operation::put_config_rule::PutConfigRuleError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_configuration_aggregator::PutConfigurationAggregatorError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_configuration_aggregator::PutConfigurationAggregatorError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_configuration_aggregator::PutConfigurationAggregatorError> for Error {
    fn from(err: crate::operation::put_configuration_aggregator::PutConfigurationAggregatorError) -> Self {
        match err {
            crate::operation::put_configuration_aggregator::PutConfigurationAggregatorError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::put_configuration_aggregator::PutConfigurationAggregatorError::InvalidRoleException(inner) => {
                Error::InvalidRoleException(inner)
            }
            crate::operation::put_configuration_aggregator::PutConfigurationAggregatorError::LimitExceededException(inner) => {
                Error::LimitExceededException(inner)
            }
            crate::operation::put_configuration_aggregator::PutConfigurationAggregatorError::NoAvailableOrganizationException(inner) => {
                Error::NoAvailableOrganizationException(inner)
            }
            crate::operation::put_configuration_aggregator::PutConfigurationAggregatorError::OrganizationAccessDeniedException(inner) => {
                Error::OrganizationAccessDeniedException(inner)
            }
            crate::operation::put_configuration_aggregator::PutConfigurationAggregatorError::OrganizationAllFeaturesNotEnabledException(inner) => {
                Error::OrganizationAllFeaturesNotEnabledException(inner)
            }
            crate::operation::put_configuration_aggregator::PutConfigurationAggregatorError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_configuration_recorder::PutConfigurationRecorderError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_configuration_recorder::PutConfigurationRecorderError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_configuration_recorder::PutConfigurationRecorderError> for Error {
    fn from(err: crate::operation::put_configuration_recorder::PutConfigurationRecorderError) -> Self {
        match err {
            crate::operation::put_configuration_recorder::PutConfigurationRecorderError::InvalidConfigurationRecorderNameException(inner) => {
                Error::InvalidConfigurationRecorderNameException(inner)
            }
            crate::operation::put_configuration_recorder::PutConfigurationRecorderError::InvalidRecordingGroupException(inner) => {
                Error::InvalidRecordingGroupException(inner)
            }
            crate::operation::put_configuration_recorder::PutConfigurationRecorderError::InvalidRoleException(inner) => {
                Error::InvalidRoleException(inner)
            }
            crate::operation::put_configuration_recorder::PutConfigurationRecorderError::MaxNumberOfConfigurationRecordersExceededException(
                inner,
            ) => Error::MaxNumberOfConfigurationRecordersExceededException(inner),
            crate::operation::put_configuration_recorder::PutConfigurationRecorderError::UnmodifiableEntityException(inner) => {
                Error::UnmodifiableEntityException(inner)
            }
            crate::operation::put_configuration_recorder::PutConfigurationRecorderError::ValidationException(inner) => {
                Error::ValidationException(inner)
            }
            crate::operation::put_configuration_recorder::PutConfigurationRecorderError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_conformance_pack::PutConformancePackError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_conformance_pack::PutConformancePackError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_conformance_pack::PutConformancePackError> for Error {
    fn from(err: crate::operation::put_conformance_pack::PutConformancePackError) -> Self {
        match err {
            crate::operation::put_conformance_pack::PutConformancePackError::ConformancePackTemplateValidationException(inner) => {
                Error::ConformancePackTemplateValidationException(inner)
            }
            crate::operation::put_conformance_pack::PutConformancePackError::InsufficientPermissionsException(inner) => {
                Error::InsufficientPermissionsException(inner)
            }
            crate::operation::put_conformance_pack::PutConformancePackError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::put_conformance_pack::PutConformancePackError::MaxNumberOfConformancePacksExceededException(inner) => {
                Error::MaxNumberOfConformancePacksExceededException(inner)
            }
            crate::operation::put_conformance_pack::PutConformancePackError::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
            crate::operation::put_conformance_pack::PutConformancePackError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_delivery_channel::PutDeliveryChannelError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_delivery_channel::PutDeliveryChannelError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_delivery_channel::PutDeliveryChannelError> for Error {
    fn from(err: crate::operation::put_delivery_channel::PutDeliveryChannelError) -> Self {
        match err {
            crate::operation::put_delivery_channel::PutDeliveryChannelError::InsufficientDeliveryPolicyException(inner) => {
                Error::InsufficientDeliveryPolicyException(inner)
            }
            crate::operation::put_delivery_channel::PutDeliveryChannelError::InvalidDeliveryChannelNameException(inner) => {
                Error::InvalidDeliveryChannelNameException(inner)
            }
            crate::operation::put_delivery_channel::PutDeliveryChannelError::InvalidS3KeyPrefixException(inner) => {
                Error::InvalidS3KeyPrefixException(inner)
            }
            crate::operation::put_delivery_channel::PutDeliveryChannelError::InvalidS3KmsKeyArnException(inner) => {
                Error::InvalidS3KmsKeyArnException(inner)
            }
            crate::operation::put_delivery_channel::PutDeliveryChannelError::InvalidSnsTopicArnException(inner) => {
                Error::InvalidSnsTopicArnException(inner)
            }
            crate::operation::put_delivery_channel::PutDeliveryChannelError::MaxNumberOfDeliveryChannelsExceededException(inner) => {
                Error::MaxNumberOfDeliveryChannelsExceededException(inner)
            }
            crate::operation::put_delivery_channel::PutDeliveryChannelError::NoAvailableConfigurationRecorderException(inner) => {
                Error::NoAvailableConfigurationRecorderException(inner)
            }
            crate::operation::put_delivery_channel::PutDeliveryChannelError::NoSuchBucketException(inner) => Error::NoSuchBucketException(inner),
            crate::operation::put_delivery_channel::PutDeliveryChannelError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_evaluations::PutEvaluationsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_evaluations::PutEvaluationsError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_evaluations::PutEvaluationsError> for Error {
    fn from(err: crate::operation::put_evaluations::PutEvaluationsError) -> Self {
        match err {
            crate::operation::put_evaluations::PutEvaluationsError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::put_evaluations::PutEvaluationsError::InvalidResultTokenException(inner) => Error::InvalidResultTokenException(inner),
            crate::operation::put_evaluations::PutEvaluationsError::NoSuchConfigRuleException(inner) => Error::NoSuchConfigRuleException(inner),
            crate::operation::put_evaluations::PutEvaluationsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_external_evaluation::PutExternalEvaluationError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_external_evaluation::PutExternalEvaluationError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_external_evaluation::PutExternalEvaluationError> for Error {
    fn from(err: crate::operation::put_external_evaluation::PutExternalEvaluationError) -> Self {
        match err {
            crate::operation::put_external_evaluation::PutExternalEvaluationError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::put_external_evaluation::PutExternalEvaluationError::NoSuchConfigRuleException(inner) => {
                Error::NoSuchConfigRuleException(inner)
            }
            crate::operation::put_external_evaluation::PutExternalEvaluationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_organization_config_rule::PutOrganizationConfigRuleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_organization_config_rule::PutOrganizationConfigRuleError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_organization_config_rule::PutOrganizationConfigRuleError> for Error {
    fn from(err: crate::operation::put_organization_config_rule::PutOrganizationConfigRuleError) -> Self {
        match err {
            crate::operation::put_organization_config_rule::PutOrganizationConfigRuleError::InsufficientPermissionsException(inner) => {
                Error::InsufficientPermissionsException(inner)
            }
            crate::operation::put_organization_config_rule::PutOrganizationConfigRuleError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::put_organization_config_rule::PutOrganizationConfigRuleError::MaxNumberOfOrganizationConfigRulesExceededException(
                inner,
            ) => Error::MaxNumberOfOrganizationConfigRulesExceededException(inner),
            crate::operation::put_organization_config_rule::PutOrganizationConfigRuleError::NoAvailableOrganizationException(inner) => {
                Error::NoAvailableOrganizationException(inner)
            }
            crate::operation::put_organization_config_rule::PutOrganizationConfigRuleError::OrganizationAccessDeniedException(inner) => {
                Error::OrganizationAccessDeniedException(inner)
            }
            crate::operation::put_organization_config_rule::PutOrganizationConfigRuleError::OrganizationAllFeaturesNotEnabledException(inner) => {
                Error::OrganizationAllFeaturesNotEnabledException(inner)
            }
            crate::operation::put_organization_config_rule::PutOrganizationConfigRuleError::ResourceInUseException(inner) => {
                Error::ResourceInUseException(inner)
            }
            crate::operation::put_organization_config_rule::PutOrganizationConfigRuleError::ValidationException(inner) => {
                Error::ValidationException(inner)
            }
            crate::operation::put_organization_config_rule::PutOrganizationConfigRuleError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackError> for Error {
    fn from(err: crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackError) -> Self {
        match err {
            crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackError::InsufficientPermissionsException(inner) => Error::InsufficientPermissionsException(inner),
            crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackError::MaxNumberOfOrganizationConformancePacksExceededException(inner) => Error::MaxNumberOfOrganizationConformancePacksExceededException(inner),
            crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackError::NoAvailableOrganizationException(inner) => Error::NoAvailableOrganizationException(inner),
            crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackError::OrganizationAccessDeniedException(inner) => Error::OrganizationAccessDeniedException(inner),
            crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackError::OrganizationAllFeaturesNotEnabledException(inner) => Error::OrganizationAllFeaturesNotEnabledException(inner),
            crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackError::OrganizationConformancePackTemplateValidationException(inner) => Error::OrganizationConformancePackTemplateValidationException(inner),
            crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackError::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
            crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_remediation_configurations::PutRemediationConfigurationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_remediation_configurations::PutRemediationConfigurationsError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_remediation_configurations::PutRemediationConfigurationsError> for Error {
    fn from(err: crate::operation::put_remediation_configurations::PutRemediationConfigurationsError) -> Self {
        match err {
            crate::operation::put_remediation_configurations::PutRemediationConfigurationsError::InsufficientPermissionsException(inner) => {
                Error::InsufficientPermissionsException(inner)
            }
            crate::operation::put_remediation_configurations::PutRemediationConfigurationsError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::put_remediation_configurations::PutRemediationConfigurationsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_remediation_exceptions::PutRemediationExceptionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_remediation_exceptions::PutRemediationExceptionsError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_remediation_exceptions::PutRemediationExceptionsError> for Error {
    fn from(err: crate::operation::put_remediation_exceptions::PutRemediationExceptionsError) -> Self {
        match err {
            crate::operation::put_remediation_exceptions::PutRemediationExceptionsError::InsufficientPermissionsException(inner) => {
                Error::InsufficientPermissionsException(inner)
            }
            crate::operation::put_remediation_exceptions::PutRemediationExceptionsError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::put_remediation_exceptions::PutRemediationExceptionsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_resource_config::PutResourceConfigError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_resource_config::PutResourceConfigError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_resource_config::PutResourceConfigError> for Error {
    fn from(err: crate::operation::put_resource_config::PutResourceConfigError) -> Self {
        match err {
            crate::operation::put_resource_config::PutResourceConfigError::InsufficientPermissionsException(inner) => {
                Error::InsufficientPermissionsException(inner)
            }
            crate::operation::put_resource_config::PutResourceConfigError::MaxActiveResourcesExceededException(inner) => {
                Error::MaxActiveResourcesExceededException(inner)
            }
            crate::operation::put_resource_config::PutResourceConfigError::NoRunningConfigurationRecorderException(inner) => {
                Error::NoRunningConfigurationRecorderException(inner)
            }
            crate::operation::put_resource_config::PutResourceConfigError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::put_resource_config::PutResourceConfigError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_retention_configuration::PutRetentionConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_retention_configuration::PutRetentionConfigurationError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_retention_configuration::PutRetentionConfigurationError> for Error {
    fn from(err: crate::operation::put_retention_configuration::PutRetentionConfigurationError) -> Self {
        match err {
            crate::operation::put_retention_configuration::PutRetentionConfigurationError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::put_retention_configuration::PutRetentionConfigurationError::MaxNumberOfRetentionConfigurationsExceededException(
                inner,
            ) => Error::MaxNumberOfRetentionConfigurationsExceededException(inner),
            crate::operation::put_retention_configuration::PutRetentionConfigurationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_service_linked_configuration_recorder::PutServiceLinkedConfigurationRecorderError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_service_linked_configuration_recorder::PutServiceLinkedConfigurationRecorderError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_service_linked_configuration_recorder::PutServiceLinkedConfigurationRecorderError> for Error {
    fn from(err: crate::operation::put_service_linked_configuration_recorder::PutServiceLinkedConfigurationRecorderError) -> Self {
        match err {
            crate::operation::put_service_linked_configuration_recorder::PutServiceLinkedConfigurationRecorderError::ConflictException(inner) => Error::ConflictException(inner),
            crate::operation::put_service_linked_configuration_recorder::PutServiceLinkedConfigurationRecorderError::InsufficientPermissionsException(inner) => Error::InsufficientPermissionsException(inner),
            crate::operation::put_service_linked_configuration_recorder::PutServiceLinkedConfigurationRecorderError::LimitExceededException(inner) => Error::LimitExceededException(inner),
            crate::operation::put_service_linked_configuration_recorder::PutServiceLinkedConfigurationRecorderError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::put_service_linked_configuration_recorder::PutServiceLinkedConfigurationRecorderError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_stored_query::PutStoredQueryError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_stored_query::PutStoredQueryError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_stored_query::PutStoredQueryError> for Error {
    fn from(err: crate::operation::put_stored_query::PutStoredQueryError) -> Self {
        match err {
            crate::operation::put_stored_query::PutStoredQueryError::ResourceConcurrentModificationException(inner) => {
                Error::ResourceConcurrentModificationException(inner)
            }
            crate::operation::put_stored_query::PutStoredQueryError::TooManyTagsException(inner) => Error::TooManyTagsException(inner),
            crate::operation::put_stored_query::PutStoredQueryError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::put_stored_query::PutStoredQueryError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::select_aggregate_resource_config::SelectAggregateResourceConfigError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::select_aggregate_resource_config::SelectAggregateResourceConfigError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::select_aggregate_resource_config::SelectAggregateResourceConfigError> for Error {
    fn from(err: crate::operation::select_aggregate_resource_config::SelectAggregateResourceConfigError) -> Self {
        match err {
            crate::operation::select_aggregate_resource_config::SelectAggregateResourceConfigError::InvalidExpressionException(inner) => {
                Error::InvalidExpressionException(inner)
            }
            crate::operation::select_aggregate_resource_config::SelectAggregateResourceConfigError::InvalidLimitException(inner) => {
                Error::InvalidLimitException(inner)
            }
            crate::operation::select_aggregate_resource_config::SelectAggregateResourceConfigError::InvalidNextTokenException(inner) => {
                Error::InvalidNextTokenException(inner)
            }
            crate::operation::select_aggregate_resource_config::SelectAggregateResourceConfigError::NoSuchConfigurationAggregatorException(inner) => {
                Error::NoSuchConfigurationAggregatorException(inner)
            }
            crate::operation::select_aggregate_resource_config::SelectAggregateResourceConfigError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::select_resource_config::SelectResourceConfigError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::select_resource_config::SelectResourceConfigError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::select_resource_config::SelectResourceConfigError> for Error {
    fn from(err: crate::operation::select_resource_config::SelectResourceConfigError) -> Self {
        match err {
            crate::operation::select_resource_config::SelectResourceConfigError::InvalidExpressionException(inner) => {
                Error::InvalidExpressionException(inner)
            }
            crate::operation::select_resource_config::SelectResourceConfigError::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
            crate::operation::select_resource_config::SelectResourceConfigError::InvalidNextTokenException(inner) => {
                Error::InvalidNextTokenException(inner)
            }
            crate::operation::select_resource_config::SelectResourceConfigError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::start_config_rules_evaluation::StartConfigRulesEvaluationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::start_config_rules_evaluation::StartConfigRulesEvaluationError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::start_config_rules_evaluation::StartConfigRulesEvaluationError> for Error {
    fn from(err: crate::operation::start_config_rules_evaluation::StartConfigRulesEvaluationError) -> Self {
        match err {
            crate::operation::start_config_rules_evaluation::StartConfigRulesEvaluationError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::start_config_rules_evaluation::StartConfigRulesEvaluationError::LimitExceededException(inner) => {
                Error::LimitExceededException(inner)
            }
            crate::operation::start_config_rules_evaluation::StartConfigRulesEvaluationError::NoSuchConfigRuleException(inner) => {
                Error::NoSuchConfigRuleException(inner)
            }
            crate::operation::start_config_rules_evaluation::StartConfigRulesEvaluationError::ResourceInUseException(inner) => {
                Error::ResourceInUseException(inner)
            }
            crate::operation::start_config_rules_evaluation::StartConfigRulesEvaluationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::start_configuration_recorder::StartConfigurationRecorderError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::start_configuration_recorder::StartConfigurationRecorderError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::start_configuration_recorder::StartConfigurationRecorderError> for Error {
    fn from(err: crate::operation::start_configuration_recorder::StartConfigurationRecorderError) -> Self {
        match err {
            crate::operation::start_configuration_recorder::StartConfigurationRecorderError::NoAvailableDeliveryChannelException(inner) => {
                Error::NoAvailableDeliveryChannelException(inner)
            }
            crate::operation::start_configuration_recorder::StartConfigurationRecorderError::NoSuchConfigurationRecorderException(inner) => {
                Error::NoSuchConfigurationRecorderException(inner)
            }
            crate::operation::start_configuration_recorder::StartConfigurationRecorderError::UnmodifiableEntityException(inner) => {
                Error::UnmodifiableEntityException(inner)
            }
            crate::operation::start_configuration_recorder::StartConfigurationRecorderError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::start_remediation_execution::StartRemediationExecutionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::start_remediation_execution::StartRemediationExecutionError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::start_remediation_execution::StartRemediationExecutionError> for Error {
    fn from(err: crate::operation::start_remediation_execution::StartRemediationExecutionError) -> Self {
        match err {
            crate::operation::start_remediation_execution::StartRemediationExecutionError::InsufficientPermissionsException(inner) => {
                Error::InsufficientPermissionsException(inner)
            }
            crate::operation::start_remediation_execution::StartRemediationExecutionError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::start_remediation_execution::StartRemediationExecutionError::NoSuchRemediationConfigurationException(inner) => {
                Error::NoSuchRemediationConfigurationException(inner)
            }
            crate::operation::start_remediation_execution::StartRemediationExecutionError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::start_resource_evaluation::StartResourceEvaluationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::start_resource_evaluation::StartResourceEvaluationError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::start_resource_evaluation::StartResourceEvaluationError> for Error {
    fn from(err: crate::operation::start_resource_evaluation::StartResourceEvaluationError) -> Self {
        match err {
            crate::operation::start_resource_evaluation::StartResourceEvaluationError::IdempotentParameterMismatch(inner) => {
                Error::IdempotentParameterMismatch(inner)
            }
            crate::operation::start_resource_evaluation::StartResourceEvaluationError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::start_resource_evaluation::StartResourceEvaluationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::stop_configuration_recorder::StopConfigurationRecorderError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::stop_configuration_recorder::StopConfigurationRecorderError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::stop_configuration_recorder::StopConfigurationRecorderError> for Error {
    fn from(err: crate::operation::stop_configuration_recorder::StopConfigurationRecorderError) -> Self {
        match err {
            crate::operation::stop_configuration_recorder::StopConfigurationRecorderError::NoSuchConfigurationRecorderException(inner) => {
                Error::NoSuchConfigurationRecorderException(inner)
            }
            crate::operation::stop_configuration_recorder::StopConfigurationRecorderError::UnmodifiableEntityException(inner) => {
                Error::UnmodifiableEntityException(inner)
            }
            crate::operation::stop_configuration_recorder::StopConfigurationRecorderError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::tag_resource::TagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::tag_resource::TagResourceError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::tag_resource::TagResourceError> for Error {
    fn from(err: crate::operation::tag_resource::TagResourceError) -> Self {
        match err {
            crate::operation::tag_resource::TagResourceError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::tag_resource::TagResourceError::TooManyTagsException(inner) => Error::TooManyTagsException(inner),
            crate::operation::tag_resource::TagResourceError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::tag_resource::TagResourceError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::untag_resource::UntagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::untag_resource::UntagResourceError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::untag_resource::UntagResourceError> for Error {
    fn from(err: crate::operation::untag_resource::UntagResourceError) -> Self {
        match err {
            crate::operation::untag_resource::UntagResourceError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::untag_resource::UntagResourceError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::untag_resource::UntagResourceError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl ::std::error::Error for Error {
    fn source(&self) -> std::option::Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            Error::ConflictException(inner) => inner.source(),
            Error::ConformancePackTemplateValidationException(inner) => inner.source(),
            Error::IdempotentParameterMismatch(inner) => inner.source(),
            Error::InsufficientDeliveryPolicyException(inner) => inner.source(),
            Error::InsufficientPermissionsException(inner) => inner.source(),
            Error::InvalidConfigurationRecorderNameException(inner) => inner.source(),
            Error::InvalidDeliveryChannelNameException(inner) => inner.source(),
            Error::InvalidExpressionException(inner) => inner.source(),
            Error::InvalidLimitException(inner) => inner.source(),
            Error::InvalidNextTokenException(inner) => inner.source(),
            Error::InvalidParameterValueException(inner) => inner.source(),
            Error::InvalidRecordingGroupException(inner) => inner.source(),
            Error::InvalidResultTokenException(inner) => inner.source(),
            Error::InvalidRoleException(inner) => inner.source(),
            Error::InvalidS3KeyPrefixException(inner) => inner.source(),
            Error::InvalidS3KmsKeyArnException(inner) => inner.source(),
            Error::InvalidSnsTopicArnException(inner) => inner.source(),
            Error::InvalidTimeRangeException(inner) => inner.source(),
            Error::LastDeliveryChannelDeleteFailedException(inner) => inner.source(),
            Error::LimitExceededException(inner) => inner.source(),
            Error::MaxActiveResourcesExceededException(inner) => inner.source(),
            Error::MaxNumberOfConfigRulesExceededException(inner) => inner.source(),
            Error::MaxNumberOfConfigurationRecordersExceededException(inner) => inner.source(),
            Error::MaxNumberOfConformancePacksExceededException(inner) => inner.source(),
            Error::MaxNumberOfDeliveryChannelsExceededException(inner) => inner.source(),
            Error::MaxNumberOfOrganizationConfigRulesExceededException(inner) => inner.source(),
            Error::MaxNumberOfOrganizationConformancePacksExceededException(inner) => inner.source(),
            Error::MaxNumberOfRetentionConfigurationsExceededException(inner) => inner.source(),
            Error::NoAvailableConfigurationRecorderException(inner) => inner.source(),
            Error::NoAvailableDeliveryChannelException(inner) => inner.source(),
            Error::NoAvailableOrganizationException(inner) => inner.source(),
            Error::NoRunningConfigurationRecorderException(inner) => inner.source(),
            Error::NoSuchBucketException(inner) => inner.source(),
            Error::NoSuchConfigRuleException(inner) => inner.source(),
            Error::NoSuchConfigRuleInConformancePackException(inner) => inner.source(),
            Error::NoSuchConfigurationAggregatorException(inner) => inner.source(),
            Error::NoSuchConfigurationRecorderException(inner) => inner.source(),
            Error::NoSuchConformancePackException(inner) => inner.source(),
            Error::NoSuchDeliveryChannelException(inner) => inner.source(),
            Error::NoSuchOrganizationConfigRuleException(inner) => inner.source(),
            Error::NoSuchOrganizationConformancePackException(inner) => inner.source(),
            Error::NoSuchRemediationConfigurationException(inner) => inner.source(),
            Error::NoSuchRemediationExceptionException(inner) => inner.source(),
            Error::NoSuchRetentionConfigurationException(inner) => inner.source(),
            Error::OrganizationAccessDeniedException(inner) => inner.source(),
            Error::OrganizationAllFeaturesNotEnabledException(inner) => inner.source(),
            Error::OrganizationConformancePackTemplateValidationException(inner) => inner.source(),
            Error::OversizedConfigurationItemException(inner) => inner.source(),
            Error::RemediationInProgressException(inner) => inner.source(),
            Error::ResourceConcurrentModificationException(inner) => inner.source(),
            Error::ResourceInUseException(inner) => inner.source(),
            Error::ResourceNotDiscoveredException(inner) => inner.source(),
            Error::ResourceNotFoundException(inner) => inner.source(),
            Error::TooManyTagsException(inner) => inner.source(),
            Error::UnmodifiableEntityException(inner) => inner.source(),
            Error::ValidationException(inner) => inner.source(),
            Error::Unhandled(inner) => ::std::option::Option::Some(&*inner.source),
        }
    }
}
impl ::aws_types::request_id::RequestId for Error {
    fn request_id(&self) -> Option<&str> {
        match self {
            Self::ConflictException(e) => e.request_id(),
            Self::ConformancePackTemplateValidationException(e) => e.request_id(),
            Self::IdempotentParameterMismatch(e) => e.request_id(),
            Self::InsufficientDeliveryPolicyException(e) => e.request_id(),
            Self::InsufficientPermissionsException(e) => e.request_id(),
            Self::InvalidConfigurationRecorderNameException(e) => e.request_id(),
            Self::InvalidDeliveryChannelNameException(e) => e.request_id(),
            Self::InvalidExpressionException(e) => e.request_id(),
            Self::InvalidLimitException(e) => e.request_id(),
            Self::InvalidNextTokenException(e) => e.request_id(),
            Self::InvalidParameterValueException(e) => e.request_id(),
            Self::InvalidRecordingGroupException(e) => e.request_id(),
            Self::InvalidResultTokenException(e) => e.request_id(),
            Self::InvalidRoleException(e) => e.request_id(),
            Self::InvalidS3KeyPrefixException(e) => e.request_id(),
            Self::InvalidS3KmsKeyArnException(e) => e.request_id(),
            Self::InvalidSnsTopicArnException(e) => e.request_id(),
            Self::InvalidTimeRangeException(e) => e.request_id(),
            Self::LastDeliveryChannelDeleteFailedException(e) => e.request_id(),
            Self::LimitExceededException(e) => e.request_id(),
            Self::MaxActiveResourcesExceededException(e) => e.request_id(),
            Self::MaxNumberOfConfigRulesExceededException(e) => e.request_id(),
            Self::MaxNumberOfConfigurationRecordersExceededException(e) => e.request_id(),
            Self::MaxNumberOfConformancePacksExceededException(e) => e.request_id(),
            Self::MaxNumberOfDeliveryChannelsExceededException(e) => e.request_id(),
            Self::MaxNumberOfOrganizationConfigRulesExceededException(e) => e.request_id(),
            Self::MaxNumberOfOrganizationConformancePacksExceededException(e) => e.request_id(),
            Self::MaxNumberOfRetentionConfigurationsExceededException(e) => e.request_id(),
            Self::NoAvailableConfigurationRecorderException(e) => e.request_id(),
            Self::NoAvailableDeliveryChannelException(e) => e.request_id(),
            Self::NoAvailableOrganizationException(e) => e.request_id(),
            Self::NoRunningConfigurationRecorderException(e) => e.request_id(),
            Self::NoSuchBucketException(e) => e.request_id(),
            Self::NoSuchConfigRuleException(e) => e.request_id(),
            Self::NoSuchConfigRuleInConformancePackException(e) => e.request_id(),
            Self::NoSuchConfigurationAggregatorException(e) => e.request_id(),
            Self::NoSuchConfigurationRecorderException(e) => e.request_id(),
            Self::NoSuchConformancePackException(e) => e.request_id(),
            Self::NoSuchDeliveryChannelException(e) => e.request_id(),
            Self::NoSuchOrganizationConfigRuleException(e) => e.request_id(),
            Self::NoSuchOrganizationConformancePackException(e) => e.request_id(),
            Self::NoSuchRemediationConfigurationException(e) => e.request_id(),
            Self::NoSuchRemediationExceptionException(e) => e.request_id(),
            Self::NoSuchRetentionConfigurationException(e) => e.request_id(),
            Self::OrganizationAccessDeniedException(e) => e.request_id(),
            Self::OrganizationAllFeaturesNotEnabledException(e) => e.request_id(),
            Self::OrganizationConformancePackTemplateValidationException(e) => e.request_id(),
            Self::OversizedConfigurationItemException(e) => e.request_id(),
            Self::RemediationInProgressException(e) => e.request_id(),
            Self::ResourceConcurrentModificationException(e) => e.request_id(),
            Self::ResourceInUseException(e) => e.request_id(),
            Self::ResourceNotDiscoveredException(e) => e.request_id(),
            Self::ResourceNotFoundException(e) => e.request_id(),
            Self::TooManyTagsException(e) => e.request_id(),
            Self::UnmodifiableEntityException(e) => e.request_id(),
            Self::ValidationException(e) => e.request_id(),
            Self::Unhandled(e) => e.meta.request_id(),
        }
    }
}
