// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::batch_get_aggregate_resource_config::_batch_get_aggregate_resource_config_output::BatchGetAggregateResourceConfigOutputBuilder;

pub use crate::operation::batch_get_aggregate_resource_config::_batch_get_aggregate_resource_config_input::BatchGetAggregateResourceConfigInputBuilder;

impl crate::operation::batch_get_aggregate_resource_config::builders::BatchGetAggregateResourceConfigInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::batch_get_aggregate_resource_config::BatchGetAggregateResourceConfigOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::batch_get_aggregate_resource_config::BatchGetAggregateResourceConfigError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.batch_get_aggregate_resource_config();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `BatchGetAggregateResourceConfig`.
///
/// <p>Returns the current configuration items for resources that are present in your Config aggregator. The operation also returns a list of resources that are not processed in the current request. If there are no unprocessed resources, the operation returns an empty <code>unprocessedResourceIdentifiers</code> list.</p><note>
/// <ul>
/// <li>
/// <p>The API does not return results for deleted resources.</p></li>
/// <li>
/// <p>The API does not return tags and relationships.</p></li>
/// </ul>
/// </note>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct BatchGetAggregateResourceConfigFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::batch_get_aggregate_resource_config::builders::BatchGetAggregateResourceConfigInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::batch_get_aggregate_resource_config::BatchGetAggregateResourceConfigOutput,
        crate::operation::batch_get_aggregate_resource_config::BatchGetAggregateResourceConfigError,
    > for BatchGetAggregateResourceConfigFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::batch_get_aggregate_resource_config::BatchGetAggregateResourceConfigOutput,
            crate::operation::batch_get_aggregate_resource_config::BatchGetAggregateResourceConfigError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl BatchGetAggregateResourceConfigFluentBuilder {
    /// Creates a new `BatchGetAggregateResourceConfigFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the BatchGetAggregateResourceConfig as a reference.
    pub fn as_input(&self) -> &crate::operation::batch_get_aggregate_resource_config::builders::BatchGetAggregateResourceConfigInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::batch_get_aggregate_resource_config::BatchGetAggregateResourceConfigOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::batch_get_aggregate_resource_config::BatchGetAggregateResourceConfigError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::batch_get_aggregate_resource_config::BatchGetAggregateResourceConfig::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::batch_get_aggregate_resource_config::BatchGetAggregateResourceConfig::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::batch_get_aggregate_resource_config::BatchGetAggregateResourceConfigOutput,
        crate::operation::batch_get_aggregate_resource_config::BatchGetAggregateResourceConfigError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The name of the configuration aggregator.</p>
    pub fn configuration_aggregator_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.configuration_aggregator_name(input.into());
        self
    }
    /// <p>The name of the configuration aggregator.</p>
    pub fn set_configuration_aggregator_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_configuration_aggregator_name(input);
        self
    }
    /// <p>The name of the configuration aggregator.</p>
    pub fn get_configuration_aggregator_name(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_configuration_aggregator_name()
    }
    ///
    /// Appends an item to `ResourceIdentifiers`.
    ///
    /// To override the contents of this collection use [`set_resource_identifiers`](Self::set_resource_identifiers).
    ///
    /// <p>A list of aggregate ResourceIdentifiers objects.</p>
    pub fn resource_identifiers(mut self, input: crate::types::AggregateResourceIdentifier) -> Self {
        self.inner = self.inner.resource_identifiers(input);
        self
    }
    /// <p>A list of aggregate ResourceIdentifiers objects.</p>
    pub fn set_resource_identifiers(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::AggregateResourceIdentifier>>) -> Self {
        self.inner = self.inner.set_resource_identifiers(input);
        self
    }
    /// <p>A list of aggregate ResourceIdentifiers objects.</p>
    pub fn get_resource_identifiers(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::AggregateResourceIdentifier>> {
        self.inner.get_resource_identifiers()
    }
}
