// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::delete_evaluation_results::_delete_evaluation_results_output::DeleteEvaluationResultsOutputBuilder;

pub use crate::operation::delete_evaluation_results::_delete_evaluation_results_input::DeleteEvaluationResultsInputBuilder;

impl crate::operation::delete_evaluation_results::builders::DeleteEvaluationResultsInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::delete_evaluation_results::DeleteEvaluationResultsOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_evaluation_results::DeleteEvaluationResultsError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.delete_evaluation_results();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `DeleteEvaluationResults`.
///
/// <p>Deletes the evaluation results for the specified Config rule. You can specify one Config rule per request. After you delete the evaluation results, you can call the <code>StartConfigRulesEvaluation</code> API to start evaluating your Amazon Web Services resources against the rule.</p>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct DeleteEvaluationResultsFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::delete_evaluation_results::builders::DeleteEvaluationResultsInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::delete_evaluation_results::DeleteEvaluationResultsOutput,
        crate::operation::delete_evaluation_results::DeleteEvaluationResultsError,
    > for DeleteEvaluationResultsFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::delete_evaluation_results::DeleteEvaluationResultsOutput,
            crate::operation::delete_evaluation_results::DeleteEvaluationResultsError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl DeleteEvaluationResultsFluentBuilder {
    /// Creates a new `DeleteEvaluationResultsFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the DeleteEvaluationResults as a reference.
    pub fn as_input(&self) -> &crate::operation::delete_evaluation_results::builders::DeleteEvaluationResultsInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::delete_evaluation_results::DeleteEvaluationResultsOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_evaluation_results::DeleteEvaluationResultsError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::delete_evaluation_results::DeleteEvaluationResults::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::delete_evaluation_results::DeleteEvaluationResults::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::delete_evaluation_results::DeleteEvaluationResultsOutput,
        crate::operation::delete_evaluation_results::DeleteEvaluationResultsError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The name of the Config rule for which you want to delete the evaluation results.</p>
    pub fn config_rule_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.config_rule_name(input.into());
        self
    }
    /// <p>The name of the Config rule for which you want to delete the evaluation results.</p>
    pub fn set_config_rule_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_config_rule_name(input);
        self
    }
    /// <p>The name of the Config rule for which you want to delete the evaluation results.</p>
    pub fn get_config_rule_name(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_config_rule_name()
    }
}
