// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::delete_pending_aggregation_request::_delete_pending_aggregation_request_output::DeletePendingAggregationRequestOutputBuilder;

pub use crate::operation::delete_pending_aggregation_request::_delete_pending_aggregation_request_input::DeletePendingAggregationRequestInputBuilder;

impl crate::operation::delete_pending_aggregation_request::builders::DeletePendingAggregationRequestInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::delete_pending_aggregation_request::DeletePendingAggregationRequestOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_pending_aggregation_request::DeletePendingAggregationRequestError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.delete_pending_aggregation_request();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `DeletePendingAggregationRequest`.
///
/// <p>Deletes pending authorization requests for a specified aggregator account in a specified region.</p>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct DeletePendingAggregationRequestFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::delete_pending_aggregation_request::builders::DeletePendingAggregationRequestInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::delete_pending_aggregation_request::DeletePendingAggregationRequestOutput,
        crate::operation::delete_pending_aggregation_request::DeletePendingAggregationRequestError,
    > for DeletePendingAggregationRequestFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::delete_pending_aggregation_request::DeletePendingAggregationRequestOutput,
            crate::operation::delete_pending_aggregation_request::DeletePendingAggregationRequestError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl DeletePendingAggregationRequestFluentBuilder {
    /// Creates a new `DeletePendingAggregationRequestFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the DeletePendingAggregationRequest as a reference.
    pub fn as_input(&self) -> &crate::operation::delete_pending_aggregation_request::builders::DeletePendingAggregationRequestInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::delete_pending_aggregation_request::DeletePendingAggregationRequestOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_pending_aggregation_request::DeletePendingAggregationRequestError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::delete_pending_aggregation_request::DeletePendingAggregationRequest::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::delete_pending_aggregation_request::DeletePendingAggregationRequest::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::delete_pending_aggregation_request::DeletePendingAggregationRequestOutput,
        crate::operation::delete_pending_aggregation_request::DeletePendingAggregationRequestError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The 12-digit account ID of the account requesting to aggregate data.</p>
    pub fn requester_account_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.requester_account_id(input.into());
        self
    }
    /// <p>The 12-digit account ID of the account requesting to aggregate data.</p>
    pub fn set_requester_account_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_requester_account_id(input);
        self
    }
    /// <p>The 12-digit account ID of the account requesting to aggregate data.</p>
    pub fn get_requester_account_id(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_requester_account_id()
    }
    /// <p>The region requesting to aggregate data.</p>
    pub fn requester_aws_region(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.requester_aws_region(input.into());
        self
    }
    /// <p>The region requesting to aggregate data.</p>
    pub fn set_requester_aws_region(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_requester_aws_region(input);
        self
    }
    /// <p>The region requesting to aggregate data.</p>
    pub fn get_requester_aws_region(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_requester_aws_region()
    }
}
