// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::delete_remediation_exceptions::_delete_remediation_exceptions_output::DeleteRemediationExceptionsOutputBuilder;

pub use crate::operation::delete_remediation_exceptions::_delete_remediation_exceptions_input::DeleteRemediationExceptionsInputBuilder;

impl crate::operation::delete_remediation_exceptions::builders::DeleteRemediationExceptionsInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::delete_remediation_exceptions::DeleteRemediationExceptionsOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_remediation_exceptions::DeleteRemediationExceptionsError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.delete_remediation_exceptions();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `DeleteRemediationExceptions`.
///
/// <p>Deletes one or more remediation exceptions mentioned in the resource keys.</p><note>
/// <p>Config generates a remediation exception when a problem occurs executing a remediation action to a specific resource. Remediation exceptions blocks auto-remediation until the exception is cleared.</p>
/// </note>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct DeleteRemediationExceptionsFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::delete_remediation_exceptions::builders::DeleteRemediationExceptionsInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::delete_remediation_exceptions::DeleteRemediationExceptionsOutput,
        crate::operation::delete_remediation_exceptions::DeleteRemediationExceptionsError,
    > for DeleteRemediationExceptionsFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::delete_remediation_exceptions::DeleteRemediationExceptionsOutput,
            crate::operation::delete_remediation_exceptions::DeleteRemediationExceptionsError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl DeleteRemediationExceptionsFluentBuilder {
    /// Creates a new `DeleteRemediationExceptionsFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the DeleteRemediationExceptions as a reference.
    pub fn as_input(&self) -> &crate::operation::delete_remediation_exceptions::builders::DeleteRemediationExceptionsInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::delete_remediation_exceptions::DeleteRemediationExceptionsOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_remediation_exceptions::DeleteRemediationExceptionsError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::delete_remediation_exceptions::DeleteRemediationExceptions::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::delete_remediation_exceptions::DeleteRemediationExceptions::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::delete_remediation_exceptions::DeleteRemediationExceptionsOutput,
        crate::operation::delete_remediation_exceptions::DeleteRemediationExceptionsError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The name of the Config rule for which you want to delete remediation exception configuration.</p>
    pub fn config_rule_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.config_rule_name(input.into());
        self
    }
    /// <p>The name of the Config rule for which you want to delete remediation exception configuration.</p>
    pub fn set_config_rule_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_config_rule_name(input);
        self
    }
    /// <p>The name of the Config rule for which you want to delete remediation exception configuration.</p>
    pub fn get_config_rule_name(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_config_rule_name()
    }
    ///
    /// Appends an item to `ResourceKeys`.
    ///
    /// To override the contents of this collection use [`set_resource_keys`](Self::set_resource_keys).
    ///
    /// <p>An exception list of resource exception keys to be processed with the current request. Config adds exception for each resource key. For example, Config adds 3 exceptions for 3 resource keys.</p>
    pub fn resource_keys(mut self, input: crate::types::RemediationExceptionResourceKey) -> Self {
        self.inner = self.inner.resource_keys(input);
        self
    }
    /// <p>An exception list of resource exception keys to be processed with the current request. Config adds exception for each resource key. For example, Config adds 3 exceptions for 3 resource keys.</p>
    pub fn set_resource_keys(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::RemediationExceptionResourceKey>>) -> Self {
        self.inner = self.inner.set_resource_keys(input);
        self
    }
    /// <p>An exception list of resource exception keys to be processed with the current request. Config adds exception for each resource key. For example, Config adds 3 exceptions for 3 resource keys.</p>
    pub fn get_resource_keys(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::RemediationExceptionResourceKey>> {
        self.inner.get_resource_keys()
    }
}
