// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct DeleteServiceLinkedConfigurationRecorderOutput {
    /// <p>The Amazon Resource Name (ARN) of the specified configuration recorder.</p>
    pub arn: ::std::string::String,
    /// <p>The name of the specified configuration recorder.</p>
    pub name: ::std::string::String,
    _request_id: Option<String>,
}
impl DeleteServiceLinkedConfigurationRecorderOutput {
    /// <p>The Amazon Resource Name (ARN) of the specified configuration recorder.</p>
    pub fn arn(&self) -> &str {
        use std::ops::Deref;
        self.arn.deref()
    }
    /// <p>The name of the specified configuration recorder.</p>
    pub fn name(&self) -> &str {
        use std::ops::Deref;
        self.name.deref()
    }
}
impl ::aws_types::request_id::RequestId for DeleteServiceLinkedConfigurationRecorderOutput {
    fn request_id(&self) -> Option<&str> {
        self._request_id.as_deref()
    }
}
impl DeleteServiceLinkedConfigurationRecorderOutput {
    /// Creates a new builder-style object to manufacture [`DeleteServiceLinkedConfigurationRecorderOutput`](crate::operation::delete_service_linked_configuration_recorder::DeleteServiceLinkedConfigurationRecorderOutput).
    pub fn builder() -> crate::operation::delete_service_linked_configuration_recorder::builders::DeleteServiceLinkedConfigurationRecorderOutputBuilder
    {
        crate::operation::delete_service_linked_configuration_recorder::builders::DeleteServiceLinkedConfigurationRecorderOutputBuilder::default()
    }
}

/// A builder for [`DeleteServiceLinkedConfigurationRecorderOutput`](crate::operation::delete_service_linked_configuration_recorder::DeleteServiceLinkedConfigurationRecorderOutput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct DeleteServiceLinkedConfigurationRecorderOutputBuilder {
    pub(crate) arn: ::std::option::Option<::std::string::String>,
    pub(crate) name: ::std::option::Option<::std::string::String>,
    _request_id: Option<String>,
}
impl DeleteServiceLinkedConfigurationRecorderOutputBuilder {
    /// <p>The Amazon Resource Name (ARN) of the specified configuration recorder.</p>
    /// This field is required.
    pub fn arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the specified configuration recorder.</p>
    pub fn set_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.arn = input;
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the specified configuration recorder.</p>
    pub fn get_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.arn
    }
    /// <p>The name of the specified configuration recorder.</p>
    /// This field is required.
    pub fn name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the specified configuration recorder.</p>
    pub fn set_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.name = input;
        self
    }
    /// <p>The name of the specified configuration recorder.</p>
    pub fn get_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.name
    }
    pub(crate) fn _request_id(mut self, request_id: impl Into<String>) -> Self {
        self._request_id = Some(request_id.into());
        self
    }

    pub(crate) fn _set_request_id(&mut self, request_id: Option<String>) -> &mut Self {
        self._request_id = request_id;
        self
    }
    /// Consumes the builder and constructs a [`DeleteServiceLinkedConfigurationRecorderOutput`](crate::operation::delete_service_linked_configuration_recorder::DeleteServiceLinkedConfigurationRecorderOutput).
    /// This method will fail if any of the following fields are not set:
    /// - [`arn`](crate::operation::delete_service_linked_configuration_recorder::builders::DeleteServiceLinkedConfigurationRecorderOutputBuilder::arn)
    /// - [`name`](crate::operation::delete_service_linked_configuration_recorder::builders::DeleteServiceLinkedConfigurationRecorderOutputBuilder::name)
    pub fn build(
        self,
    ) -> ::std::result::Result<
        crate::operation::delete_service_linked_configuration_recorder::DeleteServiceLinkedConfigurationRecorderOutput,
        ::aws_smithy_types::error::operation::BuildError,
    > {
        ::std::result::Result::Ok(
            crate::operation::delete_service_linked_configuration_recorder::DeleteServiceLinkedConfigurationRecorderOutput {
                arn: self.arn.ok_or_else(|| {
                    ::aws_smithy_types::error::operation::BuildError::missing_field(
                        "arn",
                        "arn was not specified but it is required when building DeleteServiceLinkedConfigurationRecorderOutput",
                    )
                })?,
                name: self.name.ok_or_else(|| {
                    ::aws_smithy_types::error::operation::BuildError::missing_field(
                        "name",
                        "name was not specified but it is required when building DeleteServiceLinkedConfigurationRecorderOutput",
                    )
                })?,
                _request_id: self._request_id,
            },
        )
    }
}
