// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::get_conformance_pack_compliance_details::_get_conformance_pack_compliance_details_output::GetConformancePackComplianceDetailsOutputBuilder;

pub use crate::operation::get_conformance_pack_compliance_details::_get_conformance_pack_compliance_details_input::GetConformancePackComplianceDetailsInputBuilder;

impl crate::operation::get_conformance_pack_compliance_details::builders::GetConformancePackComplianceDetailsInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::get_conformance_pack_compliance_details::GetConformancePackComplianceDetailsOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_conformance_pack_compliance_details::GetConformancePackComplianceDetailsError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.get_conformance_pack_compliance_details();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `GetConformancePackComplianceDetails`.
///
/// <p>Returns compliance details of a conformance pack for all Amazon Web Services resources that are monitered by conformance pack.</p>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct GetConformancePackComplianceDetailsFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::get_conformance_pack_compliance_details::builders::GetConformancePackComplianceDetailsInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::get_conformance_pack_compliance_details::GetConformancePackComplianceDetailsOutput,
        crate::operation::get_conformance_pack_compliance_details::GetConformancePackComplianceDetailsError,
    > for GetConformancePackComplianceDetailsFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::get_conformance_pack_compliance_details::GetConformancePackComplianceDetailsOutput,
            crate::operation::get_conformance_pack_compliance_details::GetConformancePackComplianceDetailsError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl GetConformancePackComplianceDetailsFluentBuilder {
    /// Creates a new `GetConformancePackComplianceDetailsFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the GetConformancePackComplianceDetails as a reference.
    pub fn as_input(&self) -> &crate::operation::get_conformance_pack_compliance_details::builders::GetConformancePackComplianceDetailsInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::get_conformance_pack_compliance_details::GetConformancePackComplianceDetailsOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_conformance_pack_compliance_details::GetConformancePackComplianceDetailsError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins =
            crate::operation::get_conformance_pack_compliance_details::GetConformancePackComplianceDetails::operation_runtime_plugins(
                self.handle.runtime_plugins.clone(),
                &self.handle.conf,
                self.config_override,
            );
        crate::operation::get_conformance_pack_compliance_details::GetConformancePackComplianceDetails::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::get_conformance_pack_compliance_details::GetConformancePackComplianceDetailsOutput,
        crate::operation::get_conformance_pack_compliance_details::GetConformancePackComplianceDetailsError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// Create a paginator for this request
    ///
    /// Paginators are used by calling [`send().await`](crate::operation::get_conformance_pack_compliance_details::paginator::GetConformancePackComplianceDetailsPaginator::send) which returns a [`PaginationStream`](aws_smithy_async::future::pagination_stream::PaginationStream).
    pub fn into_paginator(
        self,
    ) -> crate::operation::get_conformance_pack_compliance_details::paginator::GetConformancePackComplianceDetailsPaginator {
        crate::operation::get_conformance_pack_compliance_details::paginator::GetConformancePackComplianceDetailsPaginator::new(
            self.handle,
            self.inner,
        )
    }
    /// <p>Name of the conformance pack.</p>
    pub fn conformance_pack_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.conformance_pack_name(input.into());
        self
    }
    /// <p>Name of the conformance pack.</p>
    pub fn set_conformance_pack_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_conformance_pack_name(input);
        self
    }
    /// <p>Name of the conformance pack.</p>
    pub fn get_conformance_pack_name(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_conformance_pack_name()
    }
    /// <p>A <code>ConformancePackEvaluationFilters</code> object.</p>
    pub fn filters(mut self, input: crate::types::ConformancePackEvaluationFilters) -> Self {
        self.inner = self.inner.filters(input);
        self
    }
    /// <p>A <code>ConformancePackEvaluationFilters</code> object.</p>
    pub fn set_filters(mut self, input: ::std::option::Option<crate::types::ConformancePackEvaluationFilters>) -> Self {
        self.inner = self.inner.set_filters(input);
        self
    }
    /// <p>A <code>ConformancePackEvaluationFilters</code> object.</p>
    pub fn get_filters(&self) -> &::std::option::Option<crate::types::ConformancePackEvaluationFilters> {
        self.inner.get_filters()
    }
    /// <p>The maximum number of evaluation results returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>
    pub fn limit(mut self, input: i32) -> Self {
        self.inner = self.inner.limit(input);
        self
    }
    /// <p>The maximum number of evaluation results returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>
    pub fn set_limit(mut self, input: ::std::option::Option<i32>) -> Self {
        self.inner = self.inner.set_limit(input);
        self
    }
    /// <p>The maximum number of evaluation results returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>
    pub fn get_limit(&self) -> &::std::option::Option<i32> {
        self.inner.get_limit()
    }
    /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
    pub fn next_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.next_token(input.into());
        self
    }
    /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
    pub fn set_next_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_next_token(input);
        self
    }
    /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
    pub fn get_next_token(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_next_token()
    }
}
