// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::get_resource_config_history::_get_resource_config_history_output::GetResourceConfigHistoryOutputBuilder;

pub use crate::operation::get_resource_config_history::_get_resource_config_history_input::GetResourceConfigHistoryInputBuilder;

impl crate::operation::get_resource_config_history::builders::GetResourceConfigHistoryInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::get_resource_config_history::GetResourceConfigHistoryOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_resource_config_history::GetResourceConfigHistoryError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.get_resource_config_history();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `GetResourceConfigHistory`.
///
/// <important>
/// <p>For accurate reporting on the compliance status, you must record the <code>AWS::Config::ResourceCompliance</code> resource type.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html">Recording Amazon Web Services Resources</a> in the <i>Config Resources Developer Guide</i>.</p>
/// </important>
/// <p>Returns a list of configurations items (CIs) for the specified resource.</p>
/// <p><b>Contents</b></p>
/// <p>The list contains details about each state of the resource during the specified time interval. If you specified a retention period to retain your CIs between a minimum of 30 days and a maximum of 7 years (2557 days), Config returns the CIs for the specified retention period.</p>
/// <p><b>Pagination</b></p>
/// <p>The response is paginated. By default, Config returns a limit of 10 configuration items per page. You can customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code> string. To get the next page of results, run the request again and specify the string for the <code>nextToken</code> parameter.</p><note>
/// <p>Each call to the API is limited to span a duration of seven days. It is likely that the number of records returned is smaller than the specified <code>limit</code>. In such cases, you can make another call, using the <code>nextToken</code>.</p>
/// </note>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct GetResourceConfigHistoryFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::get_resource_config_history::builders::GetResourceConfigHistoryInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::get_resource_config_history::GetResourceConfigHistoryOutput,
        crate::operation::get_resource_config_history::GetResourceConfigHistoryError,
    > for GetResourceConfigHistoryFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::get_resource_config_history::GetResourceConfigHistoryOutput,
            crate::operation::get_resource_config_history::GetResourceConfigHistoryError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl GetResourceConfigHistoryFluentBuilder {
    /// Creates a new `GetResourceConfigHistoryFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the GetResourceConfigHistory as a reference.
    pub fn as_input(&self) -> &crate::operation::get_resource_config_history::builders::GetResourceConfigHistoryInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::get_resource_config_history::GetResourceConfigHistoryOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_resource_config_history::GetResourceConfigHistoryError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::get_resource_config_history::GetResourceConfigHistory::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::get_resource_config_history::GetResourceConfigHistory::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::get_resource_config_history::GetResourceConfigHistoryOutput,
        crate::operation::get_resource_config_history::GetResourceConfigHistoryError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// Create a paginator for this request
    ///
    /// Paginators are used by calling [`send().await`](crate::operation::get_resource_config_history::paginator::GetResourceConfigHistoryPaginator::send) which returns a [`PaginationStream`](aws_smithy_async::future::pagination_stream::PaginationStream).
    pub fn into_paginator(self) -> crate::operation::get_resource_config_history::paginator::GetResourceConfigHistoryPaginator {
        crate::operation::get_resource_config_history::paginator::GetResourceConfigHistoryPaginator::new(self.handle, self.inner)
    }
    /// <p>The resource type.</p>
    pub fn resource_type(mut self, input: crate::types::ResourceType) -> Self {
        self.inner = self.inner.resource_type(input);
        self
    }
    /// <p>The resource type.</p>
    pub fn set_resource_type(mut self, input: ::std::option::Option<crate::types::ResourceType>) -> Self {
        self.inner = self.inner.set_resource_type(input);
        self
    }
    /// <p>The resource type.</p>
    pub fn get_resource_type(&self) -> &::std::option::Option<crate::types::ResourceType> {
        self.inner.get_resource_type()
    }
    /// <p>The ID of the resource (for example., <code>sg-xxxxxx</code>).</p>
    pub fn resource_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.resource_id(input.into());
        self
    }
    /// <p>The ID of the resource (for example., <code>sg-xxxxxx</code>).</p>
    pub fn set_resource_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_resource_id(input);
        self
    }
    /// <p>The ID of the resource (for example., <code>sg-xxxxxx</code>).</p>
    pub fn get_resource_id(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_resource_id()
    }
    /// <p>The chronologically latest time in the time range for which the history requested. If not specified, current time is taken.</p>
    pub fn later_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.inner = self.inner.later_time(input);
        self
    }
    /// <p>The chronologically latest time in the time range for which the history requested. If not specified, current time is taken.</p>
    pub fn set_later_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.inner = self.inner.set_later_time(input);
        self
    }
    /// <p>The chronologically latest time in the time range for which the history requested. If not specified, current time is taken.</p>
    pub fn get_later_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        self.inner.get_later_time()
    }
    /// <p>The chronologically earliest time in the time range for which the history requested. If not specified, the action returns paginated results that contain configuration items that start when the first configuration item was recorded.</p>
    pub fn earlier_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.inner = self.inner.earlier_time(input);
        self
    }
    /// <p>The chronologically earliest time in the time range for which the history requested. If not specified, the action returns paginated results that contain configuration items that start when the first configuration item was recorded.</p>
    pub fn set_earlier_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.inner = self.inner.set_earlier_time(input);
        self
    }
    /// <p>The chronologically earliest time in the time range for which the history requested. If not specified, the action returns paginated results that contain configuration items that start when the first configuration item was recorded.</p>
    pub fn get_earlier_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        self.inner.get_earlier_time()
    }
    /// <p>The chronological order for configuration items listed. By default, the results are listed in reverse chronological order.</p>
    pub fn chronological_order(mut self, input: crate::types::ChronologicalOrder) -> Self {
        self.inner = self.inner.chronological_order(input);
        self
    }
    /// <p>The chronological order for configuration items listed. By default, the results are listed in reverse chronological order.</p>
    pub fn set_chronological_order(mut self, input: ::std::option::Option<crate::types::ChronologicalOrder>) -> Self {
        self.inner = self.inner.set_chronological_order(input);
        self
    }
    /// <p>The chronological order for configuration items listed. By default, the results are listed in reverse chronological order.</p>
    pub fn get_chronological_order(&self) -> &::std::option::Option<crate::types::ChronologicalOrder> {
        self.inner.get_chronological_order()
    }
    /// <p>The maximum number of configuration items returned on each page. The default is 10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
    pub fn limit(mut self, input: i32) -> Self {
        self.inner = self.inner.limit(input);
        self
    }
    /// <p>The maximum number of configuration items returned on each page. The default is 10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
    pub fn set_limit(mut self, input: ::std::option::Option<i32>) -> Self {
        self.inner = self.inner.set_limit(input);
        self
    }
    /// <p>The maximum number of configuration items returned on each page. The default is 10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
    pub fn get_limit(&self) -> &::std::option::Option<i32> {
        self.inner.get_limit()
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.next_token(input.into());
        self
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn set_next_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_next_token(input);
        self
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn get_next_token(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_next_token()
    }
}
