// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::put_aggregation_authorization::_put_aggregation_authorization_output::PutAggregationAuthorizationOutputBuilder;

pub use crate::operation::put_aggregation_authorization::_put_aggregation_authorization_input::PutAggregationAuthorizationInputBuilder;

impl crate::operation::put_aggregation_authorization::builders::PutAggregationAuthorizationInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::put_aggregation_authorization::PutAggregationAuthorizationOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_aggregation_authorization::PutAggregationAuthorizationError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.put_aggregation_authorization();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `PutAggregationAuthorization`.
///
/// <p>Authorizes the aggregator account and region to collect data from the source account and region.</p><note>
/// <p><b>Tags are added at creation and cannot be updated with this operation</b></p>
/// <p><code>PutAggregationAuthorization</code> is an idempotent API. Subsequent requests won’t create a duplicate resource if one was already created. If a following request has different <code>tags</code> values, Config will ignore these differences and treat it as an idempotent request of the previous. In this case, <code>tags</code> will not be updated, even if they are different.</p>
/// <p>Use <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_TagResource.html">TagResource</a> and <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_UntagResource.html">UntagResource</a> to update tags after creation.</p>
/// </note>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct PutAggregationAuthorizationFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::put_aggregation_authorization::builders::PutAggregationAuthorizationInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::put_aggregation_authorization::PutAggregationAuthorizationOutput,
        crate::operation::put_aggregation_authorization::PutAggregationAuthorizationError,
    > for PutAggregationAuthorizationFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::put_aggregation_authorization::PutAggregationAuthorizationOutput,
            crate::operation::put_aggregation_authorization::PutAggregationAuthorizationError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl PutAggregationAuthorizationFluentBuilder {
    /// Creates a new `PutAggregationAuthorizationFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the PutAggregationAuthorization as a reference.
    pub fn as_input(&self) -> &crate::operation::put_aggregation_authorization::builders::PutAggregationAuthorizationInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::put_aggregation_authorization::PutAggregationAuthorizationOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_aggregation_authorization::PutAggregationAuthorizationError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::put_aggregation_authorization::PutAggregationAuthorization::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::put_aggregation_authorization::PutAggregationAuthorization::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::put_aggregation_authorization::PutAggregationAuthorizationOutput,
        crate::operation::put_aggregation_authorization::PutAggregationAuthorizationError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The 12-digit account ID of the account authorized to aggregate data.</p>
    pub fn authorized_account_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.authorized_account_id(input.into());
        self
    }
    /// <p>The 12-digit account ID of the account authorized to aggregate data.</p>
    pub fn set_authorized_account_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_authorized_account_id(input);
        self
    }
    /// <p>The 12-digit account ID of the account authorized to aggregate data.</p>
    pub fn get_authorized_account_id(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_authorized_account_id()
    }
    /// <p>The region authorized to collect aggregated data.</p>
    pub fn authorized_aws_region(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.authorized_aws_region(input.into());
        self
    }
    /// <p>The region authorized to collect aggregated data.</p>
    pub fn set_authorized_aws_region(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_authorized_aws_region(input);
        self
    }
    /// <p>The region authorized to collect aggregated data.</p>
    pub fn get_authorized_aws_region(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_authorized_aws_region()
    }
    ///
    /// Appends an item to `Tags`.
    ///
    /// To override the contents of this collection use [`set_tags`](Self::set_tags).
    ///
    /// <p>An array of tag object.</p>
    pub fn tags(mut self, input: crate::types::Tag) -> Self {
        self.inner = self.inner.tags(input);
        self
    }
    /// <p>An array of tag object.</p>
    pub fn set_tags(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::Tag>>) -> Self {
        self.inner = self.inner.set_tags(input);
        self
    }
    /// <p>An array of tag object.</p>
    pub fn get_tags(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::Tag>> {
        self.inner.get_tags()
    }
}
