// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p></p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct PutEvaluationsInput {
    /// <p>The assessments that the Lambda function performs. Each evaluation identifies an Amazon Web Services resource and indicates whether it complies with the Config rule that invokes the Lambda function.</p>
    pub evaluations: ::std::option::Option<::std::vec::Vec<crate::types::Evaluation>>,
    /// <p>An encrypted token that associates an evaluation with an Config rule. Identifies the rule and the event that triggered the evaluation.</p>
    pub result_token: ::std::option::Option<::std::string::String>,
    /// <p>Use this parameter to specify a test run for <code>PutEvaluations</code>. You can verify whether your Lambda function will deliver evaluation results to Config. No updates occur to your existing evaluations, and evaluation results are not sent to Config.</p><note>
    /// <p>When <code>TestMode</code> is <code>true</code>, <code>PutEvaluations</code> doesn't require a valid value for the <code>ResultToken</code> parameter, but the value cannot be null.</p>
    /// </note>
    pub test_mode: ::std::option::Option<bool>,
}
impl PutEvaluationsInput {
    /// <p>The assessments that the Lambda function performs. Each evaluation identifies an Amazon Web Services resource and indicates whether it complies with the Config rule that invokes the Lambda function.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.evaluations.is_none()`.
    pub fn evaluations(&self) -> &[crate::types::Evaluation] {
        self.evaluations.as_deref().unwrap_or_default()
    }
    /// <p>An encrypted token that associates an evaluation with an Config rule. Identifies the rule and the event that triggered the evaluation.</p>
    pub fn result_token(&self) -> ::std::option::Option<&str> {
        self.result_token.as_deref()
    }
    /// <p>Use this parameter to specify a test run for <code>PutEvaluations</code>. You can verify whether your Lambda function will deliver evaluation results to Config. No updates occur to your existing evaluations, and evaluation results are not sent to Config.</p><note>
    /// <p>When <code>TestMode</code> is <code>true</code>, <code>PutEvaluations</code> doesn't require a valid value for the <code>ResultToken</code> parameter, but the value cannot be null.</p>
    /// </note>
    pub fn test_mode(&self) -> ::std::option::Option<bool> {
        self.test_mode
    }
}
impl PutEvaluationsInput {
    /// Creates a new builder-style object to manufacture [`PutEvaluationsInput`](crate::operation::put_evaluations::PutEvaluationsInput).
    pub fn builder() -> crate::operation::put_evaluations::builders::PutEvaluationsInputBuilder {
        crate::operation::put_evaluations::builders::PutEvaluationsInputBuilder::default()
    }
}

/// A builder for [`PutEvaluationsInput`](crate::operation::put_evaluations::PutEvaluationsInput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct PutEvaluationsInputBuilder {
    pub(crate) evaluations: ::std::option::Option<::std::vec::Vec<crate::types::Evaluation>>,
    pub(crate) result_token: ::std::option::Option<::std::string::String>,
    pub(crate) test_mode: ::std::option::Option<bool>,
}
impl PutEvaluationsInputBuilder {
    /// Appends an item to `evaluations`.
    ///
    /// To override the contents of this collection use [`set_evaluations`](Self::set_evaluations).
    ///
    /// <p>The assessments that the Lambda function performs. Each evaluation identifies an Amazon Web Services resource and indicates whether it complies with the Config rule that invokes the Lambda function.</p>
    pub fn evaluations(mut self, input: crate::types::Evaluation) -> Self {
        let mut v = self.evaluations.unwrap_or_default();
        v.push(input);
        self.evaluations = ::std::option::Option::Some(v);
        self
    }
    /// <p>The assessments that the Lambda function performs. Each evaluation identifies an Amazon Web Services resource and indicates whether it complies with the Config rule that invokes the Lambda function.</p>
    pub fn set_evaluations(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::Evaluation>>) -> Self {
        self.evaluations = input;
        self
    }
    /// <p>The assessments that the Lambda function performs. Each evaluation identifies an Amazon Web Services resource and indicates whether it complies with the Config rule that invokes the Lambda function.</p>
    pub fn get_evaluations(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::Evaluation>> {
        &self.evaluations
    }
    /// <p>An encrypted token that associates an evaluation with an Config rule. Identifies the rule and the event that triggered the evaluation.</p>
    /// This field is required.
    pub fn result_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.result_token = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>An encrypted token that associates an evaluation with an Config rule. Identifies the rule and the event that triggered the evaluation.</p>
    pub fn set_result_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.result_token = input;
        self
    }
    /// <p>An encrypted token that associates an evaluation with an Config rule. Identifies the rule and the event that triggered the evaluation.</p>
    pub fn get_result_token(&self) -> &::std::option::Option<::std::string::String> {
        &self.result_token
    }
    /// <p>Use this parameter to specify a test run for <code>PutEvaluations</code>. You can verify whether your Lambda function will deliver evaluation results to Config. No updates occur to your existing evaluations, and evaluation results are not sent to Config.</p><note>
    /// <p>When <code>TestMode</code> is <code>true</code>, <code>PutEvaluations</code> doesn't require a valid value for the <code>ResultToken</code> parameter, but the value cannot be null.</p>
    /// </note>
    pub fn test_mode(mut self, input: bool) -> Self {
        self.test_mode = ::std::option::Option::Some(input);
        self
    }
    /// <p>Use this parameter to specify a test run for <code>PutEvaluations</code>. You can verify whether your Lambda function will deliver evaluation results to Config. No updates occur to your existing evaluations, and evaluation results are not sent to Config.</p><note>
    /// <p>When <code>TestMode</code> is <code>true</code>, <code>PutEvaluations</code> doesn't require a valid value for the <code>ResultToken</code> parameter, but the value cannot be null.</p>
    /// </note>
    pub fn set_test_mode(mut self, input: ::std::option::Option<bool>) -> Self {
        self.test_mode = input;
        self
    }
    /// <p>Use this parameter to specify a test run for <code>PutEvaluations</code>. You can verify whether your Lambda function will deliver evaluation results to Config. No updates occur to your existing evaluations, and evaluation results are not sent to Config.</p><note>
    /// <p>When <code>TestMode</code> is <code>true</code>, <code>PutEvaluations</code> doesn't require a valid value for the <code>ResultToken</code> parameter, but the value cannot be null.</p>
    /// </note>
    pub fn get_test_mode(&self) -> &::std::option::Option<bool> {
        &self.test_mode
    }
    /// Consumes the builder and constructs a [`PutEvaluationsInput`](crate::operation::put_evaluations::PutEvaluationsInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<crate::operation::put_evaluations::PutEvaluationsInput, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::operation::put_evaluations::PutEvaluationsInput {
            evaluations: self.evaluations,
            result_token: self.result_token,
            test_mode: self.test_mode,
        })
    }
}
