// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Orchestration and serialization glue logic for `PutOrganizationConformancePack`.
#[derive(::std::clone::Clone, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct PutOrganizationConformancePack;
impl PutOrganizationConformancePack {
    /// Creates a new `PutOrganizationConformancePack`
    pub fn new() -> Self {
        Self
    }
    pub(crate) async fn orchestrate(
        runtime_plugins: &::aws_smithy_runtime_api::client::runtime_plugin::RuntimePlugins,
        input: crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackInput,
    ) -> ::std::result::Result<
        crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let map_err = |err: ::aws_smithy_runtime_api::client::result::SdkError<
            ::aws_smithy_runtime_api::client::interceptors::context::Error,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >| {
            err.map_service_error(|err| {
                err.downcast::<crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackError>()
                    .expect("correct error type")
            })
        };
        let context = Self::orchestrate_with_stop_point(runtime_plugins, input, ::aws_smithy_runtime::client::orchestrator::StopPoint::None)
            .await
            .map_err(map_err)?;
        let output = context.finalize().map_err(map_err)?;
        ::std::result::Result::Ok(
            output
                .downcast::<crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackOutput>()
                .expect("correct output type"),
        )
    }

    pub(crate) async fn orchestrate_with_stop_point(
        runtime_plugins: &::aws_smithy_runtime_api::client::runtime_plugin::RuntimePlugins,
        input: crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackInput,
        stop_point: ::aws_smithy_runtime::client::orchestrator::StopPoint,
    ) -> ::std::result::Result<
        ::aws_smithy_runtime_api::client::interceptors::context::InterceptorContext,
        ::aws_smithy_runtime_api::client::result::SdkError<
            ::aws_smithy_runtime_api::client::interceptors::context::Error,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = ::aws_smithy_runtime_api::client::interceptors::context::Input::erase(input);
        use ::tracing::Instrument;
        ::aws_smithy_runtime::client::orchestrator::invoke_with_stop_point(
            "Config Service",
            "PutOrganizationConformancePack",
            input,
            runtime_plugins,
            stop_point,
        )
        // Create a parent span for the entire operation. Includes a random, internal-only,
        // seven-digit ID for the operation orchestration so that it can be correlated in the logs.
        .instrument(::tracing::debug_span!(
            "Config Service.PutOrganizationConformancePack",
            "rpc.service" = "Config Service",
            "rpc.method" = "PutOrganizationConformancePack",
            "sdk_invocation_id" = ::fastrand::u32(1_000_000..10_000_000),
            "rpc.system" = "aws-api",
        ))
        .await
    }

    pub(crate) fn operation_runtime_plugins(
        client_runtime_plugins: ::aws_smithy_runtime_api::client::runtime_plugin::RuntimePlugins,
        client_config: &crate::config::Config,
        config_override: ::std::option::Option<crate::config::Builder>,
    ) -> ::aws_smithy_runtime_api::client::runtime_plugin::RuntimePlugins {
        let mut runtime_plugins = client_runtime_plugins.with_operation_plugin(Self::new());

        if let ::std::option::Option::Some(config_override) = config_override {
            for plugin in config_override.runtime_plugins.iter().cloned() {
                runtime_plugins = runtime_plugins.with_operation_plugin(plugin);
            }
            runtime_plugins = runtime_plugins.with_operation_plugin(crate::config::ConfigOverrideRuntimePlugin::new(
                config_override,
                client_config.config.clone(),
                &client_config.runtime_components,
            ));
        }
        runtime_plugins
    }
}
impl ::aws_smithy_runtime_api::client::runtime_plugin::RuntimePlugin for PutOrganizationConformancePack {
    fn config(&self) -> ::std::option::Option<::aws_smithy_types::config_bag::FrozenLayer> {
        let mut cfg = ::aws_smithy_types::config_bag::Layer::new("PutOrganizationConformancePack");

        cfg.store_put(::aws_smithy_runtime_api::client::ser_de::SharedRequestSerializer::new(
            PutOrganizationConformancePackRequestSerializer,
        ));
        cfg.store_put(::aws_smithy_runtime_api::client::ser_de::SharedResponseDeserializer::new(
            PutOrganizationConformancePackResponseDeserializer,
        ));

        cfg.store_put(::aws_smithy_runtime_api::client::auth::AuthSchemeOptionResolverParams::new(
            crate::config::auth::Params::builder()
                .operation_name("PutOrganizationConformancePack")
                .build()
                .expect("required fields set"),
        ));

        cfg.store_put(::aws_smithy_runtime_api::client::orchestrator::Metadata::new(
            "PutOrganizationConformancePack",
            "Config Service",
        ));
        let mut signing_options = ::aws_runtime::auth::SigningOptions::default();
        signing_options.double_uri_encode = true;
        signing_options.content_sha256_header = false;
        signing_options.normalize_uri_path = true;
        signing_options.payload_override = None;

        cfg.store_put(::aws_runtime::auth::SigV4OperationSigningConfig {
            signing_options,
            ..::std::default::Default::default()
        });

        ::std::option::Option::Some(cfg.freeze())
    }

    fn runtime_components(
        &self,
        _: &::aws_smithy_runtime_api::client::runtime_components::RuntimeComponentsBuilder,
    ) -> ::std::borrow::Cow<'_, ::aws_smithy_runtime_api::client::runtime_components::RuntimeComponentsBuilder> {
        #[allow(unused_mut)]
        let mut rcb = ::aws_smithy_runtime_api::client::runtime_components::RuntimeComponentsBuilder::new("PutOrganizationConformancePack")
            .with_interceptor(::aws_smithy_runtime::client::stalled_stream_protection::StalledStreamProtectionInterceptor::default())
            .with_interceptor(PutOrganizationConformancePackEndpointParamsInterceptor)
            .with_retry_classifier(::aws_smithy_runtime::client::retries::classifiers::TransientErrorClassifier::<
                crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackError,
            >::new())
            .with_retry_classifier(::aws_smithy_runtime::client::retries::classifiers::ModeledAsRetryableClassifier::<
                crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackError,
            >::new())
            .with_retry_classifier(::aws_runtime::retries::classifiers::AwsErrorCodeClassifier::<
                crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackError,
            >::new());

        ::std::borrow::Cow::Owned(rcb)
    }
}

#[derive(Debug)]
struct PutOrganizationConformancePackResponseDeserializer;
impl ::aws_smithy_runtime_api::client::ser_de::DeserializeResponse for PutOrganizationConformancePackResponseDeserializer {
    fn deserialize_nonstreaming(
        &self,
        response: &::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
    ) -> ::aws_smithy_runtime_api::client::interceptors::context::OutputOrError {
        let (success, status) = (response.status().is_success(), response.status().as_u16());
        let headers = response.headers();
        let body = response.body().bytes().expect("body loaded");
        #[allow(unused_mut)]
        let mut force_error = false;
        ::tracing::debug!(request_id = ?::aws_types::request_id::RequestId::request_id(response));
        let parse_result = if !success && status != 200 || force_error {
            crate::protocol_serde::shape_put_organization_conformance_pack::de_put_organization_conformance_pack_http_error(status, headers, body)
        } else {
            crate::protocol_serde::shape_put_organization_conformance_pack::de_put_organization_conformance_pack_http_response(status, headers, body)
        };
        crate::protocol_serde::type_erase_result(parse_result)
    }
}
#[derive(Debug)]
struct PutOrganizationConformancePackRequestSerializer;
impl ::aws_smithy_runtime_api::client::ser_de::SerializeRequest for PutOrganizationConformancePackRequestSerializer {
    #[allow(unused_mut, clippy::let_and_return, clippy::needless_borrow, clippy::useless_conversion)]
    fn serialize_input(
        &self,
        input: ::aws_smithy_runtime_api::client::interceptors::context::Input,
        _cfg: &mut ::aws_smithy_types::config_bag::ConfigBag,
    ) -> ::std::result::Result<::aws_smithy_runtime_api::client::orchestrator::HttpRequest, ::aws_smithy_runtime_api::box_error::BoxError> {
        let input = input
            .downcast::<crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackInput>()
            .expect("correct type");
        let _header_serialization_settings = _cfg
            .load::<crate::serialization_settings::HeaderSerializationSettings>()
            .cloned()
            .unwrap_or_default();
        let mut request_builder = {
            #[allow(clippy::uninlined_format_args)]
            fn uri_base(
                _input: &crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackInput,
                output: &mut ::std::string::String,
            ) -> ::std::result::Result<(), ::aws_smithy_types::error::operation::BuildError> {
                use ::std::fmt::Write as _;
                ::std::write!(output, "/").expect("formatting should succeed");
                ::std::result::Result::Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackInput,
                builder: ::http::request::Builder,
            ) -> ::std::result::Result<::http::request::Builder, ::aws_smithy_types::error::operation::BuildError> {
                let mut uri = ::std::string::String::new();
                uri_base(input, &mut uri)?;
                ::std::result::Result::Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&input, ::http::request::Builder::new())?;
            builder = _header_serialization_settings.set_default_header(builder, ::http::header::CONTENT_TYPE, "application/x-amz-json-1.1");
            builder = _header_serialization_settings.set_default_header(
                builder,
                ::http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.PutOrganizationConformancePack",
            );
            builder
        };
        let body = ::aws_smithy_types::body::SdkBody::from(
            crate::protocol_serde::shape_put_organization_conformance_pack::ser_put_organization_conformance_pack_input(&input)?,
        );
        if let Some(content_length) = body.content_length() {
            let content_length = content_length.to_string();
            request_builder = _header_serialization_settings.set_default_header(request_builder, ::http::header::CONTENT_LENGTH, &content_length);
        }
        ::std::result::Result::Ok(request_builder.body(body).expect("valid request").try_into().unwrap())
    }
}
#[derive(Debug)]
struct PutOrganizationConformancePackEndpointParamsInterceptor;

impl ::aws_smithy_runtime_api::client::interceptors::Intercept for PutOrganizationConformancePackEndpointParamsInterceptor {
    fn name(&self) -> &'static str {
        "PutOrganizationConformancePackEndpointParamsInterceptor"
    }

    fn read_before_execution(
        &self,
        context: &::aws_smithy_runtime_api::client::interceptors::context::BeforeSerializationInterceptorContextRef<
            '_,
            ::aws_smithy_runtime_api::client::interceptors::context::Input,
            ::aws_smithy_runtime_api::client::interceptors::context::Output,
            ::aws_smithy_runtime_api::client::interceptors::context::Error,
        >,
        cfg: &mut ::aws_smithy_types::config_bag::ConfigBag,
    ) -> ::std::result::Result<(), ::aws_smithy_runtime_api::box_error::BoxError> {
        let _input = context
            .input()
            .downcast_ref::<PutOrganizationConformancePackInput>()
            .ok_or("failed to downcast to PutOrganizationConformancePackInput")?;

        let params = crate::config::endpoint::Params::builder()
            .set_region(cfg.load::<::aws_types::region::Region>().map(|r| r.as_ref().to_owned()))
            .set_use_dual_stack(cfg.load::<::aws_types::endpoint_config::UseDualStack>().map(|ty| ty.0))
            .set_use_fips(cfg.load::<::aws_types::endpoint_config::UseFips>().map(|ty| ty.0))
            .set_endpoint(cfg.load::<::aws_types::endpoint_config::EndpointUrl>().map(|ty| ty.0.clone()))
            .build()
            .map_err(|err| {
                ::aws_smithy_runtime_api::client::interceptors::error::ContextAttachedError::new("endpoint params could not be built", err)
            })?;
        cfg.interceptor_state()
            .store_put(::aws_smithy_runtime_api::client::endpoint::EndpointResolverParams::new(params));
        ::std::result::Result::Ok(())
    }
}

// The get_* functions below are generated from JMESPath expressions in the
// operationContextParams trait. They target the operation's input shape.

/// Error type for the `PutOrganizationConformancePackError` operation.
#[non_exhaustive]
#[derive(::std::fmt::Debug)]
pub enum PutOrganizationConformancePackError {
    /// <p>Indicates one of the following errors:</p>
    /// <ul>
    /// <li>
    /// <p>For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigRule.html">PutConfigRule</a>, the rule cannot be created because the IAM role assigned to Config lacks permissions to perform the config:Put* action.</p></li>
    /// <li>
    /// <p>For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigRule.html">PutConfigRule</a>, the Lambda function cannot be invoked. Check the function ARN, and check the function's permissions.</p></li>
    /// <li>
    /// <p>For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutOrganizationConfigRule.html">PutOrganizationConfigRule</a>, organization Config rule cannot be created because you do not have permissions to call IAM <code>GetRole</code> action or create a service-linked role.</p></li>
    /// <li>
    /// <p>For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutConformancePack.html">PutConformancePack</a> and <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutOrganizationConformancePack.html">PutOrganizationConformancePack</a>, a conformance pack cannot be created because you do not have the following permissions:</p>
    /// <ul>
    /// <li>
    /// <p>You do not have permission to call IAM <code>GetRole</code> action or create a service-linked role.</p></li>
    /// <li>
    /// <p>You do not have permission to read Amazon S3 bucket or call SSM:GetDocument.</p></li>
    /// </ul></li>
    /// <li>
    /// <p>For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutServiceLinkedConfigurationRecorder.html">PutServiceLinkedConfigurationRecorder</a>, a service-linked configuration recorder cannot be created because you do not have the following permissions: IAM <code>CreateServiceLinkedRole</code>.</p></li>
    /// </ul>
    InsufficientPermissionsException(crate::types::error::InsufficientPermissionsException),
    /// <p>You have reached the limit of the number of organization conformance packs you can create in an account. For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html"> <b>Service Limits</b> </a> in the <i>Config Developer Guide</i>.</p>
    MaxNumberOfOrganizationConformancePacksExceededException(crate::types::error::MaxNumberOfOrganizationConformancePacksExceededException),
    /// <p>Organization is no longer available.</p>
    NoAvailableOrganizationException(crate::types::error::NoAvailableOrganizationException),
    /// <p>For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:</p>
    /// <ul>
    /// <li>
    /// <p>No permission to call <code>EnableAWSServiceAccess</code> API</p></li>
    /// <li>
    /// <p>The configuration aggregator cannot be updated because your Amazon Web Services Organization management account or the delegated administrator role changed. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p></li>
    /// <li>
    /// <p>The configuration aggregator is associated with a previous Amazon Web Services Organization and Config cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p></li>
    /// <li>
    /// <p>You are not a registered delegated administrator for Config with permissions to call <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated administrator for Config service principal name before the delegated administrator creates an aggregator.</p></li>
    /// </ul>
    /// <p>For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config throws an exception if APIs are called from member accounts. All APIs must be called from organization management account.</p>
    OrganizationAccessDeniedException(crate::types::error::OrganizationAccessDeniedException),
    /// <p>Config resource cannot be created because your organization does not have all features enabled.</p>
    OrganizationAllFeaturesNotEnabledException(crate::types::error::OrganizationAllFeaturesNotEnabledException),
    /// <p>You have specified a template that is not valid or supported.</p>
    OrganizationConformancePackTemplateValidationException(crate::types::error::OrganizationConformancePackTemplateValidationException),
    /// <p>You see this exception in the following cases:</p>
    /// <ul>
    /// <li>
    /// <p>For DeleteConfigRule, Config is deleting this rule. Try your request again later.</p></li>
    /// <li>
    /// <p>For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.</p></li>
    /// <li>
    /// <p>For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this rule. Delete the remediation action associated with the rule before deleting the rule and try your request again later.</p></li>
    /// <li>
    /// <p>For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again later.</p></li>
    /// <li>
    /// <p>For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request again later.</p></li>
    /// <li>
    /// <p>For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and deletion is in progress. Try your request again later.</p></li>
    /// <li>
    /// <p>For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your request again later.</p></li>
    /// </ul>
    ResourceInUseException(crate::types::error::ResourceInUseException),
    /// <p>The requested operation is not valid. You will see this exception if there are missing required fields or if the input value fails the validation.</p>
    /// <p>For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>, one of the following errors:</p>
    /// <ul>
    /// <li>
    /// <p>There are missing required fields.</p></li>
    /// <li>
    /// <p>The input value fails the validation.</p></li>
    /// <li>
    /// <p>You are trying to create more than 300 queries.</p></li>
    /// </ul>
    /// <p>For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html">DescribeConfigurationRecorders</a> and <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html">DescribeConfigurationRecorderStatus</a>, one of the following errors:</p>
    /// <ul>
    /// <li>
    /// <p>You have specified more than one configuration recorder.</p></li>
    /// <li>
    /// <p>You have provided a service principal for service-linked configuration recorder that is not valid.</p></li>
    /// </ul>
    /// <p>For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">AssociateResourceTypes</a> and <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html">DisassociateResourceTypes</a>, one of the following errors:</p>
    /// <ul>
    /// <li>
    /// <p>Your configuraiton recorder has a recording strategy that does not allow the association or disassociation of resource types.</p></li>
    /// <li>
    /// <p>One or more of the specified resource types are already associated or disassociated with the configuration recorder.</p></li>
    /// <li>
    /// <p>For service-linked configuration recorders, the configuration recorder does not record one or more of the specified resource types.</p></li>
    /// </ul>
    ValidationException(crate::types::error::ValidationException),
    /// An unexpected error occurred (e.g., invalid JSON returned by the service or an unknown error code).
    #[deprecated(note = "Matching `Unhandled` directly is not forwards compatible. Instead, match using a \
    variable wildcard pattern and check `.code()`:
     \
    &nbsp;&nbsp;&nbsp;`err if err.code() == Some(\"SpecificExceptionCode\") => { /* handle the error */ }`
     \
    See [`ProvideErrorMetadata`](#impl-ProvideErrorMetadata-for-PutOrganizationConformancePackError) for what information is available for the error.")]
    Unhandled(crate::error::sealed_unhandled::Unhandled),
}
impl PutOrganizationConformancePackError {
    /// Creates the `PutOrganizationConformancePackError::Unhandled` variant from any error type.
    pub fn unhandled(
        err: impl ::std::convert::Into<::std::boxed::Box<dyn ::std::error::Error + ::std::marker::Send + ::std::marker::Sync + 'static>>,
    ) -> Self {
        Self::Unhandled(crate::error::sealed_unhandled::Unhandled {
            source: err.into(),
            meta: ::std::default::Default::default(),
        })
    }

    /// Creates the `PutOrganizationConformancePackError::Unhandled` variant from an [`ErrorMetadata`](::aws_smithy_types::error::ErrorMetadata).
    pub fn generic(err: ::aws_smithy_types::error::ErrorMetadata) -> Self {
        Self::Unhandled(crate::error::sealed_unhandled::Unhandled {
            source: err.clone().into(),
            meta: err,
        })
    }
    ///
    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    ///
    pub fn meta(&self) -> &::aws_smithy_types::error::ErrorMetadata {
        match self {
            Self::InsufficientPermissionsException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::MaxNumberOfOrganizationConformancePacksExceededException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::NoAvailableOrganizationException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::OrganizationAccessDeniedException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::OrganizationAllFeaturesNotEnabledException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::OrganizationConformancePackTemplateValidationException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::ResourceInUseException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::ValidationException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::Unhandled(e) => &e.meta,
        }
    }
    /// Returns `true` if the error kind is `PutOrganizationConformancePackError::InsufficientPermissionsException`.
    pub fn is_insufficient_permissions_exception(&self) -> bool {
        matches!(self, Self::InsufficientPermissionsException(_))
    }
    /// Returns `true` if the error kind is `PutOrganizationConformancePackError::MaxNumberOfOrganizationConformancePacksExceededException`.
    pub fn is_max_number_of_organization_conformance_packs_exceeded_exception(&self) -> bool {
        matches!(self, Self::MaxNumberOfOrganizationConformancePacksExceededException(_))
    }
    /// Returns `true` if the error kind is `PutOrganizationConformancePackError::NoAvailableOrganizationException`.
    pub fn is_no_available_organization_exception(&self) -> bool {
        matches!(self, Self::NoAvailableOrganizationException(_))
    }
    /// Returns `true` if the error kind is `PutOrganizationConformancePackError::OrganizationAccessDeniedException`.
    pub fn is_organization_access_denied_exception(&self) -> bool {
        matches!(self, Self::OrganizationAccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `PutOrganizationConformancePackError::OrganizationAllFeaturesNotEnabledException`.
    pub fn is_organization_all_features_not_enabled_exception(&self) -> bool {
        matches!(self, Self::OrganizationAllFeaturesNotEnabledException(_))
    }
    /// Returns `true` if the error kind is `PutOrganizationConformancePackError::OrganizationConformancePackTemplateValidationException`.
    pub fn is_organization_conformance_pack_template_validation_exception(&self) -> bool {
        matches!(self, Self::OrganizationConformancePackTemplateValidationException(_))
    }
    /// Returns `true` if the error kind is `PutOrganizationConformancePackError::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(self, Self::ResourceInUseException(_))
    }
    /// Returns `true` if the error kind is `PutOrganizationConformancePackError::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(self, Self::ValidationException(_))
    }
}
impl ::std::error::Error for PutOrganizationConformancePackError {
    fn source(&self) -> ::std::option::Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            Self::InsufficientPermissionsException(_inner) => ::std::option::Option::Some(_inner),
            Self::MaxNumberOfOrganizationConformancePacksExceededException(_inner) => ::std::option::Option::Some(_inner),
            Self::NoAvailableOrganizationException(_inner) => ::std::option::Option::Some(_inner),
            Self::OrganizationAccessDeniedException(_inner) => ::std::option::Option::Some(_inner),
            Self::OrganizationAllFeaturesNotEnabledException(_inner) => ::std::option::Option::Some(_inner),
            Self::OrganizationConformancePackTemplateValidationException(_inner) => ::std::option::Option::Some(_inner),
            Self::ResourceInUseException(_inner) => ::std::option::Option::Some(_inner),
            Self::ValidationException(_inner) => ::std::option::Option::Some(_inner),
            Self::Unhandled(_inner) => ::std::option::Option::Some(&*_inner.source),
        }
    }
}
impl ::std::fmt::Display for PutOrganizationConformancePackError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            Self::InsufficientPermissionsException(_inner) => _inner.fmt(f),
            Self::MaxNumberOfOrganizationConformancePacksExceededException(_inner) => _inner.fmt(f),
            Self::NoAvailableOrganizationException(_inner) => _inner.fmt(f),
            Self::OrganizationAccessDeniedException(_inner) => _inner.fmt(f),
            Self::OrganizationAllFeaturesNotEnabledException(_inner) => _inner.fmt(f),
            Self::OrganizationConformancePackTemplateValidationException(_inner) => _inner.fmt(f),
            Self::ResourceInUseException(_inner) => _inner.fmt(f),
            Self::ValidationException(_inner) => _inner.fmt(f),
            Self::Unhandled(_inner) => {
                if let ::std::option::Option::Some(code) = ::aws_smithy_types::error::metadata::ProvideErrorMetadata::code(self) {
                    write!(f, "unhandled error ({code})")
                } else {
                    f.write_str("unhandled error")
                }
            }
        }
    }
}
impl ::aws_smithy_types::retry::ProvideErrorKind for PutOrganizationConformancePackError {
    fn code(&self) -> ::std::option::Option<&str> {
        ::aws_smithy_types::error::metadata::ProvideErrorMetadata::code(self)
    }
    fn retryable_error_kind(&self) -> ::std::option::Option<::aws_smithy_types::retry::ErrorKind> {
        ::std::option::Option::None
    }
}
impl ::aws_smithy_types::error::metadata::ProvideErrorMetadata for PutOrganizationConformancePackError {
    fn meta(&self) -> &::aws_smithy_types::error::ErrorMetadata {
        match self {
            Self::InsufficientPermissionsException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::MaxNumberOfOrganizationConformancePacksExceededException(_inner) => {
                ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner)
            }
            Self::NoAvailableOrganizationException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::OrganizationAccessDeniedException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::OrganizationAllFeaturesNotEnabledException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::OrganizationConformancePackTemplateValidationException(_inner) => {
                ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner)
            }
            Self::ResourceInUseException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::ValidationException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::Unhandled(_inner) => &_inner.meta,
        }
    }
}
impl ::aws_smithy_runtime_api::client::result::CreateUnhandledError for PutOrganizationConformancePackError {
    fn create_unhandled_error(
        source: ::std::boxed::Box<dyn ::std::error::Error + ::std::marker::Send + ::std::marker::Sync + 'static>,
        meta: ::std::option::Option<::aws_smithy_types::error::ErrorMetadata>,
    ) -> Self {
        Self::Unhandled(crate::error::sealed_unhandled::Unhandled {
            source,
            meta: meta.unwrap_or_default(),
        })
    }
}
impl ::aws_types::request_id::RequestId for crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackError {
    fn request_id(&self) -> Option<&str> {
        self.meta().request_id()
    }
}

pub use crate::operation::put_organization_conformance_pack::_put_organization_conformance_pack_output::PutOrganizationConformancePackOutput;

pub use crate::operation::put_organization_conformance_pack::_put_organization_conformance_pack_input::PutOrganizationConformancePackInput;

mod _put_organization_conformance_pack_input;

mod _put_organization_conformance_pack_output;

/// Builders
pub mod builders;
