// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::put_organization_conformance_pack::_put_organization_conformance_pack_output::PutOrganizationConformancePackOutputBuilder;

pub use crate::operation::put_organization_conformance_pack::_put_organization_conformance_pack_input::PutOrganizationConformancePackInputBuilder;

impl crate::operation::put_organization_conformance_pack::builders::PutOrganizationConformancePackInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.put_organization_conformance_pack();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `PutOrganizationConformancePack`.
///
/// <p>Deploys conformance packs across member accounts in an Amazon Web Services Organization. For information on how many organization conformance packs and how many Config rules you can have per account, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html"> <b>Service Limits</b> </a> in the <i>Config Developer Guide</i>.</p>
/// <p>Only a management account and a delegated administrator can call this API. When calling this API with a delegated administrator, you must ensure Organizations <code>ListDelegatedAdministrator</code> permissions are added. An organization can have up to 3 delegated administrators.</p><important>
/// <p>When you use <code>PutOrganizationConformancePack</code> to deploy conformance packs across member accounts, the operation can create Config rules and remediation actions without requiring <code>config:PutConfigRule</code> or <code>config:PutRemediationConfigurations</code> permissions in member account IAM policies.</p>
/// <p>This API uses the <code>AWSServiceRoleForConfigConforms</code> service-linked role in each member account to create conformance pack resources. This service-linked role includes the permissions to create Config rules and remediation configurations, even if member account IAM policies explicitly deny these actions.</p>
/// </important>
/// <p>This API enables organization service access for <code>config-multiaccountsetup.amazonaws.com</code> through the <code>EnableAWSServiceAccess</code> action and creates a service-linked role <code>AWSServiceRoleForConfigMultiAccountSetup</code> in the management or delegated administrator account of your organization. The service-linked role is created only when the role does not exist in the caller account. To use this API with delegated administrator, register a delegated administrator by calling Amazon Web Services Organization <code>register-delegate-admin</code> for <code>config-multiaccountsetup.amazonaws.com</code>.</p><note>
/// <p>Prerequisite: Ensure you call <code>EnableAllFeatures</code> API to enable all features in an organization.</p>
/// <p>You must specify either the <code>TemplateS3Uri</code> or the <code>TemplateBody</code> parameter, but not both. If you provide both Config uses the <code>TemplateS3Uri</code> parameter and ignores the <code>TemplateBody</code> parameter.</p>
/// <p>Config sets the state of a conformance pack to CREATE_IN_PROGRESS and UPDATE_IN_PROGRESS until the conformance pack is created or updated. You cannot update a conformance pack while it is in this state.</p>
/// </note>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct PutOrganizationConformancePackFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::put_organization_conformance_pack::builders::PutOrganizationConformancePackInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackOutput,
        crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackError,
    > for PutOrganizationConformancePackFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackOutput,
            crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl PutOrganizationConformancePackFluentBuilder {
    /// Creates a new `PutOrganizationConformancePackFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the PutOrganizationConformancePack as a reference.
    pub fn as_input(&self) -> &crate::operation::put_organization_conformance_pack::builders::PutOrganizationConformancePackInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::put_organization_conformance_pack::PutOrganizationConformancePack::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::put_organization_conformance_pack::PutOrganizationConformancePack::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackOutput,
        crate::operation::put_organization_conformance_pack::PutOrganizationConformancePackError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>Name of the organization conformance pack you want to create.</p>
    pub fn organization_conformance_pack_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.organization_conformance_pack_name(input.into());
        self
    }
    /// <p>Name of the organization conformance pack you want to create.</p>
    pub fn set_organization_conformance_pack_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_organization_conformance_pack_name(input);
        self
    }
    /// <p>Name of the organization conformance pack you want to create.</p>
    pub fn get_organization_conformance_pack_name(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_organization_conformance_pack_name()
    }
    /// <p>Location of file containing the template body. The uri must point to the conformance pack template (max size: 300 KB).</p><note>
    /// <p>You must have access to read Amazon S3 bucket. In addition, in order to ensure a successful deployment, the template object must not be in an <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-class-intro.html">archived storage class</a> if this parameter is passed.</p>
    /// </note>
    pub fn template_s3_uri(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.template_s3_uri(input.into());
        self
    }
    /// <p>Location of file containing the template body. The uri must point to the conformance pack template (max size: 300 KB).</p><note>
    /// <p>You must have access to read Amazon S3 bucket. In addition, in order to ensure a successful deployment, the template object must not be in an <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-class-intro.html">archived storage class</a> if this parameter is passed.</p>
    /// </note>
    pub fn set_template_s3_uri(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_template_s3_uri(input);
        self
    }
    /// <p>Location of file containing the template body. The uri must point to the conformance pack template (max size: 300 KB).</p><note>
    /// <p>You must have access to read Amazon S3 bucket. In addition, in order to ensure a successful deployment, the template object must not be in an <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-class-intro.html">archived storage class</a> if this parameter is passed.</p>
    /// </note>
    pub fn get_template_s3_uri(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_template_s3_uri()
    }
    /// <p>A string that contains the full conformance pack template body. Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.</p>
    pub fn template_body(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.template_body(input.into());
        self
    }
    /// <p>A string that contains the full conformance pack template body. Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.</p>
    pub fn set_template_body(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_template_body(input);
        self
    }
    /// <p>A string that contains the full conformance pack template body. Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.</p>
    pub fn get_template_body(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_template_body()
    }
    /// <p>The name of the Amazon S3 bucket where Config stores conformance pack templates.</p><note>
    /// <p>This field is optional. If used, it must be prefixed with <code>awsconfigconforms</code>.</p>
    /// </note>
    pub fn delivery_s3_bucket(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.delivery_s3_bucket(input.into());
        self
    }
    /// <p>The name of the Amazon S3 bucket where Config stores conformance pack templates.</p><note>
    /// <p>This field is optional. If used, it must be prefixed with <code>awsconfigconforms</code>.</p>
    /// </note>
    pub fn set_delivery_s3_bucket(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_delivery_s3_bucket(input);
        self
    }
    /// <p>The name of the Amazon S3 bucket where Config stores conformance pack templates.</p><note>
    /// <p>This field is optional. If used, it must be prefixed with <code>awsconfigconforms</code>.</p>
    /// </note>
    pub fn get_delivery_s3_bucket(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_delivery_s3_bucket()
    }
    /// <p>The prefix for the Amazon S3 bucket.</p><note>
    /// <p>This field is optional.</p>
    /// </note>
    pub fn delivery_s3_key_prefix(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.delivery_s3_key_prefix(input.into());
        self
    }
    /// <p>The prefix for the Amazon S3 bucket.</p><note>
    /// <p>This field is optional.</p>
    /// </note>
    pub fn set_delivery_s3_key_prefix(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_delivery_s3_key_prefix(input);
        self
    }
    /// <p>The prefix for the Amazon S3 bucket.</p><note>
    /// <p>This field is optional.</p>
    /// </note>
    pub fn get_delivery_s3_key_prefix(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_delivery_s3_key_prefix()
    }
    ///
    /// Appends an item to `ConformancePackInputParameters`.
    ///
    /// To override the contents of this collection use [`set_conformance_pack_input_parameters`](Self::set_conformance_pack_input_parameters).
    ///
    /// <p>A list of <code>ConformancePackInputParameter</code> objects.</p>
    pub fn conformance_pack_input_parameters(mut self, input: crate::types::ConformancePackInputParameter) -> Self {
        self.inner = self.inner.conformance_pack_input_parameters(input);
        self
    }
    /// <p>A list of <code>ConformancePackInputParameter</code> objects.</p>
    pub fn set_conformance_pack_input_parameters(
        mut self,
        input: ::std::option::Option<::std::vec::Vec<crate::types::ConformancePackInputParameter>>,
    ) -> Self {
        self.inner = self.inner.set_conformance_pack_input_parameters(input);
        self
    }
    /// <p>A list of <code>ConformancePackInputParameter</code> objects.</p>
    pub fn get_conformance_pack_input_parameters(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::ConformancePackInputParameter>> {
        self.inner.get_conformance_pack_input_parameters()
    }
    ///
    /// Appends an item to `ExcludedAccounts`.
    ///
    /// To override the contents of this collection use [`set_excluded_accounts`](Self::set_excluded_accounts).
    ///
    /// <p>A list of Amazon Web Services accounts to be excluded from an organization conformance pack while deploying a conformance pack.</p>
    pub fn excluded_accounts(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.excluded_accounts(input.into());
        self
    }
    /// <p>A list of Amazon Web Services accounts to be excluded from an organization conformance pack while deploying a conformance pack.</p>
    pub fn set_excluded_accounts(mut self, input: ::std::option::Option<::std::vec::Vec<::std::string::String>>) -> Self {
        self.inner = self.inner.set_excluded_accounts(input);
        self
    }
    /// <p>A list of Amazon Web Services accounts to be excluded from an organization conformance pack while deploying a conformance pack.</p>
    pub fn get_excluded_accounts(&self) -> &::std::option::Option<::std::vec::Vec<::std::string::String>> {
        self.inner.get_excluded_accounts()
    }
}
