// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::put_remediation_exceptions::_put_remediation_exceptions_output::PutRemediationExceptionsOutputBuilder;

pub use crate::operation::put_remediation_exceptions::_put_remediation_exceptions_input::PutRemediationExceptionsInputBuilder;

impl crate::operation::put_remediation_exceptions::builders::PutRemediationExceptionsInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::put_remediation_exceptions::PutRemediationExceptionsOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_remediation_exceptions::PutRemediationExceptionsError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.put_remediation_exceptions();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `PutRemediationExceptions`.
///
/// <p>A remediation exception is when a specified resource is no longer considered for auto-remediation. This API adds a new exception or updates an existing exception for a specified resource with a specified Config rule.</p><note>
/// <p><b>Exceptions block auto remediation</b></p>
/// <p>Config generates a remediation exception when a problem occurs running a remediation action for a specified resource. Remediation exceptions blocks auto-remediation until the exception is cleared.</p>
/// </note> <note>
/// <p><b>Manual remediation is recommended when placing an exception</b></p>
/// <p>When placing an exception on an Amazon Web Services resource, it is recommended that remediation is set as manual remediation until the given Config rule for the specified resource evaluates the resource as <code>NON_COMPLIANT</code>. Once the resource has been evaluated as <code>NON_COMPLIANT</code>, you can add remediation exceptions and change the remediation type back from Manual to Auto if you want to use auto-remediation. Otherwise, using auto-remediation before a <code>NON_COMPLIANT</code> evaluation result can delete resources before the exception is applied.</p>
/// </note> <note>
/// <p><b>Exceptions can only be performed on non-compliant resources</b></p>
/// <p>Placing an exception can only be performed on resources that are <code>NON_COMPLIANT</code>. If you use this API for <code>COMPLIANT</code> resources or resources that are <code>NOT_APPLICABLE</code>, a remediation exception will not be generated. For more information on the conditions that initiate the possible Config evaluation results, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/config-concepts.html#aws-config-rules">Concepts | Config Rules</a> in the <i>Config Developer Guide</i>.</p>
/// </note> <note>
/// <p><b>Exceptions cannot be placed on service-linked remediation actions</b></p>
/// <p>You cannot place an exception on service-linked remediation actions, such as remediation actions put by an organizational conformance pack.</p>
/// </note> <note>
/// <p><b>Auto remediation can be initiated even for compliant resources</b></p>
/// <p>If you enable auto remediation for a specific Config rule using the <a href="https://docs.aws.amazon.com/config/latest/APIReference/emAPI_PutRemediationConfigurations.html">PutRemediationConfigurations</a> API or the Config console, it initiates the remediation process for all non-compliant resources for that specific rule. The auto remediation process relies on the compliance data snapshot which is captured on a periodic basis. Any non-compliant resource that is updated between the snapshot schedule will continue to be remediated based on the last known compliance data snapshot.</p>
/// <p>This means that in some cases auto remediation can be initiated even for compliant resources, since the bootstrap processor uses a database that can have stale evaluation results based on the last known compliance data snapshot.</p>
/// </note>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct PutRemediationExceptionsFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::put_remediation_exceptions::builders::PutRemediationExceptionsInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::put_remediation_exceptions::PutRemediationExceptionsOutput,
        crate::operation::put_remediation_exceptions::PutRemediationExceptionsError,
    > for PutRemediationExceptionsFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::put_remediation_exceptions::PutRemediationExceptionsOutput,
            crate::operation::put_remediation_exceptions::PutRemediationExceptionsError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl PutRemediationExceptionsFluentBuilder {
    /// Creates a new `PutRemediationExceptionsFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the PutRemediationExceptions as a reference.
    pub fn as_input(&self) -> &crate::operation::put_remediation_exceptions::builders::PutRemediationExceptionsInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::put_remediation_exceptions::PutRemediationExceptionsOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_remediation_exceptions::PutRemediationExceptionsError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::put_remediation_exceptions::PutRemediationExceptions::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::put_remediation_exceptions::PutRemediationExceptions::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::put_remediation_exceptions::PutRemediationExceptionsOutput,
        crate::operation::put_remediation_exceptions::PutRemediationExceptionsError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The name of the Config rule for which you want to create remediation exception.</p>
    pub fn config_rule_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.config_rule_name(input.into());
        self
    }
    /// <p>The name of the Config rule for which you want to create remediation exception.</p>
    pub fn set_config_rule_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_config_rule_name(input);
        self
    }
    /// <p>The name of the Config rule for which you want to create remediation exception.</p>
    pub fn get_config_rule_name(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_config_rule_name()
    }
    ///
    /// Appends an item to `ResourceKeys`.
    ///
    /// To override the contents of this collection use [`set_resource_keys`](Self::set_resource_keys).
    ///
    /// <p>An exception list of resource exception keys to be processed with the current request. Config adds exception for each resource key. For example, Config adds 3 exceptions for 3 resource keys.</p>
    pub fn resource_keys(mut self, input: crate::types::RemediationExceptionResourceKey) -> Self {
        self.inner = self.inner.resource_keys(input);
        self
    }
    /// <p>An exception list of resource exception keys to be processed with the current request. Config adds exception for each resource key. For example, Config adds 3 exceptions for 3 resource keys.</p>
    pub fn set_resource_keys(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::RemediationExceptionResourceKey>>) -> Self {
        self.inner = self.inner.set_resource_keys(input);
        self
    }
    /// <p>An exception list of resource exception keys to be processed with the current request. Config adds exception for each resource key. For example, Config adds 3 exceptions for 3 resource keys.</p>
    pub fn get_resource_keys(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::RemediationExceptionResourceKey>> {
        self.inner.get_resource_keys()
    }
    /// <p>The message contains an explanation of the exception.</p>
    pub fn message(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.message(input.into());
        self
    }
    /// <p>The message contains an explanation of the exception.</p>
    pub fn set_message(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_message(input);
        self
    }
    /// <p>The message contains an explanation of the exception.</p>
    pub fn get_message(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_message()
    }
    /// <p>The exception is automatically deleted after the expiration date.</p>
    pub fn expiration_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.inner = self.inner.expiration_time(input);
        self
    }
    /// <p>The exception is automatically deleted after the expiration date.</p>
    pub fn set_expiration_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.inner = self.inner.set_expiration_time(input);
        self
    }
    /// <p>The exception is automatically deleted after the expiration date.</p>
    pub fn get_expiration_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        self.inner.get_expiration_time()
    }
}
