// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::put_retention_configuration::_put_retention_configuration_output::PutRetentionConfigurationOutputBuilder;

pub use crate::operation::put_retention_configuration::_put_retention_configuration_input::PutRetentionConfigurationInputBuilder;

impl crate::operation::put_retention_configuration::builders::PutRetentionConfigurationInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::put_retention_configuration::PutRetentionConfigurationOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_retention_configuration::PutRetentionConfigurationError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.put_retention_configuration();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `PutRetentionConfiguration`.
///
/// <p>Creates and updates the retention configuration with details about retention period (number of days) that Config stores your historical information. The API creates the <code>RetentionConfiguration</code> object and names the object as <b>default</b>. When you have a <code>RetentionConfiguration</code> object named <b>default</b>, calling the API modifies the default object.</p><note>
/// <p>Currently, Config supports only one retention configuration per region in your account.</p>
/// </note>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct PutRetentionConfigurationFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::put_retention_configuration::builders::PutRetentionConfigurationInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::put_retention_configuration::PutRetentionConfigurationOutput,
        crate::operation::put_retention_configuration::PutRetentionConfigurationError,
    > for PutRetentionConfigurationFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::put_retention_configuration::PutRetentionConfigurationOutput,
            crate::operation::put_retention_configuration::PutRetentionConfigurationError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl PutRetentionConfigurationFluentBuilder {
    /// Creates a new `PutRetentionConfigurationFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the PutRetentionConfiguration as a reference.
    pub fn as_input(&self) -> &crate::operation::put_retention_configuration::builders::PutRetentionConfigurationInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::put_retention_configuration::PutRetentionConfigurationOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_retention_configuration::PutRetentionConfigurationError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::put_retention_configuration::PutRetentionConfiguration::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::put_retention_configuration::PutRetentionConfiguration::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::put_retention_configuration::PutRetentionConfigurationOutput,
        crate::operation::put_retention_configuration::PutRetentionConfigurationError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>Number of days Config stores your historical information.</p><note>
    /// <p>Currently, only applicable to the configuration item history.</p>
    /// </note>
    pub fn retention_period_in_days(mut self, input: i32) -> Self {
        self.inner = self.inner.retention_period_in_days(input);
        self
    }
    /// <p>Number of days Config stores your historical information.</p><note>
    /// <p>Currently, only applicable to the configuration item history.</p>
    /// </note>
    pub fn set_retention_period_in_days(mut self, input: ::std::option::Option<i32>) -> Self {
        self.inner = self.inner.set_retention_period_in_days(input);
        self
    }
    /// <p>Number of days Config stores your historical information.</p><note>
    /// <p>Currently, only applicable to the configuration item history.</p>
    /// </note>
    pub fn get_retention_period_in_days(&self) -> &::std::option::Option<i32> {
        self.inner.get_retention_period_in_days()
    }
}
