// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::put_service_linked_configuration_recorder::_put_service_linked_configuration_recorder_output::PutServiceLinkedConfigurationRecorderOutputBuilder;

pub use crate::operation::put_service_linked_configuration_recorder::_put_service_linked_configuration_recorder_input::PutServiceLinkedConfigurationRecorderInputBuilder;

impl crate::operation::put_service_linked_configuration_recorder::builders::PutServiceLinkedConfigurationRecorderInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::put_service_linked_configuration_recorder::PutServiceLinkedConfigurationRecorderOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_service_linked_configuration_recorder::PutServiceLinkedConfigurationRecorderError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.put_service_linked_configuration_recorder();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `PutServiceLinkedConfigurationRecorder`.
///
/// <p>Creates a service-linked configuration recorder that is linked to a specific Amazon Web Services service based on the <code>ServicePrincipal</code> you specify.</p>
/// <p>The configuration recorder's <code>name</code>, <code>recordingGroup</code>, <code>recordingMode</code>, and <code>recordingScope</code> is set by the service that is linked to the configuration recorder.</p>
/// <p>For more information and a list of supported services/service principals, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/stop-start-recorder.html"> <b>Working with the Configuration Recorder</b> </a> in the <i>Config Developer Guide</i>.</p>
/// <p>This API creates a service-linked role <code>AWSServiceRoleForConfig</code> in your account. The service-linked role is created only when the role does not exist in your account.</p><note>
/// <p><b>The recording scope determines if you receive configuration items</b></p>
/// <p>The recording scope is set by the service that is linked to the configuration recorder and determines whether you receive configuration items (CIs) in the delivery channel. If the recording scope is internal, you will not receive CIs in the delivery channel.</p>
/// <p><b>Tags are added at creation and cannot be updated with this operation</b></p>
/// <p>Use <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_TagResource.html">TagResource</a> and <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_UntagResource.html">UntagResource</a> to update tags after creation.</p>
/// </note>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct PutServiceLinkedConfigurationRecorderFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::put_service_linked_configuration_recorder::builders::PutServiceLinkedConfigurationRecorderInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::put_service_linked_configuration_recorder::PutServiceLinkedConfigurationRecorderOutput,
        crate::operation::put_service_linked_configuration_recorder::PutServiceLinkedConfigurationRecorderError,
    > for PutServiceLinkedConfigurationRecorderFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::put_service_linked_configuration_recorder::PutServiceLinkedConfigurationRecorderOutput,
            crate::operation::put_service_linked_configuration_recorder::PutServiceLinkedConfigurationRecorderError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl PutServiceLinkedConfigurationRecorderFluentBuilder {
    /// Creates a new `PutServiceLinkedConfigurationRecorderFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the PutServiceLinkedConfigurationRecorder as a reference.
    pub fn as_input(
        &self,
    ) -> &crate::operation::put_service_linked_configuration_recorder::builders::PutServiceLinkedConfigurationRecorderInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::put_service_linked_configuration_recorder::PutServiceLinkedConfigurationRecorderOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_service_linked_configuration_recorder::PutServiceLinkedConfigurationRecorderError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins =
            crate::operation::put_service_linked_configuration_recorder::PutServiceLinkedConfigurationRecorder::operation_runtime_plugins(
                self.handle.runtime_plugins.clone(),
                &self.handle.conf,
                self.config_override,
            );
        crate::operation::put_service_linked_configuration_recorder::PutServiceLinkedConfigurationRecorder::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::put_service_linked_configuration_recorder::PutServiceLinkedConfigurationRecorderOutput,
        crate::operation::put_service_linked_configuration_recorder::PutServiceLinkedConfigurationRecorderError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The service principal of the Amazon Web Services service for the service-linked configuration recorder that you want to create.</p>
    pub fn service_principal(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.service_principal(input.into());
        self
    }
    /// <p>The service principal of the Amazon Web Services service for the service-linked configuration recorder that you want to create.</p>
    pub fn set_service_principal(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_service_principal(input);
        self
    }
    /// <p>The service principal of the Amazon Web Services service for the service-linked configuration recorder that you want to create.</p>
    pub fn get_service_principal(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_service_principal()
    }
    ///
    /// Appends an item to `Tags`.
    ///
    /// To override the contents of this collection use [`set_tags`](Self::set_tags).
    ///
    /// <p>The tags for a service-linked configuration recorder. Each tag consists of a key and an optional value, both of which you define.</p>
    pub fn tags(mut self, input: crate::types::Tag) -> Self {
        self.inner = self.inner.tags(input);
        self
    }
    /// <p>The tags for a service-linked configuration recorder. Each tag consists of a key and an optional value, both of which you define.</p>
    pub fn set_tags(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::Tag>>) -> Self {
        self.inner = self.inner.set_tags(input);
        self
    }
    /// <p>The tags for a service-linked configuration recorder. Each tag consists of a key and an optional value, both of which you define.</p>
    pub fn get_tags(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::Tag>> {
        self.inner.get_tags()
    }
}
