// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn de_get_resource_evaluation_summary_http_error(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<
    crate::operation::get_resource_evaluation_summary::GetResourceEvaluationSummaryOutput,
    crate::operation::get_resource_evaluation_summary::GetResourceEvaluationSummaryError,
> {
    #[allow(unused_mut)]
    let mut generic_builder = crate::protocol_serde::parse_http_error_metadata(_response_status, _response_headers, _response_body)
        .map_err(crate::operation::get_resource_evaluation_summary::GetResourceEvaluationSummaryError::unhandled)?;
    generic_builder = ::aws_types::request_id::apply_request_id(generic_builder, _response_headers);
    let generic = generic_builder.build();
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::operation::get_resource_evaluation_summary::GetResourceEvaluationSummaryError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFoundException" => {
            crate::operation::get_resource_evaluation_summary::GetResourceEvaluationSummaryError::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::types::error::builders::ResourceNotFoundExceptionBuilder::default();
                    output =
                        crate::protocol_serde::shape_resource_not_found_exception::de_resource_not_found_exception_json_err(_response_body, output)
                            .map_err(crate::operation::get_resource_evaluation_summary::GetResourceEvaluationSummaryError::unhandled)?;
                    let output = output.meta(generic);
                    output.build()
                };
                if tmp.message.is_none() {
                    tmp.message = _error_message;
                }
                tmp
            })
        }
        _ => crate::operation::get_resource_evaluation_summary::GetResourceEvaluationSummaryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn de_get_resource_evaluation_summary_http_response(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<
    crate::operation::get_resource_evaluation_summary::GetResourceEvaluationSummaryOutput,
    crate::operation::get_resource_evaluation_summary::GetResourceEvaluationSummaryError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::operation::get_resource_evaluation_summary::builders::GetResourceEvaluationSummaryOutputBuilder::default();
        output = crate::protocol_serde::shape_get_resource_evaluation_summary::de_get_resource_evaluation_summary(_response_body, output)
            .map_err(crate::operation::get_resource_evaluation_summary::GetResourceEvaluationSummaryError::unhandled)?;
        output._set_request_id(::aws_types::request_id::RequestId::request_id(_response_headers).map(str::to_string));
        output.build()
    })
}

pub fn ser_get_resource_evaluation_summary_input(
    input: &crate::operation::get_resource_evaluation_summary::GetResourceEvaluationSummaryInput,
) -> ::std::result::Result<::aws_smithy_types::body::SdkBody, ::aws_smithy_types::error::operation::SerializationError> {
    let mut out = String::new();
    let mut object = ::aws_smithy_json::serialize::JsonObjectWriter::new(&mut out);
    crate::protocol_serde::shape_get_resource_evaluation_summary_input::ser_get_resource_evaluation_summary_input_input(&mut object, input)?;
    object.finish();
    Ok(::aws_smithy_types::body::SdkBody::from(out))
}

pub(crate) fn de_get_resource_evaluation_summary(
    value: &[u8],
    mut builder: crate::operation::get_resource_evaluation_summary::builders::GetResourceEvaluationSummaryOutputBuilder,
) -> ::std::result::Result<
    crate::operation::get_resource_evaluation_summary::builders::GetResourceEvaluationSummaryOutputBuilder,
    ::aws_smithy_json::deserialize::error::DeserializeError,
> {
    let mut tokens_owned = ::aws_smithy_json::deserialize::json_token_iter(crate::protocol_serde::or_empty_doc(value)).peekable();
    let tokens = &mut tokens_owned;
    ::aws_smithy_json::deserialize::token::expect_start_object(tokens.next())?;
    loop {
        match tokens.next().transpose()? {
            Some(::aws_smithy_json::deserialize::Token::EndObject { .. }) => break,
            Some(::aws_smithy_json::deserialize::Token::ObjectKey { key, .. }) => match key.to_unescaped()?.as_ref() {
                "ResourceEvaluationId" => {
                    builder = builder.set_resource_evaluation_id(
                        ::aws_smithy_json::deserialize::token::expect_string_or_null(tokens.next())?
                            .map(|s| s.to_unescaped().map(|u| u.into_owned()))
                            .transpose()?,
                    );
                }
                "EvaluationMode" => {
                    builder = builder.set_evaluation_mode(
                        ::aws_smithy_json::deserialize::token::expect_string_or_null(tokens.next())?
                            .map(|s| s.to_unescaped().map(|u| crate::types::EvaluationMode::from(u.as_ref())))
                            .transpose()?,
                    );
                }
                "EvaluationStatus" => {
                    builder = builder.set_evaluation_status(crate::protocol_serde::shape_evaluation_status::de_evaluation_status(tokens)?);
                }
                "EvaluationStartTimestamp" => {
                    builder = builder.set_evaluation_start_timestamp(::aws_smithy_json::deserialize::token::expect_timestamp_or_null(
                        tokens.next(),
                        ::aws_smithy_types::date_time::Format::EpochSeconds,
                    )?);
                }
                "Compliance" => {
                    builder = builder.set_compliance(
                        ::aws_smithy_json::deserialize::token::expect_string_or_null(tokens.next())?
                            .map(|s| s.to_unescaped().map(|u| crate::types::ComplianceType::from(u.as_ref())))
                            .transpose()?,
                    );
                }
                "EvaluationContext" => {
                    builder = builder.set_evaluation_context(crate::protocol_serde::shape_evaluation_context::de_evaluation_context(tokens)?);
                }
                "ResourceDetails" => {
                    builder = builder.set_resource_details(crate::protocol_serde::shape_resource_details::de_resource_details(tokens)?);
                }
                _ => ::aws_smithy_json::deserialize::token::skip_value(tokens)?,
            },
            other => {
                return Err(::aws_smithy_json::deserialize::error::DeserializeError::custom(format!(
                    "expected object key or end object, found: {other:?}"
                )))
            }
        }
    }
    if tokens.next().is_some() {
        return Err(::aws_smithy_json::deserialize::error::DeserializeError::custom(
            "found more JSON tokens after completing parsing",
        ));
    }
    Ok(builder)
}
